// services/network/public/mojom/ssl_config.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/network/public/mojom/ssl_config.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/ssl_config.mojom-params-data.h"
namespace network {
namespace mojom {

std::string SSLVersionToString(SSLVersion value) {
  switch(value) {
    case SSLVersion::kTLS1:
      return "SSLVersion::kTLS1";
    case SSLVersion::kTLS11:
      return "SSLVersion::kTLS11";
    case SSLVersion::kTLS12:
      return "SSLVersion::kTLS12";
    case SSLVersion::kTLS13:
      return "SSLVersion::kTLS13";
    default:
      return base::StringPrintf("Unknown SSLVersion value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, SSLVersion value) {
  return os << SSLVersionToString(value);
}

namespace internal {


// static
bool SSLConfig_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const SSLConfig_Data* object = static_cast<const SSLConfig_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::network::mojom::internal::SSLVersion_Data
        ::Validate(object->version_min, validation_context))
    return false;


  if (!::network::mojom::internal::SSLVersion_Data
        ::Validate(object->version_min_warn, validation_context))
    return false;


  if (!::network::mojom::internal::SSLVersion_Data
        ::Validate(object->version_max, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->disabled_cipher_suites, 8, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams disabled_cipher_suites_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->disabled_cipher_suites, validation_context,
                                         &disabled_cipher_suites_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->client_cert_pooling_policy, 9, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams client_cert_pooling_policy_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->client_cert_pooling_policy, validation_context,
                                         &client_cert_pooling_policy_validate_params)) {
    return false;
  }

  return true;
}

SSLConfig_Data::SSLConfig_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SSLConfigClient_OnSSLConfigUpdated_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const SSLConfigClient_OnSSLConfigUpdated_Params_Data* object = static_cast<const SSLConfigClient_OnSSLConfigUpdated_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->ssl_config, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->ssl_config, validation_context))
    return false;

  return true;
}

SSLConfigClient_OnSSLConfigUpdated_Params_Data::SSLConfigClient_OnSSLConfigUpdated_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace network

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::SSLVersion>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::network::mojom::SSLVersion value) {
  return std::move(context).WriteString(::network::mojom::SSLVersionToString(value));
}

} // namespace perfetto
