// services/network/public/mojom/tcp_socket.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/tcp_socket.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "services/network/public/mojom/tcp_socket.mojom-params-data.h"
#include "services/network/public/mojom/tcp_socket.mojom-shared-message-ids.h"

#include "services/network/public/mojom/tcp_socket.mojom-import-headers.h"


#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_TCP_SOCKET_MOJOM_JUMBO_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_TCP_SOCKET_MOJOM_JUMBO_H_
#endif
namespace network {
namespace mojom {
TCPConnectedSocketOptions::TCPConnectedSocketOptions()
    : send_buffer_size(0),
      receive_buffer_size(0),
      no_delay(true) {}

TCPConnectedSocketOptions::TCPConnectedSocketOptions(
    int32_t send_buffer_size_in,
    int32_t receive_buffer_size_in,
    bool no_delay_in)
    : send_buffer_size(std::move(send_buffer_size_in)),
      receive_buffer_size(std::move(receive_buffer_size_in)),
      no_delay(std::move(no_delay_in)) {}

TCPConnectedSocketOptions::~TCPConnectedSocketOptions() = default;
size_t TCPConnectedSocketOptions::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->send_buffer_size);
  seed = mojo::internal::Hash(seed, this->receive_buffer_size);
  seed = mojo::internal::Hash(seed, this->no_delay);
  return seed;
}

void TCPConnectedSocketOptions::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "send_buffer_size"), this->send_buffer_size, 
      "<value of type int32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "receive_buffer_size"), this->receive_buffer_size, 
      "<value of type int32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "no_delay"), this->no_delay, 
      "<value of type bool>");
}

bool TCPConnectedSocketOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char TCPBoundSocket::Name_[] = "network.mojom.TCPBoundSocket";

class TCPBoundSocket_Listen_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  TCPBoundSocket_Listen_ForwardToCallback(
      TCPBoundSocket::ListenCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  TCPBoundSocket::ListenCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(TCPBoundSocket_Listen_ForwardToCallback);
};

class TCPBoundSocket_Connect_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  TCPBoundSocket_Connect_ForwardToCallback(
      TCPBoundSocket::ConnectCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  TCPBoundSocket::ConnectCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(TCPBoundSocket_Connect_ForwardToCallback);
};

TCPBoundSocketProxy::TCPBoundSocketProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void TCPBoundSocketProxy::Listen(
    uint32_t in_backlog, ::mojo::PendingReceiver<TCPServerSocket> in_socket, ListenCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::TCPBoundSocket::Listen", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("backlog"), in_backlog, 
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("socket"), in_socket, 
                        "<value of type ::mojo::PendingReceiver<TCPServerSocket>>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kTCPBoundSocket_Listen_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::TCPBoundSocket_Listen_Params_Data> params(
          message);
  params.Allocate();
  params->backlog = in_backlog;
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::TCPServerSocketInterfaceBase>>(
      in_socket, &params->socket, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->socket),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid socket in TCPBoundSocket.Listen request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TCPBoundSocket::Name_);
  message.set_method_name("Listen");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new TCPBoundSocket_Listen_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void TCPBoundSocketProxy::Connect(
    const ::net::AddressList& in_remote_addr_list, TCPConnectedSocketOptionsPtr in_tcp_connected_socket_options, ::mojo::PendingReceiver<TCPConnectedSocket> in_socket, ::mojo::PendingRemote<SocketObserver> in_observer, ConnectCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::TCPBoundSocket::Connect", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("remote_addr_list"), in_remote_addr_list, 
                        "<value of type const ::net::AddressList&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tcp_connected_socket_options"), in_tcp_connected_socket_options, 
                        "<value of type TCPConnectedSocketOptionsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("socket"), in_socket, 
                        "<value of type ::mojo::PendingReceiver<TCPConnectedSocket>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("observer"), in_observer, 
                        "<value of type ::mojo::PendingRemote<SocketObserver>>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kTCPBoundSocket_Connect_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::TCPBoundSocket_Connect_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->remote_addr_list)::BaseType> remote_addr_list_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::AddressListDataView>(
      in_remote_addr_list, remote_addr_list_fragment);
  params->remote_addr_list.Set(
      remote_addr_list_fragment.is_null() ? nullptr : remote_addr_list_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->remote_addr_list.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null remote_addr_list in TCPBoundSocket.Connect request");
  mojo::internal::MessageFragment<
      typename decltype(params->tcp_connected_socket_options)::BaseType> tcp_connected_socket_options_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::TCPConnectedSocketOptionsDataView>(
      in_tcp_connected_socket_options, tcp_connected_socket_options_fragment);
  params->tcp_connected_socket_options.Set(
      tcp_connected_socket_options_fragment.is_null() ? nullptr : tcp_connected_socket_options_fragment.data());
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::TCPConnectedSocketInterfaceBase>>(
      in_socket, &params->socket, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->socket),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid socket in TCPBoundSocket.Connect request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::SocketObserverInterfaceBase>>(
      in_observer, &params->observer, &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TCPBoundSocket::Name_);
  message.set_method_name("Connect");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new TCPBoundSocket_Connect_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class TCPBoundSocket_Listen_ProxyToResponder {
 public:
  static TCPBoundSocket::ListenCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<TCPBoundSocket_Listen_ProxyToResponder> proxy(
        new TCPBoundSocket_Listen_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&TCPBoundSocket_Listen_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~TCPBoundSocket_Listen_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  TCPBoundSocket_Listen_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "TCPBoundSocket::ListenCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_net_error);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(TCPBoundSocket_Listen_ProxyToResponder);
};

bool TCPBoundSocket_Listen_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::TCPBoundSocket::ListenCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::TCPBoundSocket_Listen_ResponseParams_Data* params =
      reinterpret_cast<
          internal::TCPBoundSocket_Listen_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  int32_t p_net_error{};
  TCPBoundSocket_Listen_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_net_error = input_data_view.net_error();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        TCPBoundSocket::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_net_error));
  return true;
}

void TCPBoundSocket_Listen_ProxyToResponder::Run(
    int32_t in_net_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)network::mojom::TCPBoundSocket::ListenCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("net_error"), in_net_error, 
                        "<value of type int32_t>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kTCPBoundSocket_Listen_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::TCPBoundSocket_Listen_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->net_error = in_net_error;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::TCPBoundSocket::ListenCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TCPBoundSocket::Name_);
  message.set_method_name("Listen");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class TCPBoundSocket_Connect_ProxyToResponder {
 public:
  static TCPBoundSocket::ConnectCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<TCPBoundSocket_Connect_ProxyToResponder> proxy(
        new TCPBoundSocket_Connect_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&TCPBoundSocket_Connect_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~TCPBoundSocket_Connect_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  TCPBoundSocket_Connect_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "TCPBoundSocket::ConnectCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_net_error, const base::Optional<::net::IPEndPoint>& in_local_addr, const base::Optional<::net::IPEndPoint>& in_peer_addr, ::mojo::ScopedDataPipeConsumerHandle in_receive_stream, ::mojo::ScopedDataPipeProducerHandle in_send_stream);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(TCPBoundSocket_Connect_ProxyToResponder);
};

bool TCPBoundSocket_Connect_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::TCPBoundSocket::ConnectCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::TCPBoundSocket_Connect_ResponseParams_Data* params =
      reinterpret_cast<
          internal::TCPBoundSocket_Connect_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  int32_t p_net_error{};
  base::Optional<::net::IPEndPoint> p_local_addr{};
  base::Optional<::net::IPEndPoint> p_peer_addr{};
  ::mojo::ScopedDataPipeConsumerHandle p_receive_stream{};
  ::mojo::ScopedDataPipeProducerHandle p_send_stream{};
  TCPBoundSocket_Connect_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_net_error = input_data_view.net_error();
  if (success && !input_data_view.ReadLocalAddr(&p_local_addr))
    success = false;
  if (success && !input_data_view.ReadPeerAddr(&p_peer_addr))
    success = false;
  if (success)
    p_receive_stream = input_data_view.TakeReceiveStream();
  if (success)
    p_send_stream = input_data_view.TakeSendStream();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        TCPBoundSocket::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_net_error), 
std::move(p_local_addr), 
std::move(p_peer_addr), 
std::move(p_receive_stream), 
std::move(p_send_stream));
  return true;
}

void TCPBoundSocket_Connect_ProxyToResponder::Run(
    int32_t in_net_error, const base::Optional<::net::IPEndPoint>& in_local_addr, const base::Optional<::net::IPEndPoint>& in_peer_addr, ::mojo::ScopedDataPipeConsumerHandle in_receive_stream, ::mojo::ScopedDataPipeProducerHandle in_send_stream) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)network::mojom::TCPBoundSocket::ConnectCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("net_error"), in_net_error, 
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("local_addr"), in_local_addr, 
                        "<value of type const base::Optional<::net::IPEndPoint>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("peer_addr"), in_peer_addr, 
                        "<value of type const base::Optional<::net::IPEndPoint>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receive_stream"), in_receive_stream, 
                        "<value of type ::mojo::ScopedDataPipeConsumerHandle>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("send_stream"), in_send_stream, 
                        "<value of type ::mojo::ScopedDataPipeProducerHandle>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kTCPBoundSocket_Connect_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::TCPBoundSocket_Connect_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->net_error = in_net_error;
  mojo::internal::MessageFragment<
      typename decltype(params->local_addr)::BaseType> local_addr_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::IPEndPointDataView>(
      in_local_addr, local_addr_fragment);
  params->local_addr.Set(
      local_addr_fragment.is_null() ? nullptr : local_addr_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->peer_addr)::BaseType> peer_addr_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::IPEndPointDataView>(
      in_peer_addr, peer_addr_fragment);
  params->peer_addr.Set(
      peer_addr_fragment.is_null() ? nullptr : peer_addr_fragment.data());
  mojo::internal::Serialize<mojo::ScopedDataPipeConsumerHandle>(
      in_receive_stream, &params->receive_stream, &params.message());
  mojo::internal::Serialize<mojo::ScopedDataPipeProducerHandle>(
      in_send_stream, &params->send_stream, &params.message());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::TCPBoundSocket::ConnectCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TCPBoundSocket::Name_);
  message.set_method_name("Connect");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool TCPBoundSocketStubDispatch::Accept(
    TCPBoundSocket* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kTCPBoundSocket_Listen_Name: {
      break;
    }
    case internal::kTCPBoundSocket_Connect_Name: {
      break;
    }
  }
  return false;
}

// static
bool TCPBoundSocketStubDispatch::AcceptWithResponder(
    TCPBoundSocket* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kTCPBoundSocket_Listen_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::TCPBoundSocket::Listen",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::TCPBoundSocket::Listen");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::TCPBoundSocket_Listen_Params_Data* params =
          reinterpret_cast<
              internal::TCPBoundSocket_Listen_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      uint32_t p_backlog{};
      ::mojo::PendingReceiver<TCPServerSocket> p_socket{};
      TCPBoundSocket_Listen_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_backlog = input_data_view.backlog();
      if (success) {
        p_socket =
            input_data_view.TakeSocket<decltype(p_socket)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TCPBoundSocket::Name_, 0, false);
        return false;
      }
      TCPBoundSocket::ListenCallback callback =
          TCPBoundSocket_Listen_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Listen(
std::move(p_backlog), 
std::move(p_socket), std::move(callback));
      return true;
    }
    case internal::kTCPBoundSocket_Connect_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::TCPBoundSocket::Connect",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::TCPBoundSocket::Connect");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::TCPBoundSocket_Connect_Params_Data* params =
          reinterpret_cast<
              internal::TCPBoundSocket_Connect_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::net::AddressList p_remote_addr_list{};
      TCPConnectedSocketOptionsPtr p_tcp_connected_socket_options{};
      ::mojo::PendingReceiver<TCPConnectedSocket> p_socket{};
      ::mojo::PendingRemote<SocketObserver> p_observer{};
      TCPBoundSocket_Connect_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRemoteAddrList(&p_remote_addr_list))
        success = false;
      if (success && !input_data_view.ReadTcpConnectedSocketOptions(&p_tcp_connected_socket_options))
        success = false;
      if (success) {
        p_socket =
            input_data_view.TakeSocket<decltype(p_socket)>();
      }
      if (success) {
        p_observer =
            input_data_view.TakeObserver<decltype(p_observer)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TCPBoundSocket::Name_, 1, false);
        return false;
      }
      TCPBoundSocket::ConnectCallback callback =
          TCPBoundSocket_Connect_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Connect(
std::move(p_remote_addr_list), 
std::move(p_tcp_connected_socket_options), 
std::move(p_socket), 
std::move(p_observer), std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kTCPBoundSocketValidationInfo[] = {
    {internal::kTCPBoundSocket_Listen_Name,
     {&internal::TCPBoundSocket_Listen_Params_Data::Validate,
      &internal::TCPBoundSocket_Listen_ResponseParams_Data::Validate}},
    {internal::kTCPBoundSocket_Connect_Name,
     {&internal::TCPBoundSocket_Connect_Params_Data::Validate,
      &internal::TCPBoundSocket_Connect_ResponseParams_Data::Validate}},
};

bool TCPBoundSocketRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::TCPBoundSocket::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kTCPBoundSocketValidationInfo);
}

bool TCPBoundSocketResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::TCPBoundSocket::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kTCPBoundSocketValidationInfo);

}
const char TCPConnectedSocket::Name_[] = "network.mojom.TCPConnectedSocket";

class TCPConnectedSocket_UpgradeToTLS_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  TCPConnectedSocket_UpgradeToTLS_ForwardToCallback(
      TCPConnectedSocket::UpgradeToTLSCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  TCPConnectedSocket::UpgradeToTLSCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(TCPConnectedSocket_UpgradeToTLS_ForwardToCallback);
};

class TCPConnectedSocket_SetSendBufferSize_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  TCPConnectedSocket_SetSendBufferSize_ForwardToCallback(
      TCPConnectedSocket::SetSendBufferSizeCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  TCPConnectedSocket::SetSendBufferSizeCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(TCPConnectedSocket_SetSendBufferSize_ForwardToCallback);
};

class TCPConnectedSocket_SetReceiveBufferSize_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  TCPConnectedSocket_SetReceiveBufferSize_ForwardToCallback(
      TCPConnectedSocket::SetReceiveBufferSizeCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  TCPConnectedSocket::SetReceiveBufferSizeCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(TCPConnectedSocket_SetReceiveBufferSize_ForwardToCallback);
};

class TCPConnectedSocket_SetNoDelay_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  TCPConnectedSocket_SetNoDelay_ForwardToCallback(
      TCPConnectedSocket::SetNoDelayCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  TCPConnectedSocket::SetNoDelayCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(TCPConnectedSocket_SetNoDelay_ForwardToCallback);
};

class TCPConnectedSocket_SetKeepAlive_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  TCPConnectedSocket_SetKeepAlive_ForwardToCallback(
      TCPConnectedSocket::SetKeepAliveCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  TCPConnectedSocket::SetKeepAliveCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(TCPConnectedSocket_SetKeepAlive_ForwardToCallback);
};

TCPConnectedSocketProxy::TCPConnectedSocketProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void TCPConnectedSocketProxy::UpgradeToTLS(
    const ::net::HostPortPair& in_host_port_pair, ::network::mojom::TLSClientSocketOptionsPtr in_options, const ::net::MutableNetworkTrafficAnnotationTag& in_traffic_annotation, ::mojo::PendingReceiver<::network::mojom::TLSClientSocket> in_receiver, ::mojo::PendingRemote<SocketObserver> in_observer, UpgradeToTLSCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::TCPConnectedSocket::UpgradeToTLS", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("host_port_pair"), in_host_port_pair, 
                        "<value of type const ::net::HostPortPair&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options, 
                        "<value of type ::network::mojom::TLSClientSocketOptionsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("traffic_annotation"), in_traffic_annotation, 
                        "<value of type const ::net::MutableNetworkTrafficAnnotationTag&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver, 
                        "<value of type ::mojo::PendingReceiver<::network::mojom::TLSClientSocket>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("observer"), in_observer, 
                        "<value of type ::mojo::PendingRemote<SocketObserver>>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kTCPConnectedSocket_UpgradeToTLS_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::TCPConnectedSocket_UpgradeToTLS_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->host_port_pair)::BaseType> host_port_pair_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::HostPortPairDataView>(
      in_host_port_pair, host_port_pair_fragment);
  params->host_port_pair.Set(
      host_port_pair_fragment.is_null() ? nullptr : host_port_pair_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->host_port_pair.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null host_port_pair in TCPConnectedSocket.UpgradeToTLS request");
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::TLSClientSocketOptionsDataView>(
      in_options, options_fragment);
  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->traffic_annotation)::BaseType> traffic_annotation_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::MutableNetworkTrafficAnnotationTagDataView>(
      in_traffic_annotation, traffic_annotation_fragment);
  params->traffic_annotation.Set(
      traffic_annotation_fragment.is_null() ? nullptr : traffic_annotation_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->traffic_annotation.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null traffic_annotation in TCPConnectedSocket.UpgradeToTLS request");
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::TLSClientSocketInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in TCPConnectedSocket.UpgradeToTLS request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::SocketObserverInterfaceBase>>(
      in_observer, &params->observer, &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TCPConnectedSocket::Name_);
  message.set_method_name("UpgradeToTLS");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new TCPConnectedSocket_UpgradeToTLS_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void TCPConnectedSocketProxy::SetSendBufferSize(
    int32_t in_send_buffer_size, SetSendBufferSizeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::TCPConnectedSocket::SetSendBufferSize", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("send_buffer_size"), in_send_buffer_size, 
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kTCPConnectedSocket_SetSendBufferSize_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::TCPConnectedSocket_SetSendBufferSize_Params_Data> params(
          message);
  params.Allocate();
  params->send_buffer_size = in_send_buffer_size;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TCPConnectedSocket::Name_);
  message.set_method_name("SetSendBufferSize");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new TCPConnectedSocket_SetSendBufferSize_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void TCPConnectedSocketProxy::SetReceiveBufferSize(
    int32_t in_receive_buffer_size, SetReceiveBufferSizeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::TCPConnectedSocket::SetReceiveBufferSize", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receive_buffer_size"), in_receive_buffer_size, 
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kTCPConnectedSocket_SetReceiveBufferSize_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::TCPConnectedSocket_SetReceiveBufferSize_Params_Data> params(
          message);
  params.Allocate();
  params->receive_buffer_size = in_receive_buffer_size;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TCPConnectedSocket::Name_);
  message.set_method_name("SetReceiveBufferSize");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new TCPConnectedSocket_SetReceiveBufferSize_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void TCPConnectedSocketProxy::SetNoDelay(
    bool in_no_delay, SetNoDelayCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::TCPConnectedSocket::SetNoDelay", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("no_delay"), in_no_delay, 
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kTCPConnectedSocket_SetNoDelay_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::TCPConnectedSocket_SetNoDelay_Params_Data> params(
          message);
  params.Allocate();
  params->no_delay = in_no_delay;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TCPConnectedSocket::Name_);
  message.set_method_name("SetNoDelay");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new TCPConnectedSocket_SetNoDelay_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void TCPConnectedSocketProxy::SetKeepAlive(
    bool in_enable, int32_t in_delay_secs, SetKeepAliveCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::TCPConnectedSocket::SetKeepAlive", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("enable"), in_enable, 
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("delay_secs"), in_delay_secs, 
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kTCPConnectedSocket_SetKeepAlive_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::TCPConnectedSocket_SetKeepAlive_Params_Data> params(
          message);
  params.Allocate();
  params->enable = in_enable;
  params->delay_secs = in_delay_secs;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TCPConnectedSocket::Name_);
  message.set_method_name("SetKeepAlive");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new TCPConnectedSocket_SetKeepAlive_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class TCPConnectedSocket_UpgradeToTLS_ProxyToResponder {
 public:
  static TCPConnectedSocket::UpgradeToTLSCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<TCPConnectedSocket_UpgradeToTLS_ProxyToResponder> proxy(
        new TCPConnectedSocket_UpgradeToTLS_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&TCPConnectedSocket_UpgradeToTLS_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~TCPConnectedSocket_UpgradeToTLS_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  TCPConnectedSocket_UpgradeToTLS_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "TCPConnectedSocket::UpgradeToTLSCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_net_error, ::mojo::ScopedDataPipeConsumerHandle in_receive_stream, ::mojo::ScopedDataPipeProducerHandle in_send_stream, const base::Optional<::net::SSLInfo>& in_ssl_info);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(TCPConnectedSocket_UpgradeToTLS_ProxyToResponder);
};

bool TCPConnectedSocket_UpgradeToTLS_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::TCPConnectedSocket::UpgradeToTLSCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::TCPConnectedSocket_UpgradeToTLS_ResponseParams_Data* params =
      reinterpret_cast<
          internal::TCPConnectedSocket_UpgradeToTLS_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  int32_t p_net_error{};
  ::mojo::ScopedDataPipeConsumerHandle p_receive_stream{};
  ::mojo::ScopedDataPipeProducerHandle p_send_stream{};
  base::Optional<::net::SSLInfo> p_ssl_info{};
  TCPConnectedSocket_UpgradeToTLS_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_net_error = input_data_view.net_error();
  if (success)
    p_receive_stream = input_data_view.TakeReceiveStream();
  if (success)
    p_send_stream = input_data_view.TakeSendStream();
  if (success && !input_data_view.ReadSslInfo(&p_ssl_info))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        TCPConnectedSocket::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_net_error), 
std::move(p_receive_stream), 
std::move(p_send_stream), 
std::move(p_ssl_info));
  return true;
}

void TCPConnectedSocket_UpgradeToTLS_ProxyToResponder::Run(
    int32_t in_net_error, ::mojo::ScopedDataPipeConsumerHandle in_receive_stream, ::mojo::ScopedDataPipeProducerHandle in_send_stream, const base::Optional<::net::SSLInfo>& in_ssl_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)network::mojom::TCPConnectedSocket::UpgradeToTLSCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("net_error"), in_net_error, 
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receive_stream"), in_receive_stream, 
                        "<value of type ::mojo::ScopedDataPipeConsumerHandle>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("send_stream"), in_send_stream, 
                        "<value of type ::mojo::ScopedDataPipeProducerHandle>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("ssl_info"), in_ssl_info, 
                        "<value of type const base::Optional<::net::SSLInfo>&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kTCPConnectedSocket_UpgradeToTLS_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::TCPConnectedSocket_UpgradeToTLS_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->net_error = in_net_error;
  mojo::internal::Serialize<mojo::ScopedDataPipeConsumerHandle>(
      in_receive_stream, &params->receive_stream, &params.message());
  mojo::internal::Serialize<mojo::ScopedDataPipeProducerHandle>(
      in_send_stream, &params->send_stream, &params.message());
  mojo::internal::MessageFragment<
      typename decltype(params->ssl_info)::BaseType> ssl_info_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::SSLInfoDataView>(
      in_ssl_info, ssl_info_fragment);
  params->ssl_info.Set(
      ssl_info_fragment.is_null() ? nullptr : ssl_info_fragment.data());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::TCPConnectedSocket::UpgradeToTLSCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TCPConnectedSocket::Name_);
  message.set_method_name("UpgradeToTLS");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class TCPConnectedSocket_SetSendBufferSize_ProxyToResponder {
 public:
  static TCPConnectedSocket::SetSendBufferSizeCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<TCPConnectedSocket_SetSendBufferSize_ProxyToResponder> proxy(
        new TCPConnectedSocket_SetSendBufferSize_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&TCPConnectedSocket_SetSendBufferSize_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~TCPConnectedSocket_SetSendBufferSize_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  TCPConnectedSocket_SetSendBufferSize_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "TCPConnectedSocket::SetSendBufferSizeCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_net_error);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(TCPConnectedSocket_SetSendBufferSize_ProxyToResponder);
};

bool TCPConnectedSocket_SetSendBufferSize_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::TCPConnectedSocket::SetSendBufferSizeCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::TCPConnectedSocket_SetSendBufferSize_ResponseParams_Data* params =
      reinterpret_cast<
          internal::TCPConnectedSocket_SetSendBufferSize_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  int32_t p_net_error{};
  TCPConnectedSocket_SetSendBufferSize_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_net_error = input_data_view.net_error();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        TCPConnectedSocket::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_net_error));
  return true;
}

void TCPConnectedSocket_SetSendBufferSize_ProxyToResponder::Run(
    int32_t in_net_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)network::mojom::TCPConnectedSocket::SetSendBufferSizeCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("net_error"), in_net_error, 
                        "<value of type int32_t>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kTCPConnectedSocket_SetSendBufferSize_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::TCPConnectedSocket_SetSendBufferSize_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->net_error = in_net_error;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::TCPConnectedSocket::SetSendBufferSizeCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TCPConnectedSocket::Name_);
  message.set_method_name("SetSendBufferSize");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class TCPConnectedSocket_SetReceiveBufferSize_ProxyToResponder {
 public:
  static TCPConnectedSocket::SetReceiveBufferSizeCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<TCPConnectedSocket_SetReceiveBufferSize_ProxyToResponder> proxy(
        new TCPConnectedSocket_SetReceiveBufferSize_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&TCPConnectedSocket_SetReceiveBufferSize_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~TCPConnectedSocket_SetReceiveBufferSize_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  TCPConnectedSocket_SetReceiveBufferSize_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "TCPConnectedSocket::SetReceiveBufferSizeCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_net_error);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(TCPConnectedSocket_SetReceiveBufferSize_ProxyToResponder);
};

bool TCPConnectedSocket_SetReceiveBufferSize_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::TCPConnectedSocket::SetReceiveBufferSizeCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::TCPConnectedSocket_SetReceiveBufferSize_ResponseParams_Data* params =
      reinterpret_cast<
          internal::TCPConnectedSocket_SetReceiveBufferSize_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  int32_t p_net_error{};
  TCPConnectedSocket_SetReceiveBufferSize_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_net_error = input_data_view.net_error();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        TCPConnectedSocket::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_net_error));
  return true;
}

void TCPConnectedSocket_SetReceiveBufferSize_ProxyToResponder::Run(
    int32_t in_net_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)network::mojom::TCPConnectedSocket::SetReceiveBufferSizeCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("net_error"), in_net_error, 
                        "<value of type int32_t>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kTCPConnectedSocket_SetReceiveBufferSize_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::TCPConnectedSocket_SetReceiveBufferSize_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->net_error = in_net_error;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::TCPConnectedSocket::SetReceiveBufferSizeCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TCPConnectedSocket::Name_);
  message.set_method_name("SetReceiveBufferSize");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class TCPConnectedSocket_SetNoDelay_ProxyToResponder {
 public:
  static TCPConnectedSocket::SetNoDelayCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<TCPConnectedSocket_SetNoDelay_ProxyToResponder> proxy(
        new TCPConnectedSocket_SetNoDelay_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&TCPConnectedSocket_SetNoDelay_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~TCPConnectedSocket_SetNoDelay_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  TCPConnectedSocket_SetNoDelay_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "TCPConnectedSocket::SetNoDelayCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(TCPConnectedSocket_SetNoDelay_ProxyToResponder);
};

bool TCPConnectedSocket_SetNoDelay_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::TCPConnectedSocket::SetNoDelayCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::TCPConnectedSocket_SetNoDelay_ResponseParams_Data* params =
      reinterpret_cast<
          internal::TCPConnectedSocket_SetNoDelay_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  bool p_success{};
  TCPConnectedSocket_SetNoDelay_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        TCPConnectedSocket::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_success));
  return true;
}

void TCPConnectedSocket_SetNoDelay_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)network::mojom::TCPConnectedSocket::SetNoDelayCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success, 
                        "<value of type bool>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kTCPConnectedSocket_SetNoDelay_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::TCPConnectedSocket_SetNoDelay_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->success = in_success;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::TCPConnectedSocket::SetNoDelayCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TCPConnectedSocket::Name_);
  message.set_method_name("SetNoDelay");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class TCPConnectedSocket_SetKeepAlive_ProxyToResponder {
 public:
  static TCPConnectedSocket::SetKeepAliveCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<TCPConnectedSocket_SetKeepAlive_ProxyToResponder> proxy(
        new TCPConnectedSocket_SetKeepAlive_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&TCPConnectedSocket_SetKeepAlive_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~TCPConnectedSocket_SetKeepAlive_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  TCPConnectedSocket_SetKeepAlive_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "TCPConnectedSocket::SetKeepAliveCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(TCPConnectedSocket_SetKeepAlive_ProxyToResponder);
};

bool TCPConnectedSocket_SetKeepAlive_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::TCPConnectedSocket::SetKeepAliveCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::TCPConnectedSocket_SetKeepAlive_ResponseParams_Data* params =
      reinterpret_cast<
          internal::TCPConnectedSocket_SetKeepAlive_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  bool p_success{};
  TCPConnectedSocket_SetKeepAlive_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        TCPConnectedSocket::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_success));
  return true;
}

void TCPConnectedSocket_SetKeepAlive_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)network::mojom::TCPConnectedSocket::SetKeepAliveCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success, 
                        "<value of type bool>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kTCPConnectedSocket_SetKeepAlive_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::TCPConnectedSocket_SetKeepAlive_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->success = in_success;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::TCPConnectedSocket::SetKeepAliveCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TCPConnectedSocket::Name_);
  message.set_method_name("SetKeepAlive");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool TCPConnectedSocketStubDispatch::Accept(
    TCPConnectedSocket* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kTCPConnectedSocket_UpgradeToTLS_Name: {
      break;
    }
    case internal::kTCPConnectedSocket_SetSendBufferSize_Name: {
      break;
    }
    case internal::kTCPConnectedSocket_SetReceiveBufferSize_Name: {
      break;
    }
    case internal::kTCPConnectedSocket_SetNoDelay_Name: {
      break;
    }
    case internal::kTCPConnectedSocket_SetKeepAlive_Name: {
      break;
    }
  }
  return false;
}

// static
bool TCPConnectedSocketStubDispatch::AcceptWithResponder(
    TCPConnectedSocket* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kTCPConnectedSocket_UpgradeToTLS_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::TCPConnectedSocket::UpgradeToTLS",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::TCPConnectedSocket::UpgradeToTLS");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::TCPConnectedSocket_UpgradeToTLS_Params_Data* params =
          reinterpret_cast<
              internal::TCPConnectedSocket_UpgradeToTLS_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::net::HostPortPair p_host_port_pair{};
      ::network::mojom::TLSClientSocketOptionsPtr p_options{};
      ::net::MutableNetworkTrafficAnnotationTag p_traffic_annotation{};
      ::mojo::PendingReceiver<::network::mojom::TLSClientSocket> p_receiver{};
      ::mojo::PendingRemote<SocketObserver> p_observer{};
      TCPConnectedSocket_UpgradeToTLS_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadHostPortPair(&p_host_port_pair))
        success = false;
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (success && !input_data_view.ReadTrafficAnnotation(&p_traffic_annotation))
        success = false;
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (success) {
        p_observer =
            input_data_view.TakeObserver<decltype(p_observer)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TCPConnectedSocket::Name_, 0, false);
        return false;
      }
      TCPConnectedSocket::UpgradeToTLSCallback callback =
          TCPConnectedSocket_UpgradeToTLS_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpgradeToTLS(
std::move(p_host_port_pair), 
std::move(p_options), 
std::move(p_traffic_annotation), 
std::move(p_receiver), 
std::move(p_observer), std::move(callback));
      return true;
    }
    case internal::kTCPConnectedSocket_SetSendBufferSize_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::TCPConnectedSocket::SetSendBufferSize",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::TCPConnectedSocket::SetSendBufferSize");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::TCPConnectedSocket_SetSendBufferSize_Params_Data* params =
          reinterpret_cast<
              internal::TCPConnectedSocket_SetSendBufferSize_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      int32_t p_send_buffer_size{};
      TCPConnectedSocket_SetSendBufferSize_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_send_buffer_size = input_data_view.send_buffer_size();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TCPConnectedSocket::Name_, 1, false);
        return false;
      }
      TCPConnectedSocket::SetSendBufferSizeCallback callback =
          TCPConnectedSocket_SetSendBufferSize_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetSendBufferSize(
std::move(p_send_buffer_size), std::move(callback));
      return true;
    }
    case internal::kTCPConnectedSocket_SetReceiveBufferSize_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::TCPConnectedSocket::SetReceiveBufferSize",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::TCPConnectedSocket::SetReceiveBufferSize");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::TCPConnectedSocket_SetReceiveBufferSize_Params_Data* params =
          reinterpret_cast<
              internal::TCPConnectedSocket_SetReceiveBufferSize_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      int32_t p_receive_buffer_size{};
      TCPConnectedSocket_SetReceiveBufferSize_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_receive_buffer_size = input_data_view.receive_buffer_size();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TCPConnectedSocket::Name_, 2, false);
        return false;
      }
      TCPConnectedSocket::SetReceiveBufferSizeCallback callback =
          TCPConnectedSocket_SetReceiveBufferSize_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetReceiveBufferSize(
std::move(p_receive_buffer_size), std::move(callback));
      return true;
    }
    case internal::kTCPConnectedSocket_SetNoDelay_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::TCPConnectedSocket::SetNoDelay",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::TCPConnectedSocket::SetNoDelay");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::TCPConnectedSocket_SetNoDelay_Params_Data* params =
          reinterpret_cast<
              internal::TCPConnectedSocket_SetNoDelay_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      bool p_no_delay{};
      TCPConnectedSocket_SetNoDelay_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_no_delay = input_data_view.no_delay();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TCPConnectedSocket::Name_, 3, false);
        return false;
      }
      TCPConnectedSocket::SetNoDelayCallback callback =
          TCPConnectedSocket_SetNoDelay_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetNoDelay(
std::move(p_no_delay), std::move(callback));
      return true;
    }
    case internal::kTCPConnectedSocket_SetKeepAlive_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::TCPConnectedSocket::SetKeepAlive",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::TCPConnectedSocket::SetKeepAlive");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::TCPConnectedSocket_SetKeepAlive_Params_Data* params =
          reinterpret_cast<
              internal::TCPConnectedSocket_SetKeepAlive_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      bool p_enable{};
      int32_t p_delay_secs{};
      TCPConnectedSocket_SetKeepAlive_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_enable = input_data_view.enable();
      if (success)
        p_delay_secs = input_data_view.delay_secs();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TCPConnectedSocket::Name_, 4, false);
        return false;
      }
      TCPConnectedSocket::SetKeepAliveCallback callback =
          TCPConnectedSocket_SetKeepAlive_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetKeepAlive(
std::move(p_enable), 
std::move(p_delay_secs), std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kTCPConnectedSocketValidationInfo[] = {
    {internal::kTCPConnectedSocket_UpgradeToTLS_Name,
     {&internal::TCPConnectedSocket_UpgradeToTLS_Params_Data::Validate,
      &internal::TCPConnectedSocket_UpgradeToTLS_ResponseParams_Data::Validate}},
    {internal::kTCPConnectedSocket_SetSendBufferSize_Name,
     {&internal::TCPConnectedSocket_SetSendBufferSize_Params_Data::Validate,
      &internal::TCPConnectedSocket_SetSendBufferSize_ResponseParams_Data::Validate}},
    {internal::kTCPConnectedSocket_SetReceiveBufferSize_Name,
     {&internal::TCPConnectedSocket_SetReceiveBufferSize_Params_Data::Validate,
      &internal::TCPConnectedSocket_SetReceiveBufferSize_ResponseParams_Data::Validate}},
    {internal::kTCPConnectedSocket_SetNoDelay_Name,
     {&internal::TCPConnectedSocket_SetNoDelay_Params_Data::Validate,
      &internal::TCPConnectedSocket_SetNoDelay_ResponseParams_Data::Validate}},
    {internal::kTCPConnectedSocket_SetKeepAlive_Name,
     {&internal::TCPConnectedSocket_SetKeepAlive_Params_Data::Validate,
      &internal::TCPConnectedSocket_SetKeepAlive_ResponseParams_Data::Validate}},
};

bool TCPConnectedSocketRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::TCPConnectedSocket::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kTCPConnectedSocketValidationInfo);
}

bool TCPConnectedSocketResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::TCPConnectedSocket::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kTCPConnectedSocketValidationInfo);

}
const char SocketObserver::Name_[] = "network.mojom.SocketObserver";

SocketObserverProxy::SocketObserverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SocketObserverProxy::OnReadError(
    int32_t in_net_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::SocketObserver::OnReadError", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("net_error"), in_net_error, 
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSocketObserver_OnReadError_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::SocketObserver_OnReadError_Params_Data> params(
          message);
  params.Allocate();
  params->net_error = in_net_error;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SocketObserver::Name_);
  message.set_method_name("OnReadError");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void SocketObserverProxy::OnWriteError(
    int32_t in_net_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::SocketObserver::OnWriteError", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("net_error"), in_net_error, 
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSocketObserver_OnWriteError_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::SocketObserver_OnWriteError_Params_Data> params(
          message);
  params.Allocate();
  params->net_error = in_net_error;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SocketObserver::Name_);
  message.set_method_name("OnWriteError");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool SocketObserverStubDispatch::Accept(
    SocketObserver* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kSocketObserver_OnReadError_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::SocketObserver::OnReadError",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::SocketObserver::OnReadError");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SocketObserver_OnReadError_Params_Data* params =
          reinterpret_cast<internal::SocketObserver_OnReadError_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_net_error{};
      SocketObserver_OnReadError_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_net_error = input_data_view.net_error();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SocketObserver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnReadError(
std::move(p_net_error));
      return true;
    }
    case internal::kSocketObserver_OnWriteError_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::SocketObserver::OnWriteError",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::SocketObserver::OnWriteError");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SocketObserver_OnWriteError_Params_Data* params =
          reinterpret_cast<internal::SocketObserver_OnWriteError_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_net_error{};
      SocketObserver_OnWriteError_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_net_error = input_data_view.net_error();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SocketObserver::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnWriteError(
std::move(p_net_error));
      return true;
    }
  }
  return false;
}

// static
bool SocketObserverStubDispatch::AcceptWithResponder(
    SocketObserver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kSocketObserver_OnReadError_Name: {
      break;
    }
    case internal::kSocketObserver_OnWriteError_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kSocketObserverValidationInfo[] = {
    {internal::kSocketObserver_OnReadError_Name,
     {&internal::SocketObserver_OnReadError_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kSocketObserver_OnWriteError_Name,
     {&internal::SocketObserver_OnWriteError_Params_Data::Validate,
      nullptr /* no response */}},
};

bool SocketObserverRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::SocketObserver::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kSocketObserverValidationInfo);
}

const char TCPServerSocket::Name_[] = "network.mojom.TCPServerSocket";

class TCPServerSocket_Accept_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  TCPServerSocket_Accept_ForwardToCallback(
      TCPServerSocket::AcceptCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  TCPServerSocket::AcceptCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(TCPServerSocket_Accept_ForwardToCallback);
};

TCPServerSocketProxy::TCPServerSocketProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void TCPServerSocketProxy::Accept(
    ::mojo::PendingRemote<SocketObserver> in_observer, AcceptCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::TCPServerSocket::Accept", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("observer"), in_observer, 
                        "<value of type ::mojo::PendingRemote<SocketObserver>>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kTCPServerSocket_Accept_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::TCPServerSocket_Accept_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::SocketObserverInterfaceBase>>(
      in_observer, &params->observer, &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TCPServerSocket::Name_);
  message.set_method_name("Accept");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new TCPServerSocket_Accept_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class TCPServerSocket_Accept_ProxyToResponder {
 public:
  static TCPServerSocket::AcceptCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<TCPServerSocket_Accept_ProxyToResponder> proxy(
        new TCPServerSocket_Accept_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&TCPServerSocket_Accept_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~TCPServerSocket_Accept_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  TCPServerSocket_Accept_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "TCPServerSocket::AcceptCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_net_error, const base::Optional<::net::IPEndPoint>& in_remote_addr, ::mojo::PendingRemote<TCPConnectedSocket> in_connected_socket, ::mojo::ScopedDataPipeConsumerHandle in_send_stream, ::mojo::ScopedDataPipeProducerHandle in_receive_stream);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(TCPServerSocket_Accept_ProxyToResponder);
};

bool TCPServerSocket_Accept_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::TCPServerSocket::AcceptCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::TCPServerSocket_Accept_ResponseParams_Data* params =
      reinterpret_cast<
          internal::TCPServerSocket_Accept_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  int32_t p_net_error{};
  base::Optional<::net::IPEndPoint> p_remote_addr{};
  ::mojo::PendingRemote<TCPConnectedSocket> p_connected_socket{};
  ::mojo::ScopedDataPipeConsumerHandle p_send_stream{};
  ::mojo::ScopedDataPipeProducerHandle p_receive_stream{};
  TCPServerSocket_Accept_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_net_error = input_data_view.net_error();
  if (success && !input_data_view.ReadRemoteAddr(&p_remote_addr))
    success = false;
  if (success) {
    p_connected_socket =
        input_data_view.TakeConnectedSocket<decltype(p_connected_socket)>();
  }
  if (success)
    p_send_stream = input_data_view.TakeSendStream();
  if (success)
    p_receive_stream = input_data_view.TakeReceiveStream();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        TCPServerSocket::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_net_error), 
std::move(p_remote_addr), 
std::move(p_connected_socket), 
std::move(p_send_stream), 
std::move(p_receive_stream));
  return true;
}

void TCPServerSocket_Accept_ProxyToResponder::Run(
    int32_t in_net_error, const base::Optional<::net::IPEndPoint>& in_remote_addr, ::mojo::PendingRemote<TCPConnectedSocket> in_connected_socket, ::mojo::ScopedDataPipeConsumerHandle in_send_stream, ::mojo::ScopedDataPipeProducerHandle in_receive_stream) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)network::mojom::TCPServerSocket::AcceptCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("net_error"), in_net_error, 
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("remote_addr"), in_remote_addr, 
                        "<value of type const base::Optional<::net::IPEndPoint>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("connected_socket"), in_connected_socket, 
                        "<value of type ::mojo::PendingRemote<TCPConnectedSocket>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("send_stream"), in_send_stream, 
                        "<value of type ::mojo::ScopedDataPipeConsumerHandle>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receive_stream"), in_receive_stream, 
                        "<value of type ::mojo::ScopedDataPipeProducerHandle>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kTCPServerSocket_Accept_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::TCPServerSocket_Accept_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->net_error = in_net_error;
  mojo::internal::MessageFragment<
      typename decltype(params->remote_addr)::BaseType> remote_addr_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::IPEndPointDataView>(
      in_remote_addr, remote_addr_fragment);
  params->remote_addr.Set(
      remote_addr_fragment.is_null() ? nullptr : remote_addr_fragment.data());
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::TCPConnectedSocketInterfaceBase>>(
      in_connected_socket, &params->connected_socket, &params.message());
  mojo::internal::Serialize<mojo::ScopedDataPipeConsumerHandle>(
      in_send_stream, &params->send_stream, &params.message());
  mojo::internal::Serialize<mojo::ScopedDataPipeProducerHandle>(
      in_receive_stream, &params->receive_stream, &params.message());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::TCPServerSocket::AcceptCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TCPServerSocket::Name_);
  message.set_method_name("Accept");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool TCPServerSocketStubDispatch::Accept(
    TCPServerSocket* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kTCPServerSocket_Accept_Name: {
      break;
    }
  }
  return false;
}

// static
bool TCPServerSocketStubDispatch::AcceptWithResponder(
    TCPServerSocket* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kTCPServerSocket_Accept_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::TCPServerSocket::Accept",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::TCPServerSocket::Accept");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::TCPServerSocket_Accept_Params_Data* params =
          reinterpret_cast<
              internal::TCPServerSocket_Accept_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<SocketObserver> p_observer{};
      TCPServerSocket_Accept_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_observer =
            input_data_view.TakeObserver<decltype(p_observer)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TCPServerSocket::Name_, 0, false);
        return false;
      }
      TCPServerSocket::AcceptCallback callback =
          TCPServerSocket_Accept_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Accept(
std::move(p_observer), std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kTCPServerSocketValidationInfo[] = {
    {internal::kTCPServerSocket_Accept_Name,
     {&internal::TCPServerSocket_Accept_Params_Data::Validate,
      &internal::TCPServerSocket_Accept_ResponseParams_Data::Validate}},
};

bool TCPServerSocketRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::TCPServerSocket::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kTCPServerSocketValidationInfo);
}

bool TCPServerSocketResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::TCPServerSocket::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kTCPServerSocketValidationInfo);

}
}  // namespace mojom
}  // namespace network

namespace mojo {


// static
bool StructTraits<::network::mojom::TCPConnectedSocketOptions::DataView, ::network::mojom::TCPConnectedSocketOptionsPtr>::Read(
    ::network::mojom::TCPConnectedSocketOptions::DataView input,
    ::network::mojom::TCPConnectedSocketOptionsPtr* output) {
  bool success = true;
  ::network::mojom::TCPConnectedSocketOptionsPtr result(::network::mojom::TCPConnectedSocketOptions::New());
  
      if (success)
        result->send_buffer_size = input.send_buffer_size();
      if (success)
        result->receive_buffer_size = input.receive_buffer_size();
      if (success)
        result->no_delay = input.no_delay();
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif