// services/network/public/mojom/url_loader.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/url_loader.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "services/network/public/mojom/url_loader.mojom-params-data.h"
#include "services/network/public/mojom/url_loader.mojom-shared-message-ids.h"

#include "services/network/public/mojom/url_loader.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_URL_LOADER_MOJOM_BLINK_JUMBO_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_URL_LOADER_MOJOM_BLINK_JUMBO_H_
#endif
namespace network {
namespace mojom {
namespace blink {
TrustedUrlRequestParams::TrustedUrlRequestParams()
    : isolation_info(),
      disable_secure_dns(),
      has_user_activation(),
      cookie_observer(),
      auth_cert_observer(),
      client_security_state() {}

TrustedUrlRequestParams::TrustedUrlRequestParams(
    const ::net::IsolationInfo& isolation_info_in,
    bool disable_secure_dns_in,
    bool has_user_activation_in,
    ::mojo::PendingRemote<::network::mojom::blink::CookieAccessObserver> cookie_observer_in,
    ::mojo::PendingRemote<::network::mojom::blink::AuthenticationAndCertificateObserver> auth_cert_observer_in,
    ::network::mojom::blink::ClientSecurityStatePtr client_security_state_in)
    : isolation_info(std::move(isolation_info_in)),
      disable_secure_dns(std::move(disable_secure_dns_in)),
      has_user_activation(std::move(has_user_activation_in)),
      cookie_observer(std::move(cookie_observer_in)),
      auth_cert_observer(std::move(auth_cert_observer_in)),
      client_security_state(std::move(client_security_state_in)) {}

TrustedUrlRequestParams::~TrustedUrlRequestParams() = default;

void TrustedUrlRequestParams::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "isolation_info"), this->isolation_info, 
      "<value of type const ::net::IsolationInfo&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "disable_secure_dns"), this->disable_secure_dns, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_user_activation"), this->has_user_activation, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cookie_observer"), this->cookie_observer, 
      "<value of type ::mojo::PendingRemote<::network::mojom::blink::CookieAccessObserver>>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "auth_cert_observer"), this->auth_cert_observer, 
      "<value of type ::mojo::PendingRemote<::network::mojom::blink::AuthenticationAndCertificateObserver>>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "client_security_state"), this->client_security_state, 
      "<value of type ::network::mojom::blink::ClientSecurityStatePtr>");
}

bool TrustedUrlRequestParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
WebBundleTokenParams::WebBundleTokenParams()
    : bundle_url(),
      token(),
      web_bundle_handle(),
      render_process_id() {}

WebBundleTokenParams::WebBundleTokenParams(
    const ::blink::KURL& bundle_url_in,
    const ::base::UnguessableToken& token_in,
    ::mojo::PendingRemote<::network::mojom::blink::WebBundleHandle> web_bundle_handle_in,
    int32_t render_process_id_in)
    : bundle_url(std::move(bundle_url_in)),
      token(std::move(token_in)),
      web_bundle_handle(std::move(web_bundle_handle_in)),
      render_process_id(std::move(render_process_id_in)) {}

WebBundleTokenParams::~WebBundleTokenParams() = default;

void WebBundleTokenParams::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bundle_url"), this->bundle_url, 
      "<value of type const ::blink::KURL&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "token"), this->token, 
      "<value of type const ::base::UnguessableToken&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "web_bundle_handle"), this->web_bundle_handle, 
      "<value of type ::mojo::PendingRemote<::network::mojom::blink::WebBundleHandle>>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "render_process_id"), this->render_process_id, 
      "<value of type int32_t>");
}

bool WebBundleTokenParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
URLRequest::URLRequest()
    : method(),
      url(),
      site_for_cookies(),
      update_first_party_url_on_redirect(),
      request_initiator(),
      navigation_redirect_chain(),
      isolated_world_origin(),
      referrer(),
      referrer_policy(),
      headers(),
      cors_exempt_headers(),
      load_flags(),
      resource_type(),
      priority(),
      should_reset_appcache(),
      is_external_request(),
      cors_preflight_policy(),
      originated_from_service_worker(),
      skip_service_worker(),
      corb_detachable(false),
      mode(),
      credentials_mode(),
      redirect_mode(),
      fetch_integrity(),
      destination(),
      request_body(),
      keepalive(),
      has_user_gesture(),
      enable_load_timing(),
      enable_upload_progress(),
      do_not_prompt_for_login(),
      render_frame_id(),
      is_main_frame(),
      transition_type(),
      report_raw_headers(),
      previews_state(),
      upgrade_if_insecure(),
      is_revalidating(),
      throttling_profile_id(),
      fetch_window_id(),
      devtools_request_id(),
      devtools_stack_id(),
      is_signed_exchange_prefetch_cache_enabled(),
      is_fetch_like_api(),
      is_favicon(),
      obey_origin_policy(),
      original_destination(),
      trusted_params(),
      recursive_prefetch_token(),
      trust_token_params(),
      web_bundle_token_params() {}

URLRequest::URLRequest(
    const WTF::String& method_in,
    const ::blink::KURL& url_in,
    const ::net::SiteForCookies& site_for_cookies_in,
    bool update_first_party_url_on_redirect_in,
    const ::scoped_refptr<const ::blink::SecurityOrigin>& request_initiator_in,
    WTF::Vector<::blink::KURL> navigation_redirect_chain_in,
    const ::scoped_refptr<const ::blink::SecurityOrigin>& isolated_world_origin_in,
    const ::blink::KURL& referrer_in,
    ::net::ReferrerPolicy referrer_policy_in,
    const ::net::HttpRequestHeaders& headers_in,
    const ::net::HttpRequestHeaders& cors_exempt_headers_in,
    int32_t load_flags_in,
    int32_t resource_type_in,
    ::net::RequestPriority priority_in,
    bool should_reset_appcache_in,
    bool is_external_request_in,
    ::network::mojom::blink::CorsPreflightPolicy cors_preflight_policy_in,
    bool originated_from_service_worker_in,
    bool skip_service_worker_in,
    bool corb_detachable_in,
    ::network::mojom::blink::RequestMode mode_in,
    ::network::mojom::blink::CredentialsMode credentials_mode_in,
    ::network::mojom::blink::RedirectMode redirect_mode_in,
    const WTF::String& fetch_integrity_in,
    ::network::mojom::blink::RequestDestination destination_in,
    ::scoped_refptr<::network::ResourceRequestBody> request_body_in,
    bool keepalive_in,
    bool has_user_gesture_in,
    bool enable_load_timing_in,
    bool enable_upload_progress_in,
    bool do_not_prompt_for_login_in,
    int32_t render_frame_id_in,
    bool is_main_frame_in,
    int32_t transition_type_in,
    bool report_raw_headers_in,
    int32_t previews_state_in,
    bool upgrade_if_insecure_in,
    bool is_revalidating_in,
    const base::Optional<::base::UnguessableToken>& throttling_profile_id_in,
    const base::Optional<::base::UnguessableToken>& fetch_window_id_in,
    const WTF::String& devtools_request_id_in,
    const WTF::String& devtools_stack_id_in,
    bool is_signed_exchange_prefetch_cache_enabled_in,
    bool is_fetch_like_api_in,
    bool is_favicon_in,
    bool obey_origin_policy_in,
    ::network::mojom::blink::RequestDestination original_destination_in,
    const base::Optional<::network::ResourceRequest::TrustedParams>& trusted_params_in,
    const base::Optional<::base::UnguessableToken>& recursive_prefetch_token_in,
    ::network::mojom::blink::TrustTokenParamsPtr trust_token_params_in,
    const base::Optional<::network::ResourceRequest::WebBundleTokenParams>& web_bundle_token_params_in)
    : method(std::move(method_in)),
      url(std::move(url_in)),
      site_for_cookies(std::move(site_for_cookies_in)),
      update_first_party_url_on_redirect(std::move(update_first_party_url_on_redirect_in)),
      request_initiator(std::move(request_initiator_in)),
      navigation_redirect_chain(std::move(navigation_redirect_chain_in)),
      isolated_world_origin(std::move(isolated_world_origin_in)),
      referrer(std::move(referrer_in)),
      referrer_policy(std::move(referrer_policy_in)),
      headers(std::move(headers_in)),
      cors_exempt_headers(std::move(cors_exempt_headers_in)),
      load_flags(std::move(load_flags_in)),
      resource_type(std::move(resource_type_in)),
      priority(std::move(priority_in)),
      should_reset_appcache(std::move(should_reset_appcache_in)),
      is_external_request(std::move(is_external_request_in)),
      cors_preflight_policy(std::move(cors_preflight_policy_in)),
      originated_from_service_worker(std::move(originated_from_service_worker_in)),
      skip_service_worker(std::move(skip_service_worker_in)),
      corb_detachable(std::move(corb_detachable_in)),
      mode(std::move(mode_in)),
      credentials_mode(std::move(credentials_mode_in)),
      redirect_mode(std::move(redirect_mode_in)),
      fetch_integrity(std::move(fetch_integrity_in)),
      destination(std::move(destination_in)),
      request_body(std::move(request_body_in)),
      keepalive(std::move(keepalive_in)),
      has_user_gesture(std::move(has_user_gesture_in)),
      enable_load_timing(std::move(enable_load_timing_in)),
      enable_upload_progress(std::move(enable_upload_progress_in)),
      do_not_prompt_for_login(std::move(do_not_prompt_for_login_in)),
      render_frame_id(std::move(render_frame_id_in)),
      is_main_frame(std::move(is_main_frame_in)),
      transition_type(std::move(transition_type_in)),
      report_raw_headers(std::move(report_raw_headers_in)),
      previews_state(std::move(previews_state_in)),
      upgrade_if_insecure(std::move(upgrade_if_insecure_in)),
      is_revalidating(std::move(is_revalidating_in)),
      throttling_profile_id(std::move(throttling_profile_id_in)),
      fetch_window_id(std::move(fetch_window_id_in)),
      devtools_request_id(std::move(devtools_request_id_in)),
      devtools_stack_id(std::move(devtools_stack_id_in)),
      is_signed_exchange_prefetch_cache_enabled(std::move(is_signed_exchange_prefetch_cache_enabled_in)),
      is_fetch_like_api(std::move(is_fetch_like_api_in)),
      is_favicon(std::move(is_favicon_in)),
      obey_origin_policy(std::move(obey_origin_policy_in)),
      original_destination(std::move(original_destination_in)),
      trusted_params(std::move(trusted_params_in)),
      recursive_prefetch_token(std::move(recursive_prefetch_token_in)),
      trust_token_params(std::move(trust_token_params_in)),
      web_bundle_token_params(std::move(web_bundle_token_params_in)) {}

URLRequest::~URLRequest() = default;

void URLRequest::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "method"), this->method, 
      "<value of type const WTF::String&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url, 
      "<value of type const ::blink::KURL&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "site_for_cookies"), this->site_for_cookies, 
      "<value of type const ::net::SiteForCookies&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "update_first_party_url_on_redirect"), this->update_first_party_url_on_redirect, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "request_initiator"), this->request_initiator, 
      "<value of type const ::scoped_refptr<const ::blink::SecurityOrigin>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "navigation_redirect_chain"), this->navigation_redirect_chain, 
      "<value of type const WTF::Vector<::blink::KURL>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "isolated_world_origin"), this->isolated_world_origin, 
      "<value of type const ::scoped_refptr<const ::blink::SecurityOrigin>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "referrer"), this->referrer, 
      "<value of type const ::blink::KURL&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "referrer_policy"), this->referrer_policy, 
      "<value of type ::net::ReferrerPolicy>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "headers"), this->headers, 
      "<value of type const ::net::HttpRequestHeaders&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cors_exempt_headers"), this->cors_exempt_headers, 
      "<value of type const ::net::HttpRequestHeaders&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "load_flags"), this->load_flags, 
      "<value of type int32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "resource_type"), this->resource_type, 
      "<value of type int32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "priority"), this->priority, 
      "<value of type ::net::RequestPriority>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "should_reset_appcache"), this->should_reset_appcache, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_external_request"), this->is_external_request, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cors_preflight_policy"), this->cors_preflight_policy, 
      "<value of type ::network::mojom::blink::CorsPreflightPolicy>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "originated_from_service_worker"), this->originated_from_service_worker, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "skip_service_worker"), this->skip_service_worker, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "corb_detachable"), this->corb_detachable, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mode"), this->mode, 
      "<value of type ::network::mojom::blink::RequestMode>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "credentials_mode"), this->credentials_mode, 
      "<value of type ::network::mojom::blink::CredentialsMode>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "redirect_mode"), this->redirect_mode, 
      "<value of type ::network::mojom::blink::RedirectMode>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "fetch_integrity"), this->fetch_integrity, 
      "<value of type const WTF::String&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "destination"), this->destination, 
      "<value of type ::network::mojom::blink::RequestDestination>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "request_body"), this->request_body, 
      "<value of type ::scoped_refptr<::network::ResourceRequestBody>>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "keepalive"), this->keepalive, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_user_gesture"), this->has_user_gesture, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_load_timing"), this->enable_load_timing, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_upload_progress"), this->enable_upload_progress, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "do_not_prompt_for_login"), this->do_not_prompt_for_login, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "render_frame_id"), this->render_frame_id, 
      "<value of type int32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_main_frame"), this->is_main_frame, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "transition_type"), this->transition_type, 
      "<value of type int32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "report_raw_headers"), this->report_raw_headers, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "previews_state"), this->previews_state, 
      "<value of type int32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "upgrade_if_insecure"), this->upgrade_if_insecure, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_revalidating"), this->is_revalidating, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "throttling_profile_id"), this->throttling_profile_id, 
      "<value of type const base::Optional<::base::UnguessableToken>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "fetch_window_id"), this->fetch_window_id, 
      "<value of type const base::Optional<::base::UnguessableToken>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "devtools_request_id"), this->devtools_request_id, 
      "<value of type const WTF::String&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "devtools_stack_id"), this->devtools_stack_id, 
      "<value of type const WTF::String&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_signed_exchange_prefetch_cache_enabled"), this->is_signed_exchange_prefetch_cache_enabled, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_fetch_like_api"), this->is_fetch_like_api, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_favicon"), this->is_favicon, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "obey_origin_policy"), this->obey_origin_policy, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "original_destination"), this->original_destination, 
      "<value of type ::network::mojom::blink::RequestDestination>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "trusted_params"), this->trusted_params, 
      "<value of type const base::Optional<::network::ResourceRequest::TrustedParams>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "recursive_prefetch_token"), this->recursive_prefetch_token, 
      "<value of type const base::Optional<::base::UnguessableToken>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "trust_token_params"), this->trust_token_params, 
      "<value of type ::network::mojom::blink::TrustTokenParamsPtr>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "web_bundle_token_params"), this->web_bundle_token_params, 
      "<value of type const base::Optional<::network::ResourceRequest::WebBundleTokenParams>&>");
}

bool URLRequest::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
URLRequestBody::URLRequestBody()
    : elements(),
      identifier(),
      contains_sensitive_info(),
      allow_http1_for_streaming_upload() {}

URLRequestBody::URLRequestBody(
    WTF::Vector<::network::DataElement> elements_in,
    uint64_t identifier_in,
    bool contains_sensitive_info_in,
    bool allow_http1_for_streaming_upload_in)
    : elements(std::move(elements_in)),
      identifier(std::move(identifier_in)),
      contains_sensitive_info(std::move(contains_sensitive_info_in)),
      allow_http1_for_streaming_upload(std::move(allow_http1_for_streaming_upload_in)) {}

URLRequestBody::~URLRequestBody() = default;

void URLRequestBody::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "elements"), this->elements, 
      "<value of type WTF::Vector<::network::DataElement>>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "identifier"), this->identifier, 
      "<value of type uint64_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "contains_sensitive_info"), this->contains_sensitive_info, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "allow_http1_for_streaming_upload"), this->allow_http1_for_streaming_upload, 
      "<value of type bool>");
}

bool URLRequestBody::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DataElementBytes::DataElementBytes()
    : data() {}

DataElementBytes::DataElementBytes(
    ::mojo_base::BigBuffer data_in)
    : data(std::move(data_in)) {}

DataElementBytes::~DataElementBytes() = default;

void DataElementBytes::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "data"), this->data, 
      "<value of type ::mojo_base::BigBuffer>");
}

bool DataElementBytes::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DataElementFile::DataElementFile()
    : path(),
      offset(),
      length(),
      expected_modification_time() {}

DataElementFile::DataElementFile(
    const ::base::FilePath& path_in,
    uint64_t offset_in,
    uint64_t length_in,
    ::base::Time expected_modification_time_in)
    : path(std::move(path_in)),
      offset(std::move(offset_in)),
      length(std::move(length_in)),
      expected_modification_time(std::move(expected_modification_time_in)) {}

DataElementFile::~DataElementFile() = default;

void DataElementFile::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "path"), this->path, 
      "<value of type const ::base::FilePath&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "offset"), this->offset, 
      "<value of type uint64_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "length"), this->length, 
      "<value of type uint64_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "expected_modification_time"), this->expected_modification_time, 
      "<value of type ::base::Time>");
}

bool DataElementFile::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DataElementDataPipe::DataElementDataPipe()
    : data_pipe_getter() {}

DataElementDataPipe::DataElementDataPipe(
    ::mojo::PendingRemote<::network::mojom::blink::DataPipeGetter> data_pipe_getter_in)
    : data_pipe_getter(std::move(data_pipe_getter_in)) {}

DataElementDataPipe::~DataElementDataPipe() = default;

void DataElementDataPipe::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "data_pipe_getter"), this->data_pipe_getter, 
      "<value of type ::mojo::PendingRemote<::network::mojom::blink::DataPipeGetter>>");
}

bool DataElementDataPipe::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DataElementChunkedDataPipe::DataElementChunkedDataPipe()
    : data_pipe_getter(),
      read_only_once() {}

DataElementChunkedDataPipe::DataElementChunkedDataPipe(
    ::mojo::PendingRemote<::network::mojom::blink::ChunkedDataPipeGetter> data_pipe_getter_in,
    bool read_only_once_in)
    : data_pipe_getter(std::move(data_pipe_getter_in)),
      read_only_once(std::move(read_only_once_in)) {}

DataElementChunkedDataPipe::~DataElementChunkedDataPipe() = default;

void DataElementChunkedDataPipe::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "data_pipe_getter"), this->data_pipe_getter, 
      "<value of type ::mojo::PendingRemote<::network::mojom::blink::ChunkedDataPipeGetter>>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "read_only_once"), this->read_only_once, 
      "<value of type bool>");
}

bool DataElementChunkedDataPipe::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
URLLoaderClientEndpoints::URLLoaderClientEndpoints()
    : url_loader(),
      url_loader_client() {}

URLLoaderClientEndpoints::URLLoaderClientEndpoints(
    ::mojo::PendingRemote<URLLoader> url_loader_in,
    ::mojo::PendingReceiver<URLLoaderClient> url_loader_client_in)
    : url_loader(std::move(url_loader_in)),
      url_loader_client(std::move(url_loader_client_in)) {}

URLLoaderClientEndpoints::~URLLoaderClientEndpoints() = default;

void URLLoaderClientEndpoints::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url_loader"), this->url_loader, 
      "<value of type ::mojo::PendingRemote<URLLoader>>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url_loader_client"), this->url_loader_client, 
      "<value of type ::mojo::PendingReceiver<URLLoaderClient>>");
}

bool URLLoaderClientEndpoints::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DataElement::DataElement() : tag_(Tag::BYTES) {
  data_.bytes = new ::network::DataElementBytes;
}

DataElement::~DataElement() {
  DestroyActive();
}


void DataElement::set_bytes(
    ::network::DataElementBytes bytes) {
  if (tag_ == Tag::BYTES) {
    *(data_.bytes) = std::move(bytes);
  } else {
    DestroyActive();
    tag_ = Tag::BYTES;
    data_.bytes = new ::network::DataElementBytes(
        std::move(bytes));
  }
}
void DataElement::set_file(
    ::network::DataElementFile file) {
  if (tag_ == Tag::FILE) {
    *(data_.file) = std::move(file);
  } else {
    DestroyActive();
    tag_ = Tag::FILE;
    data_.file = new ::network::DataElementFile(
        std::move(file));
  }
}
void DataElement::set_data_pipe(
    ::network::DataElementDataPipe data_pipe) {
  if (tag_ == Tag::DATA_PIPE) {
    *(data_.data_pipe) = std::move(data_pipe);
  } else {
    DestroyActive();
    tag_ = Tag::DATA_PIPE;
    data_.data_pipe = new ::network::DataElementDataPipe(
        std::move(data_pipe));
  }
}
void DataElement::set_chunked_data_pipe(
    ::network::DataElementChunkedDataPipe chunked_data_pipe) {
  if (tag_ == Tag::CHUNKED_DATA_PIPE) {
    *(data_.chunked_data_pipe) = std::move(chunked_data_pipe);
  } else {
    DestroyActive();
    tag_ = Tag::CHUNKED_DATA_PIPE;
    data_.chunked_data_pipe = new ::network::DataElementChunkedDataPipe(
        std::move(chunked_data_pipe));
  }
}

void DataElement::DestroyActive() {
  switch (tag_) {

    case Tag::BYTES:

      delete data_.bytes;
      break;
    case Tag::FILE:

      delete data_.file;
      break;
    case Tag::DATA_PIPE:

      delete data_.data_pipe;
      break;
    case Tag::CHUNKED_DATA_PIPE:

      delete data_.chunked_data_pipe;
      break;
  }
}

bool DataElement::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
const char URLLoader::Name_[] = "network.mojom.URLLoader";
constexpr uint32_t URLLoader::kClientDisconnectReason;

URLLoaderProxy::URLLoaderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void URLLoaderProxy::FollowRedirect(
    const WTF::Vector<WTF::String>& in_removed_headers, const ::net::HttpRequestHeaders& in_modified_headers, const ::net::HttpRequestHeaders& in_modified_cors_exempt_headers, const base::Optional<::blink::KURL>& in_new_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::URLLoader::FollowRedirect", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("removed_headers"), in_removed_headers, 
                        "<value of type const WTF::Vector<WTF::String>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("modified_headers"), in_modified_headers, 
                        "<value of type const ::net::HttpRequestHeaders&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("modified_cors_exempt_headers"), in_modified_cors_exempt_headers, 
                        "<value of type const ::net::HttpRequestHeaders&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("new_url"), in_new_url, 
                        "<value of type const base::Optional<::blink::KURL>&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kURLLoader_FollowRedirect_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::URLLoader_FollowRedirect_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->removed_headers)::BaseType>
      removed_headers_fragment(params.message());
  const mojo::internal::ContainerValidateParams removed_headers_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_removed_headers, removed_headers_fragment, &removed_headers_validate_params);
  params->removed_headers.Set(
      removed_headers_fragment.is_null() ? nullptr : removed_headers_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->removed_headers.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null removed_headers in URLLoader.FollowRedirect request");
  mojo::internal::MessageFragment<
      typename decltype(params->modified_headers)::BaseType> modified_headers_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::HttpRequestHeadersDataView>(
      in_modified_headers, modified_headers_fragment);
  params->modified_headers.Set(
      modified_headers_fragment.is_null() ? nullptr : modified_headers_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->modified_headers.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null modified_headers in URLLoader.FollowRedirect request");
  mojo::internal::MessageFragment<
      typename decltype(params->modified_cors_exempt_headers)::BaseType> modified_cors_exempt_headers_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::HttpRequestHeadersDataView>(
      in_modified_cors_exempt_headers, modified_cors_exempt_headers_fragment);
  params->modified_cors_exempt_headers.Set(
      modified_cors_exempt_headers_fragment.is_null() ? nullptr : modified_cors_exempt_headers_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->modified_cors_exempt_headers.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null modified_cors_exempt_headers in URLLoader.FollowRedirect request");
  mojo::internal::MessageFragment<
      typename decltype(params->new_url)::BaseType> new_url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_new_url, new_url_fragment);
  params->new_url.Set(
      new_url_fragment.is_null() ? nullptr : new_url_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(URLLoader::Name_);
  message.set_method_name("FollowRedirect");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void URLLoaderProxy::SetPriority(
    ::net::RequestPriority in_priority, int32_t in_intra_priority_value) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::URLLoader::SetPriority", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("priority"), in_priority, 
                        "<value of type ::net::RequestPriority>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("intra_priority_value"), in_intra_priority_value, 
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kURLLoader_SetPriority_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::URLLoader_SetPriority_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::network::mojom::RequestPriority>(
      in_priority, &params->priority);
  params->intra_priority_value = in_intra_priority_value;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(URLLoader::Name_);
  message.set_method_name("SetPriority");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void URLLoaderProxy::PauseReadingBodyFromNet(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "network::mojom::URLLoader::PauseReadingBodyFromNet");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kURLLoader_PauseReadingBodyFromNet_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::URLLoader_PauseReadingBodyFromNet_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(URLLoader::Name_);
  message.set_method_name("PauseReadingBodyFromNet");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void URLLoaderProxy::ResumeReadingBodyFromNet(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "network::mojom::URLLoader::ResumeReadingBodyFromNet");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kURLLoader_ResumeReadingBodyFromNet_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::URLLoader_ResumeReadingBodyFromNet_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(URLLoader::Name_);
  message.set_method_name("ResumeReadingBodyFromNet");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool URLLoaderStubDispatch::Accept(
    URLLoader* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kURLLoader_FollowRedirect_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::URLLoader::FollowRedirect",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::URLLoader::FollowRedirect");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::URLLoader_FollowRedirect_Params_Data* params =
          reinterpret_cast<internal::URLLoader_FollowRedirect_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      WTF::Vector<WTF::String> p_removed_headers{};
      ::net::HttpRequestHeaders p_modified_headers{};
      ::net::HttpRequestHeaders p_modified_cors_exempt_headers{};
      base::Optional<::blink::KURL> p_new_url{};
      URLLoader_FollowRedirect_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRemovedHeaders(&p_removed_headers))
        success = false;
      if (success && !input_data_view.ReadModifiedHeaders(&p_modified_headers))
        success = false;
      if (success && !input_data_view.ReadModifiedCorsExemptHeaders(&p_modified_cors_exempt_headers))
        success = false;
      if (success && !input_data_view.ReadNewUrl(&p_new_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            URLLoader::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FollowRedirect(
std::move(p_removed_headers), 
std::move(p_modified_headers), 
std::move(p_modified_cors_exempt_headers), 
std::move(p_new_url));
      return true;
    }
    case internal::kURLLoader_SetPriority_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::URLLoader::SetPriority",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::URLLoader::SetPriority");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::URLLoader_SetPriority_Params_Data* params =
          reinterpret_cast<internal::URLLoader_SetPriority_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::net::RequestPriority p_priority{};
      int32_t p_intra_priority_value{};
      URLLoader_SetPriority_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPriority(&p_priority))
        success = false;
      if (success)
        p_intra_priority_value = input_data_view.intra_priority_value();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            URLLoader::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetPriority(
std::move(p_priority), 
std::move(p_intra_priority_value));
      return true;
    }
    case internal::kURLLoader_PauseReadingBodyFromNet_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::URLLoader::PauseReadingBodyFromNet",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::URLLoader::PauseReadingBodyFromNet");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::URLLoader_PauseReadingBodyFromNet_Params_Data* params =
          reinterpret_cast<internal::URLLoader_PauseReadingBodyFromNet_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      URLLoader_PauseReadingBodyFromNet_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            URLLoader::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PauseReadingBodyFromNet();
      return true;
    }
    case internal::kURLLoader_ResumeReadingBodyFromNet_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::URLLoader::ResumeReadingBodyFromNet",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::URLLoader::ResumeReadingBodyFromNet");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::URLLoader_ResumeReadingBodyFromNet_Params_Data* params =
          reinterpret_cast<internal::URLLoader_ResumeReadingBodyFromNet_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      URLLoader_ResumeReadingBodyFromNet_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            URLLoader::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ResumeReadingBodyFromNet();
      return true;
    }
  }
  return false;
}

// static
bool URLLoaderStubDispatch::AcceptWithResponder(
    URLLoader* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kURLLoader_FollowRedirect_Name: {
      break;
    }
    case internal::kURLLoader_SetPriority_Name: {
      break;
    }
    case internal::kURLLoader_PauseReadingBodyFromNet_Name: {
      break;
    }
    case internal::kURLLoader_ResumeReadingBodyFromNet_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kURLLoaderValidationInfo[] = {
    {internal::kURLLoader_FollowRedirect_Name,
     {&internal::URLLoader_FollowRedirect_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kURLLoader_SetPriority_Name,
     {&internal::URLLoader_SetPriority_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kURLLoader_PauseReadingBodyFromNet_Name,
     {&internal::URLLoader_PauseReadingBodyFromNet_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kURLLoader_ResumeReadingBodyFromNet_Name,
     {&internal::URLLoader_ResumeReadingBodyFromNet_Params_Data::Validate,
      nullptr /* no response */}},
};

bool URLLoaderRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::blink::URLLoader::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kURLLoaderValidationInfo);
}

const char URLLoaderClient::Name_[] = "network.mojom.URLLoaderClient";

class URLLoaderClient_OnUploadProgress_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  URLLoaderClient_OnUploadProgress_ForwardToCallback(
      URLLoaderClient::OnUploadProgressCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  URLLoaderClient::OnUploadProgressCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(URLLoaderClient_OnUploadProgress_ForwardToCallback);
};

URLLoaderClientProxy::URLLoaderClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void URLLoaderClientProxy::OnReceiveResponse(
    ::network::mojom::blink::URLResponseHeadPtr in_head) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::URLLoaderClient::OnReceiveResponse", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("head"), in_head, 
                        "<value of type ::network::mojom::blink::URLResponseHeadPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kURLLoaderClient_OnReceiveResponse_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::URLLoaderClient_OnReceiveResponse_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->head)::BaseType> head_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::URLResponseHeadDataView>(
      in_head, head_fragment);
  params->head.Set(
      head_fragment.is_null() ? nullptr : head_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->head.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null head in URLLoaderClient.OnReceiveResponse request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(URLLoaderClient::Name_);
  message.set_method_name("OnReceiveResponse");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void URLLoaderClientProxy::OnReceiveRedirect(
    URLRequestRedirectInfoPtr in_redirect_info, ::network::mojom::blink::URLResponseHeadPtr in_head) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::URLLoaderClient::OnReceiveRedirect", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("redirect_info"), in_redirect_info, 
                        "<value of type URLRequestRedirectInfoPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("head"), in_head, 
                        "<value of type ::network::mojom::blink::URLResponseHeadPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kURLLoaderClient_OnReceiveRedirect_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::URLLoaderClient_OnReceiveRedirect_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->redirect_info)::BaseType> redirect_info_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::URLRequestRedirectInfoDataView>(
      in_redirect_info, redirect_info_fragment);
  params->redirect_info.Set(
      redirect_info_fragment.is_null() ? nullptr : redirect_info_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->redirect_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null redirect_info in URLLoaderClient.OnReceiveRedirect request");
  mojo::internal::MessageFragment<
      typename decltype(params->head)::BaseType> head_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::URLResponseHeadDataView>(
      in_head, head_fragment);
  params->head.Set(
      head_fragment.is_null() ? nullptr : head_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->head.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null head in URLLoaderClient.OnReceiveRedirect request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(URLLoaderClient::Name_);
  message.set_method_name("OnReceiveRedirect");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void URLLoaderClientProxy::OnUploadProgress(
    int64_t in_current_position, int64_t in_total_size, OnUploadProgressCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::URLLoaderClient::OnUploadProgress", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("current_position"), in_current_position, 
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("total_size"), in_total_size, 
                        "<value of type int64_t>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kURLLoaderClient_OnUploadProgress_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::URLLoaderClient_OnUploadProgress_Params_Data> params(
          message);
  params.Allocate();
  params->current_position = in_current_position;
  params->total_size = in_total_size;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(URLLoaderClient::Name_);
  message.set_method_name("OnUploadProgress");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new URLLoaderClient_OnUploadProgress_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void URLLoaderClientProxy::OnReceiveCachedMetadata(
    ::mojo_base::BigBuffer in_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::URLLoaderClient::OnReceiveCachedMetadata", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data, 
                        "<value of type ::mojo_base::BigBuffer>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kURLLoaderClient_OnReceiveCachedMetadata_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::URLLoaderClient_OnReceiveCachedMetadata_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->data)>
      data_fragment(params.message());
  data_fragment.Claim(&params->data);
  mojo::internal::Serialize<::mojo_base::mojom::BigBufferDataView>(
      in_data, data_fragment, true);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null data in URLLoaderClient.OnReceiveCachedMetadata request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(URLLoaderClient::Name_);
  message.set_method_name("OnReceiveCachedMetadata");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void URLLoaderClientProxy::OnTransferSizeUpdated(
    int32_t in_transfer_size_diff) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::URLLoaderClient::OnTransferSizeUpdated", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("transfer_size_diff"), in_transfer_size_diff, 
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kURLLoaderClient_OnTransferSizeUpdated_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::URLLoaderClient_OnTransferSizeUpdated_Params_Data> params(
          message);
  params.Allocate();
  params->transfer_size_diff = in_transfer_size_diff;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(URLLoaderClient::Name_);
  message.set_method_name("OnTransferSizeUpdated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void URLLoaderClientProxy::OnStartLoadingResponseBody(
    ::mojo::ScopedDataPipeConsumerHandle in_body) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::URLLoaderClient::OnStartLoadingResponseBody", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("body"), in_body, 
                        "<value of type ::mojo::ScopedDataPipeConsumerHandle>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kURLLoaderClient_OnStartLoadingResponseBody_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::URLLoaderClient_OnStartLoadingResponseBody_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::ScopedDataPipeConsumerHandle>(
      in_body, &params->body, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->body),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid body in URLLoaderClient.OnStartLoadingResponseBody request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(URLLoaderClient::Name_);
  message.set_method_name("OnStartLoadingResponseBody");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void URLLoaderClientProxy::OnComplete(
    URLLoaderCompletionStatusPtr in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::URLLoaderClient::OnComplete", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status, 
                        "<value of type URLLoaderCompletionStatusPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kURLLoaderClient_OnComplete_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::URLLoaderClient_OnComplete_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->status)::BaseType> status_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::URLLoaderCompletionStatusDataView>(
      in_status, status_fragment);
  params->status.Set(
      status_fragment.is_null() ? nullptr : status_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->status.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null status in URLLoaderClient.OnComplete request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(URLLoaderClient::Name_);
  message.set_method_name("OnComplete");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class URLLoaderClient_OnUploadProgress_ProxyToResponder {
 public:
  static URLLoaderClient::OnUploadProgressCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<URLLoaderClient_OnUploadProgress_ProxyToResponder> proxy(
        new URLLoaderClient_OnUploadProgress_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&URLLoaderClient_OnUploadProgress_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~URLLoaderClient_OnUploadProgress_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  URLLoaderClient_OnUploadProgress_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "URLLoaderClient::OnUploadProgressCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(URLLoaderClient_OnUploadProgress_ProxyToResponder);
};

bool URLLoaderClient_OnUploadProgress_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::URLLoaderClient::OnUploadProgressCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::URLLoaderClient_OnUploadProgress_ResponseParams_Data* params =
      reinterpret_cast<
          internal::URLLoaderClient_OnUploadProgress_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  URLLoaderClient_OnUploadProgress_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        URLLoaderClient::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void URLLoaderClient_OnUploadProgress_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)network::mojom::URLLoaderClient::OnUploadProgressCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kURLLoaderClient_OnUploadProgress_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::URLLoaderClient_OnUploadProgress_ResponseParams_Data> params(
          message);
  params.Allocate();

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::URLLoaderClient::OnUploadProgressCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(URLLoaderClient::Name_);
  message.set_method_name("OnUploadProgress");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool URLLoaderClientStubDispatch::Accept(
    URLLoaderClient* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kURLLoaderClient_OnReceiveResponse_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::URLLoaderClient::OnReceiveResponse",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::URLLoaderClient::OnReceiveResponse");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::URLLoaderClient_OnReceiveResponse_Params_Data* params =
          reinterpret_cast<internal::URLLoaderClient_OnReceiveResponse_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::network::mojom::blink::URLResponseHeadPtr p_head{};
      URLLoaderClient_OnReceiveResponse_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadHead(&p_head))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            URLLoaderClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnReceiveResponse(
std::move(p_head));
      return true;
    }
    case internal::kURLLoaderClient_OnReceiveRedirect_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::URLLoaderClient::OnReceiveRedirect",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::URLLoaderClient::OnReceiveRedirect");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::URLLoaderClient_OnReceiveRedirect_Params_Data* params =
          reinterpret_cast<internal::URLLoaderClient_OnReceiveRedirect_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      URLRequestRedirectInfoPtr p_redirect_info{};
      ::network::mojom::blink::URLResponseHeadPtr p_head{};
      URLLoaderClient_OnReceiveRedirect_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRedirectInfo(&p_redirect_info))
        success = false;
      if (success && !input_data_view.ReadHead(&p_head))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            URLLoaderClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnReceiveRedirect(
std::move(p_redirect_info), 
std::move(p_head));
      return true;
    }
    case internal::kURLLoaderClient_OnUploadProgress_Name: {
      break;
    }
    case internal::kURLLoaderClient_OnReceiveCachedMetadata_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::URLLoaderClient::OnReceiveCachedMetadata",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::URLLoaderClient::OnReceiveCachedMetadata");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::URLLoaderClient_OnReceiveCachedMetadata_Params_Data* params =
          reinterpret_cast<internal::URLLoaderClient_OnReceiveCachedMetadata_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo_base::BigBuffer p_data{};
      URLLoaderClient_OnReceiveCachedMetadata_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadData(&p_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            URLLoaderClient::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnReceiveCachedMetadata(
std::move(p_data));
      return true;
    }
    case internal::kURLLoaderClient_OnTransferSizeUpdated_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::URLLoaderClient::OnTransferSizeUpdated",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::URLLoaderClient::OnTransferSizeUpdated");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::URLLoaderClient_OnTransferSizeUpdated_Params_Data* params =
          reinterpret_cast<internal::URLLoaderClient_OnTransferSizeUpdated_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_transfer_size_diff{};
      URLLoaderClient_OnTransferSizeUpdated_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_transfer_size_diff = input_data_view.transfer_size_diff();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            URLLoaderClient::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnTransferSizeUpdated(
std::move(p_transfer_size_diff));
      return true;
    }
    case internal::kURLLoaderClient_OnStartLoadingResponseBody_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::URLLoaderClient::OnStartLoadingResponseBody",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::URLLoaderClient::OnStartLoadingResponseBody");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::URLLoaderClient_OnStartLoadingResponseBody_Params_Data* params =
          reinterpret_cast<internal::URLLoaderClient_OnStartLoadingResponseBody_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::ScopedDataPipeConsumerHandle p_body{};
      URLLoaderClient_OnStartLoadingResponseBody_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_body = input_data_view.TakeBody();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            URLLoaderClient::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnStartLoadingResponseBody(
std::move(p_body));
      return true;
    }
    case internal::kURLLoaderClient_OnComplete_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::URLLoaderClient::OnComplete",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::URLLoaderClient::OnComplete");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::URLLoaderClient_OnComplete_Params_Data* params =
          reinterpret_cast<internal::URLLoaderClient_OnComplete_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      URLLoaderCompletionStatusPtr p_status{};
      URLLoaderClient_OnComplete_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadStatus(&p_status))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            URLLoaderClient::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnComplete(
std::move(p_status));
      return true;
    }
  }
  return false;
}

// static
bool URLLoaderClientStubDispatch::AcceptWithResponder(
    URLLoaderClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kURLLoaderClient_OnReceiveResponse_Name: {
      break;
    }
    case internal::kURLLoaderClient_OnReceiveRedirect_Name: {
      break;
    }
    case internal::kURLLoaderClient_OnUploadProgress_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::URLLoaderClient::OnUploadProgress",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::URLLoaderClient::OnUploadProgress");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::URLLoaderClient_OnUploadProgress_Params_Data* params =
          reinterpret_cast<
              internal::URLLoaderClient_OnUploadProgress_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      int64_t p_current_position{};
      int64_t p_total_size{};
      URLLoaderClient_OnUploadProgress_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_current_position = input_data_view.current_position();
      if (success)
        p_total_size = input_data_view.total_size();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            URLLoaderClient::Name_, 2, false);
        return false;
      }
      URLLoaderClient::OnUploadProgressCallback callback =
          URLLoaderClient_OnUploadProgress_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnUploadProgress(
std::move(p_current_position), 
std::move(p_total_size), std::move(callback));
      return true;
    }
    case internal::kURLLoaderClient_OnReceiveCachedMetadata_Name: {
      break;
    }
    case internal::kURLLoaderClient_OnTransferSizeUpdated_Name: {
      break;
    }
    case internal::kURLLoaderClient_OnStartLoadingResponseBody_Name: {
      break;
    }
    case internal::kURLLoaderClient_OnComplete_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kURLLoaderClientValidationInfo[] = {
    {internal::kURLLoaderClient_OnReceiveResponse_Name,
     {&internal::URLLoaderClient_OnReceiveResponse_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kURLLoaderClient_OnReceiveRedirect_Name,
     {&internal::URLLoaderClient_OnReceiveRedirect_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kURLLoaderClient_OnUploadProgress_Name,
     {&internal::URLLoaderClient_OnUploadProgress_Params_Data::Validate,
      &internal::URLLoaderClient_OnUploadProgress_ResponseParams_Data::Validate}},
    {internal::kURLLoaderClient_OnReceiveCachedMetadata_Name,
     {&internal::URLLoaderClient_OnReceiveCachedMetadata_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kURLLoaderClient_OnTransferSizeUpdated_Name,
     {&internal::URLLoaderClient_OnTransferSizeUpdated_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kURLLoaderClient_OnStartLoadingResponseBody_Name,
     {&internal::URLLoaderClient_OnStartLoadingResponseBody_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kURLLoaderClient_OnComplete_Name,
     {&internal::URLLoaderClient_OnComplete_Params_Data::Validate,
      nullptr /* no response */}},
};

bool URLLoaderClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::blink::URLLoaderClient::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kURLLoaderClientValidationInfo);
}

bool URLLoaderClientResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::blink::URLLoaderClient::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kURLLoaderClientValidationInfo);

}
}  // namespace blink
}  // namespace mojom
}  // namespace network

namespace mojo {


// static
bool StructTraits<::network::mojom::blink::TrustedUrlRequestParams::DataView, ::network::mojom::blink::TrustedUrlRequestParamsPtr>::Read(
    ::network::mojom::blink::TrustedUrlRequestParams::DataView input,
    ::network::mojom::blink::TrustedUrlRequestParamsPtr* output) {
  bool success = true;
  ::network::mojom::blink::TrustedUrlRequestParamsPtr result(::network::mojom::blink::TrustedUrlRequestParams::New());
  
      if (success && !input.ReadIsolationInfo(&result->isolation_info))
        success = false;
      if (success)
        result->disable_secure_dns = input.disable_secure_dns();
      if (success)
        result->has_user_activation = input.has_user_activation();
      if (success) {
        result->cookie_observer =
            input.TakeCookieObserver<decltype(result->cookie_observer)>();
      }
      if (success) {
        result->auth_cert_observer =
            input.TakeAuthCertObserver<decltype(result->auth_cert_observer)>();
      }
      if (success && !input.ReadClientSecurityState(&result->client_security_state))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::WebBundleTokenParams::DataView, ::network::mojom::blink::WebBundleTokenParamsPtr>::Read(
    ::network::mojom::blink::WebBundleTokenParams::DataView input,
    ::network::mojom::blink::WebBundleTokenParamsPtr* output) {
  bool success = true;
  ::network::mojom::blink::WebBundleTokenParamsPtr result(::network::mojom::blink::WebBundleTokenParams::New());
  
      if (success && !input.ReadBundleUrl(&result->bundle_url))
        success = false;
      if (success && !input.ReadToken(&result->token))
        success = false;
      if (success) {
        result->web_bundle_handle =
            input.TakeWebBundleHandle<decltype(result->web_bundle_handle)>();
      }
      if (success)
        result->render_process_id = input.render_process_id();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::URLRequest::DataView, ::network::mojom::blink::URLRequestPtr>::Read(
    ::network::mojom::blink::URLRequest::DataView input,
    ::network::mojom::blink::URLRequestPtr* output) {
  bool success = true;
  ::network::mojom::blink::URLRequestPtr result(::network::mojom::blink::URLRequest::New());
  
      if (success && !input.ReadMethod(&result->method))
        success = false;
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadSiteForCookies(&result->site_for_cookies))
        success = false;
      if (success)
        result->update_first_party_url_on_redirect = input.update_first_party_url_on_redirect();
      if (success && !input.ReadRequestInitiator(&result->request_initiator))
        success = false;
      if (success && !input.ReadNavigationRedirectChain(&result->navigation_redirect_chain))
        success = false;
      if (success && !input.ReadIsolatedWorldOrigin(&result->isolated_world_origin))
        success = false;
      if (success && !input.ReadReferrer(&result->referrer))
        success = false;
      if (success && !input.ReadReferrerPolicy(&result->referrer_policy))
        success = false;
      if (success && !input.ReadHeaders(&result->headers))
        success = false;
      if (success && !input.ReadCorsExemptHeaders(&result->cors_exempt_headers))
        success = false;
      if (success)
        result->load_flags = input.load_flags();
      if (success)
        result->resource_type = input.resource_type();
      if (success && !input.ReadPriority(&result->priority))
        success = false;
      if (success)
        result->should_reset_appcache = input.should_reset_appcache();
      if (success)
        result->is_external_request = input.is_external_request();
      if (success && !input.ReadCorsPreflightPolicy(&result->cors_preflight_policy))
        success = false;
      if (success)
        result->originated_from_service_worker = input.originated_from_service_worker();
      if (success)
        result->skip_service_worker = input.skip_service_worker();
      if (success)
        result->corb_detachable = input.corb_detachable();
      if (success && !input.ReadMode(&result->mode))
        success = false;
      if (success && !input.ReadCredentialsMode(&result->credentials_mode))
        success = false;
      if (success && !input.ReadRedirectMode(&result->redirect_mode))
        success = false;
      if (success && !input.ReadFetchIntegrity(&result->fetch_integrity))
        success = false;
      if (success && !input.ReadDestination(&result->destination))
        success = false;
      if (success && !input.ReadRequestBody(&result->request_body))
        success = false;
      if (success)
        result->keepalive = input.keepalive();
      if (success)
        result->has_user_gesture = input.has_user_gesture();
      if (success)
        result->enable_load_timing = input.enable_load_timing();
      if (success)
        result->enable_upload_progress = input.enable_upload_progress();
      if (success)
        result->do_not_prompt_for_login = input.do_not_prompt_for_login();
      if (success)
        result->render_frame_id = input.render_frame_id();
      if (success)
        result->is_main_frame = input.is_main_frame();
      if (success)
        result->transition_type = input.transition_type();
      if (success)
        result->report_raw_headers = input.report_raw_headers();
      if (success)
        result->previews_state = input.previews_state();
      if (success)
        result->upgrade_if_insecure = input.upgrade_if_insecure();
      if (success)
        result->is_revalidating = input.is_revalidating();
      if (success && !input.ReadThrottlingProfileId(&result->throttling_profile_id))
        success = false;
      if (success && !input.ReadFetchWindowId(&result->fetch_window_id))
        success = false;
      if (success && !input.ReadDevtoolsRequestId(&result->devtools_request_id))
        success = false;
      if (success && !input.ReadDevtoolsStackId(&result->devtools_stack_id))
        success = false;
      if (success)
        result->is_signed_exchange_prefetch_cache_enabled = input.is_signed_exchange_prefetch_cache_enabled();
      if (success)
        result->is_fetch_like_api = input.is_fetch_like_api();
      if (success)
        result->is_favicon = input.is_favicon();
      if (success)
        result->obey_origin_policy = input.obey_origin_policy();
      if (success && !input.ReadOriginalDestination(&result->original_destination))
        success = false;
      if (success && !input.ReadTrustedParams(&result->trusted_params))
        success = false;
      if (success && !input.ReadRecursivePrefetchToken(&result->recursive_prefetch_token))
        success = false;
      if (success && !input.ReadTrustTokenParams(&result->trust_token_params))
        success = false;
      if (success && !input.ReadWebBundleTokenParams(&result->web_bundle_token_params))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::URLRequestBody::DataView, ::network::mojom::blink::URLRequestBodyPtr>::Read(
    ::network::mojom::blink::URLRequestBody::DataView input,
    ::network::mojom::blink::URLRequestBodyPtr* output) {
  bool success = true;
  ::network::mojom::blink::URLRequestBodyPtr result(::network::mojom::blink::URLRequestBody::New());
  
      if (success && !input.ReadElements(&result->elements))
        success = false;
      if (success)
        result->identifier = input.identifier();
      if (success)
        result->contains_sensitive_info = input.contains_sensitive_info();
      if (success)
        result->allow_http1_for_streaming_upload = input.allow_http1_for_streaming_upload();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::DataElementBytes::DataView, ::network::mojom::blink::DataElementBytesPtr>::Read(
    ::network::mojom::blink::DataElementBytes::DataView input,
    ::network::mojom::blink::DataElementBytesPtr* output) {
  bool success = true;
  ::network::mojom::blink::DataElementBytesPtr result(::network::mojom::blink::DataElementBytes::New());
  
      if (success && !input.ReadData(&result->data))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::DataElementFile::DataView, ::network::mojom::blink::DataElementFilePtr>::Read(
    ::network::mojom::blink::DataElementFile::DataView input,
    ::network::mojom::blink::DataElementFilePtr* output) {
  bool success = true;
  ::network::mojom::blink::DataElementFilePtr result(::network::mojom::blink::DataElementFile::New());
  
      if (success && !input.ReadPath(&result->path))
        success = false;
      if (success)
        result->offset = input.offset();
      if (success)
        result->length = input.length();
      if (success && !input.ReadExpectedModificationTime(&result->expected_modification_time))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::DataElementDataPipe::DataView, ::network::mojom::blink::DataElementDataPipePtr>::Read(
    ::network::mojom::blink::DataElementDataPipe::DataView input,
    ::network::mojom::blink::DataElementDataPipePtr* output) {
  bool success = true;
  ::network::mojom::blink::DataElementDataPipePtr result(::network::mojom::blink::DataElementDataPipe::New());
  
      if (success) {
        result->data_pipe_getter =
            input.TakeDataPipeGetter<decltype(result->data_pipe_getter)>();
      }
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::DataElementChunkedDataPipe::DataView, ::network::mojom::blink::DataElementChunkedDataPipePtr>::Read(
    ::network::mojom::blink::DataElementChunkedDataPipe::DataView input,
    ::network::mojom::blink::DataElementChunkedDataPipePtr* output) {
  bool success = true;
  ::network::mojom::blink::DataElementChunkedDataPipePtr result(::network::mojom::blink::DataElementChunkedDataPipe::New());
  
      if (success) {
        result->data_pipe_getter =
            input.TakeDataPipeGetter<decltype(result->data_pipe_getter)>();
      }
      if (success)
        result->read_only_once = input.read_only_once();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::URLLoaderClientEndpoints::DataView, ::network::mojom::blink::URLLoaderClientEndpointsPtr>::Read(
    ::network::mojom::blink::URLLoaderClientEndpoints::DataView input,
    ::network::mojom::blink::URLLoaderClientEndpointsPtr* output) {
  bool success = true;
  ::network::mojom::blink::URLLoaderClientEndpointsPtr result(::network::mojom::blink::URLLoaderClientEndpoints::New());
  
      if (success) {
        result->url_loader =
            input.TakeUrlLoader<decltype(result->url_loader)>();
      }
      if (success) {
        result->url_loader_client =
            input.TakeUrlLoaderClient<decltype(result->url_loader_client)>();
      }
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::network::mojom::blink::DataElement::DataView, ::network::mojom::blink::DataElementPtr>::Read(
    ::network::mojom::blink::DataElement::DataView input,
    ::network::mojom::blink::DataElementPtr* output) {
  using UnionType = ::network::mojom::blink::DataElement;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::BYTES: {
      ::network::DataElementBytes result_bytes;
      if (!input.ReadBytes(&result_bytes))
        return false;

      *output = UnionType::NewBytes(
          std::move(result_bytes));
      break;
    }
    case Tag::FILE: {
      ::network::DataElementFile result_file;
      if (!input.ReadFile(&result_file))
        return false;

      *output = UnionType::NewFile(
          std::move(result_file));
      break;
    }
    case Tag::DATA_PIPE: {
      ::network::DataElementDataPipe result_data_pipe;
      if (!input.ReadDataPipe(&result_data_pipe))
        return false;

      *output = UnionType::NewDataPipe(
          std::move(result_data_pipe));
      break;
    }
    case Tag::CHUNKED_DATA_PIPE: {
      ::network::DataElementChunkedDataPipe result_chunked_data_pipe;
      if (!input.ReadChunkedDataPipe(&result_chunked_data_pipe))
        return false;

      *output = UnionType::NewChunkedDataPipe(
          std::move(result_chunked_data_pipe));
      break;
    }
    default:
      return false;
  }
  return true;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif