// services/network/public/mojom/web_sandbox_flags.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/network/public/mojom/web_sandbox_flags.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/web_sandbox_flags.mojom-params-data.h"
namespace network {
namespace mojom {

std::string WebSandboxFlagsToString(WebSandboxFlags value) {
  switch(value) {
    case WebSandboxFlags::kAll:
      return "WebSandboxFlags::kAll";
    case WebSandboxFlags::kNone:
      return "WebSandboxFlags::kNone";
    case WebSandboxFlags::kNavigation:
      return "WebSandboxFlags::kNavigation";
    case WebSandboxFlags::kPlugins:
      return "WebSandboxFlags::kPlugins";
    case WebSandboxFlags::kOrigin:
      return "WebSandboxFlags::kOrigin";
    case WebSandboxFlags::kForms:
      return "WebSandboxFlags::kForms";
    case WebSandboxFlags::kScripts:
      return "WebSandboxFlags::kScripts";
    case WebSandboxFlags::kTopNavigation:
      return "WebSandboxFlags::kTopNavigation";
    case WebSandboxFlags::kPopups:
      return "WebSandboxFlags::kPopups";
    case WebSandboxFlags::kAutomaticFeatures:
      return "WebSandboxFlags::kAutomaticFeatures";
    case WebSandboxFlags::kPointerLock:
      return "WebSandboxFlags::kPointerLock";
    case WebSandboxFlags::kDocumentDomain:
      return "WebSandboxFlags::kDocumentDomain";
    case WebSandboxFlags::kOrientationLock:
      return "WebSandboxFlags::kOrientationLock";
    case WebSandboxFlags::kPropagatesToAuxiliaryBrowsingContexts:
      return "WebSandboxFlags::kPropagatesToAuxiliaryBrowsingContexts";
    case WebSandboxFlags::kModals:
      return "WebSandboxFlags::kModals";
    case WebSandboxFlags::kPresentationController:
      return "WebSandboxFlags::kPresentationController";
    case WebSandboxFlags::kTopNavigationByUserActivation:
      return "WebSandboxFlags::kTopNavigationByUserActivation";
    case WebSandboxFlags::kDownloads:
      return "WebSandboxFlags::kDownloads";
    case WebSandboxFlags::kStorageAccessByUserActivation:
      return "WebSandboxFlags::kStorageAccessByUserActivation";
    default:
      return base::StringPrintf("Unknown WebSandboxFlags value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, WebSandboxFlags value) {
  return os << WebSandboxFlagsToString(value);
}

namespace internal {

}  // namespace internal
}  // namespace mojom
}  // namespace network

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::WebSandboxFlags>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::network::mojom::WebSandboxFlags value) {
  return std::move(context).WriteString(::network::mojom::WebSandboxFlagsToString(value));
}

} // namespace perfetto
