// services/network/public/mojom/x_frame_options.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/network/public/mojom/x_frame_options.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/x_frame_options.mojom-params-data.h"
namespace network {
namespace mojom {

std::string XFrameOptionsValueToString(XFrameOptionsValue value) {
  switch(value) {
    case XFrameOptionsValue::kNone:
      return "XFrameOptionsValue::kNone";
    case XFrameOptionsValue::kDeny:
      return "XFrameOptionsValue::kDeny";
    case XFrameOptionsValue::kSameOrigin:
      return "XFrameOptionsValue::kSameOrigin";
    case XFrameOptionsValue::kAllowAll:
      return "XFrameOptionsValue::kAllowAll";
    case XFrameOptionsValue::kInvalid:
      return "XFrameOptionsValue::kInvalid";
    case XFrameOptionsValue::kConflict:
      return "XFrameOptionsValue::kConflict";
    default:
      return base::StringPrintf("Unknown XFrameOptionsValue value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, XFrameOptionsValue value) {
  return os << XFrameOptionsValueToString(value);
}

namespace internal {

}  // namespace internal
}  // namespace mojom
}  // namespace network

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::XFrameOptionsValue>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::network::mojom::XFrameOptionsValue value) {
  return std::move(context).WriteString(::network::mojom::XFrameOptionsValueToString(value));
}

} // namespace perfetto
