// services/tracing/public/mojom/perfetto_service.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/tracing/public/mojom/perfetto_service.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/tracing/public/mojom/perfetto_service.mojom-params-data.h"
namespace tracing {
namespace mojom {

std::string BufferFillPolicyToString(BufferFillPolicy value) {
  switch(value) {
    case BufferFillPolicy::kUnspecified:
      return "BufferFillPolicy::kUnspecified";
    case BufferFillPolicy::kRingBuffer:
      return "BufferFillPolicy::kRingBuffer";
    case BufferFillPolicy::kDiscard:
      return "BufferFillPolicy::kDiscard";
    default:
      return base::StringPrintf("Unknown BufferFillPolicy value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, BufferFillPolicy value) {
  return os << BufferFillPolicyToString(value);
}

std::string TracingClientPriorityToString(TracingClientPriority value) {
  switch(value) {
    case TracingClientPriority::kUnknown:
      return "TracingClientPriority::kUnknown";
    case TracingClientPriority::kBackground:
      return "TracingClientPriority::kBackground";
    case TracingClientPriority::kUserInitiated:
      return "TracingClientPriority::kUserInitiated";
    default:
      return base::StringPrintf("Unknown TracingClientPriority value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, TracingClientPriority value) {
  return os << TracingClientPriorityToString(value);
}

namespace internal {


// static
bool ChunksToMove_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ChunksToMove_Data* object = static_cast<const ChunksToMove_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

ChunksToMove_Data::ChunksToMove_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ChunkPatch_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ChunkPatch_Data* object = static_cast<const ChunkPatch_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->data, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams data_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->data, validation_context,
                                         &data_validate_params)) {
    return false;
  }

  return true;
}

ChunkPatch_Data::ChunkPatch_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ChunksToPatch_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ChunksToPatch_Data* object = static_cast<const ChunksToPatch_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->patches, 4, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams patches_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->patches, validation_context,
                                         &patches_validate_params)) {
    return false;
  }

  return true;
}

ChunksToPatch_Data::ChunksToPatch_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CommitDataRequest_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CommitDataRequest_Data* object = static_cast<const CommitDataRequest_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->chunks_to_move, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams chunks_to_move_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->chunks_to_move, validation_context,
                                         &chunks_to_move_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->chunks_to_patch, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams chunks_to_patch_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->chunks_to_patch, validation_context,
                                         &chunks_to_patch_validate_params)) {
    return false;
  }

  return true;
}

CommitDataRequest_Data::CommitDataRequest_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ChromeConfig_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ChromeConfig_Data* object = static_cast<const ChromeConfig_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->trace_config, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams trace_config_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->trace_config, validation_context,
                                         &trace_config_validate_params)) {
    return false;
  }


  if (!::tracing::mojom::internal::TracingClientPriority_Data
        ::Validate(object->client_priority, validation_context))
    return false;

  return true;
}

ChromeConfig_Data::ChromeConfig_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DataSourceConfig_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DataSourceConfig_Data* object = static_cast<const DataSourceConfig_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->chrome_config, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->chrome_config, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->legacy_config, 6, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams legacy_config_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->legacy_config, validation_context,
                                         &legacy_config_validate_params)) {
    return false;
  }

  return true;
}

DataSourceConfig_Data::DataSourceConfig_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DataSourceRegistration_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DataSourceRegistration_Data* object = static_cast<const DataSourceRegistration_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }

  return true;
}

DataSourceRegistration_Data::DataSourceRegistration_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BufferConfig_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const BufferConfig_Data* object = static_cast<const BufferConfig_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::tracing::mojom::internal::BufferFillPolicy_Data
        ::Validate(object->fill_policy, validation_context))
    return false;

  return true;
}

BufferConfig_Data::BufferConfig_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DataSource_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DataSource_Data* object = static_cast<const DataSource_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->config, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->config, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->producer_name_filter, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams producer_name_filter_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->producer_name_filter, validation_context,
                                         &producer_name_filter_validate_params)) {
    return false;
  }

  return true;
}

DataSource_Data::DataSource_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PerfettoBuiltinDataSource_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PerfettoBuiltinDataSource_Data* object = static_cast<const PerfettoBuiltinDataSource_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

PerfettoBuiltinDataSource_Data::PerfettoBuiltinDataSource_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IncrementalStateConfig_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IncrementalStateConfig_Data* object = static_cast<const IncrementalStateConfig_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

IncrementalStateConfig_Data::IncrementalStateConfig_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TraceConfig_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const TraceConfig_Data* object = static_cast<const TraceConfig_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->data_sources, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams data_sources_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->data_sources, validation_context,
                                         &data_sources_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->perfetto_builtin_data_source, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->perfetto_builtin_data_source, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->buffers, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams buffers_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->buffers, validation_context,
                                         &buffers_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->incremental_state_config, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->incremental_state_config, validation_context))
    return false;

  return true;
}

TraceConfig_Data::TraceConfig_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProducerHost_CommitData_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ProducerHost_CommitData_Params_Data* object = static_cast<const ProducerHost_CommitData_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->data_request, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->data_request, validation_context))
    return false;

  return true;
}

ProducerHost_CommitData_Params_Data::ProducerHost_CommitData_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProducerHost_CommitData_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ProducerHost_CommitData_ResponseParams_Data* object = static_cast<const ProducerHost_CommitData_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

ProducerHost_CommitData_ResponseParams_Data::ProducerHost_CommitData_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProducerHost_RegisterDataSource_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ProducerHost_RegisterDataSource_Params_Data* object = static_cast<const ProducerHost_RegisterDataSource_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->registration_info, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->registration_info, validation_context))
    return false;

  return true;
}

ProducerHost_RegisterDataSource_Params_Data::ProducerHost_RegisterDataSource_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProducerHost_RegisterTraceWriter_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ProducerHost_RegisterTraceWriter_Params_Data* object = static_cast<const ProducerHost_RegisterTraceWriter_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

ProducerHost_RegisterTraceWriter_Params_Data::ProducerHost_RegisterTraceWriter_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProducerHost_UnregisterTraceWriter_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ProducerHost_UnregisterTraceWriter_Params_Data* object = static_cast<const ProducerHost_UnregisterTraceWriter_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

ProducerHost_UnregisterTraceWriter_Params_Data::ProducerHost_UnregisterTraceWriter_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProducerClient_OnTracingStart_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ProducerClient_OnTracingStart_Params_Data* object = static_cast<const ProducerClient_OnTracingStart_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

ProducerClient_OnTracingStart_Params_Data::ProducerClient_OnTracingStart_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProducerClient_StartDataSource_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ProducerClient_StartDataSource_Params_Data* object = static_cast<const ProducerClient_StartDataSource_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->data_source_config, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->data_source_config, validation_context))
    return false;

  return true;
}

ProducerClient_StartDataSource_Params_Data::ProducerClient_StartDataSource_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProducerClient_StartDataSource_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ProducerClient_StartDataSource_ResponseParams_Data* object = static_cast<const ProducerClient_StartDataSource_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

ProducerClient_StartDataSource_ResponseParams_Data::ProducerClient_StartDataSource_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProducerClient_StopDataSource_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ProducerClient_StopDataSource_Params_Data* object = static_cast<const ProducerClient_StopDataSource_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

ProducerClient_StopDataSource_Params_Data::ProducerClient_StopDataSource_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProducerClient_StopDataSource_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ProducerClient_StopDataSource_ResponseParams_Data* object = static_cast<const ProducerClient_StopDataSource_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

ProducerClient_StopDataSource_ResponseParams_Data::ProducerClient_StopDataSource_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProducerClient_Flush_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ProducerClient_Flush_Params_Data* object = static_cast<const ProducerClient_Flush_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->data_source_ids, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams data_source_ids_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->data_source_ids, validation_context,
                                         &data_source_ids_validate_params)) {
    return false;
  }

  return true;
}

ProducerClient_Flush_Params_Data::ProducerClient_Flush_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProducerClient_ClearIncrementalState_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ProducerClient_ClearIncrementalState_Params_Data* object = static_cast<const ProducerClient_ClearIncrementalState_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

ProducerClient_ClearIncrementalState_Params_Data::ProducerClient_ClearIncrementalState_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PerfettoService_ConnectToProducerHost_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PerfettoService_ConnectToProducerHost_Params_Data* object = static_cast<const PerfettoService_ConnectToProducerHost_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->producer_client, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->producer_client,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->producer_host_receiver, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->producer_host_receiver,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->shared_memory, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->shared_memory,
                                                 validation_context)) {
    return false;
  }

  return true;
}

PerfettoService_ConnectToProducerHost_Params_Data::PerfettoService_ConnectToProducerHost_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ConsumerHost_EnableTracing_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ConsumerHost_EnableTracing_Params_Data* object = static_cast<const ConsumerHost_EnableTracing_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->tracing_session_host, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->tracing_session_host,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->tracing_session_client, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->tracing_session_client,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->config, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->config, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->output_file, validation_context))
    return false;

  return true;
}

ConsumerHost_EnableTracing_Params_Data::ConsumerHost_EnableTracing_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TracingSessionHost_ChangeTraceConfig_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const TracingSessionHost_ChangeTraceConfig_Params_Data* object = static_cast<const TracingSessionHost_ChangeTraceConfig_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->config, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->config, validation_context))
    return false;

  return true;
}

TracingSessionHost_ChangeTraceConfig_Params_Data::TracingSessionHost_ChangeTraceConfig_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TracingSessionHost_DisableTracing_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const TracingSessionHost_DisableTracing_Params_Data* object = static_cast<const TracingSessionHost_DisableTracing_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

TracingSessionHost_DisableTracing_Params_Data::TracingSessionHost_DisableTracing_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TracingSessionHost_ReadBuffers_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const TracingSessionHost_ReadBuffers_Params_Data* object = static_cast<const TracingSessionHost_ReadBuffers_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->stream, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->stream,
                                                 validation_context)) {
    return false;
  }

  return true;
}

TracingSessionHost_ReadBuffers_Params_Data::TracingSessionHost_ReadBuffers_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TracingSessionHost_ReadBuffers_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const TracingSessionHost_ReadBuffers_ResponseParams_Data* object = static_cast<const TracingSessionHost_ReadBuffers_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

TracingSessionHost_ReadBuffers_ResponseParams_Data::TracingSessionHost_ReadBuffers_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TracingSessionHost_RequestBufferUsage_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const TracingSessionHost_RequestBufferUsage_Params_Data* object = static_cast<const TracingSessionHost_RequestBufferUsage_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

TracingSessionHost_RequestBufferUsage_Params_Data::TracingSessionHost_RequestBufferUsage_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TracingSessionHost_RequestBufferUsage_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const TracingSessionHost_RequestBufferUsage_ResponseParams_Data* object = static_cast<const TracingSessionHost_RequestBufferUsage_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

TracingSessionHost_RequestBufferUsage_ResponseParams_Data::TracingSessionHost_RequestBufferUsage_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TracingSessionHost_DisableTracingAndEmitJson_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const TracingSessionHost_DisableTracingAndEmitJson_Params_Data* object = static_cast<const TracingSessionHost_DisableTracingAndEmitJson_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->agent_label_filter, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams agent_label_filter_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->agent_label_filter, validation_context,
                                         &agent_label_filter_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->stream, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->stream,
                                                 validation_context)) {
    return false;
  }

  return true;
}

TracingSessionHost_DisableTracingAndEmitJson_Params_Data::TracingSessionHost_DisableTracingAndEmitJson_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TracingSessionHost_DisableTracingAndEmitJson_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const TracingSessionHost_DisableTracingAndEmitJson_ResponseParams_Data* object = static_cast<const TracingSessionHost_DisableTracingAndEmitJson_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

TracingSessionHost_DisableTracingAndEmitJson_ResponseParams_Data::TracingSessionHost_DisableTracingAndEmitJson_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TracingSessionClient_OnTracingEnabled_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const TracingSessionClient_OnTracingEnabled_Params_Data* object = static_cast<const TracingSessionClient_OnTracingEnabled_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

TracingSessionClient_OnTracingEnabled_Params_Data::TracingSessionClient_OnTracingEnabled_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TracingSessionClient_OnTracingDisabled_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const TracingSessionClient_OnTracingDisabled_Params_Data* object = static_cast<const TracingSessionClient_OnTracingDisabled_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

TracingSessionClient_OnTracingDisabled_Params_Data::TracingSessionClient_OnTracingDisabled_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace tracing

namespace perfetto {

// static
void TraceFormatTraits<::tracing::mojom::BufferFillPolicy>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::tracing::mojom::BufferFillPolicy value) {
  return std::move(context).WriteString(::tracing::mojom::BufferFillPolicyToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::tracing::mojom::TracingClientPriority>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::tracing::mojom::TracingClientPriority value) {
  return std::move(context).WriteString(::tracing::mojom::TracingClientPriorityToString(value));
}

} // namespace perfetto
