// services/video_capture/public/mojom/device_factory.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/video_capture/public/mojom/device_factory.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/video_capture/public/mojom/device_factory.mojom-params-data.h"
namespace video_capture {
namespace mojom {

std::string DeviceAccessResultCodeToString(DeviceAccessResultCode value) {
  switch(value) {
    case DeviceAccessResultCode::NOT_INITIALIZED:
      return "DeviceAccessResultCode::NOT_INITIALIZED";
    case DeviceAccessResultCode::SUCCESS:
      return "DeviceAccessResultCode::SUCCESS";
    case DeviceAccessResultCode::ERROR_DEVICE_NOT_FOUND:
      return "DeviceAccessResultCode::ERROR_DEVICE_NOT_FOUND";
    default:
      return base::StringPrintf("Unknown DeviceAccessResultCode value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, DeviceAccessResultCode value) {
  return os << DeviceAccessResultCodeToString(value);
}

namespace internal {


// static
bool DeviceFactory_GetDeviceInfos_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DeviceFactory_GetDeviceInfos_Params_Data* object = static_cast<const DeviceFactory_GetDeviceInfos_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

DeviceFactory_GetDeviceInfos_Params_Data::DeviceFactory_GetDeviceInfos_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DeviceFactory_GetDeviceInfos_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DeviceFactory_GetDeviceInfos_ResponseParams_Data* object = static_cast<const DeviceFactory_GetDeviceInfos_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->device_infos, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams device_infos_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->device_infos, validation_context,
                                         &device_infos_validate_params)) {
    return false;
  }

  return true;
}

DeviceFactory_GetDeviceInfos_ResponseParams_Data::DeviceFactory_GetDeviceInfos_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DeviceFactory_CreateDevice_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DeviceFactory_CreateDevice_Params_Data* object = static_cast<const DeviceFactory_CreateDevice_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->device_id, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams device_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->device_id, validation_context,
                                         &device_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->device_receiver, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->device_receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

DeviceFactory_CreateDevice_Params_Data::DeviceFactory_CreateDevice_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DeviceFactory_CreateDevice_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DeviceFactory_CreateDevice_ResponseParams_Data* object = static_cast<const DeviceFactory_CreateDevice_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::video_capture::mojom::internal::DeviceAccessResultCode_Data
        ::Validate(object->result_code, validation_context))
    return false;

  return true;
}

DeviceFactory_CreateDevice_ResponseParams_Data::DeviceFactory_CreateDevice_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DeviceFactory_AddSharedMemoryVirtualDevice_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DeviceFactory_AddSharedMemoryVirtualDevice_Params_Data* object = static_cast<const DeviceFactory_AddSharedMemoryVirtualDevice_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->device_info, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->device_info, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->producer, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->producer,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->virtual_device_receiver, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->virtual_device_receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

DeviceFactory_AddSharedMemoryVirtualDevice_Params_Data::DeviceFactory_AddSharedMemoryVirtualDevice_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DeviceFactory_AddTextureVirtualDevice_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DeviceFactory_AddTextureVirtualDevice_Params_Data* object = static_cast<const DeviceFactory_AddTextureVirtualDevice_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->device_info, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->device_info, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->virtual_device_receiver, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->virtual_device_receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

DeviceFactory_AddTextureVirtualDevice_Params_Data::DeviceFactory_AddTextureVirtualDevice_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DeviceFactory_AddGpuMemoryBufferVirtualDevice_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DeviceFactory_AddGpuMemoryBufferVirtualDevice_Params_Data* object = static_cast<const DeviceFactory_AddGpuMemoryBufferVirtualDevice_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->device_info, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->device_info, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->virtual_device_receiver, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->virtual_device_receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

DeviceFactory_AddGpuMemoryBufferVirtualDevice_Params_Data::DeviceFactory_AddGpuMemoryBufferVirtualDevice_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DeviceFactory_RegisterVirtualDevicesChangedObserver_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DeviceFactory_RegisterVirtualDevicesChangedObserver_Params_Data* object = static_cast<const DeviceFactory_RegisterVirtualDevicesChangedObserver_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->observer, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->observer,
                                                 validation_context)) {
    return false;
  }

  return true;
}

DeviceFactory_RegisterVirtualDevicesChangedObserver_Params_Data::DeviceFactory_RegisterVirtualDevicesChangedObserver_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace video_capture

namespace perfetto {

// static
void TraceFormatTraits<::video_capture::mojom::DeviceAccessResultCode>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::video_capture::mojom::DeviceAccessResultCode value) {
  return std::move(context).WriteString(::video_capture::mojom::DeviceAccessResultCodeToString(value));
}

} // namespace perfetto
