// services/video_capture/public/mojom/video_capture_service.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/video_capture/public/mojom/video_capture_service.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "services/video_capture/public/mojom/video_capture_service.mojom-params-data.h"
#include "services/video_capture/public/mojom/video_capture_service.mojom-shared-message-ids.h"

#include "services/video_capture/public/mojom/video_capture_service.mojom-import-headers.h"


#ifndef SERVICES_VIDEO_CAPTURE_PUBLIC_MOJOM_VIDEO_CAPTURE_SERVICE_MOJOM_JUMBO_H_
#define SERVICES_VIDEO_CAPTURE_PUBLIC_MOJOM_VIDEO_CAPTURE_SERVICE_MOJOM_JUMBO_H_
#endif
namespace video_capture {
namespace mojom {
const char VideoCaptureService::Name_[] = "video_capture.mojom.VideoCaptureService";

VideoCaptureServiceProxy::VideoCaptureServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void VideoCaptureServiceProxy::ConnectToDeviceFactory(
    ::mojo::PendingReceiver<::video_capture::mojom::DeviceFactory> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "video_capture::mojom::VideoCaptureService::ConnectToDeviceFactory", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver, 
                        "<value of type ::mojo::PendingReceiver<::video_capture::mojom::DeviceFactory>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kVideoCaptureService_ConnectToDeviceFactory_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::VideoCaptureService_ConnectToDeviceFactory_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::video_capture::mojom::DeviceFactoryInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in VideoCaptureService.ConnectToDeviceFactory request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoCaptureService::Name_);
  message.set_method_name("ConnectToDeviceFactory");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void VideoCaptureServiceProxy::ConnectToVideoSourceProvider(
    ::mojo::PendingReceiver<::video_capture::mojom::VideoSourceProvider> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "video_capture::mojom::VideoCaptureService::ConnectToVideoSourceProvider", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver, 
                        "<value of type ::mojo::PendingReceiver<::video_capture::mojom::VideoSourceProvider>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kVideoCaptureService_ConnectToVideoSourceProvider_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::VideoCaptureService_ConnectToVideoSourceProvider_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::video_capture::mojom::VideoSourceProviderInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in VideoCaptureService.ConnectToVideoSourceProvider request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoCaptureService::Name_);
  message.set_method_name("ConnectToVideoSourceProvider");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void VideoCaptureServiceProxy::SetRetryCount(
    int32_t in_count) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "video_capture::mojom::VideoCaptureService::SetRetryCount", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("count"), in_count, 
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kVideoCaptureService_SetRetryCount_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::VideoCaptureService_SetRetryCount_Params_Data> params(
          message);
  params.Allocate();
  params->count = in_count;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoCaptureService::Name_);
  message.set_method_name("SetRetryCount");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void VideoCaptureServiceProxy::BindControlsForTesting(
    ::mojo::PendingReceiver<::video_capture::mojom::TestingControls> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "video_capture::mojom::VideoCaptureService::BindControlsForTesting", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver, 
                        "<value of type ::mojo::PendingReceiver<::video_capture::mojom::TestingControls>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kVideoCaptureService_BindControlsForTesting_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::VideoCaptureService_BindControlsForTesting_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::video_capture::mojom::TestingControlsInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in VideoCaptureService.BindControlsForTesting request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoCaptureService::Name_);
  message.set_method_name("BindControlsForTesting");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool VideoCaptureServiceStubDispatch::Accept(
    VideoCaptureService* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kVideoCaptureService_ConnectToDeviceFactory_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)video_capture::mojom::VideoCaptureService::ConnectToDeviceFactory",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)video_capture::mojom::VideoCaptureService::ConnectToDeviceFactory");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::VideoCaptureService_ConnectToDeviceFactory_Params_Data* params =
          reinterpret_cast<internal::VideoCaptureService_ConnectToDeviceFactory_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::video_capture::mojom::DeviceFactory> p_receiver{};
      VideoCaptureService_ConnectToDeviceFactory_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoCaptureService::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ConnectToDeviceFactory(
std::move(p_receiver));
      return true;
    }
    case internal::kVideoCaptureService_ConnectToVideoSourceProvider_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)video_capture::mojom::VideoCaptureService::ConnectToVideoSourceProvider",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)video_capture::mojom::VideoCaptureService::ConnectToVideoSourceProvider");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::VideoCaptureService_ConnectToVideoSourceProvider_Params_Data* params =
          reinterpret_cast<internal::VideoCaptureService_ConnectToVideoSourceProvider_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::video_capture::mojom::VideoSourceProvider> p_receiver{};
      VideoCaptureService_ConnectToVideoSourceProvider_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoCaptureService::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ConnectToVideoSourceProvider(
std::move(p_receiver));
      return true;
    }
    case internal::kVideoCaptureService_SetRetryCount_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)video_capture::mojom::VideoCaptureService::SetRetryCount",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)video_capture::mojom::VideoCaptureService::SetRetryCount");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::VideoCaptureService_SetRetryCount_Params_Data* params =
          reinterpret_cast<internal::VideoCaptureService_SetRetryCount_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_count{};
      VideoCaptureService_SetRetryCount_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_count = input_data_view.count();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoCaptureService::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetRetryCount(
std::move(p_count));
      return true;
    }
    case internal::kVideoCaptureService_BindControlsForTesting_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)video_capture::mojom::VideoCaptureService::BindControlsForTesting",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)video_capture::mojom::VideoCaptureService::BindControlsForTesting");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::VideoCaptureService_BindControlsForTesting_Params_Data* params =
          reinterpret_cast<internal::VideoCaptureService_BindControlsForTesting_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::video_capture::mojom::TestingControls> p_receiver{};
      VideoCaptureService_BindControlsForTesting_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoCaptureService::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindControlsForTesting(
std::move(p_receiver));
      return true;
    }
  }
  return false;
}

// static
bool VideoCaptureServiceStubDispatch::AcceptWithResponder(
    VideoCaptureService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kVideoCaptureService_ConnectToDeviceFactory_Name: {
      break;
    }
    case internal::kVideoCaptureService_ConnectToVideoSourceProvider_Name: {
      break;
    }
    case internal::kVideoCaptureService_SetRetryCount_Name: {
      break;
    }
    case internal::kVideoCaptureService_BindControlsForTesting_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kVideoCaptureServiceValidationInfo[] = {
    {internal::kVideoCaptureService_ConnectToDeviceFactory_Name,
     {&internal::VideoCaptureService_ConnectToDeviceFactory_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kVideoCaptureService_ConnectToVideoSourceProvider_Name,
     {&internal::VideoCaptureService_ConnectToVideoSourceProvider_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kVideoCaptureService_SetRetryCount_Name,
     {&internal::VideoCaptureService_SetRetryCount_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kVideoCaptureService_BindControlsForTesting_Name,
     {&internal::VideoCaptureService_BindControlsForTesting_Params_Data::Validate,
      nullptr /* no response */}},
};

bool VideoCaptureServiceRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::video_capture::mojom::VideoCaptureService::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kVideoCaptureServiceValidationInfo);
}

}  // namespace mojom
}  // namespace video_capture

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif