// services/video_capture/public/mojom/video_frame_handler.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/video_capture/public/mojom/video_frame_handler.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "services/video_capture/public/mojom/video_frame_handler.mojom-params-data.h"
#include "services/video_capture/public/mojom/video_frame_handler.mojom-shared-message-ids.h"

#include "services/video_capture/public/mojom/video_frame_handler.mojom-import-headers.h"


#ifndef SERVICES_VIDEO_CAPTURE_PUBLIC_MOJOM_VIDEO_FRAME_HANDLER_MOJOM_JUMBO_H_
#define SERVICES_VIDEO_CAPTURE_PUBLIC_MOJOM_VIDEO_FRAME_HANDLER_MOJOM_JUMBO_H_
#endif
namespace video_capture {
namespace mojom {
ReadyFrameInBuffer::ReadyFrameInBuffer()
    : buffer_id(),
      frame_feedback_id(),
      access_permission(),
      frame_info() {}

ReadyFrameInBuffer::ReadyFrameInBuffer(
    int32_t buffer_id_in,
    int32_t frame_feedback_id_in,
    ::mojo::PendingRemote<::video_capture::mojom::ScopedAccessPermission> access_permission_in,
    ::media::mojom::VideoFrameInfoPtr frame_info_in)
    : buffer_id(std::move(buffer_id_in)),
      frame_feedback_id(std::move(frame_feedback_id_in)),
      access_permission(std::move(access_permission_in)),
      frame_info(std::move(frame_info_in)) {}

ReadyFrameInBuffer::~ReadyFrameInBuffer() = default;

void ReadyFrameInBuffer::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "buffer_id"), this->buffer_id, 
      "<value of type int32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame_feedback_id"), this->frame_feedback_id, 
      "<value of type int32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "access_permission"), this->access_permission, 
      "<value of type ::mojo::PendingRemote<::video_capture::mojom::ScopedAccessPermission>>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame_info"), this->frame_info, 
      "<value of type ::media::mojom::VideoFrameInfoPtr>");
}

bool ReadyFrameInBuffer::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char VideoFrameHandler::Name_[] = "video_capture.mojom.VideoFrameHandler";

VideoFrameHandlerProxy::VideoFrameHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void VideoFrameHandlerProxy::OnNewBuffer(
    int32_t in_buffer_id, ::media::mojom::VideoBufferHandlePtr in_buffer_handle) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "video_capture::mojom::VideoFrameHandler::OnNewBuffer", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer_id"), in_buffer_id, 
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer_handle"), in_buffer_handle, 
                        "<value of type ::media::mojom::VideoBufferHandlePtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kVideoFrameHandler_OnNewBuffer_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::VideoFrameHandler_OnNewBuffer_Params_Data> params(
          message);
  params.Allocate();
  params->buffer_id = in_buffer_id;
  mojo::internal::MessageFragment<decltype(params->buffer_handle)>
      buffer_handle_fragment(params.message());
  buffer_handle_fragment.Claim(&params->buffer_handle);
  mojo::internal::Serialize<::media::mojom::VideoBufferHandleDataView>(
      in_buffer_handle, buffer_handle_fragment, true);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->buffer_handle.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null buffer_handle in VideoFrameHandler.OnNewBuffer request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoFrameHandler::Name_);
  message.set_method_name("OnNewBuffer");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void VideoFrameHandlerProxy::OnFrameReadyInBuffer(
    ReadyFrameInBufferPtr in_buffer, std::vector<ReadyFrameInBufferPtr> in_scaled_buffers) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "video_capture::mojom::VideoFrameHandler::OnFrameReadyInBuffer", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer"), in_buffer, 
                        "<value of type ReadyFrameInBufferPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("scaled_buffers"), in_scaled_buffers, 
                        "<value of type std::vector<ReadyFrameInBufferPtr>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kVideoFrameHandler_OnFrameReadyInBuffer_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::VideoFrameHandler_OnFrameReadyInBuffer_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->buffer)::BaseType> buffer_fragment(
          params.message());
  mojo::internal::Serialize<::video_capture::mojom::ReadyFrameInBufferDataView>(
      in_buffer, buffer_fragment);
  params->buffer.Set(
      buffer_fragment.is_null() ? nullptr : buffer_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->buffer.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null buffer in VideoFrameHandler.OnFrameReadyInBuffer request");
  mojo::internal::MessageFragment<
      typename decltype(params->scaled_buffers)::BaseType>
      scaled_buffers_fragment(params.message());
  const mojo::internal::ContainerValidateParams scaled_buffers_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::video_capture::mojom::ReadyFrameInBufferDataView>>(
      in_scaled_buffers, scaled_buffers_fragment, &scaled_buffers_validate_params);
  params->scaled_buffers.Set(
      scaled_buffers_fragment.is_null() ? nullptr : scaled_buffers_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->scaled_buffers.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null scaled_buffers in VideoFrameHandler.OnFrameReadyInBuffer request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoFrameHandler::Name_);
  message.set_method_name("OnFrameReadyInBuffer");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void VideoFrameHandlerProxy::OnBufferRetired(
    int32_t in_buffer_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "video_capture::mojom::VideoFrameHandler::OnBufferRetired", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer_id"), in_buffer_id, 
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kVideoFrameHandler_OnBufferRetired_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::VideoFrameHandler_OnBufferRetired_Params_Data> params(
          message);
  params.Allocate();
  params->buffer_id = in_buffer_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoFrameHandler::Name_);
  message.set_method_name("OnBufferRetired");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void VideoFrameHandlerProxy::OnError(
    ::media::VideoCaptureError in_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "video_capture::mojom::VideoFrameHandler::OnError", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error, 
                        "<value of type ::media::VideoCaptureError>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kVideoFrameHandler_OnError_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::VideoFrameHandler_OnError_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::media::mojom::VideoCaptureError>(
      in_error, &params->error);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoFrameHandler::Name_);
  message.set_method_name("OnError");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void VideoFrameHandlerProxy::OnFrameDropped(
    ::media::VideoCaptureFrameDropReason in_reason) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "video_capture::mojom::VideoFrameHandler::OnFrameDropped", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reason"), in_reason, 
                        "<value of type ::media::VideoCaptureFrameDropReason>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kVideoFrameHandler_OnFrameDropped_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::VideoFrameHandler_OnFrameDropped_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::media::mojom::VideoCaptureFrameDropReason>(
      in_reason, &params->reason);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoFrameHandler::Name_);
  message.set_method_name("OnFrameDropped");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void VideoFrameHandlerProxy::OnLog(
    const std::string& in_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "video_capture::mojom::VideoFrameHandler::OnLog", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message"), in_message, 
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kVideoFrameHandler_OnLog_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::VideoFrameHandler_OnLog_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->message)::BaseType> message_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_message, message_fragment);
  params->message.Set(
      message_fragment.is_null() ? nullptr : message_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->message.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null message in VideoFrameHandler.OnLog request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoFrameHandler::Name_);
  message.set_method_name("OnLog");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void VideoFrameHandlerProxy::OnStarted(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "video_capture::mojom::VideoFrameHandler::OnStarted");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kVideoFrameHandler_OnStarted_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::VideoFrameHandler_OnStarted_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoFrameHandler::Name_);
  message.set_method_name("OnStarted");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void VideoFrameHandlerProxy::OnStartedUsingGpuDecode(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "video_capture::mojom::VideoFrameHandler::OnStartedUsingGpuDecode");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kVideoFrameHandler_OnStartedUsingGpuDecode_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::VideoFrameHandler_OnStartedUsingGpuDecode_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoFrameHandler::Name_);
  message.set_method_name("OnStartedUsingGpuDecode");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void VideoFrameHandlerProxy::OnStopped(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "video_capture::mojom::VideoFrameHandler::OnStopped");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kVideoFrameHandler_OnStopped_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::VideoFrameHandler_OnStopped_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoFrameHandler::Name_);
  message.set_method_name("OnStopped");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool VideoFrameHandlerStubDispatch::Accept(
    VideoFrameHandler* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kVideoFrameHandler_OnNewBuffer_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)video_capture::mojom::VideoFrameHandler::OnNewBuffer",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)video_capture::mojom::VideoFrameHandler::OnNewBuffer");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::VideoFrameHandler_OnNewBuffer_Params_Data* params =
          reinterpret_cast<internal::VideoFrameHandler_OnNewBuffer_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_buffer_id{};
      ::media::mojom::VideoBufferHandlePtr p_buffer_handle{};
      VideoFrameHandler_OnNewBuffer_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_buffer_id = input_data_view.buffer_id();
      if (success && !input_data_view.ReadBufferHandle(&p_buffer_handle))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoFrameHandler::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnNewBuffer(
std::move(p_buffer_id), 
std::move(p_buffer_handle));
      return true;
    }
    case internal::kVideoFrameHandler_OnFrameReadyInBuffer_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)video_capture::mojom::VideoFrameHandler::OnFrameReadyInBuffer",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)video_capture::mojom::VideoFrameHandler::OnFrameReadyInBuffer");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::VideoFrameHandler_OnFrameReadyInBuffer_Params_Data* params =
          reinterpret_cast<internal::VideoFrameHandler_OnFrameReadyInBuffer_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ReadyFrameInBufferPtr p_buffer{};
      std::vector<ReadyFrameInBufferPtr> p_scaled_buffers{};
      VideoFrameHandler_OnFrameReadyInBuffer_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBuffer(&p_buffer))
        success = false;
      if (success && !input_data_view.ReadScaledBuffers(&p_scaled_buffers))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoFrameHandler::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnFrameReadyInBuffer(
std::move(p_buffer), 
std::move(p_scaled_buffers));
      return true;
    }
    case internal::kVideoFrameHandler_OnBufferRetired_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)video_capture::mojom::VideoFrameHandler::OnBufferRetired",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)video_capture::mojom::VideoFrameHandler::OnBufferRetired");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::VideoFrameHandler_OnBufferRetired_Params_Data* params =
          reinterpret_cast<internal::VideoFrameHandler_OnBufferRetired_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_buffer_id{};
      VideoFrameHandler_OnBufferRetired_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_buffer_id = input_data_view.buffer_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoFrameHandler::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnBufferRetired(
std::move(p_buffer_id));
      return true;
    }
    case internal::kVideoFrameHandler_OnError_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)video_capture::mojom::VideoFrameHandler::OnError",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)video_capture::mojom::VideoFrameHandler::OnError");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::VideoFrameHandler_OnError_Params_Data* params =
          reinterpret_cast<internal::VideoFrameHandler_OnError_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::media::VideoCaptureError p_error{};
      VideoFrameHandler_OnError_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadError(&p_error))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoFrameHandler::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnError(
std::move(p_error));
      return true;
    }
    case internal::kVideoFrameHandler_OnFrameDropped_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)video_capture::mojom::VideoFrameHandler::OnFrameDropped",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)video_capture::mojom::VideoFrameHandler::OnFrameDropped");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::VideoFrameHandler_OnFrameDropped_Params_Data* params =
          reinterpret_cast<internal::VideoFrameHandler_OnFrameDropped_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::media::VideoCaptureFrameDropReason p_reason{};
      VideoFrameHandler_OnFrameDropped_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadReason(&p_reason))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoFrameHandler::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnFrameDropped(
std::move(p_reason));
      return true;
    }
    case internal::kVideoFrameHandler_OnLog_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)video_capture::mojom::VideoFrameHandler::OnLog",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)video_capture::mojom::VideoFrameHandler::OnLog");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::VideoFrameHandler_OnLog_Params_Data* params =
          reinterpret_cast<internal::VideoFrameHandler_OnLog_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_message{};
      VideoFrameHandler_OnLog_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoFrameHandler::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnLog(
std::move(p_message));
      return true;
    }
    case internal::kVideoFrameHandler_OnStarted_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)video_capture::mojom::VideoFrameHandler::OnStarted",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)video_capture::mojom::VideoFrameHandler::OnStarted");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::VideoFrameHandler_OnStarted_Params_Data* params =
          reinterpret_cast<internal::VideoFrameHandler_OnStarted_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      VideoFrameHandler_OnStarted_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoFrameHandler::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnStarted();
      return true;
    }
    case internal::kVideoFrameHandler_OnStartedUsingGpuDecode_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)video_capture::mojom::VideoFrameHandler::OnStartedUsingGpuDecode",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)video_capture::mojom::VideoFrameHandler::OnStartedUsingGpuDecode");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::VideoFrameHandler_OnStartedUsingGpuDecode_Params_Data* params =
          reinterpret_cast<internal::VideoFrameHandler_OnStartedUsingGpuDecode_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      VideoFrameHandler_OnStartedUsingGpuDecode_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoFrameHandler::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnStartedUsingGpuDecode();
      return true;
    }
    case internal::kVideoFrameHandler_OnStopped_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)video_capture::mojom::VideoFrameHandler::OnStopped",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)video_capture::mojom::VideoFrameHandler::OnStopped");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::VideoFrameHandler_OnStopped_Params_Data* params =
          reinterpret_cast<internal::VideoFrameHandler_OnStopped_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      VideoFrameHandler_OnStopped_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoFrameHandler::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnStopped();
      return true;
    }
  }
  return false;
}

// static
bool VideoFrameHandlerStubDispatch::AcceptWithResponder(
    VideoFrameHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kVideoFrameHandler_OnNewBuffer_Name: {
      break;
    }
    case internal::kVideoFrameHandler_OnFrameReadyInBuffer_Name: {
      break;
    }
    case internal::kVideoFrameHandler_OnBufferRetired_Name: {
      break;
    }
    case internal::kVideoFrameHandler_OnError_Name: {
      break;
    }
    case internal::kVideoFrameHandler_OnFrameDropped_Name: {
      break;
    }
    case internal::kVideoFrameHandler_OnLog_Name: {
      break;
    }
    case internal::kVideoFrameHandler_OnStarted_Name: {
      break;
    }
    case internal::kVideoFrameHandler_OnStartedUsingGpuDecode_Name: {
      break;
    }
    case internal::kVideoFrameHandler_OnStopped_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kVideoFrameHandlerValidationInfo[] = {
    {internal::kVideoFrameHandler_OnNewBuffer_Name,
     {&internal::VideoFrameHandler_OnNewBuffer_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kVideoFrameHandler_OnFrameReadyInBuffer_Name,
     {&internal::VideoFrameHandler_OnFrameReadyInBuffer_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kVideoFrameHandler_OnBufferRetired_Name,
     {&internal::VideoFrameHandler_OnBufferRetired_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kVideoFrameHandler_OnError_Name,
     {&internal::VideoFrameHandler_OnError_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kVideoFrameHandler_OnFrameDropped_Name,
     {&internal::VideoFrameHandler_OnFrameDropped_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kVideoFrameHandler_OnLog_Name,
     {&internal::VideoFrameHandler_OnLog_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kVideoFrameHandler_OnStarted_Name,
     {&internal::VideoFrameHandler_OnStarted_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kVideoFrameHandler_OnStartedUsingGpuDecode_Name,
     {&internal::VideoFrameHandler_OnStartedUsingGpuDecode_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kVideoFrameHandler_OnStopped_Name,
     {&internal::VideoFrameHandler_OnStopped_Params_Data::Validate,
      nullptr /* no response */}},
};

bool VideoFrameHandlerRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::video_capture::mojom::VideoFrameHandler::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kVideoFrameHandlerValidationInfo);
}

}  // namespace mojom
}  // namespace video_capture

namespace mojo {


// static
bool StructTraits<::video_capture::mojom::ReadyFrameInBuffer::DataView, ::video_capture::mojom::ReadyFrameInBufferPtr>::Read(
    ::video_capture::mojom::ReadyFrameInBuffer::DataView input,
    ::video_capture::mojom::ReadyFrameInBufferPtr* output) {
  bool success = true;
  ::video_capture::mojom::ReadyFrameInBufferPtr result(::video_capture::mojom::ReadyFrameInBuffer::New());
  
      if (success)
        result->buffer_id = input.buffer_id();
      if (success)
        result->frame_feedback_id = input.frame_feedback_id();
      if (success) {
        result->access_permission =
            input.TakeAccessPermission<decltype(result->access_permission)>();
      }
      if (success && !input.ReadFrameInfo(&result->frame_info))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif