// services/video_capture/public/mojom/video_source.mojom-test-utils.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif


#include "services/video_capture/public/mojom/video_source.mojom-test-utils.h"

#include <utility>

#include "base/bind.h"
#include "base/run_loop.h"
#include "media/capture/mojom/image_capture.mojom.h"
#include "media/capture/mojom/video_capture_types.mojom.h"
#include "services/video_capture/public/mojom/video_frame_handler.mojom.h"


#ifndef SERVICES_VIDEO_CAPTURE_PUBLIC_MOJOM_VIDEO_SOURCE_MOJOM_JUMBO_H_
#define SERVICES_VIDEO_CAPTURE_PUBLIC_MOJOM_VIDEO_SOURCE_MOJOM_JUMBO_H_
#endif


namespace video_capture {
namespace mojom {


void PushVideoStreamSubscriptionInterceptorForTesting::Activate() {
  GetForwardingInterface()->Activate();
}
void PushVideoStreamSubscriptionInterceptorForTesting::Suspend(SuspendCallback callback) {
  GetForwardingInterface()->Suspend(std::move(callback));
}
void PushVideoStreamSubscriptionInterceptorForTesting::Resume() {
  GetForwardingInterface()->Resume();
}
void PushVideoStreamSubscriptionInterceptorForTesting::GetPhotoState(GetPhotoStateCallback callback) {
  GetForwardingInterface()->GetPhotoState(std::move(callback));
}
void PushVideoStreamSubscriptionInterceptorForTesting::SetPhotoOptions(::media::mojom::PhotoSettingsPtr settings, SetPhotoOptionsCallback callback) {
  GetForwardingInterface()->SetPhotoOptions(std::move(settings), std::move(callback));
}
void PushVideoStreamSubscriptionInterceptorForTesting::TakePhoto(TakePhotoCallback callback) {
  GetForwardingInterface()->TakePhoto(std::move(callback));
}
void PushVideoStreamSubscriptionInterceptorForTesting::Close(CloseCallback callback) {
  GetForwardingInterface()->Close(std::move(callback));
}
void PushVideoStreamSubscriptionInterceptorForTesting::ProcessFeedback(const ::media::VideoFrameFeedback& feedback) {
  GetForwardingInterface()->ProcessFeedback(std::move(feedback));
}
PushVideoStreamSubscriptionAsyncWaiter::PushVideoStreamSubscriptionAsyncWaiter(
    PushVideoStreamSubscription* proxy) : proxy_(proxy) {}

PushVideoStreamSubscriptionAsyncWaiter::~PushVideoStreamSubscriptionAsyncWaiter() = default;

void PushVideoStreamSubscriptionAsyncWaiter::Suspend(
    ) {
  base::RunLoop loop;
  proxy_->Suspend(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}
void PushVideoStreamSubscriptionAsyncWaiter::GetPhotoState(
    ::media::mojom::PhotoStatePtr* out_capabilities) {
  base::RunLoop loop;
  proxy_->GetPhotoState(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::media::mojom::PhotoStatePtr* out_capabilities
,
             ::media::mojom::PhotoStatePtr capabilities) {*out_capabilities = std::move(capabilities);
            loop->Quit();
          },
          &loop,
          out_capabilities));
  loop.Run();
}
void PushVideoStreamSubscriptionAsyncWaiter::SetPhotoOptions(
    ::media::mojom::PhotoSettingsPtr settings, bool* out_success) {
  base::RunLoop loop;
  proxy_->SetPhotoOptions(std::move(settings),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}
void PushVideoStreamSubscriptionAsyncWaiter::TakePhoto(
    ::media::mojom::BlobPtr* out_blob) {
  base::RunLoop loop;
  proxy_->TakePhoto(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::media::mojom::BlobPtr* out_blob
,
             ::media::mojom::BlobPtr blob) {*out_blob = std::move(blob);
            loop->Quit();
          },
          &loop,
          out_blob));
  loop.Run();
}
void PushVideoStreamSubscriptionAsyncWaiter::Close(
    ) {
  base::RunLoop loop;
  proxy_->Close(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void VideoSourceInterceptorForTesting::CreatePushSubscription(::mojo::PendingRemote<::video_capture::mojom::VideoFrameHandler> subscriber, const ::media::VideoCaptureParams& requested_settings, bool force_reopen_with_new_settings, ::mojo::PendingReceiver<PushVideoStreamSubscription> subscription, CreatePushSubscriptionCallback callback) {
  GetForwardingInterface()->CreatePushSubscription(std::move(subscriber), std::move(requested_settings), std::move(force_reopen_with_new_settings), std::move(subscription), std::move(callback));
}
VideoSourceAsyncWaiter::VideoSourceAsyncWaiter(
    VideoSource* proxy) : proxy_(proxy) {}

VideoSourceAsyncWaiter::~VideoSourceAsyncWaiter() = default;

void VideoSourceAsyncWaiter::CreatePushSubscription(
    ::mojo::PendingRemote<::video_capture::mojom::VideoFrameHandler> subscriber, const ::media::VideoCaptureParams& requested_settings, bool force_reopen_with_new_settings, ::mojo::PendingReceiver<PushVideoStreamSubscription> subscription, CreatePushSubscriptionResultCode* out_result_code, ::media::VideoCaptureParams* out_settings_source_was_opened_with) {
  base::RunLoop loop;
  proxy_->CreatePushSubscription(std::move(subscriber),std::move(requested_settings),std::move(force_reopen_with_new_settings),std::move(subscription),
      base::BindOnce(
          [](base::RunLoop* loop,
             CreatePushSubscriptionResultCode* out_result_code
,
             ::media::VideoCaptureParams* out_settings_source_was_opened_with
,
             CreatePushSubscriptionResultCode result_code,
             const ::media::VideoCaptureParams& settings_source_was_opened_with) {*out_result_code = std::move(result_code);*out_settings_source_was_opened_with = std::move(settings_source_was_opened_with);
            loop->Quit();
          },
          &loop,
          out_result_code,
          out_settings_source_was_opened_with));
  loop.Run();
}





}  // namespace mojom
}  // namespace video_capture

#if defined(__clang__)
#pragma clang diagnostic pop
#endif