// services/video_capture/public/mojom/video_source_provider.mojom-test-utils.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif


#include "services/video_capture/public/mojom/video_source_provider.mojom-test-utils.h"

#include <utility>

#include "base/bind.h"
#include "base/run_loop.h"
#include "media/capture/mojom/video_capture_types.mojom.h"
#include "services/video_capture/public/mojom/devices_changed_observer.mojom.h"
#include "services/video_capture/public/mojom/producer.mojom.h"
#include "services/video_capture/public/mojom/video_source.mojom.h"
#include "services/video_capture/public/mojom/virtual_device.mojom.h"


#ifndef SERVICES_VIDEO_CAPTURE_PUBLIC_MOJOM_VIDEO_SOURCE_PROVIDER_MOJOM_JUMBO_H_
#define SERVICES_VIDEO_CAPTURE_PUBLIC_MOJOM_VIDEO_SOURCE_PROVIDER_MOJOM_JUMBO_H_
#endif


namespace video_capture {
namespace mojom {


void VideoSourceProviderInterceptorForTesting::GetSourceInfos(GetSourceInfosCallback callback) {
  GetForwardingInterface()->GetSourceInfos(std::move(callback));
}
void VideoSourceProviderInterceptorForTesting::GetVideoSource(const std::string& source_id, ::mojo::PendingReceiver<::video_capture::mojom::VideoSource> stream) {
  GetForwardingInterface()->GetVideoSource(std::move(source_id), std::move(stream));
}
void VideoSourceProviderInterceptorForTesting::AddSharedMemoryVirtualDevice(const ::media::VideoCaptureDeviceInfo& device_info, ::mojo::PendingRemote<::video_capture::mojom::Producer> producer, bool send_buffer_handles_to_producer_as_raw_file_descriptors, ::mojo::PendingReceiver<::video_capture::mojom::SharedMemoryVirtualDevice> virtual_device_receiver) {
  GetForwardingInterface()->AddSharedMemoryVirtualDevice(std::move(device_info), std::move(producer), std::move(send_buffer_handles_to_producer_as_raw_file_descriptors), std::move(virtual_device_receiver));
}
void VideoSourceProviderInterceptorForTesting::AddTextureVirtualDevice(const ::media::VideoCaptureDeviceInfo& device_info, ::mojo::PendingReceiver<::video_capture::mojom::TextureVirtualDevice> virtual_device_receiver) {
  GetForwardingInterface()->AddTextureVirtualDevice(std::move(device_info), std::move(virtual_device_receiver));
}
void VideoSourceProviderInterceptorForTesting::RegisterVirtualDevicesChangedObserver(::mojo::PendingRemote<::video_capture::mojom::DevicesChangedObserver> observer, bool raise_event_if_virtual_devices_already_present) {
  GetForwardingInterface()->RegisterVirtualDevicesChangedObserver(std::move(observer), std::move(raise_event_if_virtual_devices_already_present));
}
void VideoSourceProviderInterceptorForTesting::Close(CloseCallback callback) {
  GetForwardingInterface()->Close(std::move(callback));
}
VideoSourceProviderAsyncWaiter::VideoSourceProviderAsyncWaiter(
    VideoSourceProvider* proxy) : proxy_(proxy) {}

VideoSourceProviderAsyncWaiter::~VideoSourceProviderAsyncWaiter() = default;

void VideoSourceProviderAsyncWaiter::GetSourceInfos(
    std::vector<::media::VideoCaptureDeviceInfo>* out_source_infos) {
  base::RunLoop loop;
  proxy_->GetSourceInfos(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<::media::VideoCaptureDeviceInfo>* out_source_infos
,
             const std::vector<::media::VideoCaptureDeviceInfo>& source_infos) {*out_source_infos = std::move(source_infos);
            loop->Quit();
          },
          &loop,
          out_source_infos));
  loop.Run();
}
void VideoSourceProviderAsyncWaiter::Close(
    ) {
  base::RunLoop loop;
  proxy_->Close(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}





}  // namespace mojom
}  // namespace video_capture

#if defined(__clang__)
#pragma clang diagnostic pop
#endif