// services/video_capture/public/mojom/video_source_provider.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/video_capture/public/mojom/video_source_provider.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "services/video_capture/public/mojom/video_source_provider.mojom-params-data.h"
#include "services/video_capture/public/mojom/video_source_provider.mojom-shared-message-ids.h"

#include "services/video_capture/public/mojom/video_source_provider.mojom-import-headers.h"


#ifndef SERVICES_VIDEO_CAPTURE_PUBLIC_MOJOM_VIDEO_SOURCE_PROVIDER_MOJOM_JUMBO_H_
#define SERVICES_VIDEO_CAPTURE_PUBLIC_MOJOM_VIDEO_SOURCE_PROVIDER_MOJOM_JUMBO_H_
#endif
namespace video_capture {
namespace mojom {
const char VideoSourceProvider::Name_[] = "video_capture.mojom.VideoSourceProvider";

class VideoSourceProvider_GetSourceInfos_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  VideoSourceProvider_GetSourceInfos_ForwardToCallback(
      VideoSourceProvider::GetSourceInfosCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  VideoSourceProvider::GetSourceInfosCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(VideoSourceProvider_GetSourceInfos_ForwardToCallback);
};

class VideoSourceProvider_Close_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  VideoSourceProvider_Close_ForwardToCallback(
      VideoSourceProvider::CloseCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  VideoSourceProvider::CloseCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(VideoSourceProvider_Close_ForwardToCallback);
};

VideoSourceProviderProxy::VideoSourceProviderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void VideoSourceProviderProxy::GetSourceInfos(
    GetSourceInfosCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "video_capture::mojom::VideoSourceProvider::GetSourceInfos");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kVideoSourceProvider_GetSourceInfos_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::VideoSourceProvider_GetSourceInfos_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoSourceProvider::Name_);
  message.set_method_name("GetSourceInfos");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new VideoSourceProvider_GetSourceInfos_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void VideoSourceProviderProxy::GetVideoSource(
    const std::string& in_source_id, ::mojo::PendingReceiver<::video_capture::mojom::VideoSource> in_stream) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "video_capture::mojom::VideoSourceProvider::GetVideoSource", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source_id"), in_source_id, 
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("stream"), in_stream, 
                        "<value of type ::mojo::PendingReceiver<::video_capture::mojom::VideoSource>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kVideoSourceProvider_GetVideoSource_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::VideoSourceProvider_GetVideoSource_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->source_id)::BaseType> source_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_source_id, source_id_fragment);
  params->source_id.Set(
      source_id_fragment.is_null() ? nullptr : source_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->source_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null source_id in VideoSourceProvider.GetVideoSource request");
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::video_capture::mojom::VideoSourceInterfaceBase>>(
      in_stream, &params->stream, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->stream),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid stream in VideoSourceProvider.GetVideoSource request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoSourceProvider::Name_);
  message.set_method_name("GetVideoSource");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void VideoSourceProviderProxy::AddSharedMemoryVirtualDevice(
    const ::media::VideoCaptureDeviceInfo& in_device_info, ::mojo::PendingRemote<::video_capture::mojom::Producer> in_producer, bool in_send_buffer_handles_to_producer_as_raw_file_descriptors, ::mojo::PendingReceiver<::video_capture::mojom::SharedMemoryVirtualDevice> in_virtual_device_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "video_capture::mojom::VideoSourceProvider::AddSharedMemoryVirtualDevice", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device_info"), in_device_info, 
                        "<value of type const ::media::VideoCaptureDeviceInfo&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("producer"), in_producer, 
                        "<value of type ::mojo::PendingRemote<::video_capture::mojom::Producer>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("send_buffer_handles_to_producer_as_raw_file_descriptors"), in_send_buffer_handles_to_producer_as_raw_file_descriptors, 
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("virtual_device_receiver"), in_virtual_device_receiver, 
                        "<value of type ::mojo::PendingReceiver<::video_capture::mojom::SharedMemoryVirtualDevice>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kVideoSourceProvider_AddSharedMemoryVirtualDevice_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::VideoSourceProvider_AddSharedMemoryVirtualDevice_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->device_info)::BaseType> device_info_fragment(
          params.message());
  mojo::internal::Serialize<::media::mojom::VideoCaptureDeviceInfoDataView>(
      in_device_info, device_info_fragment);
  params->device_info.Set(
      device_info_fragment.is_null() ? nullptr : device_info_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->device_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null device_info in VideoSourceProvider.AddSharedMemoryVirtualDevice request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::video_capture::mojom::ProducerInterfaceBase>>(
      in_producer, &params->producer, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->producer),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid producer in VideoSourceProvider.AddSharedMemoryVirtualDevice request");
  params->send_buffer_handles_to_producer_as_raw_file_descriptors = in_send_buffer_handles_to_producer_as_raw_file_descriptors;
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::video_capture::mojom::SharedMemoryVirtualDeviceInterfaceBase>>(
      in_virtual_device_receiver, &params->virtual_device_receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->virtual_device_receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid virtual_device_receiver in VideoSourceProvider.AddSharedMemoryVirtualDevice request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoSourceProvider::Name_);
  message.set_method_name("AddSharedMemoryVirtualDevice");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void VideoSourceProviderProxy::AddTextureVirtualDevice(
    const ::media::VideoCaptureDeviceInfo& in_device_info, ::mojo::PendingReceiver<::video_capture::mojom::TextureVirtualDevice> in_virtual_device_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "video_capture::mojom::VideoSourceProvider::AddTextureVirtualDevice", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device_info"), in_device_info, 
                        "<value of type const ::media::VideoCaptureDeviceInfo&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("virtual_device_receiver"), in_virtual_device_receiver, 
                        "<value of type ::mojo::PendingReceiver<::video_capture::mojom::TextureVirtualDevice>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kVideoSourceProvider_AddTextureVirtualDevice_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::VideoSourceProvider_AddTextureVirtualDevice_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->device_info)::BaseType> device_info_fragment(
          params.message());
  mojo::internal::Serialize<::media::mojom::VideoCaptureDeviceInfoDataView>(
      in_device_info, device_info_fragment);
  params->device_info.Set(
      device_info_fragment.is_null() ? nullptr : device_info_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->device_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null device_info in VideoSourceProvider.AddTextureVirtualDevice request");
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::video_capture::mojom::TextureVirtualDeviceInterfaceBase>>(
      in_virtual_device_receiver, &params->virtual_device_receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->virtual_device_receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid virtual_device_receiver in VideoSourceProvider.AddTextureVirtualDevice request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoSourceProvider::Name_);
  message.set_method_name("AddTextureVirtualDevice");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void VideoSourceProviderProxy::RegisterVirtualDevicesChangedObserver(
    ::mojo::PendingRemote<::video_capture::mojom::DevicesChangedObserver> in_observer, bool in_raise_event_if_virtual_devices_already_present) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "video_capture::mojom::VideoSourceProvider::RegisterVirtualDevicesChangedObserver", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("observer"), in_observer, 
                        "<value of type ::mojo::PendingRemote<::video_capture::mojom::DevicesChangedObserver>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("raise_event_if_virtual_devices_already_present"), in_raise_event_if_virtual_devices_already_present, 
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kVideoSourceProvider_RegisterVirtualDevicesChangedObserver_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::VideoSourceProvider_RegisterVirtualDevicesChangedObserver_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::video_capture::mojom::DevicesChangedObserverInterfaceBase>>(
      in_observer, &params->observer, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->observer),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid observer in VideoSourceProvider.RegisterVirtualDevicesChangedObserver request");
  params->raise_event_if_virtual_devices_already_present = in_raise_event_if_virtual_devices_already_present;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoSourceProvider::Name_);
  message.set_method_name("RegisterVirtualDevicesChangedObserver");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void VideoSourceProviderProxy::Close(
    CloseCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "video_capture::mojom::VideoSourceProvider::Close");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kVideoSourceProvider_Close_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::VideoSourceProvider_Close_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoSourceProvider::Name_);
  message.set_method_name("Close");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new VideoSourceProvider_Close_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class VideoSourceProvider_GetSourceInfos_ProxyToResponder {
 public:
  static VideoSourceProvider::GetSourceInfosCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<VideoSourceProvider_GetSourceInfos_ProxyToResponder> proxy(
        new VideoSourceProvider_GetSourceInfos_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&VideoSourceProvider_GetSourceInfos_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~VideoSourceProvider_GetSourceInfos_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  VideoSourceProvider_GetSourceInfos_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "VideoSourceProvider::GetSourceInfosCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::vector<::media::VideoCaptureDeviceInfo>& in_source_infos);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(VideoSourceProvider_GetSourceInfos_ProxyToResponder);
};

bool VideoSourceProvider_GetSourceInfos_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "video_capture::mojom::VideoSourceProvider::GetSourceInfosCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::VideoSourceProvider_GetSourceInfos_ResponseParams_Data* params =
      reinterpret_cast<
          internal::VideoSourceProvider_GetSourceInfos_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  std::vector<::media::VideoCaptureDeviceInfo> p_source_infos{};
  VideoSourceProvider_GetSourceInfos_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadSourceInfos(&p_source_infos))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        VideoSourceProvider::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_source_infos));
  return true;
}

void VideoSourceProvider_GetSourceInfos_ProxyToResponder::Run(
    const std::vector<::media::VideoCaptureDeviceInfo>& in_source_infos) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)video_capture::mojom::VideoSourceProvider::GetSourceInfosCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source_infos"), in_source_infos, 
                        "<value of type const std::vector<::media::VideoCaptureDeviceInfo>&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kVideoSourceProvider_GetSourceInfos_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::VideoSourceProvider_GetSourceInfos_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->source_infos)::BaseType>
      source_infos_fragment(params.message());
  const mojo::internal::ContainerValidateParams source_infos_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::media::mojom::VideoCaptureDeviceInfoDataView>>(
      in_source_infos, source_infos_fragment, &source_infos_validate_params);
  params->source_infos.Set(
      source_infos_fragment.is_null() ? nullptr : source_infos_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->source_infos.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null source_infos in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)video_capture::mojom::VideoSourceProvider::GetSourceInfosCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoSourceProvider::Name_);
  message.set_method_name("GetSourceInfos");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class VideoSourceProvider_Close_ProxyToResponder {
 public:
  static VideoSourceProvider::CloseCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<VideoSourceProvider_Close_ProxyToResponder> proxy(
        new VideoSourceProvider_Close_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&VideoSourceProvider_Close_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~VideoSourceProvider_Close_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  VideoSourceProvider_Close_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "VideoSourceProvider::CloseCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(VideoSourceProvider_Close_ProxyToResponder);
};

bool VideoSourceProvider_Close_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "video_capture::mojom::VideoSourceProvider::CloseCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::VideoSourceProvider_Close_ResponseParams_Data* params =
      reinterpret_cast<
          internal::VideoSourceProvider_Close_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  VideoSourceProvider_Close_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        VideoSourceProvider::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void VideoSourceProvider_Close_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)video_capture::mojom::VideoSourceProvider::CloseCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kVideoSourceProvider_Close_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::VideoSourceProvider_Close_ResponseParams_Data> params(
          message);
  params.Allocate();

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)video_capture::mojom::VideoSourceProvider::CloseCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoSourceProvider::Name_);
  message.set_method_name("Close");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool VideoSourceProviderStubDispatch::Accept(
    VideoSourceProvider* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kVideoSourceProvider_GetSourceInfos_Name: {
      break;
    }
    case internal::kVideoSourceProvider_GetVideoSource_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)video_capture::mojom::VideoSourceProvider::GetVideoSource",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)video_capture::mojom::VideoSourceProvider::GetVideoSource");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::VideoSourceProvider_GetVideoSource_Params_Data* params =
          reinterpret_cast<internal::VideoSourceProvider_GetVideoSource_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_source_id{};
      ::mojo::PendingReceiver<::video_capture::mojom::VideoSource> p_stream{};
      VideoSourceProvider_GetVideoSource_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSourceId(&p_source_id))
        success = false;
      if (success) {
        p_stream =
            input_data_view.TakeStream<decltype(p_stream)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoSourceProvider::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetVideoSource(
std::move(p_source_id), 
std::move(p_stream));
      return true;
    }
    case internal::kVideoSourceProvider_AddSharedMemoryVirtualDevice_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)video_capture::mojom::VideoSourceProvider::AddSharedMemoryVirtualDevice",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)video_capture::mojom::VideoSourceProvider::AddSharedMemoryVirtualDevice");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::VideoSourceProvider_AddSharedMemoryVirtualDevice_Params_Data* params =
          reinterpret_cast<internal::VideoSourceProvider_AddSharedMemoryVirtualDevice_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::media::VideoCaptureDeviceInfo p_device_info{};
      ::mojo::PendingRemote<::video_capture::mojom::Producer> p_producer{};
      bool p_send_buffer_handles_to_producer_as_raw_file_descriptors{};
      ::mojo::PendingReceiver<::video_capture::mojom::SharedMemoryVirtualDevice> p_virtual_device_receiver{};
      VideoSourceProvider_AddSharedMemoryVirtualDevice_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDeviceInfo(&p_device_info))
        success = false;
      if (success) {
        p_producer =
            input_data_view.TakeProducer<decltype(p_producer)>();
      }
      if (success)
        p_send_buffer_handles_to_producer_as_raw_file_descriptors = input_data_view.send_buffer_handles_to_producer_as_raw_file_descriptors();
      if (success) {
        p_virtual_device_receiver =
            input_data_view.TakeVirtualDeviceReceiver<decltype(p_virtual_device_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoSourceProvider::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddSharedMemoryVirtualDevice(
std::move(p_device_info), 
std::move(p_producer), 
std::move(p_send_buffer_handles_to_producer_as_raw_file_descriptors), 
std::move(p_virtual_device_receiver));
      return true;
    }
    case internal::kVideoSourceProvider_AddTextureVirtualDevice_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)video_capture::mojom::VideoSourceProvider::AddTextureVirtualDevice",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)video_capture::mojom::VideoSourceProvider::AddTextureVirtualDevice");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::VideoSourceProvider_AddTextureVirtualDevice_Params_Data* params =
          reinterpret_cast<internal::VideoSourceProvider_AddTextureVirtualDevice_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::media::VideoCaptureDeviceInfo p_device_info{};
      ::mojo::PendingReceiver<::video_capture::mojom::TextureVirtualDevice> p_virtual_device_receiver{};
      VideoSourceProvider_AddTextureVirtualDevice_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDeviceInfo(&p_device_info))
        success = false;
      if (success) {
        p_virtual_device_receiver =
            input_data_view.TakeVirtualDeviceReceiver<decltype(p_virtual_device_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoSourceProvider::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddTextureVirtualDevice(
std::move(p_device_info), 
std::move(p_virtual_device_receiver));
      return true;
    }
    case internal::kVideoSourceProvider_RegisterVirtualDevicesChangedObserver_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)video_capture::mojom::VideoSourceProvider::RegisterVirtualDevicesChangedObserver",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)video_capture::mojom::VideoSourceProvider::RegisterVirtualDevicesChangedObserver");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::VideoSourceProvider_RegisterVirtualDevicesChangedObserver_Params_Data* params =
          reinterpret_cast<internal::VideoSourceProvider_RegisterVirtualDevicesChangedObserver_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<::video_capture::mojom::DevicesChangedObserver> p_observer{};
      bool p_raise_event_if_virtual_devices_already_present{};
      VideoSourceProvider_RegisterVirtualDevicesChangedObserver_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_observer =
            input_data_view.TakeObserver<decltype(p_observer)>();
      }
      if (success)
        p_raise_event_if_virtual_devices_already_present = input_data_view.raise_event_if_virtual_devices_already_present();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoSourceProvider::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RegisterVirtualDevicesChangedObserver(
std::move(p_observer), 
std::move(p_raise_event_if_virtual_devices_already_present));
      return true;
    }
    case internal::kVideoSourceProvider_Close_Name: {
      break;
    }
  }
  return false;
}

// static
bool VideoSourceProviderStubDispatch::AcceptWithResponder(
    VideoSourceProvider* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kVideoSourceProvider_GetSourceInfos_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)video_capture::mojom::VideoSourceProvider::GetSourceInfos",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)video_capture::mojom::VideoSourceProvider::GetSourceInfos");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::VideoSourceProvider_GetSourceInfos_Params_Data* params =
          reinterpret_cast<
              internal::VideoSourceProvider_GetSourceInfos_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      VideoSourceProvider_GetSourceInfos_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoSourceProvider::Name_, 0, false);
        return false;
      }
      VideoSourceProvider::GetSourceInfosCallback callback =
          VideoSourceProvider_GetSourceInfos_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetSourceInfos(std::move(callback));
      return true;
    }
    case internal::kVideoSourceProvider_GetVideoSource_Name: {
      break;
    }
    case internal::kVideoSourceProvider_AddSharedMemoryVirtualDevice_Name: {
      break;
    }
    case internal::kVideoSourceProvider_AddTextureVirtualDevice_Name: {
      break;
    }
    case internal::kVideoSourceProvider_RegisterVirtualDevicesChangedObserver_Name: {
      break;
    }
    case internal::kVideoSourceProvider_Close_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)video_capture::mojom::VideoSourceProvider::Close",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)video_capture::mojom::VideoSourceProvider::Close");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::VideoSourceProvider_Close_Params_Data* params =
          reinterpret_cast<
              internal::VideoSourceProvider_Close_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      VideoSourceProvider_Close_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoSourceProvider::Name_, 5, false);
        return false;
      }
      VideoSourceProvider::CloseCallback callback =
          VideoSourceProvider_Close_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Close(std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kVideoSourceProviderValidationInfo[] = {
    {internal::kVideoSourceProvider_GetSourceInfos_Name,
     {&internal::VideoSourceProvider_GetSourceInfos_Params_Data::Validate,
      &internal::VideoSourceProvider_GetSourceInfos_ResponseParams_Data::Validate}},
    {internal::kVideoSourceProvider_GetVideoSource_Name,
     {&internal::VideoSourceProvider_GetVideoSource_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kVideoSourceProvider_AddSharedMemoryVirtualDevice_Name,
     {&internal::VideoSourceProvider_AddSharedMemoryVirtualDevice_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kVideoSourceProvider_AddTextureVirtualDevice_Name,
     {&internal::VideoSourceProvider_AddTextureVirtualDevice_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kVideoSourceProvider_RegisterVirtualDevicesChangedObserver_Name,
     {&internal::VideoSourceProvider_RegisterVirtualDevicesChangedObserver_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kVideoSourceProvider_Close_Name,
     {&internal::VideoSourceProvider_Close_Params_Data::Validate,
      &internal::VideoSourceProvider_Close_ResponseParams_Data::Validate}},
};

bool VideoSourceProviderRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::video_capture::mojom::VideoSourceProvider::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kVideoSourceProviderValidationInfo);
}

bool VideoSourceProviderResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::video_capture::mojom::VideoSourceProvider::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kVideoSourceProviderValidationInfo);

}
}  // namespace mojom
}  // namespace video_capture

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif