// services/video_capture/public/mojom/virtual_device.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/video_capture/public/mojom/virtual_device.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/video_capture/public/mojom/virtual_device.mojom-params-data.h"
namespace video_capture {
namespace mojom {

namespace internal {


// static
bool SharedMemoryVirtualDevice_RequestFrameBuffer_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const SharedMemoryVirtualDevice_RequestFrameBuffer_Params_Data* object = static_cast<const SharedMemoryVirtualDevice_RequestFrameBuffer_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->dimension, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->dimension, validation_context))
    return false;


  if (!::media::mojom::internal::VideoCapturePixelFormat_Data
        ::Validate(object->pixel_format, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->strides, validation_context))
    return false;

  return true;
}

SharedMemoryVirtualDevice_RequestFrameBuffer_Params_Data::SharedMemoryVirtualDevice_RequestFrameBuffer_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SharedMemoryVirtualDevice_RequestFrameBuffer_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const SharedMemoryVirtualDevice_RequestFrameBuffer_ResponseParams_Data* object = static_cast<const SharedMemoryVirtualDevice_RequestFrameBuffer_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

SharedMemoryVirtualDevice_RequestFrameBuffer_ResponseParams_Data::SharedMemoryVirtualDevice_RequestFrameBuffer_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SharedMemoryVirtualDevice_OnFrameReadyInBuffer_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const SharedMemoryVirtualDevice_OnFrameReadyInBuffer_Params_Data* object = static_cast<const SharedMemoryVirtualDevice_OnFrameReadyInBuffer_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->frame_info, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->frame_info, validation_context))
    return false;

  return true;
}

SharedMemoryVirtualDevice_OnFrameReadyInBuffer_Params_Data::SharedMemoryVirtualDevice_OnFrameReadyInBuffer_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TextureVirtualDevice_OnNewMailboxHolderBufferHandle_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const TextureVirtualDevice_OnNewMailboxHolderBufferHandle_Params_Data* object = static_cast<const TextureVirtualDevice_OnNewMailboxHolderBufferHandle_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->mailbox_handles, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->mailbox_handles, validation_context))
    return false;

  return true;
}

TextureVirtualDevice_OnNewMailboxHolderBufferHandle_Params_Data::TextureVirtualDevice_OnNewMailboxHolderBufferHandle_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TextureVirtualDevice_OnFrameReadyInBuffer_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const TextureVirtualDevice_OnFrameReadyInBuffer_Params_Data* object = static_cast<const TextureVirtualDevice_OnFrameReadyInBuffer_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->access_permission, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->access_permission,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->frame_info, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->frame_info, validation_context))
    return false;

  return true;
}

TextureVirtualDevice_OnFrameReadyInBuffer_Params_Data::TextureVirtualDevice_OnFrameReadyInBuffer_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TextureVirtualDevice_OnBufferRetired_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const TextureVirtualDevice_OnBufferRetired_Params_Data* object = static_cast<const TextureVirtualDevice_OnBufferRetired_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

TextureVirtualDevice_OnBufferRetired_Params_Data::TextureVirtualDevice_OnBufferRetired_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GpuMemoryBufferVirtualDevice_OnNewGpuMemoryBufferHandle_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const GpuMemoryBufferVirtualDevice_OnNewGpuMemoryBufferHandle_Params_Data* object = static_cast<const GpuMemoryBufferVirtualDevice_OnNewGpuMemoryBufferHandle_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->gmb_handle, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->gmb_handle, validation_context))
    return false;

  return true;
}

GpuMemoryBufferVirtualDevice_OnNewGpuMemoryBufferHandle_Params_Data::GpuMemoryBufferVirtualDevice_OnNewGpuMemoryBufferHandle_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GpuMemoryBufferVirtualDevice_OnFrameReadyInBuffer_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const GpuMemoryBufferVirtualDevice_OnFrameReadyInBuffer_Params_Data* object = static_cast<const GpuMemoryBufferVirtualDevice_OnFrameReadyInBuffer_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->access_permission, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->access_permission,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->frame_info, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->frame_info, validation_context))
    return false;

  return true;
}

GpuMemoryBufferVirtualDevice_OnFrameReadyInBuffer_Params_Data::GpuMemoryBufferVirtualDevice_OnFrameReadyInBuffer_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GpuMemoryBufferVirtualDevice_OnBufferRetired_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const GpuMemoryBufferVirtualDevice_OnBufferRetired_Params_Data* object = static_cast<const GpuMemoryBufferVirtualDevice_OnBufferRetired_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

GpuMemoryBufferVirtualDevice_OnBufferRetired_Params_Data::GpuMemoryBufferVirtualDevice_OnBufferRetired_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace video_capture
