// services/viz/privileged/mojom/compositing/display_private.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/viz/privileged/mojom/compositing/display_private.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "services/viz/privileged/mojom/compositing/display_private.mojom-params-data.h"
#include "services/viz/privileged/mojom/compositing/display_private.mojom-shared-message-ids.h"

#include "services/viz/privileged/mojom/compositing/display_private.mojom-import-headers.h"


#ifndef SERVICES_VIZ_PRIVILEGED_MOJOM_COMPOSITING_DISPLAY_PRIVATE_MOJOM_JUMBO_H_
#define SERVICES_VIZ_PRIVILEGED_MOJOM_COMPOSITING_DISPLAY_PRIVATE_MOJOM_JUMBO_H_
#endif
namespace viz {
namespace mojom {
const char DisplayPrivate::Name_[] = "viz.mojom.DisplayPrivate";

DisplayPrivateProxy::DisplayPrivateProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DisplayPrivateProxy::SetDisplayVisible(
    bool in_visible) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::DisplayPrivate::SetDisplayVisible", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("visible"), in_visible, 
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kDisplayPrivate_SetDisplayVisible_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::DisplayPrivate_SetDisplayVisible_Params_Data> params(
          message);
  params.Allocate();
  params->visible = in_visible;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DisplayPrivate::Name_);
  message.set_method_name("SetDisplayVisible");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void DisplayPrivateProxy::Resize(
    const ::gfx::Size& in_size) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::DisplayPrivate::Resize", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("size"), in_size, 
                        "<value of type const ::gfx::Size&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kDisplayPrivate_Resize_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::DisplayPrivate_Resize_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->size)::BaseType> size_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
      in_size, size_fragment);
  params->size.Set(
      size_fragment.is_null() ? nullptr : size_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->size.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null size in DisplayPrivate.Resize request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DisplayPrivate::Name_);
  message.set_method_name("Resize");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void DisplayPrivateProxy::SetDisplayColorMatrix(
    const ::gfx::Transform& in_color_matrix) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::DisplayPrivate::SetDisplayColorMatrix", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("color_matrix"), in_color_matrix, 
                        "<value of type const ::gfx::Transform&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kDisplayPrivate_SetDisplayColorMatrix_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::DisplayPrivate_SetDisplayColorMatrix_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->color_matrix)::BaseType> color_matrix_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::TransformDataView>(
      in_color_matrix, color_matrix_fragment);
  params->color_matrix.Set(
      color_matrix_fragment.is_null() ? nullptr : color_matrix_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->color_matrix.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null color_matrix in DisplayPrivate.SetDisplayColorMatrix request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DisplayPrivate::Name_);
  message.set_method_name("SetDisplayColorMatrix");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void DisplayPrivateProxy::SetDisplayColorSpaces(
    const ::gfx::DisplayColorSpaces& in_display_color_spaces) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::DisplayPrivate::SetDisplayColorSpaces", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("display_color_spaces"), in_display_color_spaces, 
                        "<value of type const ::gfx::DisplayColorSpaces&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kDisplayPrivate_SetDisplayColorSpaces_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::DisplayPrivate_SetDisplayColorSpaces_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->display_color_spaces)::BaseType> display_color_spaces_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::DisplayColorSpacesDataView>(
      in_display_color_spaces, display_color_spaces_fragment);
  params->display_color_spaces.Set(
      display_color_spaces_fragment.is_null() ? nullptr : display_color_spaces_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->display_color_spaces.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null display_color_spaces in DisplayPrivate.SetDisplayColorSpaces request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DisplayPrivate::Name_);
  message.set_method_name("SetDisplayColorSpaces");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void DisplayPrivateProxy::SetOutputIsSecure(
    bool in_secure) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::DisplayPrivate::SetOutputIsSecure", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("secure"), in_secure, 
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kDisplayPrivate_SetOutputIsSecure_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::DisplayPrivate_SetOutputIsSecure_Params_Data> params(
          message);
  params.Allocate();
  params->secure = in_secure;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DisplayPrivate::Name_);
  message.set_method_name("SetOutputIsSecure");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void DisplayPrivateProxy::SetDisplayVSyncParameters(
    ::base::TimeTicks in_timebase, ::base::TimeDelta in_interval) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::DisplayPrivate::SetDisplayVSyncParameters", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("timebase"), in_timebase, 
                        "<value of type ::base::TimeTicks>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("interval"), in_interval, 
                        "<value of type ::base::TimeDelta>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kDisplayPrivate_SetDisplayVSyncParameters_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::DisplayPrivate_SetDisplayVSyncParameters_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->timebase)::BaseType> timebase_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
      in_timebase, timebase_fragment);
  params->timebase.Set(
      timebase_fragment.is_null() ? nullptr : timebase_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->timebase.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null timebase in DisplayPrivate.SetDisplayVSyncParameters request");
  mojo::internal::MessageFragment<
      typename decltype(params->interval)::BaseType> interval_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_interval, interval_fragment);
  params->interval.Set(
      interval_fragment.is_null() ? nullptr : interval_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->interval.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null interval in DisplayPrivate.SetDisplayVSyncParameters request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DisplayPrivate::Name_);
  message.set_method_name("SetDisplayVSyncParameters");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void DisplayPrivateProxy::ForceImmediateDrawAndSwapIfPossible(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "viz::mojom::DisplayPrivate::ForceImmediateDrawAndSwapIfPossible");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kDisplayPrivate_ForceImmediateDrawAndSwapIfPossible_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::DisplayPrivate_ForceImmediateDrawAndSwapIfPossible_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DisplayPrivate::Name_);
  message.set_method_name("ForceImmediateDrawAndSwapIfPossible");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void DisplayPrivateProxy::AddVSyncParameterObserver(
    ::mojo::PendingRemote<::viz::mojom::VSyncParameterObserver> in_observer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::DisplayPrivate::AddVSyncParameterObserver", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("observer"), in_observer, 
                        "<value of type ::mojo::PendingRemote<::viz::mojom::VSyncParameterObserver>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kDisplayPrivate_AddVSyncParameterObserver_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::DisplayPrivate_AddVSyncParameterObserver_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::viz::mojom::VSyncParameterObserverInterfaceBase>>(
      in_observer, &params->observer, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->observer),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid observer in DisplayPrivate.AddVSyncParameterObserver request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DisplayPrivate::Name_);
  message.set_method_name("AddVSyncParameterObserver");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void DisplayPrivateProxy::SetDelegatedInkPointRenderer(
    ::mojo::PendingReceiver<::viz::mojom::DelegatedInkPointRenderer> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::DisplayPrivate::SetDelegatedInkPointRenderer", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver, 
                        "<value of type ::mojo::PendingReceiver<::viz::mojom::DelegatedInkPointRenderer>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kDisplayPrivate_SetDelegatedInkPointRenderer_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::DisplayPrivate_SetDelegatedInkPointRenderer_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::viz::mojom::DelegatedInkPointRendererInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in DisplayPrivate.SetDelegatedInkPointRenderer request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DisplayPrivate::Name_);
  message.set_method_name("SetDelegatedInkPointRenderer");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool DisplayPrivateStubDispatch::Accept(
    DisplayPrivate* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kDisplayPrivate_SetDisplayVisible_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::DisplayPrivate::SetDisplayVisible",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::DisplayPrivate::SetDisplayVisible");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DisplayPrivate_SetDisplayVisible_Params_Data* params =
          reinterpret_cast<internal::DisplayPrivate_SetDisplayVisible_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_visible{};
      DisplayPrivate_SetDisplayVisible_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_visible = input_data_view.visible();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DisplayPrivate::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetDisplayVisible(
std::move(p_visible));
      return true;
    }
    case internal::kDisplayPrivate_Resize_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::DisplayPrivate::Resize",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::DisplayPrivate::Resize");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DisplayPrivate_Resize_Params_Data* params =
          reinterpret_cast<internal::DisplayPrivate_Resize_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::gfx::Size p_size{};
      DisplayPrivate_Resize_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSize(&p_size))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DisplayPrivate::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Resize(
std::move(p_size));
      return true;
    }
    case internal::kDisplayPrivate_SetDisplayColorMatrix_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::DisplayPrivate::SetDisplayColorMatrix",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::DisplayPrivate::SetDisplayColorMatrix");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DisplayPrivate_SetDisplayColorMatrix_Params_Data* params =
          reinterpret_cast<internal::DisplayPrivate_SetDisplayColorMatrix_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::gfx::Transform p_color_matrix{};
      DisplayPrivate_SetDisplayColorMatrix_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadColorMatrix(&p_color_matrix))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DisplayPrivate::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetDisplayColorMatrix(
std::move(p_color_matrix));
      return true;
    }
    case internal::kDisplayPrivate_SetDisplayColorSpaces_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::DisplayPrivate::SetDisplayColorSpaces",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::DisplayPrivate::SetDisplayColorSpaces");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DisplayPrivate_SetDisplayColorSpaces_Params_Data* params =
          reinterpret_cast<internal::DisplayPrivate_SetDisplayColorSpaces_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::gfx::DisplayColorSpaces p_display_color_spaces{};
      DisplayPrivate_SetDisplayColorSpaces_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDisplayColorSpaces(&p_display_color_spaces))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DisplayPrivate::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetDisplayColorSpaces(
std::move(p_display_color_spaces));
      return true;
    }
    case internal::kDisplayPrivate_SetOutputIsSecure_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::DisplayPrivate::SetOutputIsSecure",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::DisplayPrivate::SetOutputIsSecure");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DisplayPrivate_SetOutputIsSecure_Params_Data* params =
          reinterpret_cast<internal::DisplayPrivate_SetOutputIsSecure_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_secure{};
      DisplayPrivate_SetOutputIsSecure_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_secure = input_data_view.secure();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DisplayPrivate::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetOutputIsSecure(
std::move(p_secure));
      return true;
    }
    case internal::kDisplayPrivate_SetDisplayVSyncParameters_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::DisplayPrivate::SetDisplayVSyncParameters",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::DisplayPrivate::SetDisplayVSyncParameters");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DisplayPrivate_SetDisplayVSyncParameters_Params_Data* params =
          reinterpret_cast<internal::DisplayPrivate_SetDisplayVSyncParameters_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::base::TimeTicks p_timebase{};
      ::base::TimeDelta p_interval{};
      DisplayPrivate_SetDisplayVSyncParameters_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTimebase(&p_timebase))
        success = false;
      if (success && !input_data_view.ReadInterval(&p_interval))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DisplayPrivate::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetDisplayVSyncParameters(
std::move(p_timebase), 
std::move(p_interval));
      return true;
    }
    case internal::kDisplayPrivate_ForceImmediateDrawAndSwapIfPossible_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::DisplayPrivate::ForceImmediateDrawAndSwapIfPossible",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::DisplayPrivate::ForceImmediateDrawAndSwapIfPossible");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DisplayPrivate_ForceImmediateDrawAndSwapIfPossible_Params_Data* params =
          reinterpret_cast<internal::DisplayPrivate_ForceImmediateDrawAndSwapIfPossible_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      DisplayPrivate_ForceImmediateDrawAndSwapIfPossible_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DisplayPrivate::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ForceImmediateDrawAndSwapIfPossible();
      return true;
    }
    case internal::kDisplayPrivate_AddVSyncParameterObserver_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::DisplayPrivate::AddVSyncParameterObserver",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::DisplayPrivate::AddVSyncParameterObserver");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DisplayPrivate_AddVSyncParameterObserver_Params_Data* params =
          reinterpret_cast<internal::DisplayPrivate_AddVSyncParameterObserver_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<::viz::mojom::VSyncParameterObserver> p_observer{};
      DisplayPrivate_AddVSyncParameterObserver_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_observer =
            input_data_view.TakeObserver<decltype(p_observer)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DisplayPrivate::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddVSyncParameterObserver(
std::move(p_observer));
      return true;
    }
    case internal::kDisplayPrivate_SetDelegatedInkPointRenderer_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::DisplayPrivate::SetDelegatedInkPointRenderer",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::DisplayPrivate::SetDelegatedInkPointRenderer");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DisplayPrivate_SetDelegatedInkPointRenderer_Params_Data* params =
          reinterpret_cast<internal::DisplayPrivate_SetDelegatedInkPointRenderer_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::viz::mojom::DelegatedInkPointRenderer> p_receiver{};
      DisplayPrivate_SetDelegatedInkPointRenderer_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DisplayPrivate::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetDelegatedInkPointRenderer(
std::move(p_receiver));
      return true;
    }
  }
  return false;
}

// static
bool DisplayPrivateStubDispatch::AcceptWithResponder(
    DisplayPrivate* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kDisplayPrivate_SetDisplayVisible_Name: {
      break;
    }
    case internal::kDisplayPrivate_Resize_Name: {
      break;
    }
    case internal::kDisplayPrivate_SetDisplayColorMatrix_Name: {
      break;
    }
    case internal::kDisplayPrivate_SetDisplayColorSpaces_Name: {
      break;
    }
    case internal::kDisplayPrivate_SetOutputIsSecure_Name: {
      break;
    }
    case internal::kDisplayPrivate_SetDisplayVSyncParameters_Name: {
      break;
    }
    case internal::kDisplayPrivate_ForceImmediateDrawAndSwapIfPossible_Name: {
      break;
    }
    case internal::kDisplayPrivate_AddVSyncParameterObserver_Name: {
      break;
    }
    case internal::kDisplayPrivate_SetDelegatedInkPointRenderer_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kDisplayPrivateValidationInfo[] = {
    {internal::kDisplayPrivate_SetDisplayVisible_Name,
     {&internal::DisplayPrivate_SetDisplayVisible_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kDisplayPrivate_Resize_Name,
     {&internal::DisplayPrivate_Resize_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kDisplayPrivate_SetDisplayColorMatrix_Name,
     {&internal::DisplayPrivate_SetDisplayColorMatrix_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kDisplayPrivate_SetDisplayColorSpaces_Name,
     {&internal::DisplayPrivate_SetDisplayColorSpaces_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kDisplayPrivate_SetOutputIsSecure_Name,
     {&internal::DisplayPrivate_SetOutputIsSecure_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kDisplayPrivate_SetDisplayVSyncParameters_Name,
     {&internal::DisplayPrivate_SetDisplayVSyncParameters_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kDisplayPrivate_ForceImmediateDrawAndSwapIfPossible_Name,
     {&internal::DisplayPrivate_ForceImmediateDrawAndSwapIfPossible_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kDisplayPrivate_AddVSyncParameterObserver_Name,
     {&internal::DisplayPrivate_AddVSyncParameterObserver_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kDisplayPrivate_SetDelegatedInkPointRenderer_Name,
     {&internal::DisplayPrivate_SetDelegatedInkPointRenderer_Params_Data::Validate,
      nullptr /* no response */}},
};

bool DisplayPrivateRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::viz::mojom::DisplayPrivate::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kDisplayPrivateValidationInfo);
}

const char DisplayClient::Name_[] = "viz.mojom.DisplayClient";

DisplayClientProxy::DisplayClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DisplayClientProxy::DidCompleteSwapWithNewSize(
    const ::gfx::Size& in_size) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::DisplayClient::DidCompleteSwapWithNewSize", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("size"), in_size, 
                        "<value of type const ::gfx::Size&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kDisplayClient_DidCompleteSwapWithNewSize_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::DisplayClient_DidCompleteSwapWithNewSize_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->size)::BaseType> size_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
      in_size, size_fragment);
  params->size.Set(
      size_fragment.is_null() ? nullptr : size_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->size.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null size in DisplayClient.DidCompleteSwapWithNewSize request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DisplayClient::Name_);
  message.set_method_name("DidCompleteSwapWithNewSize");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool DisplayClientStubDispatch::Accept(
    DisplayClient* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kDisplayClient_DidCompleteSwapWithNewSize_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::DisplayClient::DidCompleteSwapWithNewSize",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::DisplayClient::DidCompleteSwapWithNewSize");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DisplayClient_DidCompleteSwapWithNewSize_Params_Data* params =
          reinterpret_cast<internal::DisplayClient_DidCompleteSwapWithNewSize_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::gfx::Size p_size{};
      DisplayClient_DidCompleteSwapWithNewSize_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSize(&p_size))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DisplayClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidCompleteSwapWithNewSize(
std::move(p_size));
      return true;
    }
  }
  return false;
}

// static
bool DisplayClientStubDispatch::AcceptWithResponder(
    DisplayClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kDisplayClient_DidCompleteSwapWithNewSize_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kDisplayClientValidationInfo[] = {
    {internal::kDisplayClient_DidCompleteSwapWithNewSize_Name,
     {&internal::DisplayClient_DidCompleteSwapWithNewSize_Params_Data::Validate,
      nullptr /* no response */}},
};

bool DisplayClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::viz::mojom::DisplayClient::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kDisplayClientValidationInfo);
}

}  // namespace mojom
}  // namespace viz

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif