// services/viz/privileged/mojom/compositing/frame_sink_manager.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/viz/privileged/mojom/compositing/frame_sink_manager.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/viz/privileged/mojom/compositing/frame_sink_manager.mojom-params-data.h"
namespace viz {
namespace mojom {

namespace internal {


// static
bool RootCompositorFrameSinkParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 64, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RootCompositorFrameSinkParams_Data* object = static_cast<const RootCompositorFrameSinkParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->frame_sink_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->frame_sink_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->widget, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->widget, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->renderer_settings, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->renderer_settings, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->compositor_frame_sink, 8, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->compositor_frame_sink,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->compositor_frame_sink_client, 9, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->compositor_frame_sink_client,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->display_private, 10, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->display_private,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->display_client, 11, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->display_client,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterface(object->external_begin_frame_controller,
                                                 validation_context)) {
    return false;
  }

  return true;
}

RootCompositorFrameSinkParams_Data::RootCompositorFrameSinkParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameSinkManager_RegisterFrameSinkId_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FrameSinkManager_RegisterFrameSinkId_Params_Data* object = static_cast<const FrameSinkManager_RegisterFrameSinkId_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->frame_sink_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->frame_sink_id, validation_context))
    return false;

  return true;
}

FrameSinkManager_RegisterFrameSinkId_Params_Data::FrameSinkManager_RegisterFrameSinkId_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameSinkManager_InvalidateFrameSinkId_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FrameSinkManager_InvalidateFrameSinkId_Params_Data* object = static_cast<const FrameSinkManager_InvalidateFrameSinkId_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->frame_sink_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->frame_sink_id, validation_context))
    return false;

  return true;
}

FrameSinkManager_InvalidateFrameSinkId_Params_Data::FrameSinkManager_InvalidateFrameSinkId_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameSinkManager_SetFrameSinkDebugLabel_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FrameSinkManager_SetFrameSinkDebugLabel_Params_Data* object = static_cast<const FrameSinkManager_SetFrameSinkDebugLabel_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->frame_sink_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->frame_sink_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->debug_label, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams debug_label_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->debug_label, validation_context,
                                         &debug_label_validate_params)) {
    return false;
  }

  return true;
}

FrameSinkManager_SetFrameSinkDebugLabel_Params_Data::FrameSinkManager_SetFrameSinkDebugLabel_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameSinkManager_CreateRootCompositorFrameSink_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FrameSinkManager_CreateRootCompositorFrameSink_Params_Data* object = static_cast<const FrameSinkManager_CreateRootCompositorFrameSink_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->params, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->params, validation_context))
    return false;

  return true;
}

FrameSinkManager_CreateRootCompositorFrameSink_Params_Data::FrameSinkManager_CreateRootCompositorFrameSink_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameSinkManager_CreateCompositorFrameSink_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FrameSinkManager_CreateCompositorFrameSink_Params_Data* object = static_cast<const FrameSinkManager_CreateCompositorFrameSink_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->frame_sink_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->frame_sink_id, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->compositor_frame_sink, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->compositor_frame_sink,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->compositor_frame_sink_client, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->compositor_frame_sink_client,
                                                 validation_context)) {
    return false;
  }

  return true;
}

FrameSinkManager_CreateCompositorFrameSink_Params_Data::FrameSinkManager_CreateCompositorFrameSink_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameSinkManager_DestroyCompositorFrameSink_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FrameSinkManager_DestroyCompositorFrameSink_Params_Data* object = static_cast<const FrameSinkManager_DestroyCompositorFrameSink_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->frame_sink_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->frame_sink_id, validation_context))
    return false;

  return true;
}

FrameSinkManager_DestroyCompositorFrameSink_Params_Data::FrameSinkManager_DestroyCompositorFrameSink_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameSinkManager_DestroyCompositorFrameSink_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FrameSinkManager_DestroyCompositorFrameSink_ResponseParams_Data* object = static_cast<const FrameSinkManager_DestroyCompositorFrameSink_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

FrameSinkManager_DestroyCompositorFrameSink_ResponseParams_Data::FrameSinkManager_DestroyCompositorFrameSink_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameSinkManager_RegisterFrameSinkHierarchy_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FrameSinkManager_RegisterFrameSinkHierarchy_Params_Data* object = static_cast<const FrameSinkManager_RegisterFrameSinkHierarchy_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->parent_frame_sink_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->parent_frame_sink_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->child_frame_sink_id, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->child_frame_sink_id, validation_context))
    return false;

  return true;
}

FrameSinkManager_RegisterFrameSinkHierarchy_Params_Data::FrameSinkManager_RegisterFrameSinkHierarchy_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameSinkManager_UnregisterFrameSinkHierarchy_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FrameSinkManager_UnregisterFrameSinkHierarchy_Params_Data* object = static_cast<const FrameSinkManager_UnregisterFrameSinkHierarchy_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->parent_frame_sink_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->parent_frame_sink_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->child_frame_sink_id, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->child_frame_sink_id, validation_context))
    return false;

  return true;
}

FrameSinkManager_UnregisterFrameSinkHierarchy_Params_Data::FrameSinkManager_UnregisterFrameSinkHierarchy_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameSinkManager_AddVideoDetectorObserver_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FrameSinkManager_AddVideoDetectorObserver_Params_Data* object = static_cast<const FrameSinkManager_AddVideoDetectorObserver_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->observer, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->observer,
                                                 validation_context)) {
    return false;
  }

  return true;
}

FrameSinkManager_AddVideoDetectorObserver_Params_Data::FrameSinkManager_AddVideoDetectorObserver_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameSinkManager_CreateVideoCapturer_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FrameSinkManager_CreateVideoCapturer_Params_Data* object = static_cast<const FrameSinkManager_CreateVideoCapturer_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

FrameSinkManager_CreateVideoCapturer_Params_Data::FrameSinkManager_CreateVideoCapturer_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameSinkManager_EvictSurfaces_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FrameSinkManager_EvictSurfaces_Params_Data* object = static_cast<const FrameSinkManager_EvictSurfaces_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->surface_ids, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams surface_ids_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->surface_ids, validation_context,
                                         &surface_ids_validate_params)) {
    return false;
  }

  return true;
}

FrameSinkManager_EvictSurfaces_Params_Data::FrameSinkManager_EvictSurfaces_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameSinkManager_StartThrottling_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FrameSinkManager_StartThrottling_Params_Data* object = static_cast<const FrameSinkManager_StartThrottling_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->frame_sink_ids, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams frame_sink_ids_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->frame_sink_ids, validation_context,
                                         &frame_sink_ids_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->interval, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->interval, validation_context))
    return false;

  return true;
}

FrameSinkManager_StartThrottling_Params_Data::FrameSinkManager_StartThrottling_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameSinkManager_EndThrottling_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FrameSinkManager_EndThrottling_Params_Data* object = static_cast<const FrameSinkManager_EndThrottling_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

FrameSinkManager_EndThrottling_Params_Data::FrameSinkManager_EndThrottling_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameSinkManager_Throttle_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FrameSinkManager_Throttle_Params_Data* object = static_cast<const FrameSinkManager_Throttle_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->frame_sink_ids, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams frame_sink_ids_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->frame_sink_ids, validation_context,
                                         &frame_sink_ids_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->interval, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->interval, validation_context))
    return false;

  return true;
}

FrameSinkManager_Throttle_Params_Data::FrameSinkManager_Throttle_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameSinkManager_RequestCopyOfOutput_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FrameSinkManager_RequestCopyOfOutput_Params_Data* object = static_cast<const FrameSinkManager_RequestCopyOfOutput_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->surface_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->surface_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->request, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->request, validation_context))
    return false;

  return true;
}

FrameSinkManager_RequestCopyOfOutput_Params_Data::FrameSinkManager_RequestCopyOfOutput_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameSinkManager_SetHitTestAsyncQueriedDebugRegions_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FrameSinkManager_SetHitTestAsyncQueriedDebugRegions_Params_Data* object = static_cast<const FrameSinkManager_SetHitTestAsyncQueriedDebugRegions_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->root_frame_sink_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->root_frame_sink_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->hit_test_async_queried_debug_queue, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams hit_test_async_queried_debug_queue_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->hit_test_async_queried_debug_queue, validation_context,
                                         &hit_test_async_queried_debug_queue_validate_params)) {
    return false;
  }

  return true;
}

FrameSinkManager_SetHitTestAsyncQueriedDebugRegions_Params_Data::FrameSinkManager_SetHitTestAsyncQueriedDebugRegions_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameSinkManager_CacheBackBuffer_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FrameSinkManager_CacheBackBuffer_Params_Data* object = static_cast<const FrameSinkManager_CacheBackBuffer_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->root_frame_sink_id, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->root_frame_sink_id, validation_context))
    return false;

  return true;
}

FrameSinkManager_CacheBackBuffer_Params_Data::FrameSinkManager_CacheBackBuffer_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameSinkManager_EvictBackBuffer_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FrameSinkManager_EvictBackBuffer_Params_Data* object = static_cast<const FrameSinkManager_EvictBackBuffer_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

FrameSinkManager_EvictBackBuffer_Params_Data::FrameSinkManager_EvictBackBuffer_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameSinkManager_EvictBackBuffer_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FrameSinkManager_EvictBackBuffer_ResponseParams_Data* object = static_cast<const FrameSinkManager_EvictBackBuffer_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

FrameSinkManager_EvictBackBuffer_ResponseParams_Data::FrameSinkManager_EvictBackBuffer_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameSinkManager_UpdateDebugRendererSettings_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FrameSinkManager_UpdateDebugRendererSettings_Params_Data* object = static_cast<const FrameSinkManager_UpdateDebugRendererSettings_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->debug_settings, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->debug_settings, validation_context))
    return false;

  return true;
}

FrameSinkManager_UpdateDebugRendererSettings_Params_Data::FrameSinkManager_UpdateDebugRendererSettings_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameSinkManagerClient_OnFirstSurfaceActivation_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FrameSinkManagerClient_OnFirstSurfaceActivation_Params_Data* object = static_cast<const FrameSinkManagerClient_OnFirstSurfaceActivation_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->surface_info, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->surface_info, validation_context))
    return false;

  return true;
}

FrameSinkManagerClient_OnFirstSurfaceActivation_Params_Data::FrameSinkManagerClient_OnFirstSurfaceActivation_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameSinkManagerClient_OnAggregatedHitTestRegionListUpdated_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FrameSinkManagerClient_OnAggregatedHitTestRegionListUpdated_Params_Data* object = static_cast<const FrameSinkManagerClient_OnAggregatedHitTestRegionListUpdated_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->frame_sink_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->frame_sink_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->hit_test_data, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams hit_test_data_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->hit_test_data, validation_context,
                                         &hit_test_data_validate_params)) {
    return false;
  }

  return true;
}

FrameSinkManagerClient_OnAggregatedHitTestRegionListUpdated_Params_Data::FrameSinkManagerClient_OnAggregatedHitTestRegionListUpdated_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameSinkManagerClient_OnFrameTokenChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FrameSinkManagerClient_OnFrameTokenChanged_Params_Data* object = static_cast<const FrameSinkManagerClient_OnFrameTokenChanged_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->frame_sink_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->frame_sink_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->activation_time, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->activation_time, validation_context))
    return false;

  return true;
}

FrameSinkManagerClient_OnFrameTokenChanged_Params_Data::FrameSinkManagerClient_OnFrameTokenChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace viz
