// services/viz/privileged/mojom/compositing/frame_sink_manager.mojom-test-utils.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif


#include "services/viz/privileged/mojom/compositing/frame_sink_manager.mojom-test-utils.h"

#include <utility>

#include "base/bind.h"
#include "base/run_loop.h"
#include "gpu/ipc/common/surface_handle.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "services/viz/privileged/mojom/compositing/display_private.mojom.h"
#include "services/viz/privileged/mojom/compositing/external_begin_frame_controller.mojom.h"
#include "services/viz/privileged/mojom/compositing/frame_sink_video_capture.mojom.h"
#include "services/viz/privileged/mojom/compositing/renderer_settings.mojom.h"
#include "services/viz/public/mojom/compositing/compositor_frame_sink.mojom.h"
#include "services/viz/public/mojom/compositing/copy_output_request.mojom.h"
#include "services/viz/public/mojom/compositing/frame_sink_id.mojom.h"
#include "services/viz/public/mojom/compositing/local_surface_id.mojom.h"
#include "services/viz/public/mojom/compositing/surface_id.mojom.h"
#include "services/viz/public/mojom/compositing/surface_info.mojom.h"
#include "services/viz/public/mojom/hit_test/aggregated_hit_test_region.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include "services/viz/public/mojom/compositing/video_detector_observer.mojom.h"


#ifndef SERVICES_VIZ_PRIVILEGED_MOJOM_COMPOSITING_FRAME_SINK_MANAGER_MOJOM_JUMBO_H_
#define SERVICES_VIZ_PRIVILEGED_MOJOM_COMPOSITING_FRAME_SINK_MANAGER_MOJOM_JUMBO_H_
#endif


namespace viz {
namespace mojom {


void FrameSinkManagerInterceptorForTesting::RegisterFrameSinkId(const ::viz::FrameSinkId& frame_sink_id, bool report_activation) {
  GetForwardingInterface()->RegisterFrameSinkId(std::move(frame_sink_id), std::move(report_activation));
}
void FrameSinkManagerInterceptorForTesting::InvalidateFrameSinkId(const ::viz::FrameSinkId& frame_sink_id) {
  GetForwardingInterface()->InvalidateFrameSinkId(std::move(frame_sink_id));
}
void FrameSinkManagerInterceptorForTesting::SetFrameSinkDebugLabel(const ::viz::FrameSinkId& frame_sink_id, const std::string& debug_label) {
  GetForwardingInterface()->SetFrameSinkDebugLabel(std::move(frame_sink_id), std::move(debug_label));
}
void FrameSinkManagerInterceptorForTesting::CreateRootCompositorFrameSink(RootCompositorFrameSinkParamsPtr params) {
  GetForwardingInterface()->CreateRootCompositorFrameSink(std::move(params));
}
void FrameSinkManagerInterceptorForTesting::CreateCompositorFrameSink(const ::viz::FrameSinkId& frame_sink_id, ::mojo::PendingReceiver<::viz::mojom::CompositorFrameSink> compositor_frame_sink, ::mojo::PendingRemote<::viz::mojom::CompositorFrameSinkClient> compositor_frame_sink_client) {
  GetForwardingInterface()->CreateCompositorFrameSink(std::move(frame_sink_id), std::move(compositor_frame_sink), std::move(compositor_frame_sink_client));
}
void FrameSinkManagerInterceptorForTesting::DestroyCompositorFrameSink(const ::viz::FrameSinkId& frame_sink_id, DestroyCompositorFrameSinkCallback callback) {
  GetForwardingInterface()->DestroyCompositorFrameSink(std::move(frame_sink_id), std::move(callback));
}
void FrameSinkManagerInterceptorForTesting::RegisterFrameSinkHierarchy(const ::viz::FrameSinkId& parent_frame_sink_id, const ::viz::FrameSinkId& child_frame_sink_id) {
  GetForwardingInterface()->RegisterFrameSinkHierarchy(std::move(parent_frame_sink_id), std::move(child_frame_sink_id));
}
void FrameSinkManagerInterceptorForTesting::UnregisterFrameSinkHierarchy(const ::viz::FrameSinkId& parent_frame_sink_id, const ::viz::FrameSinkId& child_frame_sink_id) {
  GetForwardingInterface()->UnregisterFrameSinkHierarchy(std::move(parent_frame_sink_id), std::move(child_frame_sink_id));
}
void FrameSinkManagerInterceptorForTesting::AddVideoDetectorObserver(::mojo::PendingRemote<::viz::mojom::VideoDetectorObserver> observer) {
  GetForwardingInterface()->AddVideoDetectorObserver(std::move(observer));
}
void FrameSinkManagerInterceptorForTesting::CreateVideoCapturer(::mojo::PendingReceiver<::viz::mojom::FrameSinkVideoCapturer> receiver) {
  GetForwardingInterface()->CreateVideoCapturer(std::move(receiver));
}
void FrameSinkManagerInterceptorForTesting::EvictSurfaces(const std::vector<::viz::SurfaceId>& surface_ids) {
  GetForwardingInterface()->EvictSurfaces(std::move(surface_ids));
}
void FrameSinkManagerInterceptorForTesting::StartThrottling(const std::vector<::viz::FrameSinkId>& frame_sink_ids, ::base::TimeDelta interval) {
  GetForwardingInterface()->StartThrottling(std::move(frame_sink_ids), std::move(interval));
}
void FrameSinkManagerInterceptorForTesting::EndThrottling() {
  GetForwardingInterface()->EndThrottling();
}
void FrameSinkManagerInterceptorForTesting::Throttle(const std::vector<::viz::FrameSinkId>& frame_sink_ids, ::base::TimeDelta interval) {
  GetForwardingInterface()->Throttle(std::move(frame_sink_ids), std::move(interval));
}
void FrameSinkManagerInterceptorForTesting::RequestCopyOfOutput(const ::viz::SurfaceId& surface_id, ::std::unique_ptr<::viz::CopyOutputRequest> request) {
  GetForwardingInterface()->RequestCopyOfOutput(std::move(surface_id), std::move(request));
}
void FrameSinkManagerInterceptorForTesting::SetHitTestAsyncQueriedDebugRegions(const ::viz::FrameSinkId& root_frame_sink_id, const std::vector<::viz::FrameSinkId>& hit_test_async_queried_debug_queue) {
  GetForwardingInterface()->SetHitTestAsyncQueriedDebugRegions(std::move(root_frame_sink_id), std::move(hit_test_async_queried_debug_queue));
}
void FrameSinkManagerInterceptorForTesting::CacheBackBuffer(uint32_t cache_id, const ::viz::FrameSinkId& root_frame_sink_id) {
  GetForwardingInterface()->CacheBackBuffer(std::move(cache_id), std::move(root_frame_sink_id));
}
void FrameSinkManagerInterceptorForTesting::EvictBackBuffer(uint32_t cache_id, EvictBackBufferCallback callback) {
  GetForwardingInterface()->EvictBackBuffer(std::move(cache_id), std::move(callback));
}
void FrameSinkManagerInterceptorForTesting::UpdateDebugRendererSettings(const ::viz::DebugRendererSettings& debug_settings) {
  GetForwardingInterface()->UpdateDebugRendererSettings(std::move(debug_settings));
}
FrameSinkManagerAsyncWaiter::FrameSinkManagerAsyncWaiter(
    FrameSinkManager* proxy) : proxy_(proxy) {}

FrameSinkManagerAsyncWaiter::~FrameSinkManagerAsyncWaiter() = default;

void FrameSinkManagerAsyncWaiter::DestroyCompositorFrameSink(
    const ::viz::FrameSinkId& frame_sink_id) {
  base::RunLoop loop;
  proxy_->DestroyCompositorFrameSink(std::move(frame_sink_id),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}
void FrameSinkManagerAsyncWaiter::EvictBackBuffer(
    uint32_t cache_id) {
  base::RunLoop loop;
  proxy_->EvictBackBuffer(std::move(cache_id),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void FrameSinkManagerClientInterceptorForTesting::OnFirstSurfaceActivation(const ::viz::SurfaceInfo& surface_info) {
  GetForwardingInterface()->OnFirstSurfaceActivation(std::move(surface_info));
}
void FrameSinkManagerClientInterceptorForTesting::OnAggregatedHitTestRegionListUpdated(const ::viz::FrameSinkId& frame_sink_id, const std::vector<::viz::AggregatedHitTestRegion>& hit_test_data) {
  GetForwardingInterface()->OnAggregatedHitTestRegionListUpdated(std::move(frame_sink_id), std::move(hit_test_data));
}
void FrameSinkManagerClientInterceptorForTesting::OnFrameTokenChanged(const ::viz::FrameSinkId& frame_sink_id, uint32_t frame_token, ::base::TimeTicks activation_time) {
  GetForwardingInterface()->OnFrameTokenChanged(std::move(frame_sink_id), std::move(frame_token), std::move(activation_time));
}
FrameSinkManagerClientAsyncWaiter::FrameSinkManagerClientAsyncWaiter(
    FrameSinkManagerClient* proxy) : proxy_(proxy) {}

FrameSinkManagerClientAsyncWaiter::~FrameSinkManagerClientAsyncWaiter() = default;






}  // namespace mojom
}  // namespace viz

#if defined(__clang__)
#pragma clang diagnostic pop
#endif