// services/viz/privileged/mojom/compositing/frame_sink_video_capture.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/viz/privileged/mojom/compositing/frame_sink_video_capture.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "services/viz/privileged/mojom/compositing/frame_sink_video_capture.mojom-params-data.h"
#include "services/viz/privileged/mojom/compositing/frame_sink_video_capture.mojom-shared-message-ids.h"

#include "services/viz/privileged/mojom/compositing/frame_sink_video_capture.mojom-import-headers.h"


#ifndef SERVICES_VIZ_PRIVILEGED_MOJOM_COMPOSITING_FRAME_SINK_VIDEO_CAPTURE_MOJOM_JUMBO_H_
#define SERVICES_VIZ_PRIVILEGED_MOJOM_COMPOSITING_FRAME_SINK_VIDEO_CAPTURE_MOJOM_JUMBO_H_
#endif
namespace viz {
namespace mojom {
const char FrameSinkVideoConsumerFrameCallbacks::Name_[] = "viz.mojom.FrameSinkVideoConsumerFrameCallbacks";

FrameSinkVideoConsumerFrameCallbacksProxy::FrameSinkVideoConsumerFrameCallbacksProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void FrameSinkVideoConsumerFrameCallbacksProxy::Done(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "viz::mojom::FrameSinkVideoConsumerFrameCallbacks::Done");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameSinkVideoConsumerFrameCallbacks_Done_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinkVideoConsumerFrameCallbacks_Done_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkVideoConsumerFrameCallbacks::Name_);
  message.set_method_name("Done");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameSinkVideoConsumerFrameCallbacksProxy::ProvideFeedback(
    const ::media::VideoFrameFeedback& in_feedback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::FrameSinkVideoConsumerFrameCallbacks::ProvideFeedback", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("feedback"), in_feedback, 
                        "<value of type const ::media::VideoFrameFeedback&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameSinkVideoConsumerFrameCallbacks_ProvideFeedback_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinkVideoConsumerFrameCallbacks_ProvideFeedback_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->feedback)::BaseType> feedback_fragment(
          params.message());
  mojo::internal::Serialize<::media::mojom::VideoFrameFeedbackDataView>(
      in_feedback, feedback_fragment);
  params->feedback.Set(
      feedback_fragment.is_null() ? nullptr : feedback_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->feedback.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null feedback in FrameSinkVideoConsumerFrameCallbacks.ProvideFeedback request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkVideoConsumerFrameCallbacks::Name_);
  message.set_method_name("ProvideFeedback");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool FrameSinkVideoConsumerFrameCallbacksStubDispatch::Accept(
    FrameSinkVideoConsumerFrameCallbacks* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kFrameSinkVideoConsumerFrameCallbacks_Done_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::FrameSinkVideoConsumerFrameCallbacks::Done",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::FrameSinkVideoConsumerFrameCallbacks::Done");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameSinkVideoConsumerFrameCallbacks_Done_Params_Data* params =
          reinterpret_cast<internal::FrameSinkVideoConsumerFrameCallbacks_Done_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      FrameSinkVideoConsumerFrameCallbacks_Done_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkVideoConsumerFrameCallbacks::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Done();
      return true;
    }
    case internal::kFrameSinkVideoConsumerFrameCallbacks_ProvideFeedback_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::FrameSinkVideoConsumerFrameCallbacks::ProvideFeedback",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::FrameSinkVideoConsumerFrameCallbacks::ProvideFeedback");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameSinkVideoConsumerFrameCallbacks_ProvideFeedback_Params_Data* params =
          reinterpret_cast<internal::FrameSinkVideoConsumerFrameCallbacks_ProvideFeedback_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::media::VideoFrameFeedback p_feedback{};
      FrameSinkVideoConsumerFrameCallbacks_ProvideFeedback_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFeedback(&p_feedback))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkVideoConsumerFrameCallbacks::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ProvideFeedback(
std::move(p_feedback));
      return true;
    }
  }
  return false;
}

// static
bool FrameSinkVideoConsumerFrameCallbacksStubDispatch::AcceptWithResponder(
    FrameSinkVideoConsumerFrameCallbacks* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kFrameSinkVideoConsumerFrameCallbacks_Done_Name: {
      break;
    }
    case internal::kFrameSinkVideoConsumerFrameCallbacks_ProvideFeedback_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kFrameSinkVideoConsumerFrameCallbacksValidationInfo[] = {
    {internal::kFrameSinkVideoConsumerFrameCallbacks_Done_Name,
     {&internal::FrameSinkVideoConsumerFrameCallbacks_Done_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kFrameSinkVideoConsumerFrameCallbacks_ProvideFeedback_Name,
     {&internal::FrameSinkVideoConsumerFrameCallbacks_ProvideFeedback_Params_Data::Validate,
      nullptr /* no response */}},
};

bool FrameSinkVideoConsumerFrameCallbacksRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::viz::mojom::FrameSinkVideoConsumerFrameCallbacks::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kFrameSinkVideoConsumerFrameCallbacksValidationInfo);
}

const char FrameSinkVideoConsumer::Name_[] = "viz.mojom.FrameSinkVideoConsumer";

FrameSinkVideoConsumerProxy::FrameSinkVideoConsumerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void FrameSinkVideoConsumerProxy::OnFrameCaptured(
    ::base::ReadOnlySharedMemoryRegion in_data, ::media::mojom::VideoFrameInfoPtr in_info, const ::gfx::Rect& in_content_rect, ::mojo::PendingRemote<FrameSinkVideoConsumerFrameCallbacks> in_callbacks) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::FrameSinkVideoConsumer::OnFrameCaptured", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data, 
                        "<value of type ::base::ReadOnlySharedMemoryRegion>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("info"), in_info, 
                        "<value of type ::media::mojom::VideoFrameInfoPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("content_rect"), in_content_rect, 
                        "<value of type const ::gfx::Rect&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("callbacks"), in_callbacks, 
                        "<value of type ::mojo::PendingRemote<FrameSinkVideoConsumerFrameCallbacks>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameSinkVideoConsumer_OnFrameCaptured_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinkVideoConsumer_OnFrameCaptured_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->data)::BaseType> data_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView>(
      in_data, data_fragment);
  params->data.Set(
      data_fragment.is_null() ? nullptr : data_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null data in FrameSinkVideoConsumer.OnFrameCaptured request");
  mojo::internal::MessageFragment<
      typename decltype(params->info)::BaseType> info_fragment(
          params.message());
  mojo::internal::Serialize<::media::mojom::VideoFrameInfoDataView>(
      in_info, info_fragment);
  params->info.Set(
      info_fragment.is_null() ? nullptr : info_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null info in FrameSinkVideoConsumer.OnFrameCaptured request");
  mojo::internal::MessageFragment<
      typename decltype(params->content_rect)::BaseType> content_rect_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::RectDataView>(
      in_content_rect, content_rect_fragment);
  params->content_rect.Set(
      content_rect_fragment.is_null() ? nullptr : content_rect_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->content_rect.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null content_rect in FrameSinkVideoConsumer.OnFrameCaptured request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::viz::mojom::FrameSinkVideoConsumerFrameCallbacksInterfaceBase>>(
      in_callbacks, &params->callbacks, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->callbacks),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid callbacks in FrameSinkVideoConsumer.OnFrameCaptured request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkVideoConsumer::Name_);
  message.set_method_name("OnFrameCaptured");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameSinkVideoConsumerProxy::OnStopped(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "viz::mojom::FrameSinkVideoConsumer::OnStopped");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameSinkVideoConsumer_OnStopped_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinkVideoConsumer_OnStopped_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkVideoConsumer::Name_);
  message.set_method_name("OnStopped");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameSinkVideoConsumerProxy::OnLog(
    const std::string& in_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::FrameSinkVideoConsumer::OnLog", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message"), in_message, 
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameSinkVideoConsumer_OnLog_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinkVideoConsumer_OnLog_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->message)::BaseType> message_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_message, message_fragment);
  params->message.Set(
      message_fragment.is_null() ? nullptr : message_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->message.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null message in FrameSinkVideoConsumer.OnLog request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkVideoConsumer::Name_);
  message.set_method_name("OnLog");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool FrameSinkVideoConsumerStubDispatch::Accept(
    FrameSinkVideoConsumer* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kFrameSinkVideoConsumer_OnFrameCaptured_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::FrameSinkVideoConsumer::OnFrameCaptured",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::FrameSinkVideoConsumer::OnFrameCaptured");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameSinkVideoConsumer_OnFrameCaptured_Params_Data* params =
          reinterpret_cast<internal::FrameSinkVideoConsumer_OnFrameCaptured_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::base::ReadOnlySharedMemoryRegion p_data{};
      ::media::mojom::VideoFrameInfoPtr p_info{};
      ::gfx::Rect p_content_rect{};
      ::mojo::PendingRemote<FrameSinkVideoConsumerFrameCallbacks> p_callbacks{};
      FrameSinkVideoConsumer_OnFrameCaptured_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadData(&p_data))
        success = false;
      if (success && !input_data_view.ReadInfo(&p_info))
        success = false;
      if (success && !input_data_view.ReadContentRect(&p_content_rect))
        success = false;
      if (success) {
        p_callbacks =
            input_data_view.TakeCallbacks<decltype(p_callbacks)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkVideoConsumer::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnFrameCaptured(
std::move(p_data), 
std::move(p_info), 
std::move(p_content_rect), 
std::move(p_callbacks));
      return true;
    }
    case internal::kFrameSinkVideoConsumer_OnStopped_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::FrameSinkVideoConsumer::OnStopped",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::FrameSinkVideoConsumer::OnStopped");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameSinkVideoConsumer_OnStopped_Params_Data* params =
          reinterpret_cast<internal::FrameSinkVideoConsumer_OnStopped_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      FrameSinkVideoConsumer_OnStopped_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkVideoConsumer::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnStopped();
      return true;
    }
    case internal::kFrameSinkVideoConsumer_OnLog_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::FrameSinkVideoConsumer::OnLog",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::FrameSinkVideoConsumer::OnLog");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameSinkVideoConsumer_OnLog_Params_Data* params =
          reinterpret_cast<internal::FrameSinkVideoConsumer_OnLog_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_message{};
      FrameSinkVideoConsumer_OnLog_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkVideoConsumer::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnLog(
std::move(p_message));
      return true;
    }
  }
  return false;
}

// static
bool FrameSinkVideoConsumerStubDispatch::AcceptWithResponder(
    FrameSinkVideoConsumer* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kFrameSinkVideoConsumer_OnFrameCaptured_Name: {
      break;
    }
    case internal::kFrameSinkVideoConsumer_OnStopped_Name: {
      break;
    }
    case internal::kFrameSinkVideoConsumer_OnLog_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kFrameSinkVideoConsumerValidationInfo[] = {
    {internal::kFrameSinkVideoConsumer_OnFrameCaptured_Name,
     {&internal::FrameSinkVideoConsumer_OnFrameCaptured_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kFrameSinkVideoConsumer_OnStopped_Name,
     {&internal::FrameSinkVideoConsumer_OnStopped_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kFrameSinkVideoConsumer_OnLog_Name,
     {&internal::FrameSinkVideoConsumer_OnLog_Params_Data::Validate,
      nullptr /* no response */}},
};

bool FrameSinkVideoConsumerRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::viz::mojom::FrameSinkVideoConsumer::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kFrameSinkVideoConsumerValidationInfo);
}

const char FrameSinkVideoCapturer::Name_[] = "viz.mojom.FrameSinkVideoCapturer";

FrameSinkVideoCapturerProxy::FrameSinkVideoCapturerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void FrameSinkVideoCapturerProxy::SetFormat(
    ::media::VideoPixelFormat in_format, const ::gfx::ColorSpace& in_color_space) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::FrameSinkVideoCapturer::SetFormat", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("format"), in_format, 
                        "<value of type ::media::VideoPixelFormat>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("color_space"), in_color_space, 
                        "<value of type const ::gfx::ColorSpace&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameSinkVideoCapturer_SetFormat_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinkVideoCapturer_SetFormat_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::media::mojom::VideoPixelFormat>(
      in_format, &params->format);
  mojo::internal::MessageFragment<
      typename decltype(params->color_space)::BaseType> color_space_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::ColorSpaceDataView>(
      in_color_space, color_space_fragment);
  params->color_space.Set(
      color_space_fragment.is_null() ? nullptr : color_space_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->color_space.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null color_space in FrameSinkVideoCapturer.SetFormat request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkVideoCapturer::Name_);
  message.set_method_name("SetFormat");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameSinkVideoCapturerProxy::SetMinCapturePeriod(
    ::base::TimeDelta in_min_period) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::FrameSinkVideoCapturer::SetMinCapturePeriod", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("min_period"), in_min_period, 
                        "<value of type ::base::TimeDelta>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameSinkVideoCapturer_SetMinCapturePeriod_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinkVideoCapturer_SetMinCapturePeriod_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->min_period)::BaseType> min_period_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_min_period, min_period_fragment);
  params->min_period.Set(
      min_period_fragment.is_null() ? nullptr : min_period_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->min_period.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null min_period in FrameSinkVideoCapturer.SetMinCapturePeriod request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkVideoCapturer::Name_);
  message.set_method_name("SetMinCapturePeriod");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameSinkVideoCapturerProxy::SetMinSizeChangePeriod(
    ::base::TimeDelta in_min_period) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::FrameSinkVideoCapturer::SetMinSizeChangePeriod", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("min_period"), in_min_period, 
                        "<value of type ::base::TimeDelta>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameSinkVideoCapturer_SetMinSizeChangePeriod_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinkVideoCapturer_SetMinSizeChangePeriod_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->min_period)::BaseType> min_period_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_min_period, min_period_fragment);
  params->min_period.Set(
      min_period_fragment.is_null() ? nullptr : min_period_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->min_period.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null min_period in FrameSinkVideoCapturer.SetMinSizeChangePeriod request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkVideoCapturer::Name_);
  message.set_method_name("SetMinSizeChangePeriod");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameSinkVideoCapturerProxy::SetResolutionConstraints(
    const ::gfx::Size& in_min_size, const ::gfx::Size& in_max_size, bool in_use_fixed_aspect_ratio) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::FrameSinkVideoCapturer::SetResolutionConstraints", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("min_size"), in_min_size, 
                        "<value of type const ::gfx::Size&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("max_size"), in_max_size, 
                        "<value of type const ::gfx::Size&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("use_fixed_aspect_ratio"), in_use_fixed_aspect_ratio, 
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameSinkVideoCapturer_SetResolutionConstraints_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinkVideoCapturer_SetResolutionConstraints_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->min_size)::BaseType> min_size_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
      in_min_size, min_size_fragment);
  params->min_size.Set(
      min_size_fragment.is_null() ? nullptr : min_size_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->min_size.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null min_size in FrameSinkVideoCapturer.SetResolutionConstraints request");
  mojo::internal::MessageFragment<
      typename decltype(params->max_size)::BaseType> max_size_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
      in_max_size, max_size_fragment);
  params->max_size.Set(
      max_size_fragment.is_null() ? nullptr : max_size_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->max_size.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null max_size in FrameSinkVideoCapturer.SetResolutionConstraints request");
  params->use_fixed_aspect_ratio = in_use_fixed_aspect_ratio;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkVideoCapturer::Name_);
  message.set_method_name("SetResolutionConstraints");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameSinkVideoCapturerProxy::SetAutoThrottlingEnabled(
    bool in_enabled) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::FrameSinkVideoCapturer::SetAutoThrottlingEnabled", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("enabled"), in_enabled, 
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameSinkVideoCapturer_SetAutoThrottlingEnabled_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinkVideoCapturer_SetAutoThrottlingEnabled_Params_Data> params(
          message);
  params.Allocate();
  params->enabled = in_enabled;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkVideoCapturer::Name_);
  message.set_method_name("SetAutoThrottlingEnabled");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameSinkVideoCapturerProxy::ChangeTarget(
    const base::Optional<::viz::FrameSinkId>& in_frame_sink_id, const ::viz::SubtreeCaptureId& in_subtree_capture_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::FrameSinkVideoCapturer::ChangeTarget", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_sink_id"), in_frame_sink_id, 
                        "<value of type const base::Optional<::viz::FrameSinkId>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("subtree_capture_id"), in_subtree_capture_id, 
                        "<value of type const ::viz::SubtreeCaptureId&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameSinkVideoCapturer_ChangeTarget_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinkVideoCapturer_ChangeTarget_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->frame_sink_id)::BaseType> frame_sink_id_fragment(
          params.message());
  mojo::internal::Serialize<::viz::mojom::FrameSinkIdDataView>(
      in_frame_sink_id, frame_sink_id_fragment);
  params->frame_sink_id.Set(
      frame_sink_id_fragment.is_null() ? nullptr : frame_sink_id_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->subtree_capture_id)::BaseType> subtree_capture_id_fragment(
          params.message());
  mojo::internal::Serialize<::viz::mojom::SubtreeCaptureIdDataView>(
      in_subtree_capture_id, subtree_capture_id_fragment);
  params->subtree_capture_id.Set(
      subtree_capture_id_fragment.is_null() ? nullptr : subtree_capture_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->subtree_capture_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null subtree_capture_id in FrameSinkVideoCapturer.ChangeTarget request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkVideoCapturer::Name_);
  message.set_method_name("ChangeTarget");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameSinkVideoCapturerProxy::Start(
    ::mojo::PendingRemote<FrameSinkVideoConsumer> in_consumer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::FrameSinkVideoCapturer::Start", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("consumer"), in_consumer, 
                        "<value of type ::mojo::PendingRemote<FrameSinkVideoConsumer>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameSinkVideoCapturer_Start_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinkVideoCapturer_Start_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::viz::mojom::FrameSinkVideoConsumerInterfaceBase>>(
      in_consumer, &params->consumer, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->consumer),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid consumer in FrameSinkVideoCapturer.Start request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkVideoCapturer::Name_);
  message.set_method_name("Start");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameSinkVideoCapturerProxy::Stop(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "viz::mojom::FrameSinkVideoCapturer::Stop");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameSinkVideoCapturer_Stop_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinkVideoCapturer_Stop_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkVideoCapturer::Name_);
  message.set_method_name("Stop");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameSinkVideoCapturerProxy::RequestRefreshFrame(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "viz::mojom::FrameSinkVideoCapturer::RequestRefreshFrame");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameSinkVideoCapturer_RequestRefreshFrame_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinkVideoCapturer_RequestRefreshFrame_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkVideoCapturer::Name_);
  message.set_method_name("RequestRefreshFrame");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameSinkVideoCapturerProxy::CreateOverlay(
    int32_t in_stacking_index, ::mojo::PendingReceiver<FrameSinkVideoCaptureOverlay> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::FrameSinkVideoCapturer::CreateOverlay", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("stacking_index"), in_stacking_index, 
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver, 
                        "<value of type ::mojo::PendingReceiver<FrameSinkVideoCaptureOverlay>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameSinkVideoCapturer_CreateOverlay_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinkVideoCapturer_CreateOverlay_Params_Data> params(
          message);
  params.Allocate();
  params->stacking_index = in_stacking_index;
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::viz::mojom::FrameSinkVideoCaptureOverlayInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in FrameSinkVideoCapturer.CreateOverlay request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkVideoCapturer::Name_);
  message.set_method_name("CreateOverlay");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool FrameSinkVideoCapturerStubDispatch::Accept(
    FrameSinkVideoCapturer* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kFrameSinkVideoCapturer_SetFormat_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::FrameSinkVideoCapturer::SetFormat",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::FrameSinkVideoCapturer::SetFormat");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameSinkVideoCapturer_SetFormat_Params_Data* params =
          reinterpret_cast<internal::FrameSinkVideoCapturer_SetFormat_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::media::VideoPixelFormat p_format{};
      ::gfx::ColorSpace p_color_space{};
      FrameSinkVideoCapturer_SetFormat_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFormat(&p_format))
        success = false;
      if (success && !input_data_view.ReadColorSpace(&p_color_space))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkVideoCapturer::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetFormat(
std::move(p_format), 
std::move(p_color_space));
      return true;
    }
    case internal::kFrameSinkVideoCapturer_SetMinCapturePeriod_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::FrameSinkVideoCapturer::SetMinCapturePeriod",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::FrameSinkVideoCapturer::SetMinCapturePeriod");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameSinkVideoCapturer_SetMinCapturePeriod_Params_Data* params =
          reinterpret_cast<internal::FrameSinkVideoCapturer_SetMinCapturePeriod_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::base::TimeDelta p_min_period{};
      FrameSinkVideoCapturer_SetMinCapturePeriod_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMinPeriod(&p_min_period))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkVideoCapturer::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetMinCapturePeriod(
std::move(p_min_period));
      return true;
    }
    case internal::kFrameSinkVideoCapturer_SetMinSizeChangePeriod_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::FrameSinkVideoCapturer::SetMinSizeChangePeriod",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::FrameSinkVideoCapturer::SetMinSizeChangePeriod");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameSinkVideoCapturer_SetMinSizeChangePeriod_Params_Data* params =
          reinterpret_cast<internal::FrameSinkVideoCapturer_SetMinSizeChangePeriod_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::base::TimeDelta p_min_period{};
      FrameSinkVideoCapturer_SetMinSizeChangePeriod_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMinPeriod(&p_min_period))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkVideoCapturer::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetMinSizeChangePeriod(
std::move(p_min_period));
      return true;
    }
    case internal::kFrameSinkVideoCapturer_SetResolutionConstraints_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::FrameSinkVideoCapturer::SetResolutionConstraints",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::FrameSinkVideoCapturer::SetResolutionConstraints");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameSinkVideoCapturer_SetResolutionConstraints_Params_Data* params =
          reinterpret_cast<internal::FrameSinkVideoCapturer_SetResolutionConstraints_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::gfx::Size p_min_size{};
      ::gfx::Size p_max_size{};
      bool p_use_fixed_aspect_ratio{};
      FrameSinkVideoCapturer_SetResolutionConstraints_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMinSize(&p_min_size))
        success = false;
      if (success && !input_data_view.ReadMaxSize(&p_max_size))
        success = false;
      if (success)
        p_use_fixed_aspect_ratio = input_data_view.use_fixed_aspect_ratio();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkVideoCapturer::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetResolutionConstraints(
std::move(p_min_size), 
std::move(p_max_size), 
std::move(p_use_fixed_aspect_ratio));
      return true;
    }
    case internal::kFrameSinkVideoCapturer_SetAutoThrottlingEnabled_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::FrameSinkVideoCapturer::SetAutoThrottlingEnabled",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::FrameSinkVideoCapturer::SetAutoThrottlingEnabled");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameSinkVideoCapturer_SetAutoThrottlingEnabled_Params_Data* params =
          reinterpret_cast<internal::FrameSinkVideoCapturer_SetAutoThrottlingEnabled_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_enabled{};
      FrameSinkVideoCapturer_SetAutoThrottlingEnabled_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_enabled = input_data_view.enabled();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkVideoCapturer::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetAutoThrottlingEnabled(
std::move(p_enabled));
      return true;
    }
    case internal::kFrameSinkVideoCapturer_ChangeTarget_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::FrameSinkVideoCapturer::ChangeTarget",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::FrameSinkVideoCapturer::ChangeTarget");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameSinkVideoCapturer_ChangeTarget_Params_Data* params =
          reinterpret_cast<internal::FrameSinkVideoCapturer_ChangeTarget_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      base::Optional<::viz::FrameSinkId> p_frame_sink_id{};
      ::viz::SubtreeCaptureId p_subtree_capture_id{};
      FrameSinkVideoCapturer_ChangeTarget_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFrameSinkId(&p_frame_sink_id))
        success = false;
      if (success && !input_data_view.ReadSubtreeCaptureId(&p_subtree_capture_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkVideoCapturer::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ChangeTarget(
std::move(p_frame_sink_id), 
std::move(p_subtree_capture_id));
      return true;
    }
    case internal::kFrameSinkVideoCapturer_Start_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::FrameSinkVideoCapturer::Start",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::FrameSinkVideoCapturer::Start");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameSinkVideoCapturer_Start_Params_Data* params =
          reinterpret_cast<internal::FrameSinkVideoCapturer_Start_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<FrameSinkVideoConsumer> p_consumer{};
      FrameSinkVideoCapturer_Start_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_consumer =
            input_data_view.TakeConsumer<decltype(p_consumer)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkVideoCapturer::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Start(
std::move(p_consumer));
      return true;
    }
    case internal::kFrameSinkVideoCapturer_Stop_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::FrameSinkVideoCapturer::Stop",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::FrameSinkVideoCapturer::Stop");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameSinkVideoCapturer_Stop_Params_Data* params =
          reinterpret_cast<internal::FrameSinkVideoCapturer_Stop_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      FrameSinkVideoCapturer_Stop_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkVideoCapturer::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Stop();
      return true;
    }
    case internal::kFrameSinkVideoCapturer_RequestRefreshFrame_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::FrameSinkVideoCapturer::RequestRefreshFrame",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::FrameSinkVideoCapturer::RequestRefreshFrame");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameSinkVideoCapturer_RequestRefreshFrame_Params_Data* params =
          reinterpret_cast<internal::FrameSinkVideoCapturer_RequestRefreshFrame_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      FrameSinkVideoCapturer_RequestRefreshFrame_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkVideoCapturer::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestRefreshFrame();
      return true;
    }
    case internal::kFrameSinkVideoCapturer_CreateOverlay_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::FrameSinkVideoCapturer::CreateOverlay",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::FrameSinkVideoCapturer::CreateOverlay");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameSinkVideoCapturer_CreateOverlay_Params_Data* params =
          reinterpret_cast<internal::FrameSinkVideoCapturer_CreateOverlay_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_stacking_index{};
      ::mojo::PendingReceiver<FrameSinkVideoCaptureOverlay> p_receiver{};
      FrameSinkVideoCapturer_CreateOverlay_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_stacking_index = input_data_view.stacking_index();
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkVideoCapturer::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateOverlay(
std::move(p_stacking_index), 
std::move(p_receiver));
      return true;
    }
  }
  return false;
}

// static
bool FrameSinkVideoCapturerStubDispatch::AcceptWithResponder(
    FrameSinkVideoCapturer* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kFrameSinkVideoCapturer_SetFormat_Name: {
      break;
    }
    case internal::kFrameSinkVideoCapturer_SetMinCapturePeriod_Name: {
      break;
    }
    case internal::kFrameSinkVideoCapturer_SetMinSizeChangePeriod_Name: {
      break;
    }
    case internal::kFrameSinkVideoCapturer_SetResolutionConstraints_Name: {
      break;
    }
    case internal::kFrameSinkVideoCapturer_SetAutoThrottlingEnabled_Name: {
      break;
    }
    case internal::kFrameSinkVideoCapturer_ChangeTarget_Name: {
      break;
    }
    case internal::kFrameSinkVideoCapturer_Start_Name: {
      break;
    }
    case internal::kFrameSinkVideoCapturer_Stop_Name: {
      break;
    }
    case internal::kFrameSinkVideoCapturer_RequestRefreshFrame_Name: {
      break;
    }
    case internal::kFrameSinkVideoCapturer_CreateOverlay_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kFrameSinkVideoCapturerValidationInfo[] = {
    {internal::kFrameSinkVideoCapturer_SetFormat_Name,
     {&internal::FrameSinkVideoCapturer_SetFormat_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kFrameSinkVideoCapturer_SetMinCapturePeriod_Name,
     {&internal::FrameSinkVideoCapturer_SetMinCapturePeriod_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kFrameSinkVideoCapturer_SetMinSizeChangePeriod_Name,
     {&internal::FrameSinkVideoCapturer_SetMinSizeChangePeriod_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kFrameSinkVideoCapturer_SetResolutionConstraints_Name,
     {&internal::FrameSinkVideoCapturer_SetResolutionConstraints_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kFrameSinkVideoCapturer_SetAutoThrottlingEnabled_Name,
     {&internal::FrameSinkVideoCapturer_SetAutoThrottlingEnabled_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kFrameSinkVideoCapturer_ChangeTarget_Name,
     {&internal::FrameSinkVideoCapturer_ChangeTarget_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kFrameSinkVideoCapturer_Start_Name,
     {&internal::FrameSinkVideoCapturer_Start_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kFrameSinkVideoCapturer_Stop_Name,
     {&internal::FrameSinkVideoCapturer_Stop_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kFrameSinkVideoCapturer_RequestRefreshFrame_Name,
     {&internal::FrameSinkVideoCapturer_RequestRefreshFrame_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kFrameSinkVideoCapturer_CreateOverlay_Name,
     {&internal::FrameSinkVideoCapturer_CreateOverlay_Params_Data::Validate,
      nullptr /* no response */}},
};

bool FrameSinkVideoCapturerRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::viz::mojom::FrameSinkVideoCapturer::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kFrameSinkVideoCapturerValidationInfo);
}

const char FrameSinkVideoCaptureOverlay::Name_[] = "viz.mojom.FrameSinkVideoCaptureOverlay";

FrameSinkVideoCaptureOverlayProxy::FrameSinkVideoCaptureOverlayProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void FrameSinkVideoCaptureOverlayProxy::SetImageAndBounds(
    const ::SkBitmap& in_image, const ::gfx::RectF& in_bounds) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::FrameSinkVideoCaptureOverlay::SetImageAndBounds", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("image"), in_image, 
                        "<value of type const ::SkBitmap&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bounds"), in_bounds, 
                        "<value of type const ::gfx::RectF&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameSinkVideoCaptureOverlay_SetImageAndBounds_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinkVideoCaptureOverlay_SetImageAndBounds_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->image)::BaseType> image_fragment(
          params.message());
  mojo::internal::Serialize<::skia::mojom::BitmapN32DataView>(
      in_image, image_fragment);
  params->image.Set(
      image_fragment.is_null() ? nullptr : image_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->image.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null image in FrameSinkVideoCaptureOverlay.SetImageAndBounds request");
  mojo::internal::MessageFragment<
      typename decltype(params->bounds)::BaseType> bounds_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::RectFDataView>(
      in_bounds, bounds_fragment);
  params->bounds.Set(
      bounds_fragment.is_null() ? nullptr : bounds_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->bounds.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null bounds in FrameSinkVideoCaptureOverlay.SetImageAndBounds request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkVideoCaptureOverlay::Name_);
  message.set_method_name("SetImageAndBounds");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameSinkVideoCaptureOverlayProxy::SetBounds(
    const ::gfx::RectF& in_bounds) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::FrameSinkVideoCaptureOverlay::SetBounds", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bounds"), in_bounds, 
                        "<value of type const ::gfx::RectF&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameSinkVideoCaptureOverlay_SetBounds_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinkVideoCaptureOverlay_SetBounds_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->bounds)::BaseType> bounds_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::RectFDataView>(
      in_bounds, bounds_fragment);
  params->bounds.Set(
      bounds_fragment.is_null() ? nullptr : bounds_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->bounds.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null bounds in FrameSinkVideoCaptureOverlay.SetBounds request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkVideoCaptureOverlay::Name_);
  message.set_method_name("SetBounds");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool FrameSinkVideoCaptureOverlayStubDispatch::Accept(
    FrameSinkVideoCaptureOverlay* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kFrameSinkVideoCaptureOverlay_SetImageAndBounds_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::FrameSinkVideoCaptureOverlay::SetImageAndBounds",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::FrameSinkVideoCaptureOverlay::SetImageAndBounds");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameSinkVideoCaptureOverlay_SetImageAndBounds_Params_Data* params =
          reinterpret_cast<internal::FrameSinkVideoCaptureOverlay_SetImageAndBounds_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::SkBitmap p_image{};
      ::gfx::RectF p_bounds{};
      FrameSinkVideoCaptureOverlay_SetImageAndBounds_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadImage(&p_image))
        success = false;
      if (success && !input_data_view.ReadBounds(&p_bounds))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkVideoCaptureOverlay::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetImageAndBounds(
std::move(p_image), 
std::move(p_bounds));
      return true;
    }
    case internal::kFrameSinkVideoCaptureOverlay_SetBounds_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::FrameSinkVideoCaptureOverlay::SetBounds",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::FrameSinkVideoCaptureOverlay::SetBounds");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameSinkVideoCaptureOverlay_SetBounds_Params_Data* params =
          reinterpret_cast<internal::FrameSinkVideoCaptureOverlay_SetBounds_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::gfx::RectF p_bounds{};
      FrameSinkVideoCaptureOverlay_SetBounds_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBounds(&p_bounds))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkVideoCaptureOverlay::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetBounds(
std::move(p_bounds));
      return true;
    }
  }
  return false;
}

// static
bool FrameSinkVideoCaptureOverlayStubDispatch::AcceptWithResponder(
    FrameSinkVideoCaptureOverlay* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kFrameSinkVideoCaptureOverlay_SetImageAndBounds_Name: {
      break;
    }
    case internal::kFrameSinkVideoCaptureOverlay_SetBounds_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kFrameSinkVideoCaptureOverlayValidationInfo[] = {
    {internal::kFrameSinkVideoCaptureOverlay_SetImageAndBounds_Name,
     {&internal::FrameSinkVideoCaptureOverlay_SetImageAndBounds_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kFrameSinkVideoCaptureOverlay_SetBounds_Name,
     {&internal::FrameSinkVideoCaptureOverlay_SetBounds_Params_Data::Validate,
      nullptr /* no response */}},
};

bool FrameSinkVideoCaptureOverlayRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::viz::mojom::FrameSinkVideoCaptureOverlay::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kFrameSinkVideoCaptureOverlayValidationInfo);
}

}  // namespace mojom
}  // namespace viz

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif