// services/viz/privileged/mojom/compositing/layered_window_updater.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/viz/privileged/mojom/compositing/layered_window_updater.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "services/viz/privileged/mojom/compositing/layered_window_updater.mojom-params-data.h"
#include "services/viz/privileged/mojom/compositing/layered_window_updater.mojom-shared-message-ids.h"

#include "services/viz/privileged/mojom/compositing/layered_window_updater.mojom-import-headers.h"


#ifndef SERVICES_VIZ_PRIVILEGED_MOJOM_COMPOSITING_LAYERED_WINDOW_UPDATER_MOJOM_JUMBO_H_
#define SERVICES_VIZ_PRIVILEGED_MOJOM_COMPOSITING_LAYERED_WINDOW_UPDATER_MOJOM_JUMBO_H_
#endif
namespace viz {
namespace mojom {
const char LayeredWindowUpdater::Name_[] = "viz.mojom.LayeredWindowUpdater";

class LayeredWindowUpdater_Draw_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  LayeredWindowUpdater_Draw_ForwardToCallback(
      LayeredWindowUpdater::DrawCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  LayeredWindowUpdater::DrawCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(LayeredWindowUpdater_Draw_ForwardToCallback);
};

LayeredWindowUpdaterProxy::LayeredWindowUpdaterProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void LayeredWindowUpdaterProxy::OnAllocatedSharedMemory(
    const ::gfx::Size& in_pixel_size, ::base::UnsafeSharedMemoryRegion in_region) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::LayeredWindowUpdater::OnAllocatedSharedMemory", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pixel_size"), in_pixel_size, 
                        "<value of type const ::gfx::Size&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("region"), in_region, 
                        "<value of type ::base::UnsafeSharedMemoryRegion>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLayeredWindowUpdater_OnAllocatedSharedMemory_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::LayeredWindowUpdater_OnAllocatedSharedMemory_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->pixel_size)::BaseType> pixel_size_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
      in_pixel_size, pixel_size_fragment);
  params->pixel_size.Set(
      pixel_size_fragment.is_null() ? nullptr : pixel_size_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->pixel_size.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null pixel_size in LayeredWindowUpdater.OnAllocatedSharedMemory request");
  mojo::internal::MessageFragment<
      typename decltype(params->region)::BaseType> region_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::UnsafeSharedMemoryRegionDataView>(
      in_region, region_fragment);
  params->region.Set(
      region_fragment.is_null() ? nullptr : region_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->region.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null region in LayeredWindowUpdater.OnAllocatedSharedMemory request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LayeredWindowUpdater::Name_);
  message.set_method_name("OnAllocatedSharedMemory");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LayeredWindowUpdaterProxy::Draw(
    DrawCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "viz::mojom::LayeredWindowUpdater::Draw");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLayeredWindowUpdater_Draw_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::LayeredWindowUpdater_Draw_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LayeredWindowUpdater::Name_);
  message.set_method_name("Draw");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LayeredWindowUpdater_Draw_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class LayeredWindowUpdater_Draw_ProxyToResponder {
 public:
  static LayeredWindowUpdater::DrawCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<LayeredWindowUpdater_Draw_ProxyToResponder> proxy(
        new LayeredWindowUpdater_Draw_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&LayeredWindowUpdater_Draw_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~LayeredWindowUpdater_Draw_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  LayeredWindowUpdater_Draw_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "LayeredWindowUpdater::DrawCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(LayeredWindowUpdater_Draw_ProxyToResponder);
};

bool LayeredWindowUpdater_Draw_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "viz::mojom::LayeredWindowUpdater::DrawCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::LayeredWindowUpdater_Draw_ResponseParams_Data* params =
      reinterpret_cast<
          internal::LayeredWindowUpdater_Draw_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  LayeredWindowUpdater_Draw_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LayeredWindowUpdater::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void LayeredWindowUpdater_Draw_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)viz::mojom::LayeredWindowUpdater::DrawCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLayeredWindowUpdater_Draw_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::LayeredWindowUpdater_Draw_ResponseParams_Data> params(
          message);
  params.Allocate();

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)viz::mojom::LayeredWindowUpdater::DrawCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LayeredWindowUpdater::Name_);
  message.set_method_name("Draw");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool LayeredWindowUpdaterStubDispatch::Accept(
    LayeredWindowUpdater* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kLayeredWindowUpdater_OnAllocatedSharedMemory_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::LayeredWindowUpdater::OnAllocatedSharedMemory",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::LayeredWindowUpdater::OnAllocatedSharedMemory");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LayeredWindowUpdater_OnAllocatedSharedMemory_Params_Data* params =
          reinterpret_cast<internal::LayeredWindowUpdater_OnAllocatedSharedMemory_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::gfx::Size p_pixel_size{};
      ::base::UnsafeSharedMemoryRegion p_region{};
      LayeredWindowUpdater_OnAllocatedSharedMemory_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPixelSize(&p_pixel_size))
        success = false;
      if (success && !input_data_view.ReadRegion(&p_region))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LayeredWindowUpdater::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnAllocatedSharedMemory(
std::move(p_pixel_size), 
std::move(p_region));
      return true;
    }
    case internal::kLayeredWindowUpdater_Draw_Name: {
      break;
    }
  }
  return false;
}

// static
bool LayeredWindowUpdaterStubDispatch::AcceptWithResponder(
    LayeredWindowUpdater* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kLayeredWindowUpdater_OnAllocatedSharedMemory_Name: {
      break;
    }
    case internal::kLayeredWindowUpdater_Draw_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::LayeredWindowUpdater::Draw",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::LayeredWindowUpdater::Draw");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::LayeredWindowUpdater_Draw_Params_Data* params =
          reinterpret_cast<
              internal::LayeredWindowUpdater_Draw_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      LayeredWindowUpdater_Draw_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LayeredWindowUpdater::Name_, 1, false);
        return false;
      }
      LayeredWindowUpdater::DrawCallback callback =
          LayeredWindowUpdater_Draw_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Draw(std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kLayeredWindowUpdaterValidationInfo[] = {
    {internal::kLayeredWindowUpdater_OnAllocatedSharedMemory_Name,
     {&internal::LayeredWindowUpdater_OnAllocatedSharedMemory_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLayeredWindowUpdater_Draw_Name,
     {&internal::LayeredWindowUpdater_Draw_Params_Data::Validate,
      &internal::LayeredWindowUpdater_Draw_ResponseParams_Data::Validate}},
};

bool LayeredWindowUpdaterRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::viz::mojom::LayeredWindowUpdater::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kLayeredWindowUpdaterValidationInfo);
}

bool LayeredWindowUpdaterResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::viz::mojom::LayeredWindowUpdater::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kLayeredWindowUpdaterValidationInfo);

}
}  // namespace mojom
}  // namespace viz

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif