// services/viz/privileged/mojom/compositing/renderer_settings.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/viz/privileged/mojom/compositing/renderer_settings.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "services/viz/privileged/mojom/compositing/renderer_settings.mojom-params-data.h"
#include "services/viz/privileged/mojom/compositing/renderer_settings.mojom-shared-message-ids.h"

#include "services/viz/privileged/mojom/compositing/renderer_settings.mojom-import-headers.h"


#ifndef SERVICES_VIZ_PRIVILEGED_MOJOM_COMPOSITING_RENDERER_SETTINGS_MOJOM_JUMBO_H_
#define SERVICES_VIZ_PRIVILEGED_MOJOM_COMPOSITING_RENDERER_SETTINGS_MOJOM_JUMBO_H_
#endif
namespace viz {
namespace mojom {
RendererSettings::RendererSettings()
    : allow_antialiasing(),
      force_antialiasing(),
      force_blending_with_shaders(),
      highp_threshold_min(),
      partial_swap_enabled(),
      release_overlay_resources_after_gpu_query(),
      should_clear_root_render_pass(),
      slow_down_compositing_scale_factor(),
      use_skia_renderer(),
      allow_overlays(),
      auto_resize_output_surface(),
      requires_alpha_channel(),
      overlay_strategies() {}

RendererSettings::RendererSettings(
    bool allow_antialiasing_in,
    bool force_antialiasing_in,
    bool force_blending_with_shaders_in,
    int32_t highp_threshold_min_in,
    bool partial_swap_enabled_in,
    bool release_overlay_resources_after_gpu_query_in,
    bool should_clear_root_render_pass_in,
    int32_t slow_down_compositing_scale_factor_in,
    bool use_skia_renderer_in,
    bool allow_overlays_in,
    bool auto_resize_output_surface_in,
    bool requires_alpha_channel_in,
    std::vector<::viz::mojom::OverlayStrategy> overlay_strategies_in)
    : allow_antialiasing(std::move(allow_antialiasing_in)),
      force_antialiasing(std::move(force_antialiasing_in)),
      force_blending_with_shaders(std::move(force_blending_with_shaders_in)),
      highp_threshold_min(std::move(highp_threshold_min_in)),
      partial_swap_enabled(std::move(partial_swap_enabled_in)),
      release_overlay_resources_after_gpu_query(std::move(release_overlay_resources_after_gpu_query_in)),
      should_clear_root_render_pass(std::move(should_clear_root_render_pass_in)),
      slow_down_compositing_scale_factor(std::move(slow_down_compositing_scale_factor_in)),
      use_skia_renderer(std::move(use_skia_renderer_in)),
      allow_overlays(std::move(allow_overlays_in)),
      auto_resize_output_surface(std::move(auto_resize_output_surface_in)),
      requires_alpha_channel(std::move(requires_alpha_channel_in)),
      overlay_strategies(std::move(overlay_strategies_in)) {}

RendererSettings::~RendererSettings() = default;

void RendererSettings::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "allow_antialiasing"), this->allow_antialiasing, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "force_antialiasing"), this->force_antialiasing, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "force_blending_with_shaders"), this->force_blending_with_shaders, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "highp_threshold_min"), this->highp_threshold_min, 
      "<value of type int32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "partial_swap_enabled"), this->partial_swap_enabled, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "release_overlay_resources_after_gpu_query"), this->release_overlay_resources_after_gpu_query, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "should_clear_root_render_pass"), this->should_clear_root_render_pass, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "slow_down_compositing_scale_factor"), this->slow_down_compositing_scale_factor, 
      "<value of type int32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "use_skia_renderer"), this->use_skia_renderer, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "allow_overlays"), this->allow_overlays, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "auto_resize_output_surface"), this->auto_resize_output_surface, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "requires_alpha_channel"), this->requires_alpha_channel, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "overlay_strategies"), this->overlay_strategies, 
      "<value of type const std::vector<::viz::mojom::OverlayStrategy>&>");
}

bool RendererSettings::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DebugRendererSettings::DebugRendererSettings()
    : tint_composited_content(),
      show_overdraw_feedback(),
      show_dc_layer_debug_borders(),
      show_aggregated_damage() {}

DebugRendererSettings::DebugRendererSettings(
    bool tint_composited_content_in,
    bool show_overdraw_feedback_in,
    bool show_dc_layer_debug_borders_in,
    bool show_aggregated_damage_in)
    : tint_composited_content(std::move(tint_composited_content_in)),
      show_overdraw_feedback(std::move(show_overdraw_feedback_in)),
      show_dc_layer_debug_borders(std::move(show_dc_layer_debug_borders_in)),
      show_aggregated_damage(std::move(show_aggregated_damage_in)) {}

DebugRendererSettings::~DebugRendererSettings() = default;

void DebugRendererSettings::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tint_composited_content"), this->tint_composited_content, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "show_overdraw_feedback"), this->show_overdraw_feedback, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "show_dc_layer_debug_borders"), this->show_dc_layer_debug_borders, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "show_aggregated_damage"), this->show_aggregated_damage, 
      "<value of type bool>");
}

bool DebugRendererSettings::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
}  // namespace mojom
}  // namespace viz

namespace mojo {


// static
bool StructTraits<::viz::mojom::RendererSettings::DataView, ::viz::mojom::RendererSettingsPtr>::Read(
    ::viz::mojom::RendererSettings::DataView input,
    ::viz::mojom::RendererSettingsPtr* output) {
  bool success = true;
  ::viz::mojom::RendererSettingsPtr result(::viz::mojom::RendererSettings::New());
  
      if (success)
        result->allow_antialiasing = input.allow_antialiasing();
      if (success)
        result->force_antialiasing = input.force_antialiasing();
      if (success)
        result->force_blending_with_shaders = input.force_blending_with_shaders();
      if (success)
        result->highp_threshold_min = input.highp_threshold_min();
      if (success)
        result->partial_swap_enabled = input.partial_swap_enabled();
      if (success)
        result->release_overlay_resources_after_gpu_query = input.release_overlay_resources_after_gpu_query();
      if (success)
        result->should_clear_root_render_pass = input.should_clear_root_render_pass();
      if (success)
        result->slow_down_compositing_scale_factor = input.slow_down_compositing_scale_factor();
      if (success)
        result->use_skia_renderer = input.use_skia_renderer();
      if (success)
        result->allow_overlays = input.allow_overlays();
      if (success)
        result->auto_resize_output_surface = input.auto_resize_output_surface();
      if (success)
        result->requires_alpha_channel = input.requires_alpha_channel();
      if (success && !input.ReadOverlayStrategies(&result->overlay_strategies))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::viz::mojom::DebugRendererSettings::DataView, ::viz::mojom::DebugRendererSettingsPtr>::Read(
    ::viz::mojom::DebugRendererSettings::DataView input,
    ::viz::mojom::DebugRendererSettingsPtr* output) {
  bool success = true;
  ::viz::mojom::DebugRendererSettingsPtr result(::viz::mojom::DebugRendererSettings::New());
  
      if (success)
        result->tint_composited_content = input.tint_composited_content();
      if (success)
        result->show_overdraw_feedback = input.show_overdraw_feedback();
      if (success)
        result->show_dc_layer_debug_borders = input.show_dc_layer_debug_borders();
      if (success)
        result->show_aggregated_damage = input.show_aggregated_damage();
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif