// services/viz/privileged/mojom/compositing/vsync_parameter_observer.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/viz/privileged/mojom/compositing/vsync_parameter_observer.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "services/viz/privileged/mojom/compositing/vsync_parameter_observer.mojom-params-data.h"
#include "services/viz/privileged/mojom/compositing/vsync_parameter_observer.mojom-shared-message-ids.h"

#include "services/viz/privileged/mojom/compositing/vsync_parameter_observer.mojom-import-headers.h"


#ifndef SERVICES_VIZ_PRIVILEGED_MOJOM_COMPOSITING_VSYNC_PARAMETER_OBSERVER_MOJOM_JUMBO_H_
#define SERVICES_VIZ_PRIVILEGED_MOJOM_COMPOSITING_VSYNC_PARAMETER_OBSERVER_MOJOM_JUMBO_H_
#endif
namespace viz {
namespace mojom {
const char VSyncParameterObserver::Name_[] = "viz.mojom.VSyncParameterObserver";

VSyncParameterObserverProxy::VSyncParameterObserverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void VSyncParameterObserverProxy::OnUpdateVSyncParameters(
    ::base::TimeTicks in_timebase, ::base::TimeDelta in_interval) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::VSyncParameterObserver::OnUpdateVSyncParameters", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("timebase"), in_timebase, 
                        "<value of type ::base::TimeTicks>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("interval"), in_interval, 
                        "<value of type ::base::TimeDelta>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kVSyncParameterObserver_OnUpdateVSyncParameters_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::VSyncParameterObserver_OnUpdateVSyncParameters_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->timebase)::BaseType> timebase_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
      in_timebase, timebase_fragment);
  params->timebase.Set(
      timebase_fragment.is_null() ? nullptr : timebase_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->timebase.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null timebase in VSyncParameterObserver.OnUpdateVSyncParameters request");
  mojo::internal::MessageFragment<
      typename decltype(params->interval)::BaseType> interval_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_interval, interval_fragment);
  params->interval.Set(
      interval_fragment.is_null() ? nullptr : interval_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->interval.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null interval in VSyncParameterObserver.OnUpdateVSyncParameters request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VSyncParameterObserver::Name_);
  message.set_method_name("OnUpdateVSyncParameters");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool VSyncParameterObserverStubDispatch::Accept(
    VSyncParameterObserver* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kVSyncParameterObserver_OnUpdateVSyncParameters_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::VSyncParameterObserver::OnUpdateVSyncParameters",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::VSyncParameterObserver::OnUpdateVSyncParameters");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::VSyncParameterObserver_OnUpdateVSyncParameters_Params_Data* params =
          reinterpret_cast<internal::VSyncParameterObserver_OnUpdateVSyncParameters_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::base::TimeTicks p_timebase{};
      ::base::TimeDelta p_interval{};
      VSyncParameterObserver_OnUpdateVSyncParameters_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTimebase(&p_timebase))
        success = false;
      if (success && !input_data_view.ReadInterval(&p_interval))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VSyncParameterObserver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnUpdateVSyncParameters(
std::move(p_timebase), 
std::move(p_interval));
      return true;
    }
  }
  return false;
}

// static
bool VSyncParameterObserverStubDispatch::AcceptWithResponder(
    VSyncParameterObserver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kVSyncParameterObserver_OnUpdateVSyncParameters_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kVSyncParameterObserverValidationInfo[] = {
    {internal::kVSyncParameterObserver_OnUpdateVSyncParameters_Name,
     {&internal::VSyncParameterObserver_OnUpdateVSyncParameters_Params_Data::Validate,
      nullptr /* no response */}},
};

bool VSyncParameterObserverRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::viz::mojom::VSyncParameterObserver::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kVSyncParameterObserverValidationInfo);
}

}  // namespace mojom
}  // namespace viz

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif