// services/viz/privileged/mojom/gl/context_lost_reason.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/viz/privileged/mojom/gl/context_lost_reason.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/viz/privileged/mojom/gl/context_lost_reason.mojom-params-data.h"
namespace viz {
namespace mojom {

std::string ContextLostReasonToString(ContextLostReason value) {
  switch(value) {
    case ContextLostReason::GUILTY:
      return "ContextLostReason::GUILTY";
    case ContextLostReason::INNOCENT:
      return "ContextLostReason::INNOCENT";
    case ContextLostReason::UNKNOWN:
      return "ContextLostReason::UNKNOWN";
    case ContextLostReason::OUT_OF_MEMORY:
      return "ContextLostReason::OUT_OF_MEMORY";
    case ContextLostReason::MAKE_CURRENT_FAILED:
      return "ContextLostReason::MAKE_CURRENT_FAILED";
    case ContextLostReason::GPU_CHANNEL_LOST:
      return "ContextLostReason::GPU_CHANNEL_LOST";
    case ContextLostReason::INVALID_GPU_MESSAGE:
      return "ContextLostReason::INVALID_GPU_MESSAGE";
    default:
      return base::StringPrintf("Unknown ContextLostReason value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, ContextLostReason value) {
  return os << ContextLostReasonToString(value);
}

namespace internal {

}  // namespace internal
}  // namespace mojom
}  // namespace viz

namespace perfetto {

// static
void TraceFormatTraits<::viz::mojom::ContextLostReason>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::viz::mojom::ContextLostReason value) {
  return std::move(context).WriteString(::viz::mojom::ContextLostReasonToString(value));
}

} // namespace perfetto
