// services/viz/privileged/mojom/gl/gpu_host.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/viz/privileged/mojom/gl/gpu_host.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "services/viz/privileged/mojom/gl/gpu_host.mojom-params-data.h"
#include "services/viz/privileged/mojom/gl/gpu_host.mojom-shared-message-ids.h"

#include "services/viz/privileged/mojom/gl/gpu_host.mojom-import-headers.h"


#ifndef SERVICES_VIZ_PRIVILEGED_MOJOM_GL_GPU_HOST_MOJOM_JUMBO_H_
#define SERVICES_VIZ_PRIVILEGED_MOJOM_GL_GPU_HOST_MOJOM_JUMBO_H_
#endif
namespace viz {
namespace mojom {
const char GpuHost::Name_[] = "viz.mojom.GpuHost";

GpuHostProxy::GpuHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void GpuHostProxy::DidInitialize(
    const ::gpu::GPUInfo& in_gpu_info, const ::gpu::GpuFeatureInfo& in_gpu_feature_info, const base::Optional<::gpu::GPUInfo>& in_gpu_info_for_hardware_gpu, const base::Optional<::gpu::GpuFeatureInfo>& in_gpu_feature_info_for_hardware_gpu, const ::gfx::GpuExtraInfo& in_gpu_extra_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::GpuHost::DidInitialize", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("gpu_info"), in_gpu_info, 
                        "<value of type const ::gpu::GPUInfo&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("gpu_feature_info"), in_gpu_feature_info, 
                        "<value of type const ::gpu::GpuFeatureInfo&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("gpu_info_for_hardware_gpu"), in_gpu_info_for_hardware_gpu, 
                        "<value of type const base::Optional<::gpu::GPUInfo>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("gpu_feature_info_for_hardware_gpu"), in_gpu_feature_info_for_hardware_gpu, 
                        "<value of type const base::Optional<::gpu::GpuFeatureInfo>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("gpu_extra_info"), in_gpu_extra_info, 
                        "<value of type const ::gfx::GpuExtraInfo&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kGpuHost_DidInitialize_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuHost_DidInitialize_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->gpu_info)::BaseType> gpu_info_fragment(
          params.message());
  mojo::internal::Serialize<::gpu::mojom::GpuInfoDataView>(
      in_gpu_info, gpu_info_fragment);
  params->gpu_info.Set(
      gpu_info_fragment.is_null() ? nullptr : gpu_info_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->gpu_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null gpu_info in GpuHost.DidInitialize request");
  mojo::internal::MessageFragment<
      typename decltype(params->gpu_feature_info)::BaseType> gpu_feature_info_fragment(
          params.message());
  mojo::internal::Serialize<::gpu::mojom::GpuFeatureInfoDataView>(
      in_gpu_feature_info, gpu_feature_info_fragment);
  params->gpu_feature_info.Set(
      gpu_feature_info_fragment.is_null() ? nullptr : gpu_feature_info_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->gpu_feature_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null gpu_feature_info in GpuHost.DidInitialize request");
  mojo::internal::MessageFragment<
      typename decltype(params->gpu_info_for_hardware_gpu)::BaseType> gpu_info_for_hardware_gpu_fragment(
          params.message());
  mojo::internal::Serialize<::gpu::mojom::GpuInfoDataView>(
      in_gpu_info_for_hardware_gpu, gpu_info_for_hardware_gpu_fragment);
  params->gpu_info_for_hardware_gpu.Set(
      gpu_info_for_hardware_gpu_fragment.is_null() ? nullptr : gpu_info_for_hardware_gpu_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->gpu_feature_info_for_hardware_gpu)::BaseType> gpu_feature_info_for_hardware_gpu_fragment(
          params.message());
  mojo::internal::Serialize<::gpu::mojom::GpuFeatureInfoDataView>(
      in_gpu_feature_info_for_hardware_gpu, gpu_feature_info_for_hardware_gpu_fragment);
  params->gpu_feature_info_for_hardware_gpu.Set(
      gpu_feature_info_for_hardware_gpu_fragment.is_null() ? nullptr : gpu_feature_info_for_hardware_gpu_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->gpu_extra_info)::BaseType> gpu_extra_info_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::GpuExtraInfoDataView>(
      in_gpu_extra_info, gpu_extra_info_fragment);
  params->gpu_extra_info.Set(
      gpu_extra_info_fragment.is_null() ? nullptr : gpu_extra_info_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->gpu_extra_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null gpu_extra_info in GpuHost.DidInitialize request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuHost::Name_);
  message.set_method_name("DidInitialize");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void GpuHostProxy::DidFailInitialize(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "viz::mojom::GpuHost::DidFailInitialize");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kGpuHost_DidFailInitialize_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuHost_DidFailInitialize_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuHost::Name_);
  message.set_method_name("DidFailInitialize");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void GpuHostProxy::DidCreateContextSuccessfully(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "viz::mojom::GpuHost::DidCreateContextSuccessfully");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kGpuHost_DidCreateContextSuccessfully_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuHost_DidCreateContextSuccessfully_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuHost::Name_);
  message.set_method_name("DidCreateContextSuccessfully");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void GpuHostProxy::DidCreateOffscreenContext(
    const ::GURL& in_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::GpuHost::DidCreateOffscreenContext", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url, 
                        "<value of type const ::GURL&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kGpuHost_DidCreateOffscreenContext_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuHost_DidCreateOffscreenContext_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, url_fragment);
  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in GpuHost.DidCreateOffscreenContext request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuHost::Name_);
  message.set_method_name("DidCreateOffscreenContext");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void GpuHostProxy::DidDestroyOffscreenContext(
    const ::GURL& in_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::GpuHost::DidDestroyOffscreenContext", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url, 
                        "<value of type const ::GURL&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kGpuHost_DidDestroyOffscreenContext_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuHost_DidDestroyOffscreenContext_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, url_fragment);
  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in GpuHost.DidDestroyOffscreenContext request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuHost::Name_);
  message.set_method_name("DidDestroyOffscreenContext");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void GpuHostProxy::DidDestroyChannel(
    int32_t in_client_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::GpuHost::DidDestroyChannel", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client_id"), in_client_id, 
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kGpuHost_DidDestroyChannel_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuHost_DidDestroyChannel_Params_Data> params(
          message);
  params.Allocate();
  params->client_id = in_client_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuHost::Name_);
  message.set_method_name("DidDestroyChannel");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void GpuHostProxy::DidDestroyAllChannels(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "viz::mojom::GpuHost::DidDestroyAllChannels");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kGpuHost_DidDestroyAllChannels_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuHost_DidDestroyAllChannels_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuHost::Name_);
  message.set_method_name("DidDestroyAllChannels");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void GpuHostProxy::DidLoseContext(
    bool in_offscreen, ::gpu::error::ContextLostReason in_reason, const ::GURL& in_active_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::GpuHost::DidLoseContext", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("offscreen"), in_offscreen, 
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reason"), in_reason, 
                        "<value of type ::gpu::error::ContextLostReason>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("active_url"), in_active_url, 
                        "<value of type const ::GURL&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kGpuHost_DidLoseContext_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuHost_DidLoseContext_Params_Data> params(
          message);
  params.Allocate();
  params->offscreen = in_offscreen;
  mojo::internal::Serialize<::viz::mojom::ContextLostReason>(
      in_reason, &params->reason);
  mojo::internal::MessageFragment<
      typename decltype(params->active_url)::BaseType> active_url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_active_url, active_url_fragment);
  params->active_url.Set(
      active_url_fragment.is_null() ? nullptr : active_url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->active_url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null active_url in GpuHost.DidLoseContext request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuHost::Name_);
  message.set_method_name("DidLoseContext");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void GpuHostProxy::DidUpdateGPUInfo(
    const ::gpu::GPUInfo& in_gpu_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::GpuHost::DidUpdateGPUInfo", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("gpu_info"), in_gpu_info, 
                        "<value of type const ::gpu::GPUInfo&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kGpuHost_DidUpdateGPUInfo_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuHost_DidUpdateGPUInfo_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->gpu_info)::BaseType> gpu_info_fragment(
          params.message());
  mojo::internal::Serialize<::gpu::mojom::GpuInfoDataView>(
      in_gpu_info, gpu_info_fragment);
  params->gpu_info.Set(
      gpu_info_fragment.is_null() ? nullptr : gpu_info_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->gpu_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null gpu_info in GpuHost.DidUpdateGPUInfo request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuHost::Name_);
  message.set_method_name("DidUpdateGPUInfo");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void GpuHostProxy::DisableGpuCompositing(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "viz::mojom::GpuHost::DisableGpuCompositing");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kGpuHost_DisableGpuCompositing_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuHost_DisableGpuCompositing_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuHost::Name_);
  message.set_method_name("DisableGpuCompositing");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void GpuHostProxy::StoreShaderToDisk(
    int32_t in_client_id, const std::string& in_key, const std::string& in_shader) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::GpuHost::StoreShaderToDisk", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client_id"), in_client_id, 
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("key"), in_key, 
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("shader"), in_shader, 
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kGpuHost_StoreShaderToDisk_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuHost_StoreShaderToDisk_Params_Data> params(
          message);
  params.Allocate();
  params->client_id = in_client_id;
  mojo::internal::MessageFragment<
      typename decltype(params->key)::BaseType> key_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_key, key_fragment);
  params->key.Set(
      key_fragment.is_null() ? nullptr : key_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->key.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null key in GpuHost.StoreShaderToDisk request");
  mojo::internal::MessageFragment<
      typename decltype(params->shader)::BaseType> shader_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_shader, shader_fragment);
  params->shader.Set(
      shader_fragment.is_null() ? nullptr : shader_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->shader.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null shader in GpuHost.StoreShaderToDisk request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuHost::Name_);
  message.set_method_name("StoreShaderToDisk");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void GpuHostProxy::RecordLogMessage(
    int32_t in_severity, const std::string& in_header, const std::string& in_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::GpuHost::RecordLogMessage", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("severity"), in_severity, 
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("header"), in_header, 
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message"), in_message, 
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kGpuHost_RecordLogMessage_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuHost_RecordLogMessage_Params_Data> params(
          message);
  params.Allocate();
  params->severity = in_severity;
  mojo::internal::MessageFragment<
      typename decltype(params->header)::BaseType> header_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_header, header_fragment);
  params->header.Set(
      header_fragment.is_null() ? nullptr : header_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->header.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null header in GpuHost.RecordLogMessage request");
  mojo::internal::MessageFragment<
      typename decltype(params->message)::BaseType> message_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_message, message_fragment);
  params->message.Set(
      message_fragment.is_null() ? nullptr : message_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->message.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null message in GpuHost.RecordLogMessage request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuHost::Name_);
  message.set_method_name("RecordLogMessage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool GpuHostStubDispatch::Accept(
    GpuHost* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kGpuHost_DidInitialize_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::GpuHost::DidInitialize",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::GpuHost::DidInitialize");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::GpuHost_DidInitialize_Params_Data* params =
          reinterpret_cast<internal::GpuHost_DidInitialize_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::gpu::GPUInfo p_gpu_info{};
      ::gpu::GpuFeatureInfo p_gpu_feature_info{};
      base::Optional<::gpu::GPUInfo> p_gpu_info_for_hardware_gpu{};
      base::Optional<::gpu::GpuFeatureInfo> p_gpu_feature_info_for_hardware_gpu{};
      ::gfx::GpuExtraInfo p_gpu_extra_info{};
      GpuHost_DidInitialize_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadGpuInfo(&p_gpu_info))
        success = false;
      if (success && !input_data_view.ReadGpuFeatureInfo(&p_gpu_feature_info))
        success = false;
      if (success && !input_data_view.ReadGpuInfoForHardwareGpu(&p_gpu_info_for_hardware_gpu))
        success = false;
      if (success && !input_data_view.ReadGpuFeatureInfoForHardwareGpu(&p_gpu_feature_info_for_hardware_gpu))
        success = false;
      if (success && !input_data_view.ReadGpuExtraInfo(&p_gpu_extra_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidInitialize(
std::move(p_gpu_info), 
std::move(p_gpu_feature_info), 
std::move(p_gpu_info_for_hardware_gpu), 
std::move(p_gpu_feature_info_for_hardware_gpu), 
std::move(p_gpu_extra_info));
      return true;
    }
    case internal::kGpuHost_DidFailInitialize_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::GpuHost::DidFailInitialize",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::GpuHost::DidFailInitialize");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::GpuHost_DidFailInitialize_Params_Data* params =
          reinterpret_cast<internal::GpuHost_DidFailInitialize_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      GpuHost_DidFailInitialize_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuHost::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidFailInitialize();
      return true;
    }
    case internal::kGpuHost_DidCreateContextSuccessfully_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::GpuHost::DidCreateContextSuccessfully",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::GpuHost::DidCreateContextSuccessfully");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::GpuHost_DidCreateContextSuccessfully_Params_Data* params =
          reinterpret_cast<internal::GpuHost_DidCreateContextSuccessfully_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      GpuHost_DidCreateContextSuccessfully_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuHost::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidCreateContextSuccessfully();
      return true;
    }
    case internal::kGpuHost_DidCreateOffscreenContext_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::GpuHost::DidCreateOffscreenContext",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::GpuHost::DidCreateOffscreenContext");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::GpuHost_DidCreateOffscreenContext_Params_Data* params =
          reinterpret_cast<internal::GpuHost_DidCreateOffscreenContext_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::GURL p_url{};
      GpuHost_DidCreateOffscreenContext_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuHost::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidCreateOffscreenContext(
std::move(p_url));
      return true;
    }
    case internal::kGpuHost_DidDestroyOffscreenContext_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::GpuHost::DidDestroyOffscreenContext",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::GpuHost::DidDestroyOffscreenContext");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::GpuHost_DidDestroyOffscreenContext_Params_Data* params =
          reinterpret_cast<internal::GpuHost_DidDestroyOffscreenContext_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::GURL p_url{};
      GpuHost_DidDestroyOffscreenContext_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuHost::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidDestroyOffscreenContext(
std::move(p_url));
      return true;
    }
    case internal::kGpuHost_DidDestroyChannel_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::GpuHost::DidDestroyChannel",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::GpuHost::DidDestroyChannel");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::GpuHost_DidDestroyChannel_Params_Data* params =
          reinterpret_cast<internal::GpuHost_DidDestroyChannel_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_client_id{};
      GpuHost_DidDestroyChannel_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_client_id = input_data_view.client_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuHost::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidDestroyChannel(
std::move(p_client_id));
      return true;
    }
    case internal::kGpuHost_DidDestroyAllChannels_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::GpuHost::DidDestroyAllChannels",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::GpuHost::DidDestroyAllChannels");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::GpuHost_DidDestroyAllChannels_Params_Data* params =
          reinterpret_cast<internal::GpuHost_DidDestroyAllChannels_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      GpuHost_DidDestroyAllChannels_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuHost::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidDestroyAllChannels();
      return true;
    }
    case internal::kGpuHost_DidLoseContext_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::GpuHost::DidLoseContext",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::GpuHost::DidLoseContext");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::GpuHost_DidLoseContext_Params_Data* params =
          reinterpret_cast<internal::GpuHost_DidLoseContext_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_offscreen{};
      ::gpu::error::ContextLostReason p_reason{};
      ::GURL p_active_url{};
      GpuHost_DidLoseContext_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_offscreen = input_data_view.offscreen();
      if (success && !input_data_view.ReadReason(&p_reason))
        success = false;
      if (success && !input_data_view.ReadActiveUrl(&p_active_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuHost::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidLoseContext(
std::move(p_offscreen), 
std::move(p_reason), 
std::move(p_active_url));
      return true;
    }
    case internal::kGpuHost_DidUpdateGPUInfo_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::GpuHost::DidUpdateGPUInfo",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::GpuHost::DidUpdateGPUInfo");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::GpuHost_DidUpdateGPUInfo_Params_Data* params =
          reinterpret_cast<internal::GpuHost_DidUpdateGPUInfo_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::gpu::GPUInfo p_gpu_info{};
      GpuHost_DidUpdateGPUInfo_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadGpuInfo(&p_gpu_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuHost::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidUpdateGPUInfo(
std::move(p_gpu_info));
      return true;
    }
    case internal::kGpuHost_DisableGpuCompositing_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::GpuHost::DisableGpuCompositing",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::GpuHost::DisableGpuCompositing");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::GpuHost_DisableGpuCompositing_Params_Data* params =
          reinterpret_cast<internal::GpuHost_DisableGpuCompositing_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      GpuHost_DisableGpuCompositing_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuHost::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DisableGpuCompositing();
      return true;
    }
    case internal::kGpuHost_StoreShaderToDisk_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::GpuHost::StoreShaderToDisk",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::GpuHost::StoreShaderToDisk");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::GpuHost_StoreShaderToDisk_Params_Data* params =
          reinterpret_cast<internal::GpuHost_StoreShaderToDisk_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_client_id{};
      std::string p_key{};
      std::string p_shader{};
      GpuHost_StoreShaderToDisk_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_client_id = input_data_view.client_id();
      if (success && !input_data_view.ReadKey(&p_key))
        success = false;
      if (success && !input_data_view.ReadShader(&p_shader))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuHost::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StoreShaderToDisk(
std::move(p_client_id), 
std::move(p_key), 
std::move(p_shader));
      return true;
    }
    case internal::kGpuHost_RecordLogMessage_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::GpuHost::RecordLogMessage",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::GpuHost::RecordLogMessage");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::GpuHost_RecordLogMessage_Params_Data* params =
          reinterpret_cast<internal::GpuHost_RecordLogMessage_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_severity{};
      std::string p_header{};
      std::string p_message{};
      GpuHost_RecordLogMessage_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_severity = input_data_view.severity();
      if (success && !input_data_view.ReadHeader(&p_header))
        success = false;
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuHost::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RecordLogMessage(
std::move(p_severity), 
std::move(p_header), 
std::move(p_message));
      return true;
    }
  }
  return false;
}

// static
bool GpuHostStubDispatch::AcceptWithResponder(
    GpuHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kGpuHost_DidInitialize_Name: {
      break;
    }
    case internal::kGpuHost_DidFailInitialize_Name: {
      break;
    }
    case internal::kGpuHost_DidCreateContextSuccessfully_Name: {
      break;
    }
    case internal::kGpuHost_DidCreateOffscreenContext_Name: {
      break;
    }
    case internal::kGpuHost_DidDestroyOffscreenContext_Name: {
      break;
    }
    case internal::kGpuHost_DidDestroyChannel_Name: {
      break;
    }
    case internal::kGpuHost_DidDestroyAllChannels_Name: {
      break;
    }
    case internal::kGpuHost_DidLoseContext_Name: {
      break;
    }
    case internal::kGpuHost_DidUpdateGPUInfo_Name: {
      break;
    }
    case internal::kGpuHost_DisableGpuCompositing_Name: {
      break;
    }
    case internal::kGpuHost_StoreShaderToDisk_Name: {
      break;
    }
    case internal::kGpuHost_RecordLogMessage_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kGpuHostValidationInfo[] = {
    {internal::kGpuHost_DidInitialize_Name,
     {&internal::GpuHost_DidInitialize_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kGpuHost_DidFailInitialize_Name,
     {&internal::GpuHost_DidFailInitialize_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kGpuHost_DidCreateContextSuccessfully_Name,
     {&internal::GpuHost_DidCreateContextSuccessfully_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kGpuHost_DidCreateOffscreenContext_Name,
     {&internal::GpuHost_DidCreateOffscreenContext_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kGpuHost_DidDestroyOffscreenContext_Name,
     {&internal::GpuHost_DidDestroyOffscreenContext_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kGpuHost_DidDestroyChannel_Name,
     {&internal::GpuHost_DidDestroyChannel_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kGpuHost_DidDestroyAllChannels_Name,
     {&internal::GpuHost_DidDestroyAllChannels_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kGpuHost_DidLoseContext_Name,
     {&internal::GpuHost_DidLoseContext_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kGpuHost_DidUpdateGPUInfo_Name,
     {&internal::GpuHost_DidUpdateGPUInfo_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kGpuHost_DisableGpuCompositing_Name,
     {&internal::GpuHost_DisableGpuCompositing_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kGpuHost_StoreShaderToDisk_Name,
     {&internal::GpuHost_StoreShaderToDisk_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kGpuHost_RecordLogMessage_Name,
     {&internal::GpuHost_RecordLogMessage_Params_Data::Validate,
      nullptr /* no response */}},
};

bool GpuHostRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::viz::mojom::GpuHost::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kGpuHostValidationInfo);
}

}  // namespace mojom
}  // namespace viz

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif