// services/viz/public/mojom/compositing/begin_frame_args.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/viz/public/mojom/compositing/begin_frame_args.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/viz/public/mojom/compositing/begin_frame_args.mojom-params-data.h"
namespace viz {
namespace mojom {

std::string BeginFrameArgsTypeToString(BeginFrameArgsType value) {
  switch(value) {
    case BeginFrameArgsType::INVALID:
      return "BeginFrameArgsType::INVALID";
    case BeginFrameArgsType::NORMAL:
      return "BeginFrameArgsType::NORMAL";
    case BeginFrameArgsType::MISSED:
      return "BeginFrameArgsType::MISSED";
    default:
      return base::StringPrintf("Unknown BeginFrameArgsType value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, BeginFrameArgsType value) {
  return os << BeginFrameArgsTypeToString(value);
}

namespace internal {


// static
bool BeginFrameArgs_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 64, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const BeginFrameArgs_Data* object = static_cast<const BeginFrameArgs_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->frame_time, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->frame_time, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->deadline, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->deadline, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->interval, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->interval, validation_context))
    return false;


  if (!::viz::mojom::internal::BeginFrameArgsType_Data
        ::Validate(object->type, validation_context))
    return false;

  return true;
}

BeginFrameArgs_Data::BeginFrameArgs_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BeginFrameAck_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const BeginFrameAck_Data* object = static_cast<const BeginFrameAck_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

BeginFrameAck_Data::BeginFrameAck_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace viz

namespace perfetto {

// static
void TraceFormatTraits<::viz::mojom::BeginFrameArgsType>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::viz::mojom::BeginFrameArgsType value) {
  return std::move(context).WriteString(::viz::mojom::BeginFrameArgsTypeToString(value));
}

} // namespace perfetto
