// services/viz/public/mojom/compositing/compositor_frame_metadata.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/viz/public/mojom/compositing/compositor_frame_metadata.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "services/viz/public/mojom/compositing/compositor_frame_metadata.mojom-params-data.h"
#include "services/viz/public/mojom/compositing/compositor_frame_metadata.mojom-shared-message-ids.h"

#include "services/viz/public/mojom/compositing/compositor_frame_metadata.mojom-import-headers.h"


#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COMPOSITOR_FRAME_METADATA_MOJOM_JUMBO_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COMPOSITOR_FRAME_METADATA_MOJOM_JUMBO_H_
#include "services/viz/public/cpp/compositing/begin_frame_args_mojom_traits.h"
#endif
namespace viz {
namespace mojom {
CompositorFrameMetadata::CompositorFrameMetadata()
    : device_scale_factor(),
      root_scroll_offset(),
      page_scale_factor(),
      scrollable_viewport_size(),
      content_color_usage(),
      may_contain_video(),
      is_resourceless_software_draw_with_scroll_or_animation(),
      root_background_color(),
      latency_info(),
      referenced_surfaces(),
      deadline(),
      activation_dependencies(),
      begin_frame_ack(),
      frame_token(),
      send_frame_token_to_embedder(),
      top_controls_visible_height_set(),
      top_controls_visible_height(),
      min_page_scale_factor(),
      preferred_frame_interval(),
      display_transform_hint(),
      delegated_ink_metadata(),
      transition_directives() {}

CompositorFrameMetadata::CompositorFrameMetadata(
    float device_scale_factor_in,
    const ::gfx::Vector2dF& root_scroll_offset_in,
    float page_scale_factor_in,
    const ::gfx::SizeF& scrollable_viewport_size_in,
    ::gfx::mojom::ContentColorUsage content_color_usage_in,
    bool may_contain_video_in,
    bool is_resourceless_software_draw_with_scroll_or_animation_in,
    uint32_t root_background_color_in,
    std::vector<::ui::LatencyInfo> latency_info_in,
    std::vector<::viz::SurfaceRange> referenced_surfaces_in,
    const ::viz::FrameDeadline& deadline_in,
    std::vector<::viz::SurfaceId> activation_dependencies_in,
    const ::viz::BeginFrameAck& begin_frame_ack_in,
    uint32_t frame_token_in,
    bool send_frame_token_to_embedder_in,
    bool top_controls_visible_height_set_in,
    float top_controls_visible_height_in,
    float min_page_scale_factor_in,
    base::Optional<::base::TimeDelta> preferred_frame_interval_in,
    ::gfx::OverlayTransform display_transform_hint_in,
    ::std::unique_ptr<::viz::DelegatedInkMetadata> delegated_ink_metadata_in,
    std::vector<::viz::CompositorFrameTransitionDirective> transition_directives_in)
    : device_scale_factor(std::move(device_scale_factor_in)),
      root_scroll_offset(std::move(root_scroll_offset_in)),
      page_scale_factor(std::move(page_scale_factor_in)),
      scrollable_viewport_size(std::move(scrollable_viewport_size_in)),
      content_color_usage(std::move(content_color_usage_in)),
      may_contain_video(std::move(may_contain_video_in)),
      is_resourceless_software_draw_with_scroll_or_animation(std::move(is_resourceless_software_draw_with_scroll_or_animation_in)),
      root_background_color(std::move(root_background_color_in)),
      latency_info(std::move(latency_info_in)),
      referenced_surfaces(std::move(referenced_surfaces_in)),
      deadline(std::move(deadline_in)),
      activation_dependencies(std::move(activation_dependencies_in)),
      begin_frame_ack(std::move(begin_frame_ack_in)),
      frame_token(std::move(frame_token_in)),
      send_frame_token_to_embedder(std::move(send_frame_token_to_embedder_in)),
      top_controls_visible_height_set(std::move(top_controls_visible_height_set_in)),
      top_controls_visible_height(std::move(top_controls_visible_height_in)),
      min_page_scale_factor(std::move(min_page_scale_factor_in)),
      preferred_frame_interval(std::move(preferred_frame_interval_in)),
      display_transform_hint(std::move(display_transform_hint_in)),
      delegated_ink_metadata(std::move(delegated_ink_metadata_in)),
      transition_directives(std::move(transition_directives_in)) {}

CompositorFrameMetadata::~CompositorFrameMetadata() = default;

void CompositorFrameMetadata::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "device_scale_factor"), this->device_scale_factor, 
      "<value of type float>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "root_scroll_offset"), this->root_scroll_offset, 
      "<value of type const ::gfx::Vector2dF&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "page_scale_factor"), this->page_scale_factor, 
      "<value of type float>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scrollable_viewport_size"), this->scrollable_viewport_size, 
      "<value of type const ::gfx::SizeF&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "content_color_usage"), this->content_color_usage, 
      "<value of type ::gfx::mojom::ContentColorUsage>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "may_contain_video"), this->may_contain_video, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_resourceless_software_draw_with_scroll_or_animation"), this->is_resourceless_software_draw_with_scroll_or_animation, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "root_background_color"), this->root_background_color, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "latency_info"), this->latency_info, 
      "<value of type const std::vector<::ui::LatencyInfo>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "referenced_surfaces"), this->referenced_surfaces, 
      "<value of type const std::vector<::viz::SurfaceRange>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "deadline"), this->deadline, 
      "<value of type const ::viz::FrameDeadline&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "activation_dependencies"), this->activation_dependencies, 
      "<value of type const std::vector<::viz::SurfaceId>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "begin_frame_ack"), this->begin_frame_ack, 
      "<value of type const ::viz::BeginFrameAck&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame_token"), this->frame_token, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "send_frame_token_to_embedder"), this->send_frame_token_to_embedder, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "top_controls_visible_height_set"), this->top_controls_visible_height_set, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "top_controls_visible_height"), this->top_controls_visible_height, 
      "<value of type float>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "min_page_scale_factor"), this->min_page_scale_factor, 
      "<value of type float>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "preferred_frame_interval"), this->preferred_frame_interval, 
      "<value of type base::Optional<::base::TimeDelta>>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "display_transform_hint"), this->display_transform_hint, 
      "<value of type ::gfx::OverlayTransform>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "delegated_ink_metadata"), this->delegated_ink_metadata, 
      "<value of type ::std::unique_ptr<::viz::DelegatedInkMetadata>>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "transition_directives"), this->transition_directives, 
      "<value of type std::vector<::viz::CompositorFrameTransitionDirective>>");
}

bool CompositorFrameMetadata::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
}  // namespace mojom
}  // namespace viz

namespace mojo {


// static
bool StructTraits<::viz::mojom::CompositorFrameMetadata::DataView, ::viz::mojom::CompositorFrameMetadataPtr>::Read(
    ::viz::mojom::CompositorFrameMetadata::DataView input,
    ::viz::mojom::CompositorFrameMetadataPtr* output) {
  bool success = true;
  ::viz::mojom::CompositorFrameMetadataPtr result(::viz::mojom::CompositorFrameMetadata::New());
  
      if (success)
        result->device_scale_factor = input.device_scale_factor();
      if (success && !input.ReadRootScrollOffset(&result->root_scroll_offset))
        success = false;
      if (success)
        result->page_scale_factor = input.page_scale_factor();
      if (success && !input.ReadScrollableViewportSize(&result->scrollable_viewport_size))
        success = false;
      if (success && !input.ReadContentColorUsage(&result->content_color_usage))
        success = false;
      if (success)
        result->may_contain_video = input.may_contain_video();
      if (success)
        result->is_resourceless_software_draw_with_scroll_or_animation = input.is_resourceless_software_draw_with_scroll_or_animation();
      if (success)
        result->root_background_color = input.root_background_color();
      if (success && !input.ReadLatencyInfo(&result->latency_info))
        success = false;
      if (success && !input.ReadReferencedSurfaces(&result->referenced_surfaces))
        success = false;
      if (success && !input.ReadDeadline(&result->deadline))
        success = false;
      if (success && !input.ReadActivationDependencies(&result->activation_dependencies))
        success = false;
      if (success && !input.ReadBeginFrameAck(&result->begin_frame_ack))
        success = false;
      if (success)
        result->frame_token = input.frame_token();
      if (success)
        result->send_frame_token_to_embedder = input.send_frame_token_to_embedder();
      if (success)
        result->top_controls_visible_height_set = input.top_controls_visible_height_set();
      if (success)
        result->top_controls_visible_height = input.top_controls_visible_height();
      if (success)
        result->min_page_scale_factor = input.min_page_scale_factor();
      if (success && !input.ReadPreferredFrameInterval(&result->preferred_frame_interval))
        success = false;
      if (success && !input.ReadDisplayTransformHint(&result->display_transform_hint))
        success = false;
      if (success && !input.ReadDelegatedInkMetadata(&result->delegated_ink_metadata))
        success = false;
      if (success && !input.ReadTransitionDirectives(&result->transition_directives))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif