// services/viz/public/mojom/compositing/compositor_frame_transition_directive.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/viz/public/mojom/compositing/compositor_frame_transition_directive.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/viz/public/mojom/compositing/compositor_frame_transition_directive.mojom-params-data.h"
namespace viz {
namespace mojom {

std::string CompositorFrameTransitionDirectiveTypeToString(CompositorFrameTransitionDirectiveType value) {
  switch(value) {
    case CompositorFrameTransitionDirectiveType::kSave:
      return "CompositorFrameTransitionDirectiveType::kSave";
    case CompositorFrameTransitionDirectiveType::kAnimate:
      return "CompositorFrameTransitionDirectiveType::kAnimate";
    default:
      return base::StringPrintf("Unknown CompositorFrameTransitionDirectiveType value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, CompositorFrameTransitionDirectiveType value) {
  return os << CompositorFrameTransitionDirectiveTypeToString(value);
}

std::string CompositorFrameTransitionDirectiveEffectToString(CompositorFrameTransitionDirectiveEffect value) {
  switch(value) {
    case CompositorFrameTransitionDirectiveEffect::kNone:
      return "CompositorFrameTransitionDirectiveEffect::kNone";
    case CompositorFrameTransitionDirectiveEffect::kCoverDown:
      return "CompositorFrameTransitionDirectiveEffect::kCoverDown";
    case CompositorFrameTransitionDirectiveEffect::kCoverLeft:
      return "CompositorFrameTransitionDirectiveEffect::kCoverLeft";
    case CompositorFrameTransitionDirectiveEffect::kCoverRight:
      return "CompositorFrameTransitionDirectiveEffect::kCoverRight";
    case CompositorFrameTransitionDirectiveEffect::kCoverUp:
      return "CompositorFrameTransitionDirectiveEffect::kCoverUp";
    case CompositorFrameTransitionDirectiveEffect::kExplode:
      return "CompositorFrameTransitionDirectiveEffect::kExplode";
    case CompositorFrameTransitionDirectiveEffect::kFade:
      return "CompositorFrameTransitionDirectiveEffect::kFade";
    case CompositorFrameTransitionDirectiveEffect::kImplode:
      return "CompositorFrameTransitionDirectiveEffect::kImplode";
    case CompositorFrameTransitionDirectiveEffect::kRevealDown:
      return "CompositorFrameTransitionDirectiveEffect::kRevealDown";
    case CompositorFrameTransitionDirectiveEffect::kRevealLeft:
      return "CompositorFrameTransitionDirectiveEffect::kRevealLeft";
    case CompositorFrameTransitionDirectiveEffect::kRevealRight:
      return "CompositorFrameTransitionDirectiveEffect::kRevealRight";
    case CompositorFrameTransitionDirectiveEffect::kRevealUp:
      return "CompositorFrameTransitionDirectiveEffect::kRevealUp";
    default:
      return base::StringPrintf("Unknown CompositorFrameTransitionDirectiveEffect value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, CompositorFrameTransitionDirectiveEffect value) {
  return os << CompositorFrameTransitionDirectiveEffectToString(value);
}

namespace internal {


// static
bool CompositorFrameTransitionDirective_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CompositorFrameTransitionDirective_Data* object = static_cast<const CompositorFrameTransitionDirective_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::viz::mojom::internal::CompositorFrameTransitionDirectiveType_Data
        ::Validate(object->type, validation_context))
    return false;


  if (!::viz::mojom::internal::CompositorFrameTransitionDirectiveEffect_Data
        ::Validate(object->effect, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->duration, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->duration, validation_context))
    return false;

  return true;
}

CompositorFrameTransitionDirective_Data::CompositorFrameTransitionDirective_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace viz

namespace perfetto {

// static
void TraceFormatTraits<::viz::mojom::CompositorFrameTransitionDirectiveType>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::viz::mojom::CompositorFrameTransitionDirectiveType value) {
  return std::move(context).WriteString(::viz::mojom::CompositorFrameTransitionDirectiveTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::viz::mojom::CompositorFrameTransitionDirectiveEffect>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::viz::mojom::CompositorFrameTransitionDirectiveEffect value) {
  return std::move(context).WriteString(::viz::mojom::CompositorFrameTransitionDirectiveEffectToString(value));
}

} // namespace perfetto
