// services/viz/public/mojom/compositing/copy_output_result.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/viz/public/mojom/compositing/copy_output_result.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/viz/public/mojom/compositing/copy_output_result.mojom-params-data.h"
namespace viz {
namespace mojom {

std::string CopyOutputResultFormatToString(CopyOutputResultFormat value) {
  switch(value) {
    case CopyOutputResultFormat::RGBA_BITMAP:
      return "CopyOutputResultFormat::RGBA_BITMAP";
    case CopyOutputResultFormat::RGBA_TEXTURE:
      return "CopyOutputResultFormat::RGBA_TEXTURE";
    default:
      return base::StringPrintf("Unknown CopyOutputResultFormat value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, CopyOutputResultFormat value) {
  return os << CopyOutputResultFormatToString(value);
}

namespace internal {


// static
bool CopyOutputResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 64, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CopyOutputResult_Data* object = static_cast<const CopyOutputResult_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::viz::mojom::internal::CopyOutputResultFormat_Data
        ::Validate(object->format, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->rect, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->rect, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->bitmap, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->mailbox, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->sync_token, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->color_space, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterface(object->releaser,
                                                 validation_context)) {
    return false;
  }

  return true;
}

CopyOutputResult_Data::CopyOutputResult_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace viz

namespace perfetto {

// static
void TraceFormatTraits<::viz::mojom::CopyOutputResultFormat>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::viz::mojom::CopyOutputResultFormat value) {
  return std::move(context).WriteString(::viz::mojom::CopyOutputResultFormatToString(value));
}

} // namespace perfetto
