// services/viz/public/mojom/compositing/copy_output_result.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/viz/public/mojom/compositing/copy_output_result.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "services/viz/public/mojom/compositing/copy_output_result.mojom-params-data.h"
#include "services/viz/public/mojom/compositing/copy_output_result.mojom-shared-message-ids.h"

#include "services/viz/public/mojom/compositing/copy_output_result.mojom-import-headers.h"


#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COPY_OUTPUT_RESULT_MOJOM_JUMBO_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COPY_OUTPUT_RESULT_MOJOM_JUMBO_H_
#endif
namespace viz {
namespace mojom {
CopyOutputResult::CopyOutputResult()
    : format(),
      rect(),
      bitmap(),
      mailbox(),
      sync_token(),
      color_space(),
      releaser() {}

CopyOutputResult::CopyOutputResult(
    CopyOutputResultFormat format_in,
    const ::gfx::Rect& rect_in,
    ::viz::mojom::BitmapInSharedMemoryPtr bitmap_in,
    const base::Optional<::gpu::Mailbox>& mailbox_in,
    const base::Optional<::gpu::SyncToken>& sync_token_in,
    const base::Optional<::gfx::ColorSpace>& color_space_in,
    ::mojo::PendingRemote<::viz::mojom::TextureReleaser> releaser_in)
    : format(std::move(format_in)),
      rect(std::move(rect_in)),
      bitmap(std::move(bitmap_in)),
      mailbox(std::move(mailbox_in)),
      sync_token(std::move(sync_token_in)),
      color_space(std::move(color_space_in)),
      releaser(std::move(releaser_in)) {}

CopyOutputResult::~CopyOutputResult() = default;

void CopyOutputResult::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "format"), this->format, 
      "<value of type CopyOutputResultFormat>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "rect"), this->rect, 
      "<value of type const ::gfx::Rect&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bitmap"), this->bitmap, 
      "<value of type ::viz::mojom::BitmapInSharedMemoryPtr>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mailbox"), this->mailbox, 
      "<value of type const base::Optional<::gpu::Mailbox>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sync_token"), this->sync_token, 
      "<value of type const base::Optional<::gpu::SyncToken>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "color_space"), this->color_space, 
      "<value of type const base::Optional<::gfx::ColorSpace>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "releaser"), this->releaser, 
      "<value of type ::mojo::PendingRemote<::viz::mojom::TextureReleaser>>");
}

bool CopyOutputResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
}  // namespace mojom
}  // namespace viz

namespace mojo {


// static
bool StructTraits<::viz::mojom::CopyOutputResult::DataView, ::viz::mojom::CopyOutputResultPtr>::Read(
    ::viz::mojom::CopyOutputResult::DataView input,
    ::viz::mojom::CopyOutputResultPtr* output) {
  bool success = true;
  ::viz::mojom::CopyOutputResultPtr result(::viz::mojom::CopyOutputResult::New());
  
      if (success && !input.ReadFormat(&result->format))
        success = false;
      if (success && !input.ReadRect(&result->rect))
        success = false;
      if (success && !input.ReadBitmap(&result->bitmap))
        success = false;
      if (success && !input.ReadMailbox(&result->mailbox))
        success = false;
      if (success && !input.ReadSyncToken(&result->sync_token))
        success = false;
      if (success && !input.ReadColorSpace(&result->color_space))
        success = false;
      if (success) {
        result->releaser =
            input.TakeReleaser<decltype(result->releaser)>();
      }
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif