// services/viz/public/mojom/compositing/delegated_ink_metadata.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/viz/public/mojom/compositing/delegated_ink_metadata.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "services/viz/public/mojom/compositing/delegated_ink_metadata.mojom-params-data.h"
#include "services/viz/public/mojom/compositing/delegated_ink_metadata.mojom-shared-message-ids.h"

#include "services/viz/public/mojom/compositing/delegated_ink_metadata.mojom-import-headers.h"


#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_DELEGATED_INK_METADATA_MOJOM_JUMBO_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_DELEGATED_INK_METADATA_MOJOM_JUMBO_H_
#endif
namespace viz {
namespace mojom {
DelegatedInkMetadata::DelegatedInkMetadata()
    : point(),
      diameter(),
      color(),
      timestamp(),
      presentation_area(),
      frame_time(),
      is_hovering() {}

DelegatedInkMetadata::DelegatedInkMetadata(
    const ::gfx::PointF& point_in,
    double diameter_in,
    ::SkColor color_in,
    ::base::TimeTicks timestamp_in,
    const ::gfx::RectF& presentation_area_in,
    ::base::TimeTicks frame_time_in,
    bool is_hovering_in)
    : point(std::move(point_in)),
      diameter(std::move(diameter_in)),
      color(std::move(color_in)),
      timestamp(std::move(timestamp_in)),
      presentation_area(std::move(presentation_area_in)),
      frame_time(std::move(frame_time_in)),
      is_hovering(std::move(is_hovering_in)) {}

DelegatedInkMetadata::~DelegatedInkMetadata() = default;

void DelegatedInkMetadata::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "point"), this->point, 
      "<value of type const ::gfx::PointF&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "diameter"), this->diameter, 
      "<value of type double>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "color"), this->color, 
      "<value of type ::SkColor>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "timestamp"), this->timestamp, 
      "<value of type ::base::TimeTicks>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "presentation_area"), this->presentation_area, 
      "<value of type const ::gfx::RectF&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame_time"), this->frame_time, 
      "<value of type ::base::TimeTicks>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_hovering"), this->is_hovering, 
      "<value of type bool>");
}

bool DelegatedInkMetadata::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
}  // namespace mojom
}  // namespace viz

namespace mojo {


// static
bool StructTraits<::viz::mojom::DelegatedInkMetadata::DataView, ::viz::mojom::DelegatedInkMetadataPtr>::Read(
    ::viz::mojom::DelegatedInkMetadata::DataView input,
    ::viz::mojom::DelegatedInkMetadataPtr* output) {
  bool success = true;
  ::viz::mojom::DelegatedInkMetadataPtr result(::viz::mojom::DelegatedInkMetadata::New());
  
      if (success && !input.ReadPoint(&result->point))
        success = false;
      if (success)
        result->diameter = input.diameter();
      if (success && !input.ReadColor(&result->color))
        success = false;
      if (success && !input.ReadTimestamp(&result->timestamp))
        success = false;
      if (success && !input.ReadPresentationArea(&result->presentation_area))
        success = false;
      if (success && !input.ReadFrameTime(&result->frame_time))
        success = false;
      if (success)
        result->is_hovering = input.is_hovering();
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif