// services/viz/public/mojom/compositing/delegated_ink_point.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/viz/public/mojom/compositing/delegated_ink_point.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "services/viz/public/mojom/compositing/delegated_ink_point.mojom-params-data.h"
#include "services/viz/public/mojom/compositing/delegated_ink_point.mojom-shared-message-ids.h"

#include "services/viz/public/mojom/compositing/delegated_ink_point.mojom-import-headers.h"


#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_DELEGATED_INK_POINT_MOJOM_JUMBO_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_DELEGATED_INK_POINT_MOJOM_JUMBO_H_
#endif
namespace viz {
namespace mojom {
DelegatedInkPoint::DelegatedInkPoint()
    : point(),
      timestamp(),
      pointer_id() {}

DelegatedInkPoint::DelegatedInkPoint(
    const ::gfx::PointF& point_in,
    ::base::TimeTicks timestamp_in,
    int32_t pointer_id_in)
    : point(std::move(point_in)),
      timestamp(std::move(timestamp_in)),
      pointer_id(std::move(pointer_id_in)) {}

DelegatedInkPoint::~DelegatedInkPoint() = default;

void DelegatedInkPoint::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "point"), this->point, 
      "<value of type const ::gfx::PointF&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "timestamp"), this->timestamp, 
      "<value of type ::base::TimeTicks>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pointer_id"), this->pointer_id, 
      "<value of type int32_t>");
}

bool DelegatedInkPoint::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char DelegatedInkPointRenderer::Name_[] = "viz.mojom.DelegatedInkPointRenderer";

DelegatedInkPointRendererProxy::DelegatedInkPointRendererProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DelegatedInkPointRendererProxy::StoreDelegatedInkPoint(
    const ::viz::DelegatedInkPoint& in_point) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::DelegatedInkPointRenderer::StoreDelegatedInkPoint", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("point"), in_point, 
                        "<value of type const ::viz::DelegatedInkPoint&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kDelegatedInkPointRenderer_StoreDelegatedInkPoint_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::DelegatedInkPointRenderer_StoreDelegatedInkPoint_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->point)::BaseType> point_fragment(
          params.message());
  mojo::internal::Serialize<::viz::mojom::DelegatedInkPointDataView>(
      in_point, point_fragment);
  params->point.Set(
      point_fragment.is_null() ? nullptr : point_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->point.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null point in DelegatedInkPointRenderer.StoreDelegatedInkPoint request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DelegatedInkPointRenderer::Name_);
  message.set_method_name("StoreDelegatedInkPoint");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void DelegatedInkPointRendererProxy::ResetPrediction(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "viz::mojom::DelegatedInkPointRenderer::ResetPrediction");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kDelegatedInkPointRenderer_ResetPrediction_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::DelegatedInkPointRenderer_ResetPrediction_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DelegatedInkPointRenderer::Name_);
  message.set_method_name("ResetPrediction");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool DelegatedInkPointRendererStubDispatch::Accept(
    DelegatedInkPointRenderer* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kDelegatedInkPointRenderer_StoreDelegatedInkPoint_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::DelegatedInkPointRenderer::StoreDelegatedInkPoint",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::DelegatedInkPointRenderer::StoreDelegatedInkPoint");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DelegatedInkPointRenderer_StoreDelegatedInkPoint_Params_Data* params =
          reinterpret_cast<internal::DelegatedInkPointRenderer_StoreDelegatedInkPoint_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::viz::DelegatedInkPoint p_point{};
      DelegatedInkPointRenderer_StoreDelegatedInkPoint_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPoint(&p_point))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DelegatedInkPointRenderer::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StoreDelegatedInkPoint(
std::move(p_point));
      return true;
    }
    case internal::kDelegatedInkPointRenderer_ResetPrediction_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::DelegatedInkPointRenderer::ResetPrediction",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::DelegatedInkPointRenderer::ResetPrediction");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DelegatedInkPointRenderer_ResetPrediction_Params_Data* params =
          reinterpret_cast<internal::DelegatedInkPointRenderer_ResetPrediction_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      DelegatedInkPointRenderer_ResetPrediction_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DelegatedInkPointRenderer::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ResetPrediction();
      return true;
    }
  }
  return false;
}

// static
bool DelegatedInkPointRendererStubDispatch::AcceptWithResponder(
    DelegatedInkPointRenderer* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kDelegatedInkPointRenderer_StoreDelegatedInkPoint_Name: {
      break;
    }
    case internal::kDelegatedInkPointRenderer_ResetPrediction_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kDelegatedInkPointRendererValidationInfo[] = {
    {internal::kDelegatedInkPointRenderer_StoreDelegatedInkPoint_Name,
     {&internal::DelegatedInkPointRenderer_StoreDelegatedInkPoint_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kDelegatedInkPointRenderer_ResetPrediction_Name,
     {&internal::DelegatedInkPointRenderer_ResetPrediction_Params_Data::Validate,
      nullptr /* no response */}},
};

bool DelegatedInkPointRendererRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::viz::mojom::DelegatedInkPointRenderer::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kDelegatedInkPointRendererValidationInfo);
}

}  // namespace mojom
}  // namespace viz

namespace mojo {


// static
bool StructTraits<::viz::mojom::DelegatedInkPoint::DataView, ::viz::mojom::DelegatedInkPointPtr>::Read(
    ::viz::mojom::DelegatedInkPoint::DataView input,
    ::viz::mojom::DelegatedInkPointPtr* output) {
  bool success = true;
  ::viz::mojom::DelegatedInkPointPtr result(::viz::mojom::DelegatedInkPoint::New());
  
      if (success && !input.ReadPoint(&result->point))
        success = false;
      if (success && !input.ReadTimestamp(&result->timestamp))
        success = false;
      if (success)
        result->pointer_id = input.pointer_id();
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif