// services/viz/public/mojom/compositing/filter_operation.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/viz/public/mojom/compositing/filter_operation.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/viz/public/mojom/compositing/filter_operation.mojom-params-data.h"
namespace viz {
namespace mojom {

std::string FilterTypeToString(FilterType value) {
  switch(value) {
    case FilterType::GRAYSCALE:
      return "FilterType::GRAYSCALE";
    case FilterType::SEPIA:
      return "FilterType::SEPIA";
    case FilterType::SATURATE:
      return "FilterType::SATURATE";
    case FilterType::HUE_ROTATE:
      return "FilterType::HUE_ROTATE";
    case FilterType::INVERT:
      return "FilterType::INVERT";
    case FilterType::BRIGHTNESS:
      return "FilterType::BRIGHTNESS";
    case FilterType::CONTRAST:
      return "FilterType::CONTRAST";
    case FilterType::OPACITY:
      return "FilterType::OPACITY";
    case FilterType::BLUR:
      return "FilterType::BLUR";
    case FilterType::DROP_SHADOW:
      return "FilterType::DROP_SHADOW";
    case FilterType::COLOR_MATRIX:
      return "FilterType::COLOR_MATRIX";
    case FilterType::ZOOM:
      return "FilterType::ZOOM";
    case FilterType::REFERENCE:
      return "FilterType::REFERENCE";
    case FilterType::SATURATING_BRIGHTNESS:
      return "FilterType::SATURATING_BRIGHTNESS";
    case FilterType::ALPHA_THRESHOLD:
      return "FilterType::{ALPHA_THRESHOLD, FILTER_TYPE_LAST}";
    default:
      return base::StringPrintf("Unknown FilterType value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, FilterType value) {
  return os << FilterTypeToString(value);
}

namespace internal {


// static
bool FilterOperation_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 64, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FilterOperation_Data* object = static_cast<const FilterOperation_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::viz::mojom::internal::FilterType_Data
        ::Validate(object->type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->drop_shadow_offset, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->drop_shadow_offset, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->image_filter, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->image_filter, validation_context))
    return false;

  const mojo::internal::ContainerValidateParams matrix_validate_params(
      20, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->matrix, validation_context,
                                         &matrix_validate_params)) {
    return false;
  }


  if (!::skia::mojom::internal::TileMode_Data
        ::Validate(object->blur_tile_mode, validation_context))
    return false;

  const mojo::internal::ContainerValidateParams shape_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->shape, validation_context,
                                         &shape_validate_params)) {
    return false;
  }

  return true;
}

FilterOperation_Data::FilterOperation_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace viz

namespace perfetto {

// static
void TraceFormatTraits<::viz::mojom::FilterType>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::viz::mojom::FilterType value) {
  return std::move(context).WriteString(::viz::mojom::FilterTypeToString(value));
}

} // namespace perfetto
