// services/viz/public/mojom/compositing/frame_timing_details.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/viz/public/mojom/compositing/frame_timing_details.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "services/viz/public/mojom/compositing/frame_timing_details.mojom-params-data.h"
#include "services/viz/public/mojom/compositing/frame_timing_details.mojom-shared-message-ids.h"

#include "services/viz/public/mojom/compositing/frame_timing_details.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_FRAME_TIMING_DETAILS_MOJOM_BLINK_JUMBO_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_FRAME_TIMING_DETAILS_MOJOM_BLINK_JUMBO_H_
#endif
namespace viz {
namespace mojom {
namespace blink {
FrameTimingDetails::FrameTimingDetails()
    : received_compositor_frame_timestamp(),
      draw_start_timestamp(),
      swap_timings(),
      presentation_feedback() {}

FrameTimingDetails::FrameTimingDetails(
    ::base::TimeTicks received_compositor_frame_timestamp_in,
    ::base::TimeTicks draw_start_timestamp_in,
    const ::gfx::SwapTimings& swap_timings_in,
    const ::gfx::PresentationFeedback& presentation_feedback_in)
    : received_compositor_frame_timestamp(std::move(received_compositor_frame_timestamp_in)),
      draw_start_timestamp(std::move(draw_start_timestamp_in)),
      swap_timings(std::move(swap_timings_in)),
      presentation_feedback(std::move(presentation_feedback_in)) {}

FrameTimingDetails::~FrameTimingDetails() = default;

void FrameTimingDetails::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "received_compositor_frame_timestamp"), this->received_compositor_frame_timestamp, 
      "<value of type ::base::TimeTicks>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "draw_start_timestamp"), this->draw_start_timestamp, 
      "<value of type ::base::TimeTicks>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "swap_timings"), this->swap_timings, 
      "<value of type const ::gfx::SwapTimings&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "presentation_feedback"), this->presentation_feedback, 
      "<value of type const ::gfx::PresentationFeedback&>");
}

bool FrameTimingDetails::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
}  // namespace blink
}  // namespace mojom
}  // namespace viz

namespace mojo {


// static
bool StructTraits<::viz::mojom::blink::FrameTimingDetails::DataView, ::viz::mojom::blink::FrameTimingDetailsPtr>::Read(
    ::viz::mojom::blink::FrameTimingDetails::DataView input,
    ::viz::mojom::blink::FrameTimingDetailsPtr* output) {
  bool success = true;
  ::viz::mojom::blink::FrameTimingDetailsPtr result(::viz::mojom::blink::FrameTimingDetails::New());
  
      if (success && !input.ReadReceivedCompositorFrameTimestamp(&result->received_compositor_frame_timestamp))
        success = false;
      if (success && !input.ReadDrawStartTimestamp(&result->draw_start_timestamp))
        success = false;
      if (success && !input.ReadSwapTimings(&result->swap_timings))
        success = false;
      if (success && !input.ReadPresentationFeedback(&result->presentation_feedback))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif