// services/viz/public/mojom/compositing/local_surface_id.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/viz/public/mojom/compositing/local_surface_id.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "services/viz/public/mojom/compositing/local_surface_id.mojom-params-data.h"
#include "services/viz/public/mojom/compositing/local_surface_id.mojom-shared-message-ids.h"

#include "services/viz/public/mojom/compositing/local_surface_id.mojom-import-headers.h"


#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_LOCAL_SURFACE_ID_MOJOM_JUMBO_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_LOCAL_SURFACE_ID_MOJOM_JUMBO_H_
#endif
namespace viz {
namespace mojom {
LocalSurfaceId::LocalSurfaceId()
    : parent_sequence_number(),
      child_sequence_number(),
      embed_token() {}

LocalSurfaceId::LocalSurfaceId(
    uint32_t parent_sequence_number_in,
    uint32_t child_sequence_number_in,
    const ::base::UnguessableToken& embed_token_in)
    : parent_sequence_number(std::move(parent_sequence_number_in)),
      child_sequence_number(std::move(child_sequence_number_in)),
      embed_token(std::move(embed_token_in)) {}

LocalSurfaceId::~LocalSurfaceId() = default;

void LocalSurfaceId::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "parent_sequence_number"), this->parent_sequence_number, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "child_sequence_number"), this->child_sequence_number, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "embed_token"), this->embed_token, 
      "<value of type const ::base::UnguessableToken&>");
}

bool LocalSurfaceId::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
}  // namespace mojom
}  // namespace viz

namespace mojo {


// static
bool StructTraits<::viz::mojom::LocalSurfaceId::DataView, ::viz::mojom::LocalSurfaceIdPtr>::Read(
    ::viz::mojom::LocalSurfaceId::DataView input,
    ::viz::mojom::LocalSurfaceIdPtr* output) {
  bool success = true;
  ::viz::mojom::LocalSurfaceIdPtr result(::viz::mojom::LocalSurfaceId::New());
  
      if (success)
        result->parent_sequence_number = input.parent_sequence_number();
      if (success)
        result->child_sequence_number = input.child_sequence_number();
      if (success && !input.ReadEmbedToken(&result->embed_token))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif