// services/viz/public/mojom/compositing/shared_quad_state.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/viz/public/mojom/compositing/shared_quad_state.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "services/viz/public/mojom/compositing/shared_quad_state.mojom-params-data.h"
#include "services/viz/public/mojom/compositing/shared_quad_state.mojom-shared-message-ids.h"

#include "services/viz/public/mojom/compositing/shared_quad_state.mojom-import-headers.h"


#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_SHARED_QUAD_STATE_MOJOM_JUMBO_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_SHARED_QUAD_STATE_MOJOM_JUMBO_H_
#endif
namespace viz {
namespace mojom {
SharedQuadState::SharedQuadState()
    : quad_to_target_transform(),
      quad_layer_rect(),
      visible_quad_layer_rect(),
      mask_filter_info(),
      clip_rect(),
      is_clipped(),
      are_contents_opaque(),
      opacity(),
      blend_mode(),
      sorting_context_id(),
      is_fast_rounded_corner(),
      de_jelly_delta_y(),
      no_damage() {}

SharedQuadState::SharedQuadState(
    const ::gfx::Transform& quad_to_target_transform_in,
    const ::gfx::Rect& quad_layer_rect_in,
    const ::gfx::Rect& visible_quad_layer_rect_in,
    const ::gfx::MaskFilterInfo& mask_filter_info_in,
    const ::gfx::Rect& clip_rect_in,
    bool is_clipped_in,
    bool are_contents_opaque_in,
    float opacity_in,
    uint32_t blend_mode_in,
    int32_t sorting_context_id_in,
    bool is_fast_rounded_corner_in,
    float de_jelly_delta_y_in,
    bool no_damage_in)
    : quad_to_target_transform(std::move(quad_to_target_transform_in)),
      quad_layer_rect(std::move(quad_layer_rect_in)),
      visible_quad_layer_rect(std::move(visible_quad_layer_rect_in)),
      mask_filter_info(std::move(mask_filter_info_in)),
      clip_rect(std::move(clip_rect_in)),
      is_clipped(std::move(is_clipped_in)),
      are_contents_opaque(std::move(are_contents_opaque_in)),
      opacity(std::move(opacity_in)),
      blend_mode(std::move(blend_mode_in)),
      sorting_context_id(std::move(sorting_context_id_in)),
      is_fast_rounded_corner(std::move(is_fast_rounded_corner_in)),
      de_jelly_delta_y(std::move(de_jelly_delta_y_in)),
      no_damage(std::move(no_damage_in)) {}

SharedQuadState::~SharedQuadState() = default;

void SharedQuadState::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "quad_to_target_transform"), this->quad_to_target_transform, 
      "<value of type const ::gfx::Transform&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "quad_layer_rect"), this->quad_layer_rect, 
      "<value of type const ::gfx::Rect&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "visible_quad_layer_rect"), this->visible_quad_layer_rect, 
      "<value of type const ::gfx::Rect&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mask_filter_info"), this->mask_filter_info, 
      "<value of type const ::gfx::MaskFilterInfo&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "clip_rect"), this->clip_rect, 
      "<value of type const ::gfx::Rect&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_clipped"), this->is_clipped, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "are_contents_opaque"), this->are_contents_opaque, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "opacity"), this->opacity, 
      "<value of type float>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "blend_mode"), this->blend_mode, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sorting_context_id"), this->sorting_context_id, 
      "<value of type int32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_fast_rounded_corner"), this->is_fast_rounded_corner, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "de_jelly_delta_y"), this->de_jelly_delta_y, 
      "<value of type float>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "no_damage"), this->no_damage, 
      "<value of type bool>");
}

bool SharedQuadState::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
}  // namespace mojom
}  // namespace viz

namespace mojo {


// static
bool StructTraits<::viz::mojom::SharedQuadState::DataView, ::viz::mojom::SharedQuadStatePtr>::Read(
    ::viz::mojom::SharedQuadState::DataView input,
    ::viz::mojom::SharedQuadStatePtr* output) {
  bool success = true;
  ::viz::mojom::SharedQuadStatePtr result(::viz::mojom::SharedQuadState::New());
  
      if (success && !input.ReadQuadToTargetTransform(&result->quad_to_target_transform))
        success = false;
      if (success && !input.ReadQuadLayerRect(&result->quad_layer_rect))
        success = false;
      if (success && !input.ReadVisibleQuadLayerRect(&result->visible_quad_layer_rect))
        success = false;
      if (success && !input.ReadMaskFilterInfo(&result->mask_filter_info))
        success = false;
      if (success && !input.ReadClipRect(&result->clip_rect))
        success = false;
      if (success)
        result->is_clipped = input.is_clipped();
      if (success)
        result->are_contents_opaque = input.are_contents_opaque();
      if (success)
        result->opacity = input.opacity();
      if (success)
        result->blend_mode = input.blend_mode();
      if (success)
        result->sorting_context_id = input.sorting_context_id();
      if (success)
        result->is_fast_rounded_corner = input.is_fast_rounded_corner();
      if (success)
        result->de_jelly_delta_y = input.de_jelly_delta_y();
      if (success)
        result->no_damage = input.no_damage();
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif