// services/viz/public/mojom/compositing/surface_info.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/viz/public/mojom/compositing/surface_info.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "services/viz/public/mojom/compositing/surface_info.mojom-params-data.h"
#include "services/viz/public/mojom/compositing/surface_info.mojom-shared-message-ids.h"

#include "services/viz/public/mojom/compositing/surface_info.mojom-import-headers.h"


#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_SURFACE_INFO_MOJOM_JUMBO_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_SURFACE_INFO_MOJOM_JUMBO_H_
#endif
namespace viz {
namespace mojom {
SurfaceInfo::SurfaceInfo()
    : surface_id(),
      device_scale_factor(),
      size_in_pixels() {}

SurfaceInfo::SurfaceInfo(
    const ::viz::SurfaceId& surface_id_in,
    float device_scale_factor_in,
    const ::gfx::Size& size_in_pixels_in)
    : surface_id(std::move(surface_id_in)),
      device_scale_factor(std::move(device_scale_factor_in)),
      size_in_pixels(std::move(size_in_pixels_in)) {}

SurfaceInfo::~SurfaceInfo() = default;

void SurfaceInfo::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "surface_id"), this->surface_id, 
      "<value of type const ::viz::SurfaceId&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "device_scale_factor"), this->device_scale_factor, 
      "<value of type float>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "size_in_pixels"), this->size_in_pixels, 
      "<value of type const ::gfx::Size&>");
}

bool SurfaceInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
}  // namespace mojom
}  // namespace viz

namespace mojo {


// static
bool StructTraits<::viz::mojom::SurfaceInfo::DataView, ::viz::mojom::SurfaceInfoPtr>::Read(
    ::viz::mojom::SurfaceInfo::DataView input,
    ::viz::mojom::SurfaceInfoPtr* output) {
  bool success = true;
  ::viz::mojom::SurfaceInfoPtr result(::viz::mojom::SurfaceInfo::New());
  
      if (success && !input.ReadSurfaceId(&result->surface_id))
        success = false;
      if (success)
        result->device_scale_factor = input.device_scale_factor();
      if (success && !input.ReadSizeInPixels(&result->size_in_pixels))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif