// services/viz/public/mojom/compositing/transferable_resource.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/viz/public/mojom/compositing/transferable_resource.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/viz/public/mojom/compositing/transferable_resource.mojom-params-data.h"
namespace viz {
namespace mojom {

std::string ResourceFormatToString(ResourceFormat value) {
  switch(value) {
    case ResourceFormat::RGBA_8888:
      return "ResourceFormat::RGBA_8888";
    case ResourceFormat::RGBA_4444:
      return "ResourceFormat::RGBA_4444";
    case ResourceFormat::BGRA_8888:
      return "ResourceFormat::BGRA_8888";
    case ResourceFormat::ALPHA_8:
      return "ResourceFormat::ALPHA_8";
    case ResourceFormat::LUMINANCE_8:
      return "ResourceFormat::LUMINANCE_8";
    case ResourceFormat::RGB_565:
      return "ResourceFormat::RGB_565";
    case ResourceFormat::BGR_565:
      return "ResourceFormat::BGR_565";
    case ResourceFormat::ETC1:
      return "ResourceFormat::ETC1";
    case ResourceFormat::RED_8:
      return "ResourceFormat::RED_8";
    case ResourceFormat::RG_88:
      return "ResourceFormat::RG_88";
    case ResourceFormat::LUMINANCE_F16:
      return "ResourceFormat::LUMINANCE_F16";
    case ResourceFormat::RGBA_F16:
      return "ResourceFormat::RGBA_F16";
    case ResourceFormat::R16_EXT:
      return "ResourceFormat::R16_EXT";
    case ResourceFormat::RG16_EXT:
      return "ResourceFormat::RG16_EXT";
    case ResourceFormat::RGBX_8888:
      return "ResourceFormat::RGBX_8888";
    case ResourceFormat::BGRX_8888:
      return "ResourceFormat::BGRX_8888";
    case ResourceFormat::RGBX_1010102:
      return "ResourceFormat::RGBX_1010102";
    case ResourceFormat::BGRX_1010102:
      return "ResourceFormat::BGRX_1010102";
    case ResourceFormat::YVU_420:
      return "ResourceFormat::YVU_420";
    case ResourceFormat::YUV_420_BIPLANAR:
      return "ResourceFormat::YUV_420_BIPLANAR";
    case ResourceFormat::P010:
      return "ResourceFormat::P010";
    default:
      return base::StringPrintf("Unknown ResourceFormat value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, ResourceFormat value) {
  return os << ResourceFormatToString(value);
}

namespace internal {


// static
bool TransferableResource_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 64, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const TransferableResource_Data* object = static_cast<const TransferableResource_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->id, validation_context))
    return false;


  if (!::viz::mojom::internal::ResourceFormat_Data
        ::Validate(object->format, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->size, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->size, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->mailbox_holder, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->mailbox_holder, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->color_space, 11, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->color_space, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->ycbcr_info, validation_context))
    return false;

  return true;
}

TransferableResource_Data::TransferableResource_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace viz

namespace perfetto {

// static
void TraceFormatTraits<::viz::mojom::ResourceFormat>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::viz::mojom::ResourceFormat value) {
  return std::move(context).WriteString(::viz::mojom::ResourceFormatToString(value));
}

} // namespace perfetto
