// services/viz/public/mojom/compositing/transferable_resource.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/viz/public/mojom/compositing/transferable_resource.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "services/viz/public/mojom/compositing/transferable_resource.mojom-params-data.h"
#include "services/viz/public/mojom/compositing/transferable_resource.mojom-shared-message-ids.h"

#include "services/viz/public/mojom/compositing/transferable_resource.mojom-import-headers.h"


#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_TRANSFERABLE_RESOURCE_MOJOM_JUMBO_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_TRANSFERABLE_RESOURCE_MOJOM_JUMBO_H_
#endif
namespace viz {
namespace mojom {
TransferableResource::TransferableResource()
    : id(),
      format(),
      filter(),
      size(),
      mailbox_holder(),
      read_lock_fences_enabled(),
      is_software(),
      is_overlay_candidate(),
      is_backed_by_surface_texture(),
      wants_promotion_hint(),
      color_space(),
      ycbcr_info() {}

TransferableResource::TransferableResource(
    const ::viz::ResourceId& id_in,
    ResourceFormat format_in,
    uint32_t filter_in,
    const ::gfx::Size& size_in,
    const ::gpu::MailboxHolder& mailbox_holder_in,
    bool read_lock_fences_enabled_in,
    bool is_software_in,
    bool is_overlay_candidate_in,
    bool is_backed_by_surface_texture_in,
    bool wants_promotion_hint_in,
    const ::gfx::ColorSpace& color_space_in,
    base::Optional<::gpu::VulkanYCbCrInfo> ycbcr_info_in)
    : id(std::move(id_in)),
      format(std::move(format_in)),
      filter(std::move(filter_in)),
      size(std::move(size_in)),
      mailbox_holder(std::move(mailbox_holder_in)),
      read_lock_fences_enabled(std::move(read_lock_fences_enabled_in)),
      is_software(std::move(is_software_in)),
      is_overlay_candidate(std::move(is_overlay_candidate_in)),
      is_backed_by_surface_texture(std::move(is_backed_by_surface_texture_in)),
      wants_promotion_hint(std::move(wants_promotion_hint_in)),
      color_space(std::move(color_space_in)),
      ycbcr_info(std::move(ycbcr_info_in)) {}

TransferableResource::~TransferableResource() = default;

void TransferableResource::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id, 
      "<value of type const ::viz::ResourceId&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "format"), this->format, 
      "<value of type ResourceFormat>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "filter"), this->filter, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "size"), this->size, 
      "<value of type const ::gfx::Size&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mailbox_holder"), this->mailbox_holder, 
      "<value of type const ::gpu::MailboxHolder&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "read_lock_fences_enabled"), this->read_lock_fences_enabled, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_software"), this->is_software, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_overlay_candidate"), this->is_overlay_candidate, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_backed_by_surface_texture"), this->is_backed_by_surface_texture, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "wants_promotion_hint"), this->wants_promotion_hint, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "color_space"), this->color_space, 
      "<value of type const ::gfx::ColorSpace&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ycbcr_info"), this->ycbcr_info, 
      "<value of type base::Optional<::gpu::VulkanYCbCrInfo>>");
}

bool TransferableResource::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
}  // namespace mojom
}  // namespace viz

namespace mojo {


// static
bool StructTraits<::viz::mojom::TransferableResource::DataView, ::viz::mojom::TransferableResourcePtr>::Read(
    ::viz::mojom::TransferableResource::DataView input,
    ::viz::mojom::TransferableResourcePtr* output) {
  bool success = true;
  ::viz::mojom::TransferableResourcePtr result(::viz::mojom::TransferableResource::New());
  
      if (success && !input.ReadId(&result->id))
        success = false;
      if (success && !input.ReadFormat(&result->format))
        success = false;
      if (success)
        result->filter = input.filter();
      if (success && !input.ReadSize(&result->size))
        success = false;
      if (success && !input.ReadMailboxHolder(&result->mailbox_holder))
        success = false;
      if (success)
        result->read_lock_fences_enabled = input.read_lock_fences_enabled();
      if (success)
        result->is_software = input.is_software();
      if (success)
        result->is_overlay_candidate = input.is_overlay_candidate();
      if (success)
        result->is_backed_by_surface_texture = input.is_backed_by_surface_texture();
      if (success)
        result->wants_promotion_hint = input.wants_promotion_hint();
      if (success && !input.ReadColorSpace(&result->color_space))
        success = false;
      if (success && !input.ReadYcbcrInfo(&result->ycbcr_info))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif