// services/viz/public/mojom/gpu.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/viz/public/mojom/gpu.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "services/viz/public/mojom/gpu.mojom-params-data.h"
#include "services/viz/public/mojom/gpu.mojom-shared-message-ids.h"

#include "services/viz/public/mojom/gpu.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef SERVICES_VIZ_PUBLIC_MOJOM_GPU_MOJOM_BLINK_JUMBO_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_GPU_MOJOM_BLINK_JUMBO_H_
#endif
namespace viz {
namespace mojom {
namespace blink {
const char GpuMemoryBufferFactory::Name_[] = "viz.mojom.GpuMemoryBufferFactory";

class GpuMemoryBufferFactory_CreateGpuMemoryBuffer_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  GpuMemoryBufferFactory_CreateGpuMemoryBuffer_ForwardToCallback(
      GpuMemoryBufferFactory::CreateGpuMemoryBufferCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  GpuMemoryBufferFactory::CreateGpuMemoryBufferCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(GpuMemoryBufferFactory_CreateGpuMemoryBuffer_ForwardToCallback);
};

class GpuMemoryBufferFactory_CopyGpuMemoryBuffer_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  GpuMemoryBufferFactory_CopyGpuMemoryBuffer_ForwardToCallback(
      GpuMemoryBufferFactory::CopyGpuMemoryBufferCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  GpuMemoryBufferFactory::CopyGpuMemoryBufferCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(GpuMemoryBufferFactory_CopyGpuMemoryBuffer_ForwardToCallback);
};

GpuMemoryBufferFactoryProxy::GpuMemoryBufferFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void GpuMemoryBufferFactoryProxy::CreateGpuMemoryBuffer(
    ::gfx::GpuMemoryBufferId in_id, const ::gfx::Size& in_size, ::gfx::BufferFormat in_format, ::gfx::BufferUsage in_usage, CreateGpuMemoryBufferCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::GpuMemoryBufferFactory::CreateGpuMemoryBuffer", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id, 
                        "<value of type ::gfx::GpuMemoryBufferId>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("size"), in_size, 
                        "<value of type const ::gfx::Size&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("format"), in_format, 
                        "<value of type ::gfx::BufferFormat>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("usage"), in_usage, 
                        "<value of type ::gfx::BufferUsage>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kGpuMemoryBufferFactory_CreateGpuMemoryBuffer_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuMemoryBufferFactory_CreateGpuMemoryBuffer_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->id)::BaseType> id_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::GpuMemoryBufferIdDataView>(
      in_id, id_fragment);
  params->id.Set(
      id_fragment.is_null() ? nullptr : id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in GpuMemoryBufferFactory.CreateGpuMemoryBuffer request");
  mojo::internal::MessageFragment<
      typename decltype(params->size)::BaseType> size_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
      in_size, size_fragment);
  params->size.Set(
      size_fragment.is_null() ? nullptr : size_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->size.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null size in GpuMemoryBufferFactory.CreateGpuMemoryBuffer request");
  mojo::internal::Serialize<::gfx::mojom::BufferFormat>(
      in_format, &params->format);
  mojo::internal::Serialize<::gfx::mojom::BufferUsage>(
      in_usage, &params->usage);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuMemoryBufferFactory::Name_);
  message.set_method_name("CreateGpuMemoryBuffer");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new GpuMemoryBufferFactory_CreateGpuMemoryBuffer_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void GpuMemoryBufferFactoryProxy::DestroyGpuMemoryBuffer(
    ::gfx::GpuMemoryBufferId in_id, const ::gpu::SyncToken& in_sync_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::GpuMemoryBufferFactory::DestroyGpuMemoryBuffer", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id, 
                        "<value of type ::gfx::GpuMemoryBufferId>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("sync_token"), in_sync_token, 
                        "<value of type const ::gpu::SyncToken&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kGpuMemoryBufferFactory_DestroyGpuMemoryBuffer_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuMemoryBufferFactory_DestroyGpuMemoryBuffer_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->id)::BaseType> id_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::GpuMemoryBufferIdDataView>(
      in_id, id_fragment);
  params->id.Set(
      id_fragment.is_null() ? nullptr : id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in GpuMemoryBufferFactory.DestroyGpuMemoryBuffer request");
  mojo::internal::MessageFragment<
      typename decltype(params->sync_token)::BaseType> sync_token_fragment(
          params.message());
  mojo::internal::Serialize<::gpu::mojom::SyncTokenDataView>(
      in_sync_token, sync_token_fragment);
  params->sync_token.Set(
      sync_token_fragment.is_null() ? nullptr : sync_token_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->sync_token.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null sync_token in GpuMemoryBufferFactory.DestroyGpuMemoryBuffer request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuMemoryBufferFactory::Name_);
  message.set_method_name("DestroyGpuMemoryBuffer");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void GpuMemoryBufferFactoryProxy::CopyGpuMemoryBuffer(
    ::gfx::GpuMemoryBufferHandle in_buffer_handle, ::base::UnsafeSharedMemoryRegion in_shared_memory, CopyGpuMemoryBufferCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::GpuMemoryBufferFactory::CopyGpuMemoryBuffer", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer_handle"), in_buffer_handle, 
                        "<value of type ::gfx::GpuMemoryBufferHandle>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("shared_memory"), in_shared_memory, 
                        "<value of type ::base::UnsafeSharedMemoryRegion>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kGpuMemoryBufferFactory_CopyGpuMemoryBuffer_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuMemoryBufferFactory_CopyGpuMemoryBuffer_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->buffer_handle)::BaseType> buffer_handle_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::GpuMemoryBufferHandleDataView>(
      in_buffer_handle, buffer_handle_fragment);
  params->buffer_handle.Set(
      buffer_handle_fragment.is_null() ? nullptr : buffer_handle_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->buffer_handle.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null buffer_handle in GpuMemoryBufferFactory.CopyGpuMemoryBuffer request");
  mojo::internal::MessageFragment<
      typename decltype(params->shared_memory)::BaseType> shared_memory_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::UnsafeSharedMemoryRegionDataView>(
      in_shared_memory, shared_memory_fragment);
  params->shared_memory.Set(
      shared_memory_fragment.is_null() ? nullptr : shared_memory_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->shared_memory.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null shared_memory in GpuMemoryBufferFactory.CopyGpuMemoryBuffer request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuMemoryBufferFactory::Name_);
  message.set_method_name("CopyGpuMemoryBuffer");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new GpuMemoryBufferFactory_CopyGpuMemoryBuffer_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class GpuMemoryBufferFactory_CreateGpuMemoryBuffer_ProxyToResponder {
 public:
  static GpuMemoryBufferFactory::CreateGpuMemoryBufferCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<GpuMemoryBufferFactory_CreateGpuMemoryBuffer_ProxyToResponder> proxy(
        new GpuMemoryBufferFactory_CreateGpuMemoryBuffer_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&GpuMemoryBufferFactory_CreateGpuMemoryBuffer_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~GpuMemoryBufferFactory_CreateGpuMemoryBuffer_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  GpuMemoryBufferFactory_CreateGpuMemoryBuffer_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "GpuMemoryBufferFactory::CreateGpuMemoryBufferCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::gfx::GpuMemoryBufferHandle in_buffer_handle);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(GpuMemoryBufferFactory_CreateGpuMemoryBuffer_ProxyToResponder);
};

bool GpuMemoryBufferFactory_CreateGpuMemoryBuffer_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "viz::mojom::GpuMemoryBufferFactory::CreateGpuMemoryBufferCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::GpuMemoryBufferFactory_CreateGpuMemoryBuffer_ResponseParams_Data* params =
      reinterpret_cast<
          internal::GpuMemoryBufferFactory_CreateGpuMemoryBuffer_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::gfx::GpuMemoryBufferHandle p_buffer_handle{};
  GpuMemoryBufferFactory_CreateGpuMemoryBuffer_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadBufferHandle(&p_buffer_handle))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        GpuMemoryBufferFactory::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_buffer_handle));
  return true;
}

void GpuMemoryBufferFactory_CreateGpuMemoryBuffer_ProxyToResponder::Run(
    ::gfx::GpuMemoryBufferHandle in_buffer_handle) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)viz::mojom::GpuMemoryBufferFactory::CreateGpuMemoryBufferCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer_handle"), in_buffer_handle, 
                        "<value of type ::gfx::GpuMemoryBufferHandle>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kGpuMemoryBufferFactory_CreateGpuMemoryBuffer_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuMemoryBufferFactory_CreateGpuMemoryBuffer_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->buffer_handle)::BaseType> buffer_handle_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::GpuMemoryBufferHandleDataView>(
      in_buffer_handle, buffer_handle_fragment);
  params->buffer_handle.Set(
      buffer_handle_fragment.is_null() ? nullptr : buffer_handle_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->buffer_handle.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null buffer_handle in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)viz::mojom::GpuMemoryBufferFactory::CreateGpuMemoryBufferCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuMemoryBufferFactory::Name_);
  message.set_method_name("CreateGpuMemoryBuffer");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class GpuMemoryBufferFactory_CopyGpuMemoryBuffer_ProxyToResponder {
 public:
  static GpuMemoryBufferFactory::CopyGpuMemoryBufferCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<GpuMemoryBufferFactory_CopyGpuMemoryBuffer_ProxyToResponder> proxy(
        new GpuMemoryBufferFactory_CopyGpuMemoryBuffer_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&GpuMemoryBufferFactory_CopyGpuMemoryBuffer_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~GpuMemoryBufferFactory_CopyGpuMemoryBuffer_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  GpuMemoryBufferFactory_CopyGpuMemoryBuffer_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "GpuMemoryBufferFactory::CopyGpuMemoryBufferCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(GpuMemoryBufferFactory_CopyGpuMemoryBuffer_ProxyToResponder);
};

bool GpuMemoryBufferFactory_CopyGpuMemoryBuffer_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "viz::mojom::GpuMemoryBufferFactory::CopyGpuMemoryBufferCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::GpuMemoryBufferFactory_CopyGpuMemoryBuffer_ResponseParams_Data* params =
      reinterpret_cast<
          internal::GpuMemoryBufferFactory_CopyGpuMemoryBuffer_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  bool p_success{};
  GpuMemoryBufferFactory_CopyGpuMemoryBuffer_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        GpuMemoryBufferFactory::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_success));
  return true;
}

void GpuMemoryBufferFactory_CopyGpuMemoryBuffer_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)viz::mojom::GpuMemoryBufferFactory::CopyGpuMemoryBufferCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success, 
                        "<value of type bool>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kGpuMemoryBufferFactory_CopyGpuMemoryBuffer_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuMemoryBufferFactory_CopyGpuMemoryBuffer_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->success = in_success;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)viz::mojom::GpuMemoryBufferFactory::CopyGpuMemoryBufferCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuMemoryBufferFactory::Name_);
  message.set_method_name("CopyGpuMemoryBuffer");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool GpuMemoryBufferFactoryStubDispatch::Accept(
    GpuMemoryBufferFactory* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kGpuMemoryBufferFactory_CreateGpuMemoryBuffer_Name: {
      break;
    }
    case internal::kGpuMemoryBufferFactory_DestroyGpuMemoryBuffer_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::GpuMemoryBufferFactory::DestroyGpuMemoryBuffer",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::GpuMemoryBufferFactory::DestroyGpuMemoryBuffer");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::GpuMemoryBufferFactory_DestroyGpuMemoryBuffer_Params_Data* params =
          reinterpret_cast<internal::GpuMemoryBufferFactory_DestroyGpuMemoryBuffer_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::gfx::GpuMemoryBufferId p_id{};
      ::gpu::SyncToken p_sync_token{};
      GpuMemoryBufferFactory_DestroyGpuMemoryBuffer_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadId(&p_id))
        success = false;
      if (success && !input_data_view.ReadSyncToken(&p_sync_token))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuMemoryBufferFactory::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DestroyGpuMemoryBuffer(
std::move(p_id), 
std::move(p_sync_token));
      return true;
    }
    case internal::kGpuMemoryBufferFactory_CopyGpuMemoryBuffer_Name: {
      break;
    }
  }
  return false;
}

// static
bool GpuMemoryBufferFactoryStubDispatch::AcceptWithResponder(
    GpuMemoryBufferFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kGpuMemoryBufferFactory_CreateGpuMemoryBuffer_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::GpuMemoryBufferFactory::CreateGpuMemoryBuffer",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::GpuMemoryBufferFactory::CreateGpuMemoryBuffer");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::GpuMemoryBufferFactory_CreateGpuMemoryBuffer_Params_Data* params =
          reinterpret_cast<
              internal::GpuMemoryBufferFactory_CreateGpuMemoryBuffer_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::gfx::GpuMemoryBufferId p_id{};
      ::gfx::Size p_size{};
      ::gfx::BufferFormat p_format{};
      ::gfx::BufferUsage p_usage{};
      GpuMemoryBufferFactory_CreateGpuMemoryBuffer_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadId(&p_id))
        success = false;
      if (success && !input_data_view.ReadSize(&p_size))
        success = false;
      if (success && !input_data_view.ReadFormat(&p_format))
        success = false;
      if (success && !input_data_view.ReadUsage(&p_usage))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuMemoryBufferFactory::Name_, 0, false);
        return false;
      }
      GpuMemoryBufferFactory::CreateGpuMemoryBufferCallback callback =
          GpuMemoryBufferFactory_CreateGpuMemoryBuffer_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateGpuMemoryBuffer(
std::move(p_id), 
std::move(p_size), 
std::move(p_format), 
std::move(p_usage), std::move(callback));
      return true;
    }
    case internal::kGpuMemoryBufferFactory_DestroyGpuMemoryBuffer_Name: {
      break;
    }
    case internal::kGpuMemoryBufferFactory_CopyGpuMemoryBuffer_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::GpuMemoryBufferFactory::CopyGpuMemoryBuffer",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::GpuMemoryBufferFactory::CopyGpuMemoryBuffer");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::GpuMemoryBufferFactory_CopyGpuMemoryBuffer_Params_Data* params =
          reinterpret_cast<
              internal::GpuMemoryBufferFactory_CopyGpuMemoryBuffer_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::gfx::GpuMemoryBufferHandle p_buffer_handle{};
      ::base::UnsafeSharedMemoryRegion p_shared_memory{};
      GpuMemoryBufferFactory_CopyGpuMemoryBuffer_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBufferHandle(&p_buffer_handle))
        success = false;
      if (success && !input_data_view.ReadSharedMemory(&p_shared_memory))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuMemoryBufferFactory::Name_, 2, false);
        return false;
      }
      GpuMemoryBufferFactory::CopyGpuMemoryBufferCallback callback =
          GpuMemoryBufferFactory_CopyGpuMemoryBuffer_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CopyGpuMemoryBuffer(
std::move(p_buffer_handle), 
std::move(p_shared_memory), std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kGpuMemoryBufferFactoryValidationInfo[] = {
    {internal::kGpuMemoryBufferFactory_CreateGpuMemoryBuffer_Name,
     {&internal::GpuMemoryBufferFactory_CreateGpuMemoryBuffer_Params_Data::Validate,
      &internal::GpuMemoryBufferFactory_CreateGpuMemoryBuffer_ResponseParams_Data::Validate}},
    {internal::kGpuMemoryBufferFactory_DestroyGpuMemoryBuffer_Name,
     {&internal::GpuMemoryBufferFactory_DestroyGpuMemoryBuffer_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kGpuMemoryBufferFactory_CopyGpuMemoryBuffer_Name,
     {&internal::GpuMemoryBufferFactory_CopyGpuMemoryBuffer_Params_Data::Validate,
      &internal::GpuMemoryBufferFactory_CopyGpuMemoryBuffer_ResponseParams_Data::Validate}},
};

bool GpuMemoryBufferFactoryRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::viz::mojom::blink::GpuMemoryBufferFactory::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kGpuMemoryBufferFactoryValidationInfo);
}

bool GpuMemoryBufferFactoryResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::viz::mojom::blink::GpuMemoryBufferFactory::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kGpuMemoryBufferFactoryValidationInfo);

}
const char Gpu::Name_[] = "viz.mojom.Gpu";

class Gpu_EstablishGpuChannel_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Gpu_EstablishGpuChannel_ForwardToCallback(
      Gpu::EstablishGpuChannelCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  Gpu::EstablishGpuChannelCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(Gpu_EstablishGpuChannel_ForwardToCallback);
};

GpuProxy::GpuProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void GpuProxy::CreateGpuMemoryBufferFactory(
    ::mojo::PendingReceiver<GpuMemoryBufferFactory> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::Gpu::CreateGpuMemoryBufferFactory", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver, 
                        "<value of type ::mojo::PendingReceiver<GpuMemoryBufferFactory>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kGpu_CreateGpuMemoryBufferFactory_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::Gpu_CreateGpuMemoryBufferFactory_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::viz::mojom::GpuMemoryBufferFactoryInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in Gpu.CreateGpuMemoryBufferFactory request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Gpu::Name_);
  message.set_method_name("CreateGpuMemoryBufferFactory");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void GpuProxy::EstablishGpuChannel(
    EstablishGpuChannelCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "viz::mojom::Gpu::EstablishGpuChannel");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kGpu_EstablishGpuChannel_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::Gpu_EstablishGpuChannel_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Gpu::Name_);
  message.set_method_name("EstablishGpuChannel");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Gpu_EstablishGpuChannel_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void GpuProxy::CreateVideoEncodeAcceleratorProvider(
    ::mojo::PendingReceiver<::media::mojom::blink::VideoEncodeAcceleratorProvider> in_vea_provider) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::Gpu::CreateVideoEncodeAcceleratorProvider", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("vea_provider"), in_vea_provider, 
                        "<value of type ::mojo::PendingReceiver<::media::mojom::blink::VideoEncodeAcceleratorProvider>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kGpu_CreateVideoEncodeAcceleratorProvider_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::Gpu_CreateVideoEncodeAcceleratorProvider_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media::mojom::VideoEncodeAcceleratorProviderInterfaceBase>>(
      in_vea_provider, &params->vea_provider, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->vea_provider),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid vea_provider in Gpu.CreateVideoEncodeAcceleratorProvider request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Gpu::Name_);
  message.set_method_name("CreateVideoEncodeAcceleratorProvider");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class Gpu_EstablishGpuChannel_ProxyToResponder {
 public:
  static Gpu::EstablishGpuChannelCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<Gpu_EstablishGpuChannel_ProxyToResponder> proxy(
        new Gpu_EstablishGpuChannel_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&Gpu_EstablishGpuChannel_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Gpu_EstablishGpuChannel_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  Gpu_EstablishGpuChannel_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Gpu::EstablishGpuChannelCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_client_id, ::mojo::ScopedMessagePipeHandle in_channel_handle, ::gpu::mojom::blink::GpuInfoPtr in_gpu_info, ::gpu::mojom::blink::GpuFeatureInfoPtr in_gpu_feature_info);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(Gpu_EstablishGpuChannel_ProxyToResponder);
};

bool Gpu_EstablishGpuChannel_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "viz::mojom::Gpu::EstablishGpuChannelCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::Gpu_EstablishGpuChannel_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Gpu_EstablishGpuChannel_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  int32_t p_client_id{};
  ::mojo::ScopedMessagePipeHandle p_channel_handle{};
  ::gpu::mojom::blink::GpuInfoPtr p_gpu_info{};
  ::gpu::mojom::blink::GpuFeatureInfoPtr p_gpu_feature_info{};
  Gpu_EstablishGpuChannel_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_client_id = input_data_view.client_id();
  if (success)
    p_channel_handle = input_data_view.TakeChannelHandle();
  if (success && !input_data_view.ReadGpuInfo(&p_gpu_info))
    success = false;
  if (success && !input_data_view.ReadGpuFeatureInfo(&p_gpu_feature_info))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Gpu::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_client_id), 
std::move(p_channel_handle), 
std::move(p_gpu_info), 
std::move(p_gpu_feature_info));
  return true;
}

void Gpu_EstablishGpuChannel_ProxyToResponder::Run(
    int32_t in_client_id, ::mojo::ScopedMessagePipeHandle in_channel_handle, ::gpu::mojom::blink::GpuInfoPtr in_gpu_info, ::gpu::mojom::blink::GpuFeatureInfoPtr in_gpu_feature_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)viz::mojom::Gpu::EstablishGpuChannelCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client_id"), in_client_id, 
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("channel_handle"), in_channel_handle, 
                        "<value of type ::mojo::ScopedMessagePipeHandle>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("gpu_info"), in_gpu_info, 
                        "<value of type ::gpu::mojom::blink::GpuInfoPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("gpu_feature_info"), in_gpu_feature_info, 
                        "<value of type ::gpu::mojom::blink::GpuFeatureInfoPtr>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kGpu_EstablishGpuChannel_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::Gpu_EstablishGpuChannel_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->client_id = in_client_id;
  mojo::internal::Serialize<mojo::ScopedMessagePipeHandle>(
      in_channel_handle, &params->channel_handle, &params.message());
  mojo::internal::MessageFragment<
      typename decltype(params->gpu_info)::BaseType> gpu_info_fragment(
          params.message());
  mojo::internal::Serialize<::gpu::mojom::GpuInfoDataView>(
      in_gpu_info, gpu_info_fragment);
  params->gpu_info.Set(
      gpu_info_fragment.is_null() ? nullptr : gpu_info_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->gpu_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null gpu_info in ");
  mojo::internal::MessageFragment<
      typename decltype(params->gpu_feature_info)::BaseType> gpu_feature_info_fragment(
          params.message());
  mojo::internal::Serialize<::gpu::mojom::GpuFeatureInfoDataView>(
      in_gpu_feature_info, gpu_feature_info_fragment);
  params->gpu_feature_info.Set(
      gpu_feature_info_fragment.is_null() ? nullptr : gpu_feature_info_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->gpu_feature_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null gpu_feature_info in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)viz::mojom::Gpu::EstablishGpuChannelCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Gpu::Name_);
  message.set_method_name("EstablishGpuChannel");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool GpuStubDispatch::Accept(
    Gpu* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kGpu_CreateGpuMemoryBufferFactory_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::Gpu::CreateGpuMemoryBufferFactory",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::Gpu::CreateGpuMemoryBufferFactory");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Gpu_CreateGpuMemoryBufferFactory_Params_Data* params =
          reinterpret_cast<internal::Gpu_CreateGpuMemoryBufferFactory_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<GpuMemoryBufferFactory> p_receiver{};
      Gpu_CreateGpuMemoryBufferFactory_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Gpu::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateGpuMemoryBufferFactory(
std::move(p_receiver));
      return true;
    }
    case internal::kGpu_EstablishGpuChannel_Name: {
      break;
    }
    case internal::kGpu_CreateVideoEncodeAcceleratorProvider_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::Gpu::CreateVideoEncodeAcceleratorProvider",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::Gpu::CreateVideoEncodeAcceleratorProvider");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Gpu_CreateVideoEncodeAcceleratorProvider_Params_Data* params =
          reinterpret_cast<internal::Gpu_CreateVideoEncodeAcceleratorProvider_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::media::mojom::blink::VideoEncodeAcceleratorProvider> p_vea_provider{};
      Gpu_CreateVideoEncodeAcceleratorProvider_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_vea_provider =
            input_data_view.TakeVeaProvider<decltype(p_vea_provider)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Gpu::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateVideoEncodeAcceleratorProvider(
std::move(p_vea_provider));
      return true;
    }
  }
  return false;
}

// static
bool GpuStubDispatch::AcceptWithResponder(
    Gpu* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kGpu_CreateGpuMemoryBufferFactory_Name: {
      break;
    }
    case internal::kGpu_EstablishGpuChannel_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::Gpu::EstablishGpuChannel",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::Gpu::EstablishGpuChannel");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::Gpu_EstablishGpuChannel_Params_Data* params =
          reinterpret_cast<
              internal::Gpu_EstablishGpuChannel_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      Gpu_EstablishGpuChannel_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Gpu::Name_, 1, false);
        return false;
      }
      Gpu::EstablishGpuChannelCallback callback =
          Gpu_EstablishGpuChannel_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EstablishGpuChannel(std::move(callback));
      return true;
    }
    case internal::kGpu_CreateVideoEncodeAcceleratorProvider_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kGpuValidationInfo[] = {
    {internal::kGpu_CreateGpuMemoryBufferFactory_Name,
     {&internal::Gpu_CreateGpuMemoryBufferFactory_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kGpu_EstablishGpuChannel_Name,
     {&internal::Gpu_EstablishGpuChannel_Params_Data::Validate,
      &internal::Gpu_EstablishGpuChannel_ResponseParams_Data::Validate}},
    {internal::kGpu_CreateVideoEncodeAcceleratorProvider_Name,
     {&internal::Gpu_CreateVideoEncodeAcceleratorProvider_Params_Data::Validate,
      nullptr /* no response */}},
};

bool GpuRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::viz::mojom::blink::Gpu::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kGpuValidationInfo);
}

bool GpuResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::viz::mojom::blink::Gpu::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kGpuValidationInfo);

}
}  // namespace blink
}  // namespace mojom
}  // namespace viz

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif