// skia/public/mojom/bitmap.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "skia/public/mojom/bitmap.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "skia/public/mojom/bitmap.mojom-params-data.h"
namespace skia {
namespace mojom {

namespace internal {


// static
bool BitmapN32_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const BitmapN32_Data* object = static_cast<const BitmapN32_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->image_info, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->image_info, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->pixel_data, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->pixel_data, validation_context))
    return false;

  return true;
}

BitmapN32_Data::BitmapN32_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BitmapWithArbitraryBpp_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const BitmapWithArbitraryBpp_Data* object = static_cast<const BitmapWithArbitraryBpp_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->image_info, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->image_info, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->pixel_data, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->pixel_data, validation_context))
    return false;

  return true;
}

BitmapWithArbitraryBpp_Data::BitmapWithArbitraryBpp_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BitmapMappedFromTrustedProcess_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const BitmapMappedFromTrustedProcess_Data* object = static_cast<const BitmapMappedFromTrustedProcess_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->image_info, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->image_info, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->pixel_data, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->pixel_data, validation_context))
    return false;

  return true;
}

BitmapMappedFromTrustedProcess_Data::BitmapMappedFromTrustedProcess_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool InlineBitmap_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const InlineBitmap_Data* object = static_cast<const InlineBitmap_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->image_info, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->image_info, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->pixel_data, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams pixel_data_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->pixel_data, validation_context,
                                         &pixel_data_validate_params)) {
    return false;
  }

  return true;
}

InlineBitmap_Data::InlineBitmap_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace skia
