// skia/public/mojom/image_info.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "skia/public/mojom/image_info.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "skia/public/mojom/image_info.mojom-params-data.h"
#include "skia/public/mojom/image_info.mojom-shared-message-ids.h"

#include "skia/public/mojom/image_info.mojom-import-headers.h"


#ifndef SKIA_PUBLIC_MOJOM_IMAGE_INFO_MOJOM_JUMBO_H_
#define SKIA_PUBLIC_MOJOM_IMAGE_INFO_MOJOM_JUMBO_H_
#endif
namespace skia {
namespace mojom {
ImageInfo::ImageInfo()
    : color_type(),
      alpha_type(),
      width(),
      height(),
      color_transfer_function(),
      color_to_xyz_matrix() {}

ImageInfo::ImageInfo(
    ::SkColorType color_type_in,
    ::SkAlphaType alpha_type_in,
    uint32_t width_in,
    uint32_t height_in,
    base::Optional<std::vector<float>> color_transfer_function_in,
    base::Optional<std::vector<float>> color_to_xyz_matrix_in)
    : color_type(std::move(color_type_in)),
      alpha_type(std::move(alpha_type_in)),
      width(std::move(width_in)),
      height(std::move(height_in)),
      color_transfer_function(std::move(color_transfer_function_in)),
      color_to_xyz_matrix(std::move(color_to_xyz_matrix_in)) {}

ImageInfo::~ImageInfo() = default;

void ImageInfo::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "color_type"), this->color_type, 
      "<value of type ::SkColorType>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "alpha_type"), this->alpha_type, 
      "<value of type ::SkAlphaType>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "width"), this->width, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "height"), this->height, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "color_transfer_function"), this->color_transfer_function, 
      "<value of type const base::Optional<std::vector<float>>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "color_to_xyz_matrix"), this->color_to_xyz_matrix, 
      "<value of type const base::Optional<std::vector<float>>&>");
}

bool ImageInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
BitmapN32ImageInfo::BitmapN32ImageInfo()
    : alpha_type(),
      width(),
      height(),
      color_transfer_function(),
      color_to_xyz_matrix() {}

BitmapN32ImageInfo::BitmapN32ImageInfo(
    ::SkAlphaType alpha_type_in,
    uint32_t width_in,
    uint32_t height_in,
    base::Optional<std::vector<float>> color_transfer_function_in,
    base::Optional<std::vector<float>> color_to_xyz_matrix_in)
    : alpha_type(std::move(alpha_type_in)),
      width(std::move(width_in)),
      height(std::move(height_in)),
      color_transfer_function(std::move(color_transfer_function_in)),
      color_to_xyz_matrix(std::move(color_to_xyz_matrix_in)) {}

BitmapN32ImageInfo::~BitmapN32ImageInfo() = default;

void BitmapN32ImageInfo::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "alpha_type"), this->alpha_type, 
      "<value of type ::SkAlphaType>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "width"), this->width, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "height"), this->height, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "color_transfer_function"), this->color_transfer_function, 
      "<value of type const base::Optional<std::vector<float>>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "color_to_xyz_matrix"), this->color_to_xyz_matrix, 
      "<value of type const base::Optional<std::vector<float>>&>");
}

bool BitmapN32ImageInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
}  // namespace mojom
}  // namespace skia

namespace mojo {


// static
bool StructTraits<::skia::mojom::ImageInfo::DataView, ::skia::mojom::ImageInfoPtr>::Read(
    ::skia::mojom::ImageInfo::DataView input,
    ::skia::mojom::ImageInfoPtr* output) {
  bool success = true;
  ::skia::mojom::ImageInfoPtr result(::skia::mojom::ImageInfo::New());
  
      if (success && !input.ReadColorType(&result->color_type))
        success = false;
      if (success && !input.ReadAlphaType(&result->alpha_type))
        success = false;
      if (success)
        result->width = input.width();
      if (success)
        result->height = input.height();
      if (success && !input.ReadColorTransferFunction(&result->color_transfer_function))
        success = false;
      if (success && !input.ReadColorToXyzMatrix(&result->color_to_xyz_matrix))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::skia::mojom::BitmapN32ImageInfo::DataView, ::skia::mojom::BitmapN32ImageInfoPtr>::Read(
    ::skia::mojom::BitmapN32ImageInfo::DataView input,
    ::skia::mojom::BitmapN32ImageInfoPtr* output) {
  bool success = true;
  ::skia::mojom::BitmapN32ImageInfoPtr result(::skia::mojom::BitmapN32ImageInfo::New());
  
      if (success && !input.ReadAlphaType(&result->alpha_type))
        success = false;
      if (success)
        result->width = input.width();
      if (success)
        result->height = input.height();
      if (success && !input.ReadColorTransferFunction(&result->color_transfer_function))
        success = false;
      if (success && !input.ReadColorToXyzMatrix(&result->color_to_xyz_matrix))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif