// third_party/blink/public/mojom/appcache/appcache_info.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/appcache/appcache_info.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/appcache/appcache_info.mojom-params-data.h"
namespace blink {
namespace mojom {

std::string AppCacheStatusToString(AppCacheStatus value) {
  switch(value) {
    case AppCacheStatus::APPCACHE_STATUS_UNCACHED:
      return "AppCacheStatus::APPCACHE_STATUS_UNCACHED";
    case AppCacheStatus::APPCACHE_STATUS_IDLE:
      return "AppCacheStatus::APPCACHE_STATUS_IDLE";
    case AppCacheStatus::APPCACHE_STATUS_CHECKING:
      return "AppCacheStatus::APPCACHE_STATUS_CHECKING";
    case AppCacheStatus::APPCACHE_STATUS_DOWNLOADING:
      return "AppCacheStatus::APPCACHE_STATUS_DOWNLOADING";
    case AppCacheStatus::APPCACHE_STATUS_UPDATE_READY:
      return "AppCacheStatus::APPCACHE_STATUS_UPDATE_READY";
    case AppCacheStatus::APPCACHE_STATUS_OBSOLETE:
      return "AppCacheStatus::APPCACHE_STATUS_OBSOLETE";
    default:
      return base::StringPrintf("Unknown AppCacheStatus value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, AppCacheStatus value) {
  return os << AppCacheStatusToString(value);
}

namespace internal {


// static
bool AppCacheInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 104, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const AppCacheInfo_Data* object = static_cast<const AppCacheInfo_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->manifest_url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->manifest_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->creation_time, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->creation_time, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->last_update_time, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->last_update_time, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->last_access_time, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->last_access_time, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->token_expires, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->token_expires, validation_context))
    return false;


  if (!::blink::mojom::internal::AppCacheStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->manifest_scope, 13, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams manifest_scope_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->manifest_scope, validation_context,
                                         &manifest_scope_validate_params)) {
    return false;
  }

  return true;
}

AppCacheInfo_Data::AppCacheInfo_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::AppCacheStatus>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::blink::mojom::AppCacheStatus value) {
  return std::move(context).WriteString(::blink::mojom::AppCacheStatusToString(value));
}

} // namespace perfetto
