// third_party/blink/public/mojom/background_fetch/background_fetch.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/background_fetch/background_fetch.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/background_fetch/background_fetch.mojom-params-data.h"
#include "third_party/blink/public/mojom/background_fetch/background_fetch.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/background_fetch/background_fetch.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_BACKGROUND_FETCH_BACKGROUND_FETCH_MOJOM_BLINK_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_BACKGROUND_FETCH_BACKGROUND_FETCH_MOJOM_BLINK_JUMBO_H_
#include "third_party/blink/renderer/platform/loader/fetch/fetch_api_request_body_mojom_traits.h"
#endif
namespace blink {
namespace mojom {
namespace blink {
BackgroundFetchSettledFetch::BackgroundFetchSettledFetch()
    : request(),
      response() {}

BackgroundFetchSettledFetch::BackgroundFetchSettledFetch(
    ::blink::mojom::blink::FetchAPIRequestPtr request_in,
    ::blink::mojom::blink::FetchAPIResponsePtr response_in)
    : request(std::move(request_in)),
      response(std::move(response_in)) {}

BackgroundFetchSettledFetch::~BackgroundFetchSettledFetch() = default;

void BackgroundFetchSettledFetch::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "request"), this->request, 
      "<value of type ::blink::mojom::blink::FetchAPIRequestPtr>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "response"), this->response, 
      "<value of type ::blink::mojom::blink::FetchAPIResponsePtr>");
}

bool BackgroundFetchSettledFetch::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
BackgroundFetchOptions::BackgroundFetchOptions()
    : icons(),
      download_total(),
      title() {}

BackgroundFetchOptions::BackgroundFetchOptions(
    WTF::Vector<::blink::mojom::blink::ManifestImageResourcePtr> icons_in,
    uint64_t download_total_in,
    const WTF::String& title_in)
    : icons(std::move(icons_in)),
      download_total(std::move(download_total_in)),
      title(std::move(title_in)) {}

BackgroundFetchOptions::~BackgroundFetchOptions() = default;

void BackgroundFetchOptions::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "icons"), this->icons, 
      "<value of type WTF::Vector<::blink::mojom::blink::ManifestImageResourcePtr>>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "download_total"), this->download_total, 
      "<value of type uint64_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "title"), this->title, 
      "<value of type const WTF::String&>");
}

bool BackgroundFetchOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
BackgroundFetchRegistrationData::BackgroundFetchRegistrationData()
    : developer_id(),
      upload_total(),
      uploaded(),
      download_total(),
      downloaded(),
      result(BackgroundFetchResult::UNSET),
      failure_reason(BackgroundFetchFailureReason::NONE) {}

BackgroundFetchRegistrationData::BackgroundFetchRegistrationData(
    const WTF::String& developer_id_in,
    uint64_t upload_total_in,
    uint64_t uploaded_in,
    uint64_t download_total_in,
    uint64_t downloaded_in,
    BackgroundFetchResult result_in,
    BackgroundFetchFailureReason failure_reason_in)
    : developer_id(std::move(developer_id_in)),
      upload_total(std::move(upload_total_in)),
      uploaded(std::move(uploaded_in)),
      download_total(std::move(download_total_in)),
      downloaded(std::move(downloaded_in)),
      result(std::move(result_in)),
      failure_reason(std::move(failure_reason_in)) {}

BackgroundFetchRegistrationData::~BackgroundFetchRegistrationData() = default;
size_t BackgroundFetchRegistrationData::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->developer_id);
  seed = mojo::internal::WTFHash(seed, this->upload_total);
  seed = mojo::internal::WTFHash(seed, this->uploaded);
  seed = mojo::internal::WTFHash(seed, this->download_total);
  seed = mojo::internal::WTFHash(seed, this->downloaded);
  seed = mojo::internal::WTFHash(seed, this->result);
  seed = mojo::internal::WTFHash(seed, this->failure_reason);
  return seed;
}

void BackgroundFetchRegistrationData::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "developer_id"), this->developer_id, 
      "<value of type const WTF::String&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "upload_total"), this->upload_total, 
      "<value of type uint64_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "uploaded"), this->uploaded, 
      "<value of type uint64_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "download_total"), this->download_total, 
      "<value of type uint64_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "downloaded"), this->downloaded, 
      "<value of type uint64_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "result"), this->result, 
      "<value of type BackgroundFetchResult>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "failure_reason"), this->failure_reason, 
      "<value of type BackgroundFetchFailureReason>");
}

bool BackgroundFetchRegistrationData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
BackgroundFetchRegistration::BackgroundFetchRegistration()
    : registration_data(),
      registration_interface() {}

BackgroundFetchRegistration::BackgroundFetchRegistration(
    BackgroundFetchRegistrationDataPtr registration_data_in,
    ::mojo::PendingRemote<BackgroundFetchRegistrationService> registration_interface_in)
    : registration_data(std::move(registration_data_in)),
      registration_interface(std::move(registration_interface_in)) {}

BackgroundFetchRegistration::~BackgroundFetchRegistration() = default;

void BackgroundFetchRegistration::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "registration_data"), this->registration_data, 
      "<value of type BackgroundFetchRegistrationDataPtr>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "registration_interface"), this->registration_interface, 
      "<value of type ::mojo::PendingRemote<BackgroundFetchRegistrationService>>");
}

bool BackgroundFetchRegistration::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
BackgroundFetchUkmData::BackgroundFetchUkmData()
    : ideal_to_chosen_icon_size(-1) {}

BackgroundFetchUkmData::BackgroundFetchUkmData(
    int64_t ideal_to_chosen_icon_size_in)
    : ideal_to_chosen_icon_size(std::move(ideal_to_chosen_icon_size_in)) {}

BackgroundFetchUkmData::~BackgroundFetchUkmData() = default;
size_t BackgroundFetchUkmData::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->ideal_to_chosen_icon_size);
  return seed;
}

void BackgroundFetchUkmData::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ideal_to_chosen_icon_size"), this->ideal_to_chosen_icon_size, 
      "<value of type int64_t>");
}

bool BackgroundFetchUkmData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char BackgroundFetchRegistrationObserver::Name_[] = "blink.mojom.BackgroundFetchRegistrationObserver";

BackgroundFetchRegistrationObserverProxy::BackgroundFetchRegistrationObserverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void BackgroundFetchRegistrationObserverProxy::OnProgress(
    uint64_t in_upload_total, uint64_t in_uploaded, uint64_t in_download_total, uint64_t in_downloaded, BackgroundFetchResult in_result, BackgroundFetchFailureReason in_failure_reason) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::BackgroundFetchRegistrationObserver::OnProgress", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("upload_total"), in_upload_total, 
                        "<value of type uint64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("uploaded"), in_uploaded, 
                        "<value of type uint64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("download_total"), in_download_total, 
                        "<value of type uint64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("downloaded"), in_downloaded, 
                        "<value of type uint64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result, 
                        "<value of type BackgroundFetchResult>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("failure_reason"), in_failure_reason, 
                        "<value of type BackgroundFetchFailureReason>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kBackgroundFetchRegistrationObserver_OnProgress_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BackgroundFetchRegistrationObserver_OnProgress_Params_Data> params(
          message);
  params.Allocate();
  params->upload_total = in_upload_total;
  params->uploaded = in_uploaded;
  params->download_total = in_download_total;
  params->downloaded = in_downloaded;
  mojo::internal::Serialize<::blink::mojom::BackgroundFetchResult>(
      in_result, &params->result);
  mojo::internal::Serialize<::blink::mojom::BackgroundFetchFailureReason>(
      in_failure_reason, &params->failure_reason);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BackgroundFetchRegistrationObserver::Name_);
  message.set_method_name("OnProgress");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void BackgroundFetchRegistrationObserverProxy::OnRecordsUnavailable(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::BackgroundFetchRegistrationObserver::OnRecordsUnavailable");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kBackgroundFetchRegistrationObserver_OnRecordsUnavailable_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BackgroundFetchRegistrationObserver_OnRecordsUnavailable_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BackgroundFetchRegistrationObserver::Name_);
  message.set_method_name("OnRecordsUnavailable");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void BackgroundFetchRegistrationObserverProxy::OnRequestCompleted(
    ::blink::mojom::blink::FetchAPIRequestPtr in_request, ::blink::mojom::blink::FetchAPIResponsePtr in_response) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::BackgroundFetchRegistrationObserver::OnRequestCompleted", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request"), in_request, 
                        "<value of type ::blink::mojom::blink::FetchAPIRequestPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("response"), in_response, 
                        "<value of type ::blink::mojom::blink::FetchAPIResponsePtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kBackgroundFetchRegistrationObserver_OnRequestCompleted_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BackgroundFetchRegistrationObserver_OnRequestCompleted_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->request)::BaseType> request_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::FetchAPIRequestDataView>(
      in_request, request_fragment);
  params->request.Set(
      request_fragment.is_null() ? nullptr : request_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->request.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null request in BackgroundFetchRegistrationObserver.OnRequestCompleted request");
  mojo::internal::MessageFragment<
      typename decltype(params->response)::BaseType> response_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::FetchAPIResponseDataView>(
      in_response, response_fragment);
  params->response.Set(
      response_fragment.is_null() ? nullptr : response_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BackgroundFetchRegistrationObserver::Name_);
  message.set_method_name("OnRequestCompleted");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool BackgroundFetchRegistrationObserverStubDispatch::Accept(
    BackgroundFetchRegistrationObserver* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kBackgroundFetchRegistrationObserver_OnProgress_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::BackgroundFetchRegistrationObserver::OnProgress",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::BackgroundFetchRegistrationObserver::OnProgress");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::BackgroundFetchRegistrationObserver_OnProgress_Params_Data* params =
          reinterpret_cast<internal::BackgroundFetchRegistrationObserver_OnProgress_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      uint64_t p_upload_total{};
      uint64_t p_uploaded{};
      uint64_t p_download_total{};
      uint64_t p_downloaded{};
      BackgroundFetchResult p_result{};
      BackgroundFetchFailureReason p_failure_reason{};
      BackgroundFetchRegistrationObserver_OnProgress_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_upload_total = input_data_view.upload_total();
      if (success)
        p_uploaded = input_data_view.uploaded();
      if (success)
        p_download_total = input_data_view.download_total();
      if (success)
        p_downloaded = input_data_view.downloaded();
      if (success && !input_data_view.ReadResult(&p_result))
        success = false;
      if (success && !input_data_view.ReadFailureReason(&p_failure_reason))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BackgroundFetchRegistrationObserver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnProgress(
std::move(p_upload_total), 
std::move(p_uploaded), 
std::move(p_download_total), 
std::move(p_downloaded), 
std::move(p_result), 
std::move(p_failure_reason));
      return true;
    }
    case internal::kBackgroundFetchRegistrationObserver_OnRecordsUnavailable_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::BackgroundFetchRegistrationObserver::OnRecordsUnavailable",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::BackgroundFetchRegistrationObserver::OnRecordsUnavailable");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::BackgroundFetchRegistrationObserver_OnRecordsUnavailable_Params_Data* params =
          reinterpret_cast<internal::BackgroundFetchRegistrationObserver_OnRecordsUnavailable_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      BackgroundFetchRegistrationObserver_OnRecordsUnavailable_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BackgroundFetchRegistrationObserver::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnRecordsUnavailable();
      return true;
    }
    case internal::kBackgroundFetchRegistrationObserver_OnRequestCompleted_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::BackgroundFetchRegistrationObserver::OnRequestCompleted",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::BackgroundFetchRegistrationObserver::OnRequestCompleted");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::BackgroundFetchRegistrationObserver_OnRequestCompleted_Params_Data* params =
          reinterpret_cast<internal::BackgroundFetchRegistrationObserver_OnRequestCompleted_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::blink::FetchAPIRequestPtr p_request{};
      ::blink::mojom::blink::FetchAPIResponsePtr p_response{};
      BackgroundFetchRegistrationObserver_OnRequestCompleted_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRequest(&p_request))
        success = false;
      if (success && !input_data_view.ReadResponse(&p_response))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BackgroundFetchRegistrationObserver::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnRequestCompleted(
std::move(p_request), 
std::move(p_response));
      return true;
    }
  }
  return false;
}

// static
bool BackgroundFetchRegistrationObserverStubDispatch::AcceptWithResponder(
    BackgroundFetchRegistrationObserver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kBackgroundFetchRegistrationObserver_OnProgress_Name: {
      break;
    }
    case internal::kBackgroundFetchRegistrationObserver_OnRecordsUnavailable_Name: {
      break;
    }
    case internal::kBackgroundFetchRegistrationObserver_OnRequestCompleted_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kBackgroundFetchRegistrationObserverValidationInfo[] = {
    {&internal::BackgroundFetchRegistrationObserver_OnProgress_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::BackgroundFetchRegistrationObserver_OnRecordsUnavailable_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::BackgroundFetchRegistrationObserver_OnRequestCompleted_Params_Data::Validate,
     nullptr /* no response */},
};

bool BackgroundFetchRegistrationObserverRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::BackgroundFetchRegistrationObserver::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kBackgroundFetchRegistrationObserverValidationInfo);
}

const char BackgroundFetchService::Name_[] = "blink.mojom.BackgroundFetchService";

class BackgroundFetchService_Fetch_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  BackgroundFetchService_Fetch_ForwardToCallback(
      BackgroundFetchService::FetchCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  BackgroundFetchService::FetchCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(BackgroundFetchService_Fetch_ForwardToCallback);
};

class BackgroundFetchService_GetRegistration_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  BackgroundFetchService_GetRegistration_ForwardToCallback(
      BackgroundFetchService::GetRegistrationCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  BackgroundFetchService::GetRegistrationCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(BackgroundFetchService_GetRegistration_ForwardToCallback);
};

class BackgroundFetchService_GetDeveloperIds_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  BackgroundFetchService_GetDeveloperIds_ForwardToCallback(
      BackgroundFetchService::GetDeveloperIdsCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  BackgroundFetchService::GetDeveloperIdsCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(BackgroundFetchService_GetDeveloperIds_ForwardToCallback);
};

class BackgroundFetchService_GetIconDisplaySize_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  BackgroundFetchService_GetIconDisplaySize_ForwardToCallback(
      BackgroundFetchService::GetIconDisplaySizeCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  BackgroundFetchService::GetIconDisplaySizeCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(BackgroundFetchService_GetIconDisplaySize_ForwardToCallback);
};

BackgroundFetchServiceProxy::BackgroundFetchServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void BackgroundFetchServiceProxy::Fetch(
    int64_t in_service_worker_registration_id, const WTF::String& in_developer_id, WTF::Vector<::blink::mojom::blink::FetchAPIRequestPtr> in_requests, BackgroundFetchOptionsPtr in_options, const ::SkBitmap& in_icon, BackgroundFetchUkmDataPtr in_ukm_data, FetchCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::BackgroundFetchService::Fetch", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("service_worker_registration_id"), in_service_worker_registration_id, 
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("developer_id"), in_developer_id, 
                        "<value of type const WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("requests"), in_requests, 
                        "<value of type WTF::Vector<::blink::mojom::blink::FetchAPIRequestPtr>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options, 
                        "<value of type BackgroundFetchOptionsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("icon"), in_icon, 
                        "<value of type const ::SkBitmap&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("ukm_data"), in_ukm_data, 
                        "<value of type BackgroundFetchUkmDataPtr>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kBackgroundFetchService_Fetch_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BackgroundFetchService_Fetch_Params_Data> params(
          message);
  params.Allocate();
  params->service_worker_registration_id = in_service_worker_registration_id;
  mojo::internal::MessageFragment<
      typename decltype(params->developer_id)::BaseType> developer_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_developer_id, developer_id_fragment);
  params->developer_id.Set(
      developer_id_fragment.is_null() ? nullptr : developer_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->developer_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null developer_id in BackgroundFetchService.Fetch request");
  mojo::internal::MessageFragment<
      typename decltype(params->requests)::BaseType>
      requests_fragment(params.message());
  const mojo::internal::ContainerValidateParams requests_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::FetchAPIRequestDataView>>(
      in_requests, requests_fragment, &requests_validate_params);
  params->requests.Set(
      requests_fragment.is_null() ? nullptr : requests_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->requests.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null requests in BackgroundFetchService.Fetch request");
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::BackgroundFetchOptionsDataView>(
      in_options, options_fragment);
  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->options.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null options in BackgroundFetchService.Fetch request");
  mojo::internal::MessageFragment<
      typename decltype(params->icon)::BaseType> icon_fragment(
          params.message());
  mojo::internal::Serialize<::skia::mojom::BitmapN32DataView>(
      in_icon, icon_fragment);
  params->icon.Set(
      icon_fragment.is_null() ? nullptr : icon_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->ukm_data)::BaseType> ukm_data_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::BackgroundFetchUkmDataDataView>(
      in_ukm_data, ukm_data_fragment);
  params->ukm_data.Set(
      ukm_data_fragment.is_null() ? nullptr : ukm_data_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->ukm_data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null ukm_data in BackgroundFetchService.Fetch request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BackgroundFetchService::Name_);
  message.set_method_name("Fetch");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new BackgroundFetchService_Fetch_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void BackgroundFetchServiceProxy::GetRegistration(
    int64_t in_service_worker_registration_id, const WTF::String& in_developer_id, GetRegistrationCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::BackgroundFetchService::GetRegistration", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("service_worker_registration_id"), in_service_worker_registration_id, 
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("developer_id"), in_developer_id, 
                        "<value of type const WTF::String&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kBackgroundFetchService_GetRegistration_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BackgroundFetchService_GetRegistration_Params_Data> params(
          message);
  params.Allocate();
  params->service_worker_registration_id = in_service_worker_registration_id;
  mojo::internal::MessageFragment<
      typename decltype(params->developer_id)::BaseType> developer_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_developer_id, developer_id_fragment);
  params->developer_id.Set(
      developer_id_fragment.is_null() ? nullptr : developer_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->developer_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null developer_id in BackgroundFetchService.GetRegistration request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BackgroundFetchService::Name_);
  message.set_method_name("GetRegistration");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new BackgroundFetchService_GetRegistration_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void BackgroundFetchServiceProxy::GetDeveloperIds(
    int64_t in_service_worker_registration_id, GetDeveloperIdsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::BackgroundFetchService::GetDeveloperIds", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("service_worker_registration_id"), in_service_worker_registration_id, 
                        "<value of type int64_t>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kBackgroundFetchService_GetDeveloperIds_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BackgroundFetchService_GetDeveloperIds_Params_Data> params(
          message);
  params.Allocate();
  params->service_worker_registration_id = in_service_worker_registration_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BackgroundFetchService::Name_);
  message.set_method_name("GetDeveloperIds");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new BackgroundFetchService_GetDeveloperIds_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void BackgroundFetchServiceProxy::GetIconDisplaySize(
    GetIconDisplaySizeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::BackgroundFetchService::GetIconDisplaySize");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kBackgroundFetchService_GetIconDisplaySize_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BackgroundFetchService_GetIconDisplaySize_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BackgroundFetchService::Name_);
  message.set_method_name("GetIconDisplaySize");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new BackgroundFetchService_GetIconDisplaySize_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class BackgroundFetchService_Fetch_ProxyToResponder {
 public:
  static BackgroundFetchService::FetchCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<BackgroundFetchService_Fetch_ProxyToResponder> proxy(
        new BackgroundFetchService_Fetch_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&BackgroundFetchService_Fetch_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~BackgroundFetchService_Fetch_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  BackgroundFetchService_Fetch_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "BackgroundFetchService::FetchCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      BackgroundFetchError in_error, BackgroundFetchRegistrationPtr in_registration);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(BackgroundFetchService_Fetch_ProxyToResponder);
};

bool BackgroundFetchService_Fetch_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::BackgroundFetchService::FetchCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::BackgroundFetchService_Fetch_ResponseParams_Data* params =
      reinterpret_cast<
          internal::BackgroundFetchService_Fetch_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  BackgroundFetchError p_error{};
  BackgroundFetchRegistrationPtr p_registration{};
  BackgroundFetchService_Fetch_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (success && !input_data_view.ReadRegistration(&p_registration))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        BackgroundFetchService::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_error), 
std::move(p_registration));
  return true;
}

void BackgroundFetchService_Fetch_ProxyToResponder::Run(
    BackgroundFetchError in_error, BackgroundFetchRegistrationPtr in_registration) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::BackgroundFetchService::FetchCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error, 
                        "<value of type BackgroundFetchError>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("registration"), in_registration, 
                        "<value of type BackgroundFetchRegistrationPtr>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kBackgroundFetchService_Fetch_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BackgroundFetchService_Fetch_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::BackgroundFetchError>(
      in_error, &params->error);
  mojo::internal::MessageFragment<
      typename decltype(params->registration)::BaseType> registration_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::BackgroundFetchRegistrationDataView>(
      in_registration, registration_fragment);
  params->registration.Set(
      registration_fragment.is_null() ? nullptr : registration_fragment.data());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::BackgroundFetchService::FetchCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BackgroundFetchService::Name_);
  message.set_method_name("Fetch");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class BackgroundFetchService_GetRegistration_ProxyToResponder {
 public:
  static BackgroundFetchService::GetRegistrationCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<BackgroundFetchService_GetRegistration_ProxyToResponder> proxy(
        new BackgroundFetchService_GetRegistration_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&BackgroundFetchService_GetRegistration_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~BackgroundFetchService_GetRegistration_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  BackgroundFetchService_GetRegistration_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "BackgroundFetchService::GetRegistrationCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      BackgroundFetchError in_error, BackgroundFetchRegistrationPtr in_registration);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(BackgroundFetchService_GetRegistration_ProxyToResponder);
};

bool BackgroundFetchService_GetRegistration_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::BackgroundFetchService::GetRegistrationCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::BackgroundFetchService_GetRegistration_ResponseParams_Data* params =
      reinterpret_cast<
          internal::BackgroundFetchService_GetRegistration_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  BackgroundFetchError p_error{};
  BackgroundFetchRegistrationPtr p_registration{};
  BackgroundFetchService_GetRegistration_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (success && !input_data_view.ReadRegistration(&p_registration))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        BackgroundFetchService::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_error), 
std::move(p_registration));
  return true;
}

void BackgroundFetchService_GetRegistration_ProxyToResponder::Run(
    BackgroundFetchError in_error, BackgroundFetchRegistrationPtr in_registration) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::BackgroundFetchService::GetRegistrationCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error, 
                        "<value of type BackgroundFetchError>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("registration"), in_registration, 
                        "<value of type BackgroundFetchRegistrationPtr>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kBackgroundFetchService_GetRegistration_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BackgroundFetchService_GetRegistration_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::BackgroundFetchError>(
      in_error, &params->error);
  mojo::internal::MessageFragment<
      typename decltype(params->registration)::BaseType> registration_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::BackgroundFetchRegistrationDataView>(
      in_registration, registration_fragment);
  params->registration.Set(
      registration_fragment.is_null() ? nullptr : registration_fragment.data());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::BackgroundFetchService::GetRegistrationCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BackgroundFetchService::Name_);
  message.set_method_name("GetRegistration");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class BackgroundFetchService_GetDeveloperIds_ProxyToResponder {
 public:
  static BackgroundFetchService::GetDeveloperIdsCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<BackgroundFetchService_GetDeveloperIds_ProxyToResponder> proxy(
        new BackgroundFetchService_GetDeveloperIds_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&BackgroundFetchService_GetDeveloperIds_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~BackgroundFetchService_GetDeveloperIds_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  BackgroundFetchService_GetDeveloperIds_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "BackgroundFetchService::GetDeveloperIdsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      BackgroundFetchError in_error, const WTF::Vector<WTF::String>& in_developer_ids);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(BackgroundFetchService_GetDeveloperIds_ProxyToResponder);
};

bool BackgroundFetchService_GetDeveloperIds_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::BackgroundFetchService::GetDeveloperIdsCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::BackgroundFetchService_GetDeveloperIds_ResponseParams_Data* params =
      reinterpret_cast<
          internal::BackgroundFetchService_GetDeveloperIds_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  BackgroundFetchError p_error{};
  WTF::Vector<WTF::String> p_developer_ids{};
  BackgroundFetchService_GetDeveloperIds_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (success && !input_data_view.ReadDeveloperIds(&p_developer_ids))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        BackgroundFetchService::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_error), 
std::move(p_developer_ids));
  return true;
}

void BackgroundFetchService_GetDeveloperIds_ProxyToResponder::Run(
    BackgroundFetchError in_error, const WTF::Vector<WTF::String>& in_developer_ids) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::BackgroundFetchService::GetDeveloperIdsCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error, 
                        "<value of type BackgroundFetchError>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("developer_ids"), in_developer_ids, 
                        "<value of type const WTF::Vector<WTF::String>&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kBackgroundFetchService_GetDeveloperIds_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BackgroundFetchService_GetDeveloperIds_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::BackgroundFetchError>(
      in_error, &params->error);
  mojo::internal::MessageFragment<
      typename decltype(params->developer_ids)::BaseType>
      developer_ids_fragment(params.message());
  const mojo::internal::ContainerValidateParams developer_ids_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_developer_ids, developer_ids_fragment, &developer_ids_validate_params);
  params->developer_ids.Set(
      developer_ids_fragment.is_null() ? nullptr : developer_ids_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->developer_ids.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null developer_ids in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::BackgroundFetchService::GetDeveloperIdsCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BackgroundFetchService::Name_);
  message.set_method_name("GetDeveloperIds");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class BackgroundFetchService_GetIconDisplaySize_ProxyToResponder {
 public:
  static BackgroundFetchService::GetIconDisplaySizeCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<BackgroundFetchService_GetIconDisplaySize_ProxyToResponder> proxy(
        new BackgroundFetchService_GetIconDisplaySize_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&BackgroundFetchService_GetIconDisplaySize_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~BackgroundFetchService_GetIconDisplaySize_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  BackgroundFetchService_GetIconDisplaySize_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "BackgroundFetchService::GetIconDisplaySizeCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::gfx::Size& in_icon_size_pixels);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(BackgroundFetchService_GetIconDisplaySize_ProxyToResponder);
};

bool BackgroundFetchService_GetIconDisplaySize_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::BackgroundFetchService::GetIconDisplaySizeCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::BackgroundFetchService_GetIconDisplaySize_ResponseParams_Data* params =
      reinterpret_cast<
          internal::BackgroundFetchService_GetIconDisplaySize_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::gfx::Size p_icon_size_pixels{};
  BackgroundFetchService_GetIconDisplaySize_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadIconSizePixels(&p_icon_size_pixels))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        BackgroundFetchService::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_icon_size_pixels));
  return true;
}

void BackgroundFetchService_GetIconDisplaySize_ProxyToResponder::Run(
    const ::gfx::Size& in_icon_size_pixels) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::BackgroundFetchService::GetIconDisplaySizeCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("icon_size_pixels"), in_icon_size_pixels, 
                        "<value of type const ::gfx::Size&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kBackgroundFetchService_GetIconDisplaySize_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BackgroundFetchService_GetIconDisplaySize_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->icon_size_pixels)::BaseType> icon_size_pixels_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
      in_icon_size_pixels, icon_size_pixels_fragment);
  params->icon_size_pixels.Set(
      icon_size_pixels_fragment.is_null() ? nullptr : icon_size_pixels_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->icon_size_pixels.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null icon_size_pixels in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::BackgroundFetchService::GetIconDisplaySizeCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BackgroundFetchService::Name_);
  message.set_method_name("GetIconDisplaySize");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool BackgroundFetchServiceStubDispatch::Accept(
    BackgroundFetchService* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kBackgroundFetchService_Fetch_Name: {
      break;
    }
    case internal::kBackgroundFetchService_GetRegistration_Name: {
      break;
    }
    case internal::kBackgroundFetchService_GetDeveloperIds_Name: {
      break;
    }
    case internal::kBackgroundFetchService_GetIconDisplaySize_Name: {
      break;
    }
  }
  return false;
}

// static
bool BackgroundFetchServiceStubDispatch::AcceptWithResponder(
    BackgroundFetchService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kBackgroundFetchService_Fetch_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::BackgroundFetchService::Fetch",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::BackgroundFetchService::Fetch");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::BackgroundFetchService_Fetch_Params_Data* params =
          reinterpret_cast<
              internal::BackgroundFetchService_Fetch_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      int64_t p_service_worker_registration_id{};
      WTF::String p_developer_id{};
      WTF::Vector<::blink::mojom::blink::FetchAPIRequestPtr> p_requests{};
      BackgroundFetchOptionsPtr p_options{};
      ::SkBitmap p_icon{};
      BackgroundFetchUkmDataPtr p_ukm_data{};
      BackgroundFetchService_Fetch_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_service_worker_registration_id = input_data_view.service_worker_registration_id();
      if (success && !input_data_view.ReadDeveloperId(&p_developer_id))
        success = false;
      if (success && !input_data_view.ReadRequests(&p_requests))
        success = false;
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (success && !input_data_view.ReadIcon(&p_icon))
        success = false;
      if (success && !input_data_view.ReadUkmData(&p_ukm_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BackgroundFetchService::Name_, 0, false);
        return false;
      }
      BackgroundFetchService::FetchCallback callback =
          BackgroundFetchService_Fetch_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Fetch(
std::move(p_service_worker_registration_id), 
std::move(p_developer_id), 
std::move(p_requests), 
std::move(p_options), 
std::move(p_icon), 
std::move(p_ukm_data), std::move(callback));
      return true;
    }
    case internal::kBackgroundFetchService_GetRegistration_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::BackgroundFetchService::GetRegistration",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::BackgroundFetchService::GetRegistration");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::BackgroundFetchService_GetRegistration_Params_Data* params =
          reinterpret_cast<
              internal::BackgroundFetchService_GetRegistration_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      int64_t p_service_worker_registration_id{};
      WTF::String p_developer_id{};
      BackgroundFetchService_GetRegistration_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_service_worker_registration_id = input_data_view.service_worker_registration_id();
      if (success && !input_data_view.ReadDeveloperId(&p_developer_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BackgroundFetchService::Name_, 1, false);
        return false;
      }
      BackgroundFetchService::GetRegistrationCallback callback =
          BackgroundFetchService_GetRegistration_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetRegistration(
std::move(p_service_worker_registration_id), 
std::move(p_developer_id), std::move(callback));
      return true;
    }
    case internal::kBackgroundFetchService_GetDeveloperIds_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::BackgroundFetchService::GetDeveloperIds",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::BackgroundFetchService::GetDeveloperIds");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::BackgroundFetchService_GetDeveloperIds_Params_Data* params =
          reinterpret_cast<
              internal::BackgroundFetchService_GetDeveloperIds_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      int64_t p_service_worker_registration_id{};
      BackgroundFetchService_GetDeveloperIds_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_service_worker_registration_id = input_data_view.service_worker_registration_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BackgroundFetchService::Name_, 2, false);
        return false;
      }
      BackgroundFetchService::GetDeveloperIdsCallback callback =
          BackgroundFetchService_GetDeveloperIds_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetDeveloperIds(
std::move(p_service_worker_registration_id), std::move(callback));
      return true;
    }
    case internal::kBackgroundFetchService_GetIconDisplaySize_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::BackgroundFetchService::GetIconDisplaySize",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::BackgroundFetchService::GetIconDisplaySize");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::BackgroundFetchService_GetIconDisplaySize_Params_Data* params =
          reinterpret_cast<
              internal::BackgroundFetchService_GetIconDisplaySize_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      BackgroundFetchService_GetIconDisplaySize_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BackgroundFetchService::Name_, 3, false);
        return false;
      }
      BackgroundFetchService::GetIconDisplaySizeCallback callback =
          BackgroundFetchService_GetIconDisplaySize_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetIconDisplaySize(std::move(callback));
      return true;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kBackgroundFetchServiceValidationInfo[] = {
    {&internal::BackgroundFetchService_Fetch_Params_Data::Validate,
     &internal::BackgroundFetchService_Fetch_ResponseParams_Data::Validate},
    {&internal::BackgroundFetchService_GetRegistration_Params_Data::Validate,
     &internal::BackgroundFetchService_GetRegistration_ResponseParams_Data::Validate},
    {&internal::BackgroundFetchService_GetDeveloperIds_Params_Data::Validate,
     &internal::BackgroundFetchService_GetDeveloperIds_ResponseParams_Data::Validate},
    {&internal::BackgroundFetchService_GetIconDisplaySize_Params_Data::Validate,
     &internal::BackgroundFetchService_GetIconDisplaySize_ResponseParams_Data::Validate},
};

bool BackgroundFetchServiceRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::BackgroundFetchService::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kBackgroundFetchServiceValidationInfo);
}

bool BackgroundFetchServiceResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::BackgroundFetchService::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kBackgroundFetchServiceValidationInfo);
}
const char BackgroundFetchRegistrationService::Name_[] = "blink.mojom.BackgroundFetchRegistrationService";

class BackgroundFetchRegistrationService_UpdateUI_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  BackgroundFetchRegistrationService_UpdateUI_ForwardToCallback(
      BackgroundFetchRegistrationService::UpdateUICallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  BackgroundFetchRegistrationService::UpdateUICallback callback_;
  DISALLOW_COPY_AND_ASSIGN(BackgroundFetchRegistrationService_UpdateUI_ForwardToCallback);
};

class BackgroundFetchRegistrationService_Abort_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  BackgroundFetchRegistrationService_Abort_ForwardToCallback(
      BackgroundFetchRegistrationService::AbortCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  BackgroundFetchRegistrationService::AbortCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(BackgroundFetchRegistrationService_Abort_ForwardToCallback);
};

class BackgroundFetchRegistrationService_MatchRequests_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  BackgroundFetchRegistrationService_MatchRequests_ForwardToCallback(
      BackgroundFetchRegistrationService::MatchRequestsCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  BackgroundFetchRegistrationService::MatchRequestsCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(BackgroundFetchRegistrationService_MatchRequests_ForwardToCallback);
};

BackgroundFetchRegistrationServiceProxy::BackgroundFetchRegistrationServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void BackgroundFetchRegistrationServiceProxy::UpdateUI(
    const WTF::String& in_title, const ::SkBitmap& in_icon, UpdateUICallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::BackgroundFetchRegistrationService::UpdateUI", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("title"), in_title, 
                        "<value of type const WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("icon"), in_icon, 
                        "<value of type const ::SkBitmap&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kBackgroundFetchRegistrationService_UpdateUI_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BackgroundFetchRegistrationService_UpdateUI_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->title)::BaseType> title_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_title, title_fragment);
  params->title.Set(
      title_fragment.is_null() ? nullptr : title_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->icon)::BaseType> icon_fragment(
          params.message());
  mojo::internal::Serialize<::skia::mojom::BitmapN32DataView>(
      in_icon, icon_fragment);
  params->icon.Set(
      icon_fragment.is_null() ? nullptr : icon_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BackgroundFetchRegistrationService::Name_);
  message.set_method_name("UpdateUI");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new BackgroundFetchRegistrationService_UpdateUI_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void BackgroundFetchRegistrationServiceProxy::Abort(
    AbortCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::BackgroundFetchRegistrationService::Abort");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kBackgroundFetchRegistrationService_Abort_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BackgroundFetchRegistrationService_Abort_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BackgroundFetchRegistrationService::Name_);
  message.set_method_name("Abort");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new BackgroundFetchRegistrationService_Abort_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void BackgroundFetchRegistrationServiceProxy::MatchRequests(
    ::blink::mojom::blink::FetchAPIRequestPtr in_request_to_match, ::blink::mojom::blink::CacheQueryOptionsPtr in_cache_query_options, bool in_match_all, MatchRequestsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::BackgroundFetchRegistrationService::MatchRequests", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_to_match"), in_request_to_match, 
                        "<value of type ::blink::mojom::blink::FetchAPIRequestPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cache_query_options"), in_cache_query_options, 
                        "<value of type ::blink::mojom::blink::CacheQueryOptionsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("match_all"), in_match_all, 
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kBackgroundFetchRegistrationService_MatchRequests_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BackgroundFetchRegistrationService_MatchRequests_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->request_to_match)::BaseType> request_to_match_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::FetchAPIRequestDataView>(
      in_request_to_match, request_to_match_fragment);
  params->request_to_match.Set(
      request_to_match_fragment.is_null() ? nullptr : request_to_match_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->cache_query_options)::BaseType> cache_query_options_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::CacheQueryOptionsDataView>(
      in_cache_query_options, cache_query_options_fragment);
  params->cache_query_options.Set(
      cache_query_options_fragment.is_null() ? nullptr : cache_query_options_fragment.data());
  params->match_all = in_match_all;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BackgroundFetchRegistrationService::Name_);
  message.set_method_name("MatchRequests");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new BackgroundFetchRegistrationService_MatchRequests_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void BackgroundFetchRegistrationServiceProxy::AddRegistrationObserver(
    ::mojo::PendingRemote<BackgroundFetchRegistrationObserver> in_observer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::BackgroundFetchRegistrationService::AddRegistrationObserver", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("observer"), in_observer, 
                        "<value of type ::mojo::PendingRemote<BackgroundFetchRegistrationObserver>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kBackgroundFetchRegistrationService_AddRegistrationObserver_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BackgroundFetchRegistrationService_AddRegistrationObserver_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::BackgroundFetchRegistrationObserverInterfaceBase>>(
      in_observer, &params->observer, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->observer),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid observer in BackgroundFetchRegistrationService.AddRegistrationObserver request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BackgroundFetchRegistrationService::Name_);
  message.set_method_name("AddRegistrationObserver");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class BackgroundFetchRegistrationService_UpdateUI_ProxyToResponder {
 public:
  static BackgroundFetchRegistrationService::UpdateUICallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<BackgroundFetchRegistrationService_UpdateUI_ProxyToResponder> proxy(
        new BackgroundFetchRegistrationService_UpdateUI_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&BackgroundFetchRegistrationService_UpdateUI_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~BackgroundFetchRegistrationService_UpdateUI_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  BackgroundFetchRegistrationService_UpdateUI_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "BackgroundFetchRegistrationService::UpdateUICallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      BackgroundFetchError in_error);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(BackgroundFetchRegistrationService_UpdateUI_ProxyToResponder);
};

bool BackgroundFetchRegistrationService_UpdateUI_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::BackgroundFetchRegistrationService::UpdateUICallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::BackgroundFetchRegistrationService_UpdateUI_ResponseParams_Data* params =
      reinterpret_cast<
          internal::BackgroundFetchRegistrationService_UpdateUI_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  BackgroundFetchError p_error{};
  BackgroundFetchRegistrationService_UpdateUI_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        BackgroundFetchRegistrationService::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_error));
  return true;
}

void BackgroundFetchRegistrationService_UpdateUI_ProxyToResponder::Run(
    BackgroundFetchError in_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::BackgroundFetchRegistrationService::UpdateUICallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error, 
                        "<value of type BackgroundFetchError>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kBackgroundFetchRegistrationService_UpdateUI_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BackgroundFetchRegistrationService_UpdateUI_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::BackgroundFetchError>(
      in_error, &params->error);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::BackgroundFetchRegistrationService::UpdateUICallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BackgroundFetchRegistrationService::Name_);
  message.set_method_name("UpdateUI");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class BackgroundFetchRegistrationService_Abort_ProxyToResponder {
 public:
  static BackgroundFetchRegistrationService::AbortCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<BackgroundFetchRegistrationService_Abort_ProxyToResponder> proxy(
        new BackgroundFetchRegistrationService_Abort_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&BackgroundFetchRegistrationService_Abort_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~BackgroundFetchRegistrationService_Abort_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  BackgroundFetchRegistrationService_Abort_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "BackgroundFetchRegistrationService::AbortCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      BackgroundFetchError in_error);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(BackgroundFetchRegistrationService_Abort_ProxyToResponder);
};

bool BackgroundFetchRegistrationService_Abort_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::BackgroundFetchRegistrationService::AbortCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::BackgroundFetchRegistrationService_Abort_ResponseParams_Data* params =
      reinterpret_cast<
          internal::BackgroundFetchRegistrationService_Abort_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  BackgroundFetchError p_error{};
  BackgroundFetchRegistrationService_Abort_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        BackgroundFetchRegistrationService::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_error));
  return true;
}

void BackgroundFetchRegistrationService_Abort_ProxyToResponder::Run(
    BackgroundFetchError in_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::BackgroundFetchRegistrationService::AbortCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error, 
                        "<value of type BackgroundFetchError>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kBackgroundFetchRegistrationService_Abort_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BackgroundFetchRegistrationService_Abort_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::BackgroundFetchError>(
      in_error, &params->error);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::BackgroundFetchRegistrationService::AbortCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BackgroundFetchRegistrationService::Name_);
  message.set_method_name("Abort");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class BackgroundFetchRegistrationService_MatchRequests_ProxyToResponder {
 public:
  static BackgroundFetchRegistrationService::MatchRequestsCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<BackgroundFetchRegistrationService_MatchRequests_ProxyToResponder> proxy(
        new BackgroundFetchRegistrationService_MatchRequests_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&BackgroundFetchRegistrationService_MatchRequests_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~BackgroundFetchRegistrationService_MatchRequests_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  BackgroundFetchRegistrationService_MatchRequests_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "BackgroundFetchRegistrationService::MatchRequestsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      WTF::Vector<BackgroundFetchSettledFetchPtr> in_fetches);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(BackgroundFetchRegistrationService_MatchRequests_ProxyToResponder);
};

bool BackgroundFetchRegistrationService_MatchRequests_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::BackgroundFetchRegistrationService::MatchRequestsCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::BackgroundFetchRegistrationService_MatchRequests_ResponseParams_Data* params =
      reinterpret_cast<
          internal::BackgroundFetchRegistrationService_MatchRequests_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  WTF::Vector<BackgroundFetchSettledFetchPtr> p_fetches{};
  BackgroundFetchRegistrationService_MatchRequests_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadFetches(&p_fetches))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        BackgroundFetchRegistrationService::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_fetches));
  return true;
}

void BackgroundFetchRegistrationService_MatchRequests_ProxyToResponder::Run(
    WTF::Vector<BackgroundFetchSettledFetchPtr> in_fetches) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::BackgroundFetchRegistrationService::MatchRequestsCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("fetches"), in_fetches, 
                        "<value of type WTF::Vector<BackgroundFetchSettledFetchPtr>>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kBackgroundFetchRegistrationService_MatchRequests_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BackgroundFetchRegistrationService_MatchRequests_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->fetches)::BaseType>
      fetches_fragment(params.message());
  const mojo::internal::ContainerValidateParams fetches_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::BackgroundFetchSettledFetchDataView>>(
      in_fetches, fetches_fragment, &fetches_validate_params);
  params->fetches.Set(
      fetches_fragment.is_null() ? nullptr : fetches_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->fetches.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null fetches in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::BackgroundFetchRegistrationService::MatchRequestsCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BackgroundFetchRegistrationService::Name_);
  message.set_method_name("MatchRequests");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool BackgroundFetchRegistrationServiceStubDispatch::Accept(
    BackgroundFetchRegistrationService* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kBackgroundFetchRegistrationService_UpdateUI_Name: {
      break;
    }
    case internal::kBackgroundFetchRegistrationService_Abort_Name: {
      break;
    }
    case internal::kBackgroundFetchRegistrationService_MatchRequests_Name: {
      break;
    }
    case internal::kBackgroundFetchRegistrationService_AddRegistrationObserver_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::BackgroundFetchRegistrationService::AddRegistrationObserver",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::BackgroundFetchRegistrationService::AddRegistrationObserver");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::BackgroundFetchRegistrationService_AddRegistrationObserver_Params_Data* params =
          reinterpret_cast<internal::BackgroundFetchRegistrationService_AddRegistrationObserver_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<BackgroundFetchRegistrationObserver> p_observer{};
      BackgroundFetchRegistrationService_AddRegistrationObserver_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_observer =
            input_data_view.TakeObserver<decltype(p_observer)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BackgroundFetchRegistrationService::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddRegistrationObserver(
std::move(p_observer));
      return true;
    }
  }
  return false;
}

// static
bool BackgroundFetchRegistrationServiceStubDispatch::AcceptWithResponder(
    BackgroundFetchRegistrationService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kBackgroundFetchRegistrationService_UpdateUI_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::BackgroundFetchRegistrationService::UpdateUI",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::BackgroundFetchRegistrationService::UpdateUI");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::BackgroundFetchRegistrationService_UpdateUI_Params_Data* params =
          reinterpret_cast<
              internal::BackgroundFetchRegistrationService_UpdateUI_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      WTF::String p_title{};
      ::SkBitmap p_icon{};
      BackgroundFetchRegistrationService_UpdateUI_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTitle(&p_title))
        success = false;
      if (success && !input_data_view.ReadIcon(&p_icon))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BackgroundFetchRegistrationService::Name_, 0, false);
        return false;
      }
      BackgroundFetchRegistrationService::UpdateUICallback callback =
          BackgroundFetchRegistrationService_UpdateUI_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateUI(
std::move(p_title), 
std::move(p_icon), std::move(callback));
      return true;
    }
    case internal::kBackgroundFetchRegistrationService_Abort_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::BackgroundFetchRegistrationService::Abort",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::BackgroundFetchRegistrationService::Abort");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::BackgroundFetchRegistrationService_Abort_Params_Data* params =
          reinterpret_cast<
              internal::BackgroundFetchRegistrationService_Abort_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      BackgroundFetchRegistrationService_Abort_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BackgroundFetchRegistrationService::Name_, 1, false);
        return false;
      }
      BackgroundFetchRegistrationService::AbortCallback callback =
          BackgroundFetchRegistrationService_Abort_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Abort(std::move(callback));
      return true;
    }
    case internal::kBackgroundFetchRegistrationService_MatchRequests_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::BackgroundFetchRegistrationService::MatchRequests",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::BackgroundFetchRegistrationService::MatchRequests");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::BackgroundFetchRegistrationService_MatchRequests_Params_Data* params =
          reinterpret_cast<
              internal::BackgroundFetchRegistrationService_MatchRequests_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::blink::FetchAPIRequestPtr p_request_to_match{};
      ::blink::mojom::blink::CacheQueryOptionsPtr p_cache_query_options{};
      bool p_match_all{};
      BackgroundFetchRegistrationService_MatchRequests_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRequestToMatch(&p_request_to_match))
        success = false;
      if (success && !input_data_view.ReadCacheQueryOptions(&p_cache_query_options))
        success = false;
      if (success)
        p_match_all = input_data_view.match_all();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BackgroundFetchRegistrationService::Name_, 2, false);
        return false;
      }
      BackgroundFetchRegistrationService::MatchRequestsCallback callback =
          BackgroundFetchRegistrationService_MatchRequests_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MatchRequests(
std::move(p_request_to_match), 
std::move(p_cache_query_options), 
std::move(p_match_all), std::move(callback));
      return true;
    }
    case internal::kBackgroundFetchRegistrationService_AddRegistrationObserver_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kBackgroundFetchRegistrationServiceValidationInfo[] = {
    {&internal::BackgroundFetchRegistrationService_UpdateUI_Params_Data::Validate,
     &internal::BackgroundFetchRegistrationService_UpdateUI_ResponseParams_Data::Validate},
    {&internal::BackgroundFetchRegistrationService_Abort_Params_Data::Validate,
     &internal::BackgroundFetchRegistrationService_Abort_ResponseParams_Data::Validate},
    {&internal::BackgroundFetchRegistrationService_MatchRequests_Params_Data::Validate,
     &internal::BackgroundFetchRegistrationService_MatchRequests_ResponseParams_Data::Validate},
    {&internal::BackgroundFetchRegistrationService_AddRegistrationObserver_Params_Data::Validate,
     nullptr /* no response */},
};

bool BackgroundFetchRegistrationServiceRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::BackgroundFetchRegistrationService::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kBackgroundFetchRegistrationServiceValidationInfo);
}

bool BackgroundFetchRegistrationServiceResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::BackgroundFetchRegistrationService::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kBackgroundFetchRegistrationServiceValidationInfo);
}
}  // namespace blink
}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::blink::BackgroundFetchSettledFetch::DataView, ::blink::mojom::blink::BackgroundFetchSettledFetchPtr>::Read(
    ::blink::mojom::blink::BackgroundFetchSettledFetch::DataView input,
    ::blink::mojom::blink::BackgroundFetchSettledFetchPtr* output) {
  bool success = true;
  ::blink::mojom::blink::BackgroundFetchSettledFetchPtr result(::blink::mojom::blink::BackgroundFetchSettledFetch::New());
  
      if (success && !input.ReadRequest(&result->request))
        success = false;
      if (success && !input.ReadResponse(&result->response))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::BackgroundFetchOptions::DataView, ::blink::mojom::blink::BackgroundFetchOptionsPtr>::Read(
    ::blink::mojom::blink::BackgroundFetchOptions::DataView input,
    ::blink::mojom::blink::BackgroundFetchOptionsPtr* output) {
  bool success = true;
  ::blink::mojom::blink::BackgroundFetchOptionsPtr result(::blink::mojom::blink::BackgroundFetchOptions::New());
  
      if (success && !input.ReadIcons(&result->icons))
        success = false;
      if (success)
        result->download_total = input.download_total();
      if (success && !input.ReadTitle(&result->title))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::BackgroundFetchRegistrationData::DataView, ::blink::mojom::blink::BackgroundFetchRegistrationDataPtr>::Read(
    ::blink::mojom::blink::BackgroundFetchRegistrationData::DataView input,
    ::blink::mojom::blink::BackgroundFetchRegistrationDataPtr* output) {
  bool success = true;
  ::blink::mojom::blink::BackgroundFetchRegistrationDataPtr result(::blink::mojom::blink::BackgroundFetchRegistrationData::New());
  
      if (success && !input.ReadDeveloperId(&result->developer_id))
        success = false;
      if (success)
        result->upload_total = input.upload_total();
      if (success)
        result->uploaded = input.uploaded();
      if (success)
        result->download_total = input.download_total();
      if (success)
        result->downloaded = input.downloaded();
      if (success && !input.ReadResult(&result->result))
        success = false;
      if (success && !input.ReadFailureReason(&result->failure_reason))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::BackgroundFetchRegistration::DataView, ::blink::mojom::blink::BackgroundFetchRegistrationPtr>::Read(
    ::blink::mojom::blink::BackgroundFetchRegistration::DataView input,
    ::blink::mojom::blink::BackgroundFetchRegistrationPtr* output) {
  bool success = true;
  ::blink::mojom::blink::BackgroundFetchRegistrationPtr result(::blink::mojom::blink::BackgroundFetchRegistration::New());
  
      if (success && !input.ReadRegistrationData(&result->registration_data))
        success = false;
      if (success) {
        result->registration_interface =
            input.TakeRegistrationInterface<decltype(result->registration_interface)>();
      }
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::BackgroundFetchUkmData::DataView, ::blink::mojom::blink::BackgroundFetchUkmDataPtr>::Read(
    ::blink::mojom::blink::BackgroundFetchUkmData::DataView input,
    ::blink::mojom::blink::BackgroundFetchUkmDataPtr* output) {
  bool success = true;
  ::blink::mojom::blink::BackgroundFetchUkmDataPtr result(::blink::mojom::blink::BackgroundFetchUkmData::New());
  
      if (success)
        result->ideal_to_chosen_icon_size = input.ideal_to_chosen_icon_size();
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif