// third_party/blink/public/mojom/background_sync/background_sync.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/background_sync/background_sync.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/background_sync/background_sync.mojom-params-data.h"
#include "third_party/blink/public/mojom/background_sync/background_sync.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/background_sync/background_sync.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_BACKGROUND_SYNC_BACKGROUND_SYNC_MOJOM_BLINK_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_BACKGROUND_SYNC_BACKGROUND_SYNC_MOJOM_BLINK_JUMBO_H_
#endif
namespace blink {
namespace mojom {
namespace blink {
SyncRegistrationOptions::SyncRegistrationOptions()
    : tag(""),
      min_interval(-1) {}

SyncRegistrationOptions::SyncRegistrationOptions(
    const WTF::String& tag_in,
    int64_t min_interval_in)
    : tag(std::move(tag_in)),
      min_interval(std::move(min_interval_in)) {}

SyncRegistrationOptions::~SyncRegistrationOptions() = default;
size_t SyncRegistrationOptions::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->tag);
  seed = mojo::internal::WTFHash(seed, this->min_interval);
  return seed;
}

void SyncRegistrationOptions::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tag"), this->tag, 
      "<value of type const WTF::String&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "min_interval"), this->min_interval, 
      "<value of type int64_t>");
}

bool SyncRegistrationOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
BackgroundSyncRegistrationInfo::BackgroundSyncRegistrationInfo()
    : service_worker_registration_id(-1),
      tag(),
      sync_type() {}

BackgroundSyncRegistrationInfo::BackgroundSyncRegistrationInfo(
    int64_t service_worker_registration_id_in,
    const WTF::String& tag_in,
    BackgroundSyncType sync_type_in)
    : service_worker_registration_id(std::move(service_worker_registration_id_in)),
      tag(std::move(tag_in)),
      sync_type(std::move(sync_type_in)) {}

BackgroundSyncRegistrationInfo::~BackgroundSyncRegistrationInfo() = default;
size_t BackgroundSyncRegistrationInfo::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->service_worker_registration_id);
  seed = mojo::internal::WTFHash(seed, this->tag);
  seed = mojo::internal::WTFHash(seed, this->sync_type);
  return seed;
}

void BackgroundSyncRegistrationInfo::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "service_worker_registration_id"), this->service_worker_registration_id, 
      "<value of type int64_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tag"), this->tag, 
      "<value of type const WTF::String&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sync_type"), this->sync_type, 
      "<value of type BackgroundSyncType>");
}

bool BackgroundSyncRegistrationInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char OneShotBackgroundSyncService::Name_[] = "blink.mojom.OneShotBackgroundSyncService";

class OneShotBackgroundSyncService_Register_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  OneShotBackgroundSyncService_Register_ForwardToCallback(
      OneShotBackgroundSyncService::RegisterCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  OneShotBackgroundSyncService::RegisterCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(OneShotBackgroundSyncService_Register_ForwardToCallback);
};

class OneShotBackgroundSyncService_GetRegistrations_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  OneShotBackgroundSyncService_GetRegistrations_ForwardToCallback(
      OneShotBackgroundSyncService::GetRegistrationsCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  OneShotBackgroundSyncService::GetRegistrationsCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(OneShotBackgroundSyncService_GetRegistrations_ForwardToCallback);
};

OneShotBackgroundSyncServiceProxy::OneShotBackgroundSyncServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void OneShotBackgroundSyncServiceProxy::Register(
    SyncRegistrationOptionsPtr in_options, int64_t in_service_worker_registration_id, RegisterCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::OneShotBackgroundSyncService::Register", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options, 
                        "<value of type SyncRegistrationOptionsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("service_worker_registration_id"), in_service_worker_registration_id, 
                        "<value of type int64_t>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kOneShotBackgroundSyncService_Register_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::OneShotBackgroundSyncService_Register_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::SyncRegistrationOptionsDataView>(
      in_options, options_fragment);
  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->options.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null options in OneShotBackgroundSyncService.Register request");
  params->service_worker_registration_id = in_service_worker_registration_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(OneShotBackgroundSyncService::Name_);
  message.set_method_name("Register");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new OneShotBackgroundSyncService_Register_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void OneShotBackgroundSyncServiceProxy::DidResolveRegistration(
    BackgroundSyncRegistrationInfoPtr in_registration_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::OneShotBackgroundSyncService::DidResolveRegistration", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("registration_info"), in_registration_info, 
                        "<value of type BackgroundSyncRegistrationInfoPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kOneShotBackgroundSyncService_DidResolveRegistration_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::OneShotBackgroundSyncService_DidResolveRegistration_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->registration_info)::BaseType> registration_info_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::BackgroundSyncRegistrationInfoDataView>(
      in_registration_info, registration_info_fragment);
  params->registration_info.Set(
      registration_info_fragment.is_null() ? nullptr : registration_info_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->registration_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null registration_info in OneShotBackgroundSyncService.DidResolveRegistration request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(OneShotBackgroundSyncService::Name_);
  message.set_method_name("DidResolveRegistration");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void OneShotBackgroundSyncServiceProxy::GetRegistrations(
    int64_t in_service_worker_registration_id, GetRegistrationsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::OneShotBackgroundSyncService::GetRegistrations", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("service_worker_registration_id"), in_service_worker_registration_id, 
                        "<value of type int64_t>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kOneShotBackgroundSyncService_GetRegistrations_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::OneShotBackgroundSyncService_GetRegistrations_Params_Data> params(
          message);
  params.Allocate();
  params->service_worker_registration_id = in_service_worker_registration_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(OneShotBackgroundSyncService::Name_);
  message.set_method_name("GetRegistrations");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new OneShotBackgroundSyncService_GetRegistrations_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class OneShotBackgroundSyncService_Register_ProxyToResponder {
 public:
  static OneShotBackgroundSyncService::RegisterCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<OneShotBackgroundSyncService_Register_ProxyToResponder> proxy(
        new OneShotBackgroundSyncService_Register_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&OneShotBackgroundSyncService_Register_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~OneShotBackgroundSyncService_Register_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  OneShotBackgroundSyncService_Register_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "OneShotBackgroundSyncService::RegisterCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      BackgroundSyncError in_err, SyncRegistrationOptionsPtr in_options);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(OneShotBackgroundSyncService_Register_ProxyToResponder);
};

bool OneShotBackgroundSyncService_Register_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::OneShotBackgroundSyncService::RegisterCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::OneShotBackgroundSyncService_Register_ResponseParams_Data* params =
      reinterpret_cast<
          internal::OneShotBackgroundSyncService_Register_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  BackgroundSyncError p_err{};
  SyncRegistrationOptionsPtr p_options{};
  OneShotBackgroundSyncService_Register_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadErr(&p_err))
    success = false;
  if (success && !input_data_view.ReadOptions(&p_options))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        OneShotBackgroundSyncService::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_err), 
std::move(p_options));
  return true;
}

void OneShotBackgroundSyncService_Register_ProxyToResponder::Run(
    BackgroundSyncError in_err, SyncRegistrationOptionsPtr in_options) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::OneShotBackgroundSyncService::RegisterCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("err"), in_err, 
                        "<value of type BackgroundSyncError>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options, 
                        "<value of type SyncRegistrationOptionsPtr>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kOneShotBackgroundSyncService_Register_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::OneShotBackgroundSyncService_Register_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::BackgroundSyncError>(
      in_err, &params->err);
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::SyncRegistrationOptionsDataView>(
      in_options, options_fragment);
  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::OneShotBackgroundSyncService::RegisterCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(OneShotBackgroundSyncService::Name_);
  message.set_method_name("Register");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class OneShotBackgroundSyncService_GetRegistrations_ProxyToResponder {
 public:
  static OneShotBackgroundSyncService::GetRegistrationsCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<OneShotBackgroundSyncService_GetRegistrations_ProxyToResponder> proxy(
        new OneShotBackgroundSyncService_GetRegistrations_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&OneShotBackgroundSyncService_GetRegistrations_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~OneShotBackgroundSyncService_GetRegistrations_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  OneShotBackgroundSyncService_GetRegistrations_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "OneShotBackgroundSyncService::GetRegistrationsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      BackgroundSyncError in_err, WTF::Vector<SyncRegistrationOptionsPtr> in_registrations);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(OneShotBackgroundSyncService_GetRegistrations_ProxyToResponder);
};

bool OneShotBackgroundSyncService_GetRegistrations_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::OneShotBackgroundSyncService::GetRegistrationsCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::OneShotBackgroundSyncService_GetRegistrations_ResponseParams_Data* params =
      reinterpret_cast<
          internal::OneShotBackgroundSyncService_GetRegistrations_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  BackgroundSyncError p_err{};
  WTF::Vector<SyncRegistrationOptionsPtr> p_registrations{};
  OneShotBackgroundSyncService_GetRegistrations_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadErr(&p_err))
    success = false;
  if (success && !input_data_view.ReadRegistrations(&p_registrations))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        OneShotBackgroundSyncService::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_err), 
std::move(p_registrations));
  return true;
}

void OneShotBackgroundSyncService_GetRegistrations_ProxyToResponder::Run(
    BackgroundSyncError in_err, WTF::Vector<SyncRegistrationOptionsPtr> in_registrations) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::OneShotBackgroundSyncService::GetRegistrationsCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("err"), in_err, 
                        "<value of type BackgroundSyncError>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("registrations"), in_registrations, 
                        "<value of type WTF::Vector<SyncRegistrationOptionsPtr>>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kOneShotBackgroundSyncService_GetRegistrations_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::OneShotBackgroundSyncService_GetRegistrations_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::BackgroundSyncError>(
      in_err, &params->err);
  mojo::internal::MessageFragment<
      typename decltype(params->registrations)::BaseType>
      registrations_fragment(params.message());
  const mojo::internal::ContainerValidateParams registrations_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::SyncRegistrationOptionsDataView>>(
      in_registrations, registrations_fragment, &registrations_validate_params);
  params->registrations.Set(
      registrations_fragment.is_null() ? nullptr : registrations_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->registrations.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null registrations in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::OneShotBackgroundSyncService::GetRegistrationsCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(OneShotBackgroundSyncService::Name_);
  message.set_method_name("GetRegistrations");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool OneShotBackgroundSyncServiceStubDispatch::Accept(
    OneShotBackgroundSyncService* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kOneShotBackgroundSyncService_Register_Name: {
      break;
    }
    case internal::kOneShotBackgroundSyncService_DidResolveRegistration_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::OneShotBackgroundSyncService::DidResolveRegistration",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::OneShotBackgroundSyncService::DidResolveRegistration");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::OneShotBackgroundSyncService_DidResolveRegistration_Params_Data* params =
          reinterpret_cast<internal::OneShotBackgroundSyncService_DidResolveRegistration_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      BackgroundSyncRegistrationInfoPtr p_registration_info{};
      OneShotBackgroundSyncService_DidResolveRegistration_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRegistrationInfo(&p_registration_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            OneShotBackgroundSyncService::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidResolveRegistration(
std::move(p_registration_info));
      return true;
    }
    case internal::kOneShotBackgroundSyncService_GetRegistrations_Name: {
      break;
    }
  }
  return false;
}

// static
bool OneShotBackgroundSyncServiceStubDispatch::AcceptWithResponder(
    OneShotBackgroundSyncService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kOneShotBackgroundSyncService_Register_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::OneShotBackgroundSyncService::Register",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::OneShotBackgroundSyncService::Register");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::OneShotBackgroundSyncService_Register_Params_Data* params =
          reinterpret_cast<
              internal::OneShotBackgroundSyncService_Register_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      SyncRegistrationOptionsPtr p_options{};
      int64_t p_service_worker_registration_id{};
      OneShotBackgroundSyncService_Register_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (success)
        p_service_worker_registration_id = input_data_view.service_worker_registration_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            OneShotBackgroundSyncService::Name_, 0, false);
        return false;
      }
      OneShotBackgroundSyncService::RegisterCallback callback =
          OneShotBackgroundSyncService_Register_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Register(
std::move(p_options), 
std::move(p_service_worker_registration_id), std::move(callback));
      return true;
    }
    case internal::kOneShotBackgroundSyncService_DidResolveRegistration_Name: {
      break;
    }
    case internal::kOneShotBackgroundSyncService_GetRegistrations_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::OneShotBackgroundSyncService::GetRegistrations",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::OneShotBackgroundSyncService::GetRegistrations");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::OneShotBackgroundSyncService_GetRegistrations_Params_Data* params =
          reinterpret_cast<
              internal::OneShotBackgroundSyncService_GetRegistrations_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      int64_t p_service_worker_registration_id{};
      OneShotBackgroundSyncService_GetRegistrations_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_service_worker_registration_id = input_data_view.service_worker_registration_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            OneShotBackgroundSyncService::Name_, 2, false);
        return false;
      }
      OneShotBackgroundSyncService::GetRegistrationsCallback callback =
          OneShotBackgroundSyncService_GetRegistrations_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetRegistrations(
std::move(p_service_worker_registration_id), std::move(callback));
      return true;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kOneShotBackgroundSyncServiceValidationInfo[] = {
    {&internal::OneShotBackgroundSyncService_Register_Params_Data::Validate,
     &internal::OneShotBackgroundSyncService_Register_ResponseParams_Data::Validate},
    {&internal::OneShotBackgroundSyncService_DidResolveRegistration_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::OneShotBackgroundSyncService_GetRegistrations_Params_Data::Validate,
     &internal::OneShotBackgroundSyncService_GetRegistrations_ResponseParams_Data::Validate},
};

bool OneShotBackgroundSyncServiceRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::OneShotBackgroundSyncService::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kOneShotBackgroundSyncServiceValidationInfo);
}

bool OneShotBackgroundSyncServiceResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::OneShotBackgroundSyncService::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kOneShotBackgroundSyncServiceValidationInfo);
}
const char PeriodicBackgroundSyncService::Name_[] = "blink.mojom.PeriodicBackgroundSyncService";

class PeriodicBackgroundSyncService_Register_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PeriodicBackgroundSyncService_Register_ForwardToCallback(
      PeriodicBackgroundSyncService::RegisterCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  PeriodicBackgroundSyncService::RegisterCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(PeriodicBackgroundSyncService_Register_ForwardToCallback);
};

class PeriodicBackgroundSyncService_Unregister_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PeriodicBackgroundSyncService_Unregister_ForwardToCallback(
      PeriodicBackgroundSyncService::UnregisterCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  PeriodicBackgroundSyncService::UnregisterCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(PeriodicBackgroundSyncService_Unregister_ForwardToCallback);
};

class PeriodicBackgroundSyncService_GetRegistrations_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PeriodicBackgroundSyncService_GetRegistrations_ForwardToCallback(
      PeriodicBackgroundSyncService::GetRegistrationsCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  PeriodicBackgroundSyncService::GetRegistrationsCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(PeriodicBackgroundSyncService_GetRegistrations_ForwardToCallback);
};

PeriodicBackgroundSyncServiceProxy::PeriodicBackgroundSyncServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PeriodicBackgroundSyncServiceProxy::Register(
    SyncRegistrationOptionsPtr in_options, int64_t in_service_worker_registration_id, RegisterCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::PeriodicBackgroundSyncService::Register", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options, 
                        "<value of type SyncRegistrationOptionsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("service_worker_registration_id"), in_service_worker_registration_id, 
                        "<value of type int64_t>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPeriodicBackgroundSyncService_Register_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PeriodicBackgroundSyncService_Register_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::SyncRegistrationOptionsDataView>(
      in_options, options_fragment);
  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->options.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null options in PeriodicBackgroundSyncService.Register request");
  params->service_worker_registration_id = in_service_worker_registration_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PeriodicBackgroundSyncService::Name_);
  message.set_method_name("Register");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PeriodicBackgroundSyncService_Register_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void PeriodicBackgroundSyncServiceProxy::Unregister(
    int64_t in_service_worker_registration_id, const WTF::String& in_tag, UnregisterCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::PeriodicBackgroundSyncService::Unregister", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("service_worker_registration_id"), in_service_worker_registration_id, 
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tag"), in_tag, 
                        "<value of type const WTF::String&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPeriodicBackgroundSyncService_Unregister_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PeriodicBackgroundSyncService_Unregister_Params_Data> params(
          message);
  params.Allocate();
  params->service_worker_registration_id = in_service_worker_registration_id;
  mojo::internal::MessageFragment<
      typename decltype(params->tag)::BaseType> tag_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_tag, tag_fragment);
  params->tag.Set(
      tag_fragment.is_null() ? nullptr : tag_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->tag.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null tag in PeriodicBackgroundSyncService.Unregister request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PeriodicBackgroundSyncService::Name_);
  message.set_method_name("Unregister");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PeriodicBackgroundSyncService_Unregister_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void PeriodicBackgroundSyncServiceProxy::GetRegistrations(
    int64_t in_service_worker_registration_id, GetRegistrationsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::PeriodicBackgroundSyncService::GetRegistrations", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("service_worker_registration_id"), in_service_worker_registration_id, 
                        "<value of type int64_t>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPeriodicBackgroundSyncService_GetRegistrations_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PeriodicBackgroundSyncService_GetRegistrations_Params_Data> params(
          message);
  params.Allocate();
  params->service_worker_registration_id = in_service_worker_registration_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PeriodicBackgroundSyncService::Name_);
  message.set_method_name("GetRegistrations");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PeriodicBackgroundSyncService_GetRegistrations_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class PeriodicBackgroundSyncService_Register_ProxyToResponder {
 public:
  static PeriodicBackgroundSyncService::RegisterCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<PeriodicBackgroundSyncService_Register_ProxyToResponder> proxy(
        new PeriodicBackgroundSyncService_Register_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&PeriodicBackgroundSyncService_Register_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PeriodicBackgroundSyncService_Register_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  PeriodicBackgroundSyncService_Register_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PeriodicBackgroundSyncService::RegisterCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      BackgroundSyncError in_err, SyncRegistrationOptionsPtr in_options);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(PeriodicBackgroundSyncService_Register_ProxyToResponder);
};

bool PeriodicBackgroundSyncService_Register_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::PeriodicBackgroundSyncService::RegisterCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::PeriodicBackgroundSyncService_Register_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PeriodicBackgroundSyncService_Register_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  BackgroundSyncError p_err{};
  SyncRegistrationOptionsPtr p_options{};
  PeriodicBackgroundSyncService_Register_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadErr(&p_err))
    success = false;
  if (success && !input_data_view.ReadOptions(&p_options))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PeriodicBackgroundSyncService::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_err), 
std::move(p_options));
  return true;
}

void PeriodicBackgroundSyncService_Register_ProxyToResponder::Run(
    BackgroundSyncError in_err, SyncRegistrationOptionsPtr in_options) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::PeriodicBackgroundSyncService::RegisterCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("err"), in_err, 
                        "<value of type BackgroundSyncError>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options, 
                        "<value of type SyncRegistrationOptionsPtr>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPeriodicBackgroundSyncService_Register_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PeriodicBackgroundSyncService_Register_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::BackgroundSyncError>(
      in_err, &params->err);
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::SyncRegistrationOptionsDataView>(
      in_options, options_fragment);
  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::PeriodicBackgroundSyncService::RegisterCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PeriodicBackgroundSyncService::Name_);
  message.set_method_name("Register");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PeriodicBackgroundSyncService_Unregister_ProxyToResponder {
 public:
  static PeriodicBackgroundSyncService::UnregisterCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<PeriodicBackgroundSyncService_Unregister_ProxyToResponder> proxy(
        new PeriodicBackgroundSyncService_Unregister_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&PeriodicBackgroundSyncService_Unregister_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PeriodicBackgroundSyncService_Unregister_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  PeriodicBackgroundSyncService_Unregister_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PeriodicBackgroundSyncService::UnregisterCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      BackgroundSyncError in_err);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(PeriodicBackgroundSyncService_Unregister_ProxyToResponder);
};

bool PeriodicBackgroundSyncService_Unregister_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::PeriodicBackgroundSyncService::UnregisterCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::PeriodicBackgroundSyncService_Unregister_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PeriodicBackgroundSyncService_Unregister_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  BackgroundSyncError p_err{};
  PeriodicBackgroundSyncService_Unregister_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadErr(&p_err))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PeriodicBackgroundSyncService::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_err));
  return true;
}

void PeriodicBackgroundSyncService_Unregister_ProxyToResponder::Run(
    BackgroundSyncError in_err) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::PeriodicBackgroundSyncService::UnregisterCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("err"), in_err, 
                        "<value of type BackgroundSyncError>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPeriodicBackgroundSyncService_Unregister_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PeriodicBackgroundSyncService_Unregister_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::BackgroundSyncError>(
      in_err, &params->err);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::PeriodicBackgroundSyncService::UnregisterCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PeriodicBackgroundSyncService::Name_);
  message.set_method_name("Unregister");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PeriodicBackgroundSyncService_GetRegistrations_ProxyToResponder {
 public:
  static PeriodicBackgroundSyncService::GetRegistrationsCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<PeriodicBackgroundSyncService_GetRegistrations_ProxyToResponder> proxy(
        new PeriodicBackgroundSyncService_GetRegistrations_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&PeriodicBackgroundSyncService_GetRegistrations_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PeriodicBackgroundSyncService_GetRegistrations_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  PeriodicBackgroundSyncService_GetRegistrations_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PeriodicBackgroundSyncService::GetRegistrationsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      BackgroundSyncError in_err, WTF::Vector<SyncRegistrationOptionsPtr> in_registrations);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(PeriodicBackgroundSyncService_GetRegistrations_ProxyToResponder);
};

bool PeriodicBackgroundSyncService_GetRegistrations_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::PeriodicBackgroundSyncService::GetRegistrationsCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::PeriodicBackgroundSyncService_GetRegistrations_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PeriodicBackgroundSyncService_GetRegistrations_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  BackgroundSyncError p_err{};
  WTF::Vector<SyncRegistrationOptionsPtr> p_registrations{};
  PeriodicBackgroundSyncService_GetRegistrations_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadErr(&p_err))
    success = false;
  if (success && !input_data_view.ReadRegistrations(&p_registrations))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PeriodicBackgroundSyncService::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_err), 
std::move(p_registrations));
  return true;
}

void PeriodicBackgroundSyncService_GetRegistrations_ProxyToResponder::Run(
    BackgroundSyncError in_err, WTF::Vector<SyncRegistrationOptionsPtr> in_registrations) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::PeriodicBackgroundSyncService::GetRegistrationsCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("err"), in_err, 
                        "<value of type BackgroundSyncError>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("registrations"), in_registrations, 
                        "<value of type WTF::Vector<SyncRegistrationOptionsPtr>>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPeriodicBackgroundSyncService_GetRegistrations_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PeriodicBackgroundSyncService_GetRegistrations_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::BackgroundSyncError>(
      in_err, &params->err);
  mojo::internal::MessageFragment<
      typename decltype(params->registrations)::BaseType>
      registrations_fragment(params.message());
  const mojo::internal::ContainerValidateParams registrations_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::SyncRegistrationOptionsDataView>>(
      in_registrations, registrations_fragment, &registrations_validate_params);
  params->registrations.Set(
      registrations_fragment.is_null() ? nullptr : registrations_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->registrations.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null registrations in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::PeriodicBackgroundSyncService::GetRegistrationsCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PeriodicBackgroundSyncService::Name_);
  message.set_method_name("GetRegistrations");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool PeriodicBackgroundSyncServiceStubDispatch::Accept(
    PeriodicBackgroundSyncService* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kPeriodicBackgroundSyncService_Register_Name: {
      break;
    }
    case internal::kPeriodicBackgroundSyncService_Unregister_Name: {
      break;
    }
    case internal::kPeriodicBackgroundSyncService_GetRegistrations_Name: {
      break;
    }
  }
  return false;
}

// static
bool PeriodicBackgroundSyncServiceStubDispatch::AcceptWithResponder(
    PeriodicBackgroundSyncService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kPeriodicBackgroundSyncService_Register_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::PeriodicBackgroundSyncService::Register",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::PeriodicBackgroundSyncService::Register");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::PeriodicBackgroundSyncService_Register_Params_Data* params =
          reinterpret_cast<
              internal::PeriodicBackgroundSyncService_Register_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      SyncRegistrationOptionsPtr p_options{};
      int64_t p_service_worker_registration_id{};
      PeriodicBackgroundSyncService_Register_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (success)
        p_service_worker_registration_id = input_data_view.service_worker_registration_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PeriodicBackgroundSyncService::Name_, 0, false);
        return false;
      }
      PeriodicBackgroundSyncService::RegisterCallback callback =
          PeriodicBackgroundSyncService_Register_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Register(
std::move(p_options), 
std::move(p_service_worker_registration_id), std::move(callback));
      return true;
    }
    case internal::kPeriodicBackgroundSyncService_Unregister_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::PeriodicBackgroundSyncService::Unregister",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::PeriodicBackgroundSyncService::Unregister");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::PeriodicBackgroundSyncService_Unregister_Params_Data* params =
          reinterpret_cast<
              internal::PeriodicBackgroundSyncService_Unregister_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      int64_t p_service_worker_registration_id{};
      WTF::String p_tag{};
      PeriodicBackgroundSyncService_Unregister_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_service_worker_registration_id = input_data_view.service_worker_registration_id();
      if (success && !input_data_view.ReadTag(&p_tag))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PeriodicBackgroundSyncService::Name_, 1, false);
        return false;
      }
      PeriodicBackgroundSyncService::UnregisterCallback callback =
          PeriodicBackgroundSyncService_Unregister_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Unregister(
std::move(p_service_worker_registration_id), 
std::move(p_tag), std::move(callback));
      return true;
    }
    case internal::kPeriodicBackgroundSyncService_GetRegistrations_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::PeriodicBackgroundSyncService::GetRegistrations",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::PeriodicBackgroundSyncService::GetRegistrations");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::PeriodicBackgroundSyncService_GetRegistrations_Params_Data* params =
          reinterpret_cast<
              internal::PeriodicBackgroundSyncService_GetRegistrations_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      int64_t p_service_worker_registration_id{};
      PeriodicBackgroundSyncService_GetRegistrations_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_service_worker_registration_id = input_data_view.service_worker_registration_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PeriodicBackgroundSyncService::Name_, 2, false);
        return false;
      }
      PeriodicBackgroundSyncService::GetRegistrationsCallback callback =
          PeriodicBackgroundSyncService_GetRegistrations_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetRegistrations(
std::move(p_service_worker_registration_id), std::move(callback));
      return true;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kPeriodicBackgroundSyncServiceValidationInfo[] = {
    {&internal::PeriodicBackgroundSyncService_Register_Params_Data::Validate,
     &internal::PeriodicBackgroundSyncService_Register_ResponseParams_Data::Validate},
    {&internal::PeriodicBackgroundSyncService_Unregister_Params_Data::Validate,
     &internal::PeriodicBackgroundSyncService_Unregister_ResponseParams_Data::Validate},
    {&internal::PeriodicBackgroundSyncService_GetRegistrations_Params_Data::Validate,
     &internal::PeriodicBackgroundSyncService_GetRegistrations_ResponseParams_Data::Validate},
};

bool PeriodicBackgroundSyncServiceRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::PeriodicBackgroundSyncService::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kPeriodicBackgroundSyncServiceValidationInfo);
}

bool PeriodicBackgroundSyncServiceResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::PeriodicBackgroundSyncService::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kPeriodicBackgroundSyncServiceValidationInfo);
}
}  // namespace blink
}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::blink::SyncRegistrationOptions::DataView, ::blink::mojom::blink::SyncRegistrationOptionsPtr>::Read(
    ::blink::mojom::blink::SyncRegistrationOptions::DataView input,
    ::blink::mojom::blink::SyncRegistrationOptionsPtr* output) {
  bool success = true;
  ::blink::mojom::blink::SyncRegistrationOptionsPtr result(::blink::mojom::blink::SyncRegistrationOptions::New());
  
      if (success && !input.ReadTag(&result->tag))
        success = false;
      if (success)
        result->min_interval = input.min_interval();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::BackgroundSyncRegistrationInfo::DataView, ::blink::mojom::blink::BackgroundSyncRegistrationInfoPtr>::Read(
    ::blink::mojom::blink::BackgroundSyncRegistrationInfo::DataView input,
    ::blink::mojom::blink::BackgroundSyncRegistrationInfoPtr* output) {
  bool success = true;
  ::blink::mojom::blink::BackgroundSyncRegistrationInfoPtr result(::blink::mojom::blink::BackgroundSyncRegistrationInfo::New());
  
      if (success)
        result->service_worker_registration_id = input.service_worker_registration_id();
      if (success && !input.ReadTag(&result->tag))
        success = false;
      if (success && !input.ReadSyncType(&result->sync_type))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif