// third_party/blink/public/mojom/blob/blob.mojom-test-utils.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif


#include "third_party/blink/public/mojom/blob/blob.mojom-test-utils.h"

#include <utility>

#include "base/bind.h"
#include "base/run_loop.h"
#include "mojo/public/mojom/base/big_buffer.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "services/network/public/mojom/data_pipe_getter.mojom.h"
#include "services/network/public/mojom/http_request_headers.mojom.h"
#include "services/network/public/mojom/url_loader.mojom.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_BLOB_BLOB_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_BLOB_BLOB_MOJOM_JUMBO_H_
#endif


namespace blink {
namespace mojom {


void BlobReaderClientInterceptorForTesting::OnCalculatedSize(uint64_t total_size, uint64_t expected_content_size) {
  GetForwardingInterface()->OnCalculatedSize(std::move(total_size), std::move(expected_content_size));
}
void BlobReaderClientInterceptorForTesting::OnComplete(int32_t status, uint64_t data_length) {
  GetForwardingInterface()->OnComplete(std::move(status), std::move(data_length));
}
BlobReaderClientAsyncWaiter::BlobReaderClientAsyncWaiter(
    BlobReaderClient* proxy) : proxy_(proxy) {}

BlobReaderClientAsyncWaiter::~BlobReaderClientAsyncWaiter() = default;




void BlobInterceptorForTesting::Clone(::mojo::PendingReceiver<Blob> blob) {
  GetForwardingInterface()->Clone(std::move(blob));
}
void BlobInterceptorForTesting::AsDataPipeGetter(::mojo::PendingReceiver<::network::mojom::DataPipeGetter> data_pipe_getter) {
  GetForwardingInterface()->AsDataPipeGetter(std::move(data_pipe_getter));
}
void BlobInterceptorForTesting::ReadAll(::mojo::ScopedDataPipeProducerHandle pipe, ::mojo::PendingRemote<BlobReaderClient> client) {
  GetForwardingInterface()->ReadAll(std::move(pipe), std::move(client));
}
void BlobInterceptorForTesting::ReadRange(uint64_t offset, uint64_t length, ::mojo::ScopedDataPipeProducerHandle pipe, ::mojo::PendingRemote<BlobReaderClient> client) {
  GetForwardingInterface()->ReadRange(std::move(offset), std::move(length), std::move(pipe), std::move(client));
}
void BlobInterceptorForTesting::Load(::mojo::PendingReceiver<::network::mojom::URLLoader> loader, const std::string& request_method, const ::net::HttpRequestHeaders& headers, ::mojo::PendingRemote<::network::mojom::URLLoaderClient> client) {
  GetForwardingInterface()->Load(std::move(loader), std::move(request_method), std::move(headers), std::move(client));
}
void BlobInterceptorForTesting::ReadSideData(ReadSideDataCallback callback) {
  GetForwardingInterface()->ReadSideData(std::move(callback));
}
void BlobInterceptorForTesting::CaptureSnapshot(CaptureSnapshotCallback callback) {
  GetForwardingInterface()->CaptureSnapshot(std::move(callback));
}
void BlobInterceptorForTesting::GetInternalUUID(GetInternalUUIDCallback callback) {
  GetForwardingInterface()->GetInternalUUID(std::move(callback));
}
BlobAsyncWaiter::BlobAsyncWaiter(
    Blob* proxy) : proxy_(proxy) {}

BlobAsyncWaiter::~BlobAsyncWaiter() = default;

void BlobAsyncWaiter::ReadSideData(
    base::Optional<::mojo_base::BigBuffer>* out_data) {
  base::RunLoop loop;
  proxy_->ReadSideData(
      base::BindOnce(
          [](base::RunLoop* loop,
             base::Optional<::mojo_base::BigBuffer>* out_data
,
             base::Optional<::mojo_base::BigBuffer> data) {*out_data = std::move(data);
            loop->Quit();
          },
          &loop,
          out_data));
  loop.Run();
}
void BlobAsyncWaiter::CaptureSnapshot(
    uint64_t* out_length, base::Optional<::base::Time>* out_modification_time) {
  base::RunLoop loop;
  proxy_->CaptureSnapshot(
      base::BindOnce(
          [](base::RunLoop* loop,
             uint64_t* out_length
,
             base::Optional<::base::Time>* out_modification_time
,
             uint64_t length,
             base::Optional<::base::Time> modification_time) {*out_length = std::move(length);*out_modification_time = std::move(modification_time);
            loop->Quit();
          },
          &loop,
          out_length,
          out_modification_time));
  loop.Run();
}
void BlobAsyncWaiter::GetInternalUUID(
    std::string* out_uuid) {
  base::RunLoop loop;
  proxy_->GetInternalUUID(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::string* out_uuid
,
             const std::string& uuid) {*out_uuid = std::move(uuid);
            loop->Quit();
          },
          &loop,
          out_uuid));
  loop.Run();
}





}  // namespace mojom
}  // namespace blink

#if defined(__clang__)
#pragma clang diagnostic pop
#endif