// third_party/blink/public/mojom/blob/blob_url_store.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/blob/blob_url_store.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/blob/blob_url_store.mojom-params-data.h"
#include "third_party/blink/public/mojom/blob/blob_url_store.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/blob/blob_url_store.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_BLOB_BLOB_URL_STORE_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_BLOB_BLOB_URL_STORE_MOJOM_JUMBO_H_
#endif
namespace blink {
namespace mojom {
const char BlobURLStore::Name_[] = "blink.mojom.BlobURLStore";
bool BlobURLStore::Register(::mojo::PendingRemote<::blink::mojom::Blob> blob, const ::GURL& url) {
  NOTREACHED();
  return false;
}
class BlobURLStore_Register_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  BlobURLStore_Register_HandleSyncResponse(
      bool* result)
      : result_(result) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;DISALLOW_COPY_AND_ASSIGN(BlobURLStore_Register_HandleSyncResponse);
};

class BlobURLStore_Register_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  BlobURLStore_Register_ForwardToCallback(
      BlobURLStore::RegisterCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  BlobURLStore::RegisterCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(BlobURLStore_Register_ForwardToCallback);
};

class BlobURLStore_Resolve_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  BlobURLStore_Resolve_ForwardToCallback(
      BlobURLStore::ResolveCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  BlobURLStore::ResolveCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(BlobURLStore_Resolve_ForwardToCallback);
};

BlobURLStoreProxy::BlobURLStoreProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}
bool BlobURLStoreProxy::Register(
    ::mojo::PendingRemote<::blink::mojom::Blob> param_blob, const ::GURL& param_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "blink::mojom::BlobURLStore::Register", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("blob"), param_blob, 
                        "<value of type ::mojo::PendingRemote<::blink::mojom::Blob>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), param_url, 
                        "<value of type const ::GURL&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kBlobURLStore_Register_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BlobURLStore_Register_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::BlobInterfaceBase>>(
      param_blob, &params->blob, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->blob),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid blob in BlobURLStore.Register request");
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      param_url, url_fragment);
  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in BlobURLStore.Register request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BlobURLStore::Name_);
  message.set_method_name("Register");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new BlobURLStore_Register_HandleSyncResponse(
          &result));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END0("mojom", "blink::mojom::BlobURLStore::Register");
#endif
  return result;
}

void BlobURLStoreProxy::Register(
    ::mojo::PendingRemote<::blink::mojom::Blob> in_blob, const ::GURL& in_url, RegisterCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::BlobURLStore::Register", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("blob"), in_blob, 
                        "<value of type ::mojo::PendingRemote<::blink::mojom::Blob>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url, 
                        "<value of type const ::GURL&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kBlobURLStore_Register_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BlobURLStore_Register_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::BlobInterfaceBase>>(
      in_blob, &params->blob, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->blob),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid blob in BlobURLStore.Register request");
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, url_fragment);
  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in BlobURLStore.Register request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BlobURLStore::Name_);
  message.set_method_name("Register");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new BlobURLStore_Register_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void BlobURLStoreProxy::Revoke(
    const ::GURL& in_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::BlobURLStore::Revoke", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url, 
                        "<value of type const ::GURL&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kBlobURLStore_Revoke_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BlobURLStore_Revoke_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, url_fragment);
  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in BlobURLStore.Revoke request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BlobURLStore::Name_);
  message.set_method_name("Revoke");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void BlobURLStoreProxy::Resolve(
    const ::GURL& in_url, ResolveCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::BlobURLStore::Resolve", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url, 
                        "<value of type const ::GURL&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kBlobURLStore_Resolve_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BlobURLStore_Resolve_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, url_fragment);
  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in BlobURLStore.Resolve request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BlobURLStore::Name_);
  message.set_method_name("Resolve");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new BlobURLStore_Resolve_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void BlobURLStoreProxy::ResolveAsURLLoaderFactory(
    const ::GURL& in_url, ::mojo::PendingReceiver<::network::mojom::URLLoaderFactory> in_factory) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::BlobURLStore::ResolveAsURLLoaderFactory", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url, 
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("factory"), in_factory, 
                        "<value of type ::mojo::PendingReceiver<::network::mojom::URLLoaderFactory>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kBlobURLStore_ResolveAsURLLoaderFactory_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BlobURLStore_ResolveAsURLLoaderFactory_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, url_fragment);
  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in BlobURLStore.ResolveAsURLLoaderFactory request");
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::URLLoaderFactoryInterfaceBase>>(
      in_factory, &params->factory, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->factory),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid factory in BlobURLStore.ResolveAsURLLoaderFactory request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BlobURLStore::Name_);
  message.set_method_name("ResolveAsURLLoaderFactory");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void BlobURLStoreProxy::ResolveForNavigation(
    const ::GURL& in_url, ::mojo::PendingReceiver<BlobURLToken> in_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::BlobURLStore::ResolveForNavigation", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url, 
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("token"), in_token, 
                        "<value of type ::mojo::PendingReceiver<BlobURLToken>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kBlobURLStore_ResolveForNavigation_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BlobURLStore_ResolveForNavigation_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, url_fragment);
  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in BlobURLStore.ResolveForNavigation request");
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::BlobURLTokenInterfaceBase>>(
      in_token, &params->token, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->token),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid token in BlobURLStore.ResolveForNavigation request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BlobURLStore::Name_);
  message.set_method_name("ResolveForNavigation");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class BlobURLStore_Register_ProxyToResponder {
 public:
  static BlobURLStore::RegisterCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<BlobURLStore_Register_ProxyToResponder> proxy(
        new BlobURLStore_Register_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&BlobURLStore_Register_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~BlobURLStore_Register_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  BlobURLStore_Register_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "BlobURLStore::RegisterCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(BlobURLStore_Register_ProxyToResponder);
};

bool BlobURLStore_Register_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::BlobURLStore::RegisterCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::BlobURLStore_Register_ResponseParams_Data* params =
      reinterpret_cast<
          internal::BlobURLStore_Register_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  BlobURLStore_Register_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        BlobURLStore::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void BlobURLStore_Register_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)blink::mojom::BlobURLStore::RegisterCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kBlobURLStore_Register_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BlobURLStore_Register_ResponseParams_Data> params(
          message);
  params.Allocate();

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::BlobURLStore::RegisterCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BlobURLStore::Name_);
  message.set_method_name("Register");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool BlobURLStore_Register_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::BlobURLStore_Register_ResponseParams_Data* params =
      reinterpret_cast<internal::BlobURLStore_Register_ResponseParams_Data*>(
          message->mutable_payload());
  
  bool success = true;
  BlobURLStore_Register_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        BlobURLStore::Name_, 0, true);
    return false;
  }
  mojo::internal::SyncMessageResponseSetup::SetCurrentSyncResponseMessage(
      message);
  *result_ = true;
  return true;
}
class BlobURLStore_Resolve_ProxyToResponder {
 public:
  static BlobURLStore::ResolveCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<BlobURLStore_Resolve_ProxyToResponder> proxy(
        new BlobURLStore_Resolve_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&BlobURLStore_Resolve_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~BlobURLStore_Resolve_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  BlobURLStore_Resolve_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "BlobURLStore::ResolveCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::mojo::PendingRemote<::blink::mojom::Blob> in_blob);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(BlobURLStore_Resolve_ProxyToResponder);
};

bool BlobURLStore_Resolve_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::BlobURLStore::ResolveCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::BlobURLStore_Resolve_ResponseParams_Data* params =
      reinterpret_cast<
          internal::BlobURLStore_Resolve_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::mojo::PendingRemote<::blink::mojom::Blob> p_blob{};
  BlobURLStore_Resolve_ResponseParamsDataView input_data_view(params, message);
  
  if (success) {
    p_blob =
        input_data_view.TakeBlob<decltype(p_blob)>();
  }
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        BlobURLStore::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_blob));
  return true;
}

void BlobURLStore_Resolve_ProxyToResponder::Run(
    ::mojo::PendingRemote<::blink::mojom::Blob> in_blob) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::BlobURLStore::ResolveCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("blob"), in_blob, 
                        "<value of type ::mojo::PendingRemote<::blink::mojom::Blob>>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kBlobURLStore_Resolve_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BlobURLStore_Resolve_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::BlobInterfaceBase>>(
      in_blob, &params->blob, &params.message());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::BlobURLStore::ResolveCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BlobURLStore::Name_);
  message.set_method_name("Resolve");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool BlobURLStoreStubDispatch::Accept(
    BlobURLStore* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kBlobURLStore_Register_Name: {
      break;
    }
    case internal::kBlobURLStore_Revoke_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::BlobURLStore::Revoke",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::BlobURLStore::Revoke");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::BlobURLStore_Revoke_Params_Data* params =
          reinterpret_cast<internal::BlobURLStore_Revoke_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::GURL p_url{};
      BlobURLStore_Revoke_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BlobURLStore::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Revoke(
std::move(p_url));
      return true;
    }
    case internal::kBlobURLStore_Resolve_Name: {
      break;
    }
    case internal::kBlobURLStore_ResolveAsURLLoaderFactory_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::BlobURLStore::ResolveAsURLLoaderFactory",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::BlobURLStore::ResolveAsURLLoaderFactory");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::BlobURLStore_ResolveAsURLLoaderFactory_Params_Data* params =
          reinterpret_cast<internal::BlobURLStore_ResolveAsURLLoaderFactory_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::GURL p_url{};
      ::mojo::PendingReceiver<::network::mojom::URLLoaderFactory> p_factory{};
      BlobURLStore_ResolveAsURLLoaderFactory_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success) {
        p_factory =
            input_data_view.TakeFactory<decltype(p_factory)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BlobURLStore::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ResolveAsURLLoaderFactory(
std::move(p_url), 
std::move(p_factory));
      return true;
    }
    case internal::kBlobURLStore_ResolveForNavigation_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::BlobURLStore::ResolveForNavigation",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::BlobURLStore::ResolveForNavigation");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::BlobURLStore_ResolveForNavigation_Params_Data* params =
          reinterpret_cast<internal::BlobURLStore_ResolveForNavigation_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::GURL p_url{};
      ::mojo::PendingReceiver<BlobURLToken> p_token{};
      BlobURLStore_ResolveForNavigation_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success) {
        p_token =
            input_data_view.TakeToken<decltype(p_token)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BlobURLStore::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ResolveForNavigation(
std::move(p_url), 
std::move(p_token));
      return true;
    }
  }
  return false;
}

// static
bool BlobURLStoreStubDispatch::AcceptWithResponder(
    BlobURLStore* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kBlobURLStore_Register_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::BlobURLStore::Register",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::BlobURLStore::Register");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::BlobURLStore_Register_Params_Data* params =
          reinterpret_cast<
              internal::BlobURLStore_Register_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<::blink::mojom::Blob> p_blob{};
      ::GURL p_url{};
      BlobURLStore_Register_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_blob =
            input_data_view.TakeBlob<decltype(p_blob)>();
      }
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BlobURLStore::Name_, 0, false);
        return false;
      }
      BlobURLStore::RegisterCallback callback =
          BlobURLStore_Register_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Register(
std::move(p_blob), 
std::move(p_url), std::move(callback));
      return true;
    }
    case internal::kBlobURLStore_Revoke_Name: {
      break;
    }
    case internal::kBlobURLStore_Resolve_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::BlobURLStore::Resolve",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::BlobURLStore::Resolve");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::BlobURLStore_Resolve_Params_Data* params =
          reinterpret_cast<
              internal::BlobURLStore_Resolve_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::GURL p_url{};
      BlobURLStore_Resolve_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BlobURLStore::Name_, 2, false);
        return false;
      }
      BlobURLStore::ResolveCallback callback =
          BlobURLStore_Resolve_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Resolve(
std::move(p_url), std::move(callback));
      return true;
    }
    case internal::kBlobURLStore_ResolveAsURLLoaderFactory_Name: {
      break;
    }
    case internal::kBlobURLStore_ResolveForNavigation_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kBlobURLStoreValidationInfo[] = {
    {&internal::BlobURLStore_Register_Params_Data::Validate,
     &internal::BlobURLStore_Register_ResponseParams_Data::Validate},
    {&internal::BlobURLStore_Revoke_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::BlobURLStore_Resolve_Params_Data::Validate,
     &internal::BlobURLStore_Resolve_ResponseParams_Data::Validate},
    {&internal::BlobURLStore_ResolveAsURLLoaderFactory_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::BlobURLStore_ResolveForNavigation_Params_Data::Validate,
     nullptr /* no response */},
};

bool BlobURLStoreRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::BlobURLStore::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kBlobURLStoreValidationInfo);
}

bool BlobURLStoreResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::BlobURLStore::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kBlobURLStoreValidationInfo);
}
const char BlobURLToken::Name_[] = "blink.mojom.BlobURLToken";

class BlobURLToken_GetToken_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  BlobURLToken_GetToken_ForwardToCallback(
      BlobURLToken::GetTokenCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  BlobURLToken::GetTokenCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(BlobURLToken_GetToken_ForwardToCallback);
};

BlobURLTokenProxy::BlobURLTokenProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void BlobURLTokenProxy::Clone(
    ::mojo::PendingReceiver<BlobURLToken> in_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::BlobURLToken::Clone", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("token"), in_token, 
                        "<value of type ::mojo::PendingReceiver<BlobURLToken>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kBlobURLToken_Clone_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BlobURLToken_Clone_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::BlobURLTokenInterfaceBase>>(
      in_token, &params->token, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->token),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid token in BlobURLToken.Clone request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BlobURLToken::Name_);
  message.set_method_name("Clone");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void BlobURLTokenProxy::GetToken(
    GetTokenCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::BlobURLToken::GetToken");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kBlobURLToken_GetToken_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BlobURLToken_GetToken_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BlobURLToken::Name_);
  message.set_method_name("GetToken");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new BlobURLToken_GetToken_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class BlobURLToken_GetToken_ProxyToResponder {
 public:
  static BlobURLToken::GetTokenCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<BlobURLToken_GetToken_ProxyToResponder> proxy(
        new BlobURLToken_GetToken_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&BlobURLToken_GetToken_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~BlobURLToken_GetToken_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  BlobURLToken_GetToken_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "BlobURLToken::GetTokenCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::base::UnguessableToken& in_token);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(BlobURLToken_GetToken_ProxyToResponder);
};

bool BlobURLToken_GetToken_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::BlobURLToken::GetTokenCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::BlobURLToken_GetToken_ResponseParams_Data* params =
      reinterpret_cast<
          internal::BlobURLToken_GetToken_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::base::UnguessableToken p_token{};
  BlobURLToken_GetToken_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadToken(&p_token))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        BlobURLToken::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_token));
  return true;
}

void BlobURLToken_GetToken_ProxyToResponder::Run(
    const ::base::UnguessableToken& in_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::BlobURLToken::GetTokenCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("token"), in_token, 
                        "<value of type const ::base::UnguessableToken&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kBlobURLToken_GetToken_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BlobURLToken_GetToken_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->token)::BaseType> token_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_token, token_fragment);
  params->token.Set(
      token_fragment.is_null() ? nullptr : token_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->token.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null token in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::BlobURLToken::GetTokenCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BlobURLToken::Name_);
  message.set_method_name("GetToken");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool BlobURLTokenStubDispatch::Accept(
    BlobURLToken* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kBlobURLToken_Clone_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::BlobURLToken::Clone",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::BlobURLToken::Clone");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::BlobURLToken_Clone_Params_Data* params =
          reinterpret_cast<internal::BlobURLToken_Clone_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<BlobURLToken> p_token{};
      BlobURLToken_Clone_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_token =
            input_data_view.TakeToken<decltype(p_token)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BlobURLToken::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Clone(
std::move(p_token));
      return true;
    }
    case internal::kBlobURLToken_GetToken_Name: {
      break;
    }
  }
  return false;
}

// static
bool BlobURLTokenStubDispatch::AcceptWithResponder(
    BlobURLToken* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kBlobURLToken_Clone_Name: {
      break;
    }
    case internal::kBlobURLToken_GetToken_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::BlobURLToken::GetToken",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::BlobURLToken::GetToken");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::BlobURLToken_GetToken_Params_Data* params =
          reinterpret_cast<
              internal::BlobURLToken_GetToken_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      BlobURLToken_GetToken_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BlobURLToken::Name_, 1, false);
        return false;
      }
      BlobURLToken::GetTokenCallback callback =
          BlobURLToken_GetToken_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetToken(std::move(callback));
      return true;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kBlobURLTokenValidationInfo[] = {
    {&internal::BlobURLToken_Clone_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::BlobURLToken_GetToken_Params_Data::Validate,
     &internal::BlobURLToken_GetToken_ResponseParams_Data::Validate},
};

bool BlobURLTokenRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::BlobURLToken::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kBlobURLTokenValidationInfo);
}

bool BlobURLTokenResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::BlobURLToken::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kBlobURLTokenValidationInfo);
}
}  // namespace mojom
}  // namespace blink

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif