// third_party/blink/public/mojom/blob/data_element.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/blob/data_element.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/blob/data_element.mojom-params-data.h"
namespace blink {
namespace mojom {

namespace internal {
// static
bool DataElement_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const DataElement_Data* object = static_cast<const DataElement_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case DataElement_Tag::BYTES: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_bytes, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_bytes, validation_context))
        return false;
      return true;
    }
    case DataElement_Tag::FILE: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_file, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_file, validation_context))
        return false;
      return true;
    }
    case DataElement_Tag::FILE_FILESYSTEM: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_file_filesystem, 3, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_file_filesystem, validation_context))
        return false;
      return true;
    }
    case DataElement_Tag::BLOB: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_blob, 4, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_blob, validation_context))
        return false;
      return true;
    }
    default: {
      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in DataElement");
      return false;
    }
  }
}


// static
bool DataElementBytes_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DataElementBytes_Data* object = static_cast<const DataElementBytes_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  const mojo::internal::ContainerValidateParams embedded_data_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->embedded_data, validation_context,
                                         &embedded_data_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->data, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->data,
                                                 validation_context)) {
    return false;
  }

  return true;
}

DataElementBytes_Data::DataElementBytes_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DataElementFile_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DataElementFile_Data* object = static_cast<const DataElementFile_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->path, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->path, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->expected_modification_time, validation_context))
    return false;

  return true;
}

DataElementFile_Data::DataElementFile_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DataElementFilesystemURL_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DataElementFilesystemURL_Data* object = static_cast<const DataElementFilesystemURL_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->expected_modification_time, validation_context))
    return false;

  return true;
}

DataElementFilesystemURL_Data::DataElementFilesystemURL_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DataElementBlob_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DataElementBlob_Data* object = static_cast<const DataElementBlob_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->blob, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->blob,
                                                 validation_context)) {
    return false;
  }

  return true;
}

DataElementBlob_Data::DataElementBlob_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BytesProvider_RequestAsReply_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const BytesProvider_RequestAsReply_Params_Data* object = static_cast<const BytesProvider_RequestAsReply_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

BytesProvider_RequestAsReply_Params_Data::BytesProvider_RequestAsReply_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BytesProvider_RequestAsReply_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const BytesProvider_RequestAsReply_ResponseParams_Data* object = static_cast<const BytesProvider_RequestAsReply_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->data, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams data_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->data, validation_context,
                                         &data_validate_params)) {
    return false;
  }

  return true;
}

BytesProvider_RequestAsReply_ResponseParams_Data::BytesProvider_RequestAsReply_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BytesProvider_RequestAsStream_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const BytesProvider_RequestAsStream_Params_Data* object = static_cast<const BytesProvider_RequestAsStream_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->pipe, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->pipe,
                                                 validation_context)) {
    return false;
  }

  return true;
}

BytesProvider_RequestAsStream_Params_Data::BytesProvider_RequestAsStream_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BytesProvider_RequestAsFile_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const BytesProvider_RequestAsFile_Params_Data* object = static_cast<const BytesProvider_RequestAsFile_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->file, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->file, validation_context))
    return false;

  return true;
}

BytesProvider_RequestAsFile_Params_Data::BytesProvider_RequestAsFile_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BytesProvider_RequestAsFile_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const BytesProvider_RequestAsFile_ResponseParams_Data* object = static_cast<const BytesProvider_RequestAsFile_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateStruct(object->time_file_modified, validation_context))
    return false;

  return true;
}

BytesProvider_RequestAsFile_ResponseParams_Data::BytesProvider_RequestAsFile_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink
