// third_party/blink/public/mojom/cache_storage/cache_storage.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/cache_storage/cache_storage.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/cache_storage/cache_storage.mojom-params-data.h"
namespace blink {
namespace mojom {

std::string CacheStorageErrorToString(CacheStorageError value) {
  switch(value) {
    case CacheStorageError::kSuccess:
      return "CacheStorageError::kSuccess";
    case CacheStorageError::kErrorExists:
      return "CacheStorageError::kErrorExists";
    case CacheStorageError::kErrorStorage:
      return "CacheStorageError::kErrorStorage";
    case CacheStorageError::kErrorNotFound:
      return "CacheStorageError::kErrorNotFound";
    case CacheStorageError::kErrorQuotaExceeded:
      return "CacheStorageError::kErrorQuotaExceeded";
    case CacheStorageError::kErrorCacheNameNotFound:
      return "CacheStorageError::kErrorCacheNameNotFound";
    case CacheStorageError::kErrorQueryTooLarge:
      return "CacheStorageError::kErrorQueryTooLarge";
    case CacheStorageError::kErrorNotImplemented:
      return "CacheStorageError::kErrorNotImplemented";
    case CacheStorageError::kErrorDuplicateOperation:
      return "CacheStorageError::kErrorDuplicateOperation";
    case CacheStorageError::kErrorCrossOriginResourcePolicy:
      return "CacheStorageError::kErrorCrossOriginResourcePolicy";
    default:
      return base::StringPrintf("Unknown CacheStorageError value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, CacheStorageError value) {
  return os << CacheStorageErrorToString(value);
}

std::string OperationTypeToString(OperationType value) {
  switch(value) {
    case OperationType::kUndefined:
      return "OperationType::kUndefined";
    case OperationType::kPut:
      return "OperationType::kPut";
    case OperationType::kDelete:
      return "OperationType::kDelete";
    default:
      return base::StringPrintf("Unknown OperationType value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, OperationType value) {
  return os << OperationTypeToString(value);
}

namespace internal {
// static
bool OpenResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const OpenResult_Data* object = static_cast<const OpenResult_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case OpenResult_Tag::STATUS: {


      if (!::blink::mojom::internal::CacheStorageError_Data
            ::Validate(object->data.f_status, validation_context))
        return false;
      return true;
    }
    case OpenResult_Tag::CACHE: {

      if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
              object->data.f_cache, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateHandleOrInterface(object->data.f_cache,
                                                     validation_context)) {
        return false;
      }
      return true;
    }
    default: {
      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in OpenResult");
      return false;
    }
  }
}
// static
bool MatchResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const MatchResult_Data* object = static_cast<const MatchResult_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case MatchResult_Tag::STATUS: {


      if (!::blink::mojom::internal::CacheStorageError_Data
            ::Validate(object->data.f_status, validation_context))
        return false;
      return true;
    }
    case MatchResult_Tag::RESPONSE: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_response, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_response, validation_context))
        return false;
      return true;
    }
    case MatchResult_Tag::EAGER_RESPONSE: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_eager_response, 3, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_eager_response, validation_context))
        return false;
      return true;
    }
    default: {
      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in MatchResult");
      return false;
    }
  }
}
// static
bool MatchAllResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const MatchAllResult_Data* object = static_cast<const MatchAllResult_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case MatchAllResult_Tag::STATUS: {


      if (!::blink::mojom::internal::CacheStorageError_Data
            ::Validate(object->data.f_status, validation_context))
        return false;
      return true;
    }
    case MatchAllResult_Tag::RESPONSES: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_responses, 2, validation_context)) {
        return false;
      }
      const mojo::internal::ContainerValidateParams responses_validate_params(
          0, false, nullptr);
      if (!mojo::internal::ValidateContainer(object->data.f_responses, validation_context,
                                             &responses_validate_params)) {
        return false;
      }
      return true;
    }
    default: {
      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in MatchAllResult");
      return false;
    }
  }
}
// static
bool GetAllMatchedEntriesResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const GetAllMatchedEntriesResult_Data* object = static_cast<const GetAllMatchedEntriesResult_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case GetAllMatchedEntriesResult_Tag::STATUS: {


      if (!::blink::mojom::internal::CacheStorageError_Data
            ::Validate(object->data.f_status, validation_context))
        return false;
      return true;
    }
    case GetAllMatchedEntriesResult_Tag::ENTRIES: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_entries, 2, validation_context)) {
        return false;
      }
      const mojo::internal::ContainerValidateParams entries_validate_params(
          0, false, nullptr);
      if (!mojo::internal::ValidateContainer(object->data.f_entries, validation_context,
                                             &entries_validate_params)) {
        return false;
      }
      return true;
    }
    default: {
      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in GetAllMatchedEntriesResult");
      return false;
    }
  }
}
// static
bool CacheKeysResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const CacheKeysResult_Data* object = static_cast<const CacheKeysResult_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case CacheKeysResult_Tag::STATUS: {


      if (!::blink::mojom::internal::CacheStorageError_Data
            ::Validate(object->data.f_status, validation_context))
        return false;
      return true;
    }
    case CacheKeysResult_Tag::KEYS: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_keys, 2, validation_context)) {
        return false;
      }
      const mojo::internal::ContainerValidateParams keys_validate_params(
          0, false, nullptr);
      if (!mojo::internal::ValidateContainer(object->data.f_keys, validation_context,
                                             &keys_validate_params)) {
        return false;
      }
      return true;
    }
    default: {
      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in CacheKeysResult");
      return false;
    }
  }
}


// static
bool CacheStorageVerboseError_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CacheStorageVerboseError_Data* object = static_cast<const CacheStorageVerboseError_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::blink::mojom::internal::CacheStorageError_Data
        ::Validate(object->value, validation_context))
    return false;

  const mojo::internal::ContainerValidateParams message_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->message, validation_context,
                                         &message_validate_params)) {
    return false;
  }

  return true;
}

CacheStorageVerboseError_Data::CacheStorageVerboseError_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CacheQueryOptions_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CacheQueryOptions_Data* object = static_cast<const CacheQueryOptions_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

CacheQueryOptions_Data::CacheQueryOptions_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MultiCacheQueryOptions_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const MultiCacheQueryOptions_Data* object = static_cast<const MultiCacheQueryOptions_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->query_options, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->query_options, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->cache_name, validation_context))
    return false;

  return true;
}

MultiCacheQueryOptions_Data::MultiCacheQueryOptions_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BatchOperation_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const BatchOperation_Data* object = static_cast<const BatchOperation_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::blink::mojom::internal::OperationType_Data
        ::Validate(object->operation_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->request, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->request, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->response, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->match_options, validation_context))
    return false;

  return true;
}

BatchOperation_Data::BatchOperation_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool EagerResponse_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const EagerResponse_Data* object = static_cast<const EagerResponse_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->response, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->response, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->pipe, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->pipe,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client_receiver, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client_receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

EagerResponse_Data::EagerResponse_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CacheEntry_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CacheEntry_Data* object = static_cast<const CacheEntry_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->request, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->request, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->response, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->response, validation_context))
    return false;

  return true;
}

CacheEntry_Data::CacheEntry_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CacheStorageCache_Match_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CacheStorageCache_Match_Params_Data* object = static_cast<const CacheStorageCache_Match_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->request, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->request, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->query_options, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->query_options, validation_context))
    return false;

  return true;
}

CacheStorageCache_Match_Params_Data::CacheStorageCache_Match_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CacheStorageCache_Match_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CacheStorageCache_Match_ResponseParams_Data* object = static_cast<const CacheStorageCache_Match_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

CacheStorageCache_Match_ResponseParams_Data::CacheStorageCache_Match_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CacheStorageCache_MatchAll_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CacheStorageCache_MatchAll_Params_Data* object = static_cast<const CacheStorageCache_MatchAll_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateStruct(object->request, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->query_options, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->query_options, validation_context))
    return false;

  return true;
}

CacheStorageCache_MatchAll_Params_Data::CacheStorageCache_MatchAll_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CacheStorageCache_MatchAll_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CacheStorageCache_MatchAll_ResponseParams_Data* object = static_cast<const CacheStorageCache_MatchAll_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

CacheStorageCache_MatchAll_ResponseParams_Data::CacheStorageCache_MatchAll_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CacheStorageCache_GetAllMatchedEntries_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CacheStorageCache_GetAllMatchedEntries_Params_Data* object = static_cast<const CacheStorageCache_GetAllMatchedEntries_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateStruct(object->request, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->query_options, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->query_options, validation_context))
    return false;

  return true;
}

CacheStorageCache_GetAllMatchedEntries_Params_Data::CacheStorageCache_GetAllMatchedEntries_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CacheStorageCache_GetAllMatchedEntries_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CacheStorageCache_GetAllMatchedEntries_ResponseParams_Data* object = static_cast<const CacheStorageCache_GetAllMatchedEntries_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

CacheStorageCache_GetAllMatchedEntries_ResponseParams_Data::CacheStorageCache_GetAllMatchedEntries_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CacheStorageCache_Keys_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CacheStorageCache_Keys_Params_Data* object = static_cast<const CacheStorageCache_Keys_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateStruct(object->request, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->query_options, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->query_options, validation_context))
    return false;

  return true;
}

CacheStorageCache_Keys_Params_Data::CacheStorageCache_Keys_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CacheStorageCache_Keys_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CacheStorageCache_Keys_ResponseParams_Data* object = static_cast<const CacheStorageCache_Keys_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

CacheStorageCache_Keys_ResponseParams_Data::CacheStorageCache_Keys_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CacheStorageCache_Batch_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CacheStorageCache_Batch_Params_Data* object = static_cast<const CacheStorageCache_Batch_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->batch_operations, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams batch_operations_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->batch_operations, validation_context,
                                         &batch_operations_validate_params)) {
    return false;
  }

  return true;
}

CacheStorageCache_Batch_Params_Data::CacheStorageCache_Batch_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CacheStorageCache_Batch_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CacheStorageCache_Batch_ResponseParams_Data* object = static_cast<const CacheStorageCache_Batch_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->result, validation_context))
    return false;

  return true;
}

CacheStorageCache_Batch_ResponseParams_Data::CacheStorageCache_Batch_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CacheStorageCache_WriteSideData_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CacheStorageCache_WriteSideData_Params_Data* object = static_cast<const CacheStorageCache_WriteSideData_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->expected_response_time, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->expected_response_time, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->data, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->data, validation_context))
    return false;

  return true;
}

CacheStorageCache_WriteSideData_Params_Data::CacheStorageCache_WriteSideData_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CacheStorageCache_WriteSideData_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CacheStorageCache_WriteSideData_ResponseParams_Data* object = static_cast<const CacheStorageCache_WriteSideData_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::blink::mojom::internal::CacheStorageError_Data
        ::Validate(object->result, validation_context))
    return false;

  return true;
}

CacheStorageCache_WriteSideData_ResponseParams_Data::CacheStorageCache_WriteSideData_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CacheStorage_Has_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CacheStorage_Has_Params_Data* object = static_cast<const CacheStorage_Has_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cache_name, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->cache_name, validation_context))
    return false;

  return true;
}

CacheStorage_Has_Params_Data::CacheStorage_Has_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CacheStorage_Has_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CacheStorage_Has_ResponseParams_Data* object = static_cast<const CacheStorage_Has_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::blink::mojom::internal::CacheStorageError_Data
        ::Validate(object->result, validation_context))
    return false;

  return true;
}

CacheStorage_Has_ResponseParams_Data::CacheStorage_Has_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CacheStorage_Delete_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CacheStorage_Delete_Params_Data* object = static_cast<const CacheStorage_Delete_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cache_name, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->cache_name, validation_context))
    return false;

  return true;
}

CacheStorage_Delete_Params_Data::CacheStorage_Delete_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CacheStorage_Delete_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CacheStorage_Delete_ResponseParams_Data* object = static_cast<const CacheStorage_Delete_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::blink::mojom::internal::CacheStorageError_Data
        ::Validate(object->result, validation_context))
    return false;

  return true;
}

CacheStorage_Delete_ResponseParams_Data::CacheStorage_Delete_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CacheStorage_Keys_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CacheStorage_Keys_Params_Data* object = static_cast<const CacheStorage_Keys_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

CacheStorage_Keys_Params_Data::CacheStorage_Keys_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CacheStorage_Keys_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CacheStorage_Keys_ResponseParams_Data* object = static_cast<const CacheStorage_Keys_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->keys, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams keys_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->keys, validation_context,
                                         &keys_validate_params)) {
    return false;
  }

  return true;
}

CacheStorage_Keys_ResponseParams_Data::CacheStorage_Keys_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CacheStorage_Match_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CacheStorage_Match_Params_Data* object = static_cast<const CacheStorage_Match_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->request, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->request, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->match_options, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->match_options, validation_context))
    return false;

  return true;
}

CacheStorage_Match_Params_Data::CacheStorage_Match_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CacheStorage_Match_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CacheStorage_Match_ResponseParams_Data* object = static_cast<const CacheStorage_Match_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

CacheStorage_Match_ResponseParams_Data::CacheStorage_Match_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CacheStorage_Open_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CacheStorage_Open_Params_Data* object = static_cast<const CacheStorage_Open_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cache_name, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->cache_name, validation_context))
    return false;

  return true;
}

CacheStorage_Open_Params_Data::CacheStorage_Open_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CacheStorage_Open_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CacheStorage_Open_ResponseParams_Data* object = static_cast<const CacheStorage_Open_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

CacheStorage_Open_ResponseParams_Data::CacheStorage_Open_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::CacheStorageError>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::blink::mojom::CacheStorageError value) {
  return std::move(context).WriteString(::blink::mojom::CacheStorageErrorToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::OperationType>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::blink::mojom::OperationType value) {
  return std::move(context).WriteString(::blink::mojom::OperationTypeToString(value));
}

} // namespace perfetto
