// third_party/blink/public/mojom/clipboard/clipboard.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/clipboard/clipboard.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/clipboard/clipboard.mojom-params-data.h"
#include "third_party/blink/public/mojom/clipboard/clipboard.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/clipboard/clipboard.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_CLIPBOARD_CLIPBOARD_MOJOM_BLINK_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_CLIPBOARD_CLIPBOARD_MOJOM_BLINK_JUMBO_H_
#endif
namespace blink {
namespace mojom {
namespace blink {
ClipboardFiles::ClipboardFiles()
    : files(),
      file_system_id() {}

ClipboardFiles::ClipboardFiles(
    WTF::Vector<::blink::mojom::blink::DataTransferFilePtr> files_in,
    const WTF::String& file_system_id_in)
    : files(std::move(files_in)),
      file_system_id(std::move(file_system_id_in)) {}

ClipboardFiles::~ClipboardFiles() = default;

void ClipboardFiles::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "files"), this->files, 
      "<value of type WTF::Vector<::blink::mojom::blink::DataTransferFilePtr>>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "file_system_id"), this->file_system_id, 
      "<value of type const WTF::String&>");
}

bool ClipboardFiles::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char ClipboardHost::Name_[] = "blink.mojom.ClipboardHost";
bool ClipboardHost::GetSequenceNumber(ClipboardBuffer buffer, uint64_t* out_result) {
  NOTREACHED();
  return false;
}
bool ClipboardHost::IsFormatAvailable(ClipboardFormat format, ClipboardBuffer buffer, bool* out_result) {
  NOTREACHED();
  return false;
}
bool ClipboardHost::ReadAvailableTypes(ClipboardBuffer buffer, WTF::Vector<::WTF::String>* out_types) {
  NOTREACHED();
  return false;
}
bool ClipboardHost::ReadText(ClipboardBuffer buffer, ::WTF::String* out_result) {
  NOTREACHED();
  return false;
}
bool ClipboardHost::ReadHtml(ClipboardBuffer buffer, ::WTF::String* out_markup, ::blink::KURL* out_url, uint32_t* out_fragment_start, uint32_t* out_fragment_end) {
  NOTREACHED();
  return false;
}
bool ClipboardHost::ReadRtf(ClipboardBuffer buffer, ::WTF::String* out_result) {
  NOTREACHED();
  return false;
}
bool ClipboardHost::ReadImage(ClipboardBuffer buffer, ::SkBitmap* out_image) {
  NOTREACHED();
  return false;
}
bool ClipboardHost::ReadFiles(ClipboardBuffer buffer, ClipboardFilesPtr* out_result) {
  NOTREACHED();
  return false;
}
bool ClipboardHost::ReadCustomData(ClipboardBuffer buffer, const ::WTF::String& type, ::WTF::String* out_result) {
  NOTREACHED();
  return false;
}
class ClipboardHost_GetSequenceNumber_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  ClipboardHost_GetSequenceNumber_HandleSyncResponse(
      bool* result, uint64_t* out_result)
      : result_(result), out_result_(out_result) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  uint64_t* out_result_;DISALLOW_COPY_AND_ASSIGN(ClipboardHost_GetSequenceNumber_HandleSyncResponse);
};

class ClipboardHost_GetSequenceNumber_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ClipboardHost_GetSequenceNumber_ForwardToCallback(
      ClipboardHost::GetSequenceNumberCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ClipboardHost::GetSequenceNumberCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ClipboardHost_GetSequenceNumber_ForwardToCallback);
};
class ClipboardHost_IsFormatAvailable_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  ClipboardHost_IsFormatAvailable_HandleSyncResponse(
      bool* result, bool* out_result)
      : result_(result), out_result_(out_result) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  bool* out_result_;DISALLOW_COPY_AND_ASSIGN(ClipboardHost_IsFormatAvailable_HandleSyncResponse);
};

class ClipboardHost_IsFormatAvailable_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ClipboardHost_IsFormatAvailable_ForwardToCallback(
      ClipboardHost::IsFormatAvailableCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ClipboardHost::IsFormatAvailableCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ClipboardHost_IsFormatAvailable_ForwardToCallback);
};
class ClipboardHost_ReadAvailableTypes_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  ClipboardHost_ReadAvailableTypes_HandleSyncResponse(
      bool* result, WTF::Vector<::WTF::String>* out_types)
      : result_(result), out_types_(out_types) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  WTF::Vector<::WTF::String>* out_types_;DISALLOW_COPY_AND_ASSIGN(ClipboardHost_ReadAvailableTypes_HandleSyncResponse);
};

class ClipboardHost_ReadAvailableTypes_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ClipboardHost_ReadAvailableTypes_ForwardToCallback(
      ClipboardHost::ReadAvailableTypesCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ClipboardHost::ReadAvailableTypesCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ClipboardHost_ReadAvailableTypes_ForwardToCallback);
};
class ClipboardHost_ReadText_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  ClipboardHost_ReadText_HandleSyncResponse(
      bool* result, ::WTF::String* out_result)
      : result_(result), out_result_(out_result) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::WTF::String* out_result_;DISALLOW_COPY_AND_ASSIGN(ClipboardHost_ReadText_HandleSyncResponse);
};

class ClipboardHost_ReadText_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ClipboardHost_ReadText_ForwardToCallback(
      ClipboardHost::ReadTextCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ClipboardHost::ReadTextCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ClipboardHost_ReadText_ForwardToCallback);
};
class ClipboardHost_ReadHtml_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  ClipboardHost_ReadHtml_HandleSyncResponse(
      bool* result, ::WTF::String* out_markup, ::blink::KURL* out_url, uint32_t* out_fragment_start, uint32_t* out_fragment_end)
      : result_(result), out_markup_(out_markup), out_url_(out_url), out_fragment_start_(out_fragment_start), out_fragment_end_(out_fragment_end) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::WTF::String* out_markup_;
  ::blink::KURL* out_url_;
  uint32_t* out_fragment_start_;
  uint32_t* out_fragment_end_;DISALLOW_COPY_AND_ASSIGN(ClipboardHost_ReadHtml_HandleSyncResponse);
};

class ClipboardHost_ReadHtml_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ClipboardHost_ReadHtml_ForwardToCallback(
      ClipboardHost::ReadHtmlCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ClipboardHost::ReadHtmlCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ClipboardHost_ReadHtml_ForwardToCallback);
};

class ClipboardHost_ReadSvg_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ClipboardHost_ReadSvg_ForwardToCallback(
      ClipboardHost::ReadSvgCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ClipboardHost::ReadSvgCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ClipboardHost_ReadSvg_ForwardToCallback);
};
class ClipboardHost_ReadRtf_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  ClipboardHost_ReadRtf_HandleSyncResponse(
      bool* result, ::WTF::String* out_result)
      : result_(result), out_result_(out_result) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::WTF::String* out_result_;DISALLOW_COPY_AND_ASSIGN(ClipboardHost_ReadRtf_HandleSyncResponse);
};

class ClipboardHost_ReadRtf_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ClipboardHost_ReadRtf_ForwardToCallback(
      ClipboardHost::ReadRtfCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ClipboardHost::ReadRtfCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ClipboardHost_ReadRtf_ForwardToCallback);
};
class ClipboardHost_ReadImage_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  ClipboardHost_ReadImage_HandleSyncResponse(
      bool* result, ::SkBitmap* out_image)
      : result_(result), out_image_(out_image) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::SkBitmap* out_image_;DISALLOW_COPY_AND_ASSIGN(ClipboardHost_ReadImage_HandleSyncResponse);
};

class ClipboardHost_ReadImage_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ClipboardHost_ReadImage_ForwardToCallback(
      ClipboardHost::ReadImageCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ClipboardHost::ReadImageCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ClipboardHost_ReadImage_ForwardToCallback);
};
class ClipboardHost_ReadFiles_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  ClipboardHost_ReadFiles_HandleSyncResponse(
      bool* result, ClipboardFilesPtr* out_result)
      : result_(result), out_result_(out_result) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ClipboardFilesPtr* out_result_;DISALLOW_COPY_AND_ASSIGN(ClipboardHost_ReadFiles_HandleSyncResponse);
};

class ClipboardHost_ReadFiles_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ClipboardHost_ReadFiles_ForwardToCallback(
      ClipboardHost::ReadFilesCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ClipboardHost::ReadFilesCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ClipboardHost_ReadFiles_ForwardToCallback);
};
class ClipboardHost_ReadCustomData_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  ClipboardHost_ReadCustomData_HandleSyncResponse(
      bool* result, ::WTF::String* out_result)
      : result_(result), out_result_(out_result) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::WTF::String* out_result_;DISALLOW_COPY_AND_ASSIGN(ClipboardHost_ReadCustomData_HandleSyncResponse);
};

class ClipboardHost_ReadCustomData_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ClipboardHost_ReadCustomData_ForwardToCallback(
      ClipboardHost::ReadCustomDataCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ClipboardHost::ReadCustomDataCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ClipboardHost_ReadCustomData_ForwardToCallback);
};

ClipboardHostProxy::ClipboardHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}
bool ClipboardHostProxy::GetSequenceNumber(
    ClipboardBuffer param_buffer, uint64_t* out_param_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "blink::mojom::ClipboardHost::GetSequenceNumber", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer"), param_buffer, 
                        "<value of type ClipboardBuffer>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kClipboardHost_GetSequenceNumber_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ClipboardHost_GetSequenceNumber_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::ClipboardBuffer>(
      param_buffer, &params->buffer);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClipboardHost::Name_);
  message.set_method_name("GetSequenceNumber");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ClipboardHost_GetSequenceNumber_HandleSyncResponse(
          &result, out_param_result));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "blink::mojom::ClipboardHost::GetSequenceNumber", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), out_param_result, 
                        "<value of type uint64_t>");
   });
#endif
  return result;
}

void ClipboardHostProxy::GetSequenceNumber(
    ClipboardBuffer in_buffer, GetSequenceNumberCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ClipboardHost::GetSequenceNumber", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer"), in_buffer, 
                        "<value of type ClipboardBuffer>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kClipboardHost_GetSequenceNumber_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ClipboardHost_GetSequenceNumber_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::ClipboardBuffer>(
      in_buffer, &params->buffer);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClipboardHost::Name_);
  message.set_method_name("GetSequenceNumber");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ClipboardHost_GetSequenceNumber_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
bool ClipboardHostProxy::IsFormatAvailable(
    ClipboardFormat param_format, ClipboardBuffer param_buffer, bool* out_param_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "blink::mojom::ClipboardHost::IsFormatAvailable", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("format"), param_format, 
                        "<value of type ClipboardFormat>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer"), param_buffer, 
                        "<value of type ClipboardBuffer>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kClipboardHost_IsFormatAvailable_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ClipboardHost_IsFormatAvailable_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::ClipboardFormat>(
      param_format, &params->format);
  mojo::internal::Serialize<::blink::mojom::ClipboardBuffer>(
      param_buffer, &params->buffer);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClipboardHost::Name_);
  message.set_method_name("IsFormatAvailable");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ClipboardHost_IsFormatAvailable_HandleSyncResponse(
          &result, out_param_result));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "blink::mojom::ClipboardHost::IsFormatAvailable", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), out_param_result, 
                        "<value of type bool>");
   });
#endif
  return result;
}

void ClipboardHostProxy::IsFormatAvailable(
    ClipboardFormat in_format, ClipboardBuffer in_buffer, IsFormatAvailableCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ClipboardHost::IsFormatAvailable", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("format"), in_format, 
                        "<value of type ClipboardFormat>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer"), in_buffer, 
                        "<value of type ClipboardBuffer>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kClipboardHost_IsFormatAvailable_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ClipboardHost_IsFormatAvailable_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::ClipboardFormat>(
      in_format, &params->format);
  mojo::internal::Serialize<::blink::mojom::ClipboardBuffer>(
      in_buffer, &params->buffer);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClipboardHost::Name_);
  message.set_method_name("IsFormatAvailable");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ClipboardHost_IsFormatAvailable_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
bool ClipboardHostProxy::ReadAvailableTypes(
    ClipboardBuffer param_buffer, WTF::Vector<::WTF::String>* out_param_types) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "blink::mojom::ClipboardHost::ReadAvailableTypes", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer"), param_buffer, 
                        "<value of type ClipboardBuffer>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kClipboardHost_ReadAvailableTypes_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ClipboardHost_ReadAvailableTypes_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::ClipboardBuffer>(
      param_buffer, &params->buffer);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClipboardHost::Name_);
  message.set_method_name("ReadAvailableTypes");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ClipboardHost_ReadAvailableTypes_HandleSyncResponse(
          &result, out_param_types));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "blink::mojom::ClipboardHost::ReadAvailableTypes", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("types"), out_param_types, 
                        "<value of type const WTF::Vector<::WTF::String>&>");
   });
#endif
  return result;
}

void ClipboardHostProxy::ReadAvailableTypes(
    ClipboardBuffer in_buffer, ReadAvailableTypesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ClipboardHost::ReadAvailableTypes", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer"), in_buffer, 
                        "<value of type ClipboardBuffer>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kClipboardHost_ReadAvailableTypes_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ClipboardHost_ReadAvailableTypes_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::ClipboardBuffer>(
      in_buffer, &params->buffer);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClipboardHost::Name_);
  message.set_method_name("ReadAvailableTypes");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ClipboardHost_ReadAvailableTypes_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
bool ClipboardHostProxy::ReadText(
    ClipboardBuffer param_buffer, ::WTF::String* out_param_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "blink::mojom::ClipboardHost::ReadText", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer"), param_buffer, 
                        "<value of type ClipboardBuffer>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kClipboardHost_ReadText_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ClipboardHost_ReadText_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::ClipboardBuffer>(
      param_buffer, &params->buffer);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClipboardHost::Name_);
  message.set_method_name("ReadText");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ClipboardHost_ReadText_HandleSyncResponse(
          &result, out_param_result));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "blink::mojom::ClipboardHost::ReadText", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), out_param_result, 
                        "<value of type const ::WTF::String&>");
   });
#endif
  return result;
}

void ClipboardHostProxy::ReadText(
    ClipboardBuffer in_buffer, ReadTextCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ClipboardHost::ReadText", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer"), in_buffer, 
                        "<value of type ClipboardBuffer>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kClipboardHost_ReadText_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ClipboardHost_ReadText_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::ClipboardBuffer>(
      in_buffer, &params->buffer);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClipboardHost::Name_);
  message.set_method_name("ReadText");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ClipboardHost_ReadText_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
bool ClipboardHostProxy::ReadHtml(
    ClipboardBuffer param_buffer, ::WTF::String* out_param_markup, ::blink::KURL* out_param_url, uint32_t* out_param_fragment_start, uint32_t* out_param_fragment_end) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "blink::mojom::ClipboardHost::ReadHtml", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer"), param_buffer, 
                        "<value of type ClipboardBuffer>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kClipboardHost_ReadHtml_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ClipboardHost_ReadHtml_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::ClipboardBuffer>(
      param_buffer, &params->buffer);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClipboardHost::Name_);
  message.set_method_name("ReadHtml");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ClipboardHost_ReadHtml_HandleSyncResponse(
          &result, out_param_markup, out_param_url, out_param_fragment_start, out_param_fragment_end));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "blink::mojom::ClipboardHost::ReadHtml", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("markup"), out_param_markup, 
                        "<value of type const ::WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), out_param_url, 
                        "<value of type const ::blink::KURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("fragment_start"), out_param_fragment_start, 
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("fragment_end"), out_param_fragment_end, 
                        "<value of type uint32_t>");
   });
#endif
  return result;
}

void ClipboardHostProxy::ReadHtml(
    ClipboardBuffer in_buffer, ReadHtmlCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ClipboardHost::ReadHtml", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer"), in_buffer, 
                        "<value of type ClipboardBuffer>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kClipboardHost_ReadHtml_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ClipboardHost_ReadHtml_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::ClipboardBuffer>(
      in_buffer, &params->buffer);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClipboardHost::Name_);
  message.set_method_name("ReadHtml");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ClipboardHost_ReadHtml_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ClipboardHostProxy::ReadSvg(
    ClipboardBuffer in_buffer, ReadSvgCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ClipboardHost::ReadSvg", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer"), in_buffer, 
                        "<value of type ClipboardBuffer>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kClipboardHost_ReadSvg_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ClipboardHost_ReadSvg_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::ClipboardBuffer>(
      in_buffer, &params->buffer);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClipboardHost::Name_);
  message.set_method_name("ReadSvg");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ClipboardHost_ReadSvg_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
bool ClipboardHostProxy::ReadRtf(
    ClipboardBuffer param_buffer, ::WTF::String* out_param_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "blink::mojom::ClipboardHost::ReadRtf", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer"), param_buffer, 
                        "<value of type ClipboardBuffer>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kClipboardHost_ReadRtf_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ClipboardHost_ReadRtf_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::ClipboardBuffer>(
      param_buffer, &params->buffer);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClipboardHost::Name_);
  message.set_method_name("ReadRtf");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ClipboardHost_ReadRtf_HandleSyncResponse(
          &result, out_param_result));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "blink::mojom::ClipboardHost::ReadRtf", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), out_param_result, 
                        "<value of type const ::WTF::String&>");
   });
#endif
  return result;
}

void ClipboardHostProxy::ReadRtf(
    ClipboardBuffer in_buffer, ReadRtfCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ClipboardHost::ReadRtf", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer"), in_buffer, 
                        "<value of type ClipboardBuffer>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kClipboardHost_ReadRtf_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ClipboardHost_ReadRtf_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::ClipboardBuffer>(
      in_buffer, &params->buffer);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClipboardHost::Name_);
  message.set_method_name("ReadRtf");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ClipboardHost_ReadRtf_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
bool ClipboardHostProxy::ReadImage(
    ClipboardBuffer param_buffer, ::SkBitmap* out_param_image) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "blink::mojom::ClipboardHost::ReadImage", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer"), param_buffer, 
                        "<value of type ClipboardBuffer>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kClipboardHost_ReadImage_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ClipboardHost_ReadImage_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::ClipboardBuffer>(
      param_buffer, &params->buffer);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClipboardHost::Name_);
  message.set_method_name("ReadImage");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ClipboardHost_ReadImage_HandleSyncResponse(
          &result, out_param_image));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "blink::mojom::ClipboardHost::ReadImage", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("image"), out_param_image, 
                        "<value of type const ::SkBitmap&>");
   });
#endif
  return result;
}

void ClipboardHostProxy::ReadImage(
    ClipboardBuffer in_buffer, ReadImageCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ClipboardHost::ReadImage", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer"), in_buffer, 
                        "<value of type ClipboardBuffer>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kClipboardHost_ReadImage_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ClipboardHost_ReadImage_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::ClipboardBuffer>(
      in_buffer, &params->buffer);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClipboardHost::Name_);
  message.set_method_name("ReadImage");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ClipboardHost_ReadImage_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
bool ClipboardHostProxy::ReadFiles(
    ClipboardBuffer param_buffer, ClipboardFilesPtr* out_param_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "blink::mojom::ClipboardHost::ReadFiles", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer"), param_buffer, 
                        "<value of type ClipboardBuffer>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kClipboardHost_ReadFiles_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ClipboardHost_ReadFiles_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::ClipboardBuffer>(
      param_buffer, &params->buffer);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClipboardHost::Name_);
  message.set_method_name("ReadFiles");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ClipboardHost_ReadFiles_HandleSyncResponse(
          &result, out_param_result));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "blink::mojom::ClipboardHost::ReadFiles", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), out_param_result, 
                        "<value of type ClipboardFilesPtr>");
   });
#endif
  return result;
}

void ClipboardHostProxy::ReadFiles(
    ClipboardBuffer in_buffer, ReadFilesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ClipboardHost::ReadFiles", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer"), in_buffer, 
                        "<value of type ClipboardBuffer>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kClipboardHost_ReadFiles_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ClipboardHost_ReadFiles_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::ClipboardBuffer>(
      in_buffer, &params->buffer);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClipboardHost::Name_);
  message.set_method_name("ReadFiles");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ClipboardHost_ReadFiles_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
bool ClipboardHostProxy::ReadCustomData(
    ClipboardBuffer param_buffer, const ::WTF::String& param_type, ::WTF::String* out_param_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "blink::mojom::ClipboardHost::ReadCustomData", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer"), param_buffer, 
                        "<value of type ClipboardBuffer>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), param_type, 
                        "<value of type const ::WTF::String&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kClipboardHost_ReadCustomData_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ClipboardHost_ReadCustomData_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::ClipboardBuffer>(
      param_buffer, &params->buffer);
  mojo::internal::MessageFragment<
      typename decltype(params->type)::BaseType> type_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      param_type, type_fragment);
  params->type.Set(
      type_fragment.is_null() ? nullptr : type_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->type.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null type in ClipboardHost.ReadCustomData request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClipboardHost::Name_);
  message.set_method_name("ReadCustomData");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ClipboardHost_ReadCustomData_HandleSyncResponse(
          &result, out_param_result));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "blink::mojom::ClipboardHost::ReadCustomData", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), out_param_result, 
                        "<value of type const ::WTF::String&>");
   });
#endif
  return result;
}

void ClipboardHostProxy::ReadCustomData(
    ClipboardBuffer in_buffer, const ::WTF::String& in_type, ReadCustomDataCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ClipboardHost::ReadCustomData", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer"), in_buffer, 
                        "<value of type ClipboardBuffer>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type, 
                        "<value of type const ::WTF::String&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kClipboardHost_ReadCustomData_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ClipboardHost_ReadCustomData_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::ClipboardBuffer>(
      in_buffer, &params->buffer);
  mojo::internal::MessageFragment<
      typename decltype(params->type)::BaseType> type_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_type, type_fragment);
  params->type.Set(
      type_fragment.is_null() ? nullptr : type_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->type.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null type in ClipboardHost.ReadCustomData request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClipboardHost::Name_);
  message.set_method_name("ReadCustomData");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ClipboardHost_ReadCustomData_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ClipboardHostProxy::WriteText(
    const ::WTF::String& in_text) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ClipboardHost::WriteText", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("text"), in_text, 
                        "<value of type const ::WTF::String&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kClipboardHost_WriteText_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ClipboardHost_WriteText_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->text)::BaseType> text_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::BigString16DataView>(
      in_text, text_fragment);
  params->text.Set(
      text_fragment.is_null() ? nullptr : text_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->text.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null text in ClipboardHost.WriteText request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClipboardHost::Name_);
  message.set_method_name("WriteText");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void ClipboardHostProxy::WriteHtml(
    const ::WTF::String& in_markup, const ::blink::KURL& in_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ClipboardHost::WriteHtml", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("markup"), in_markup, 
                        "<value of type const ::WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url, 
                        "<value of type const ::blink::KURL&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kClipboardHost_WriteHtml_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ClipboardHost_WriteHtml_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->markup)::BaseType> markup_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::BigString16DataView>(
      in_markup, markup_fragment);
  params->markup.Set(
      markup_fragment.is_null() ? nullptr : markup_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->markup.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null markup in ClipboardHost.WriteHtml request");
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, url_fragment);
  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in ClipboardHost.WriteHtml request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClipboardHost::Name_);
  message.set_method_name("WriteHtml");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void ClipboardHostProxy::WriteSvg(
    const ::WTF::String& in_markup) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ClipboardHost::WriteSvg", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("markup"), in_markup, 
                        "<value of type const ::WTF::String&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kClipboardHost_WriteSvg_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ClipboardHost_WriteSvg_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->markup)::BaseType> markup_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::BigString16DataView>(
      in_markup, markup_fragment);
  params->markup.Set(
      markup_fragment.is_null() ? nullptr : markup_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->markup.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null markup in ClipboardHost.WriteSvg request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClipboardHost::Name_);
  message.set_method_name("WriteSvg");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void ClipboardHostProxy::WriteSmartPasteMarker(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::ClipboardHost::WriteSmartPasteMarker");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kClipboardHost_WriteSmartPasteMarker_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ClipboardHost_WriteSmartPasteMarker_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClipboardHost::Name_);
  message.set_method_name("WriteSmartPasteMarker");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void ClipboardHostProxy::WriteCustomData(
    const WTF::HashMap<::WTF::String, ::WTF::String>& in_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ClipboardHost::WriteCustomData", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data, 
                        "<value of type const WTF::HashMap<::WTF::String, ::WTF::String>&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kClipboardHost_WriteCustomData_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ClipboardHost_WriteCustomData_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->data)::BaseType>
      data_fragment(params.message());
  const mojo::internal::ContainerValidateParams data_validate_params(
      new mojo::internal::ContainerValidateParams(0, false, nullptr), new mojo::internal::ContainerValidateParams(0, false, nullptr));
  mojo::internal::Serialize<mojo::MapDataView<::mojo_base::mojom::String16DataView, ::mojo_base::mojom::BigString16DataView>>(
      in_data, data_fragment, &data_validate_params);
  params->data.Set(
      data_fragment.is_null() ? nullptr : data_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null data in ClipboardHost.WriteCustomData request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClipboardHost::Name_);
  message.set_method_name("WriteCustomData");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void ClipboardHostProxy::WriteBookmark(
    const WTF::String& in_url, const ::WTF::String& in_title) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ClipboardHost::WriteBookmark", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url, 
                        "<value of type const WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("title"), in_title, 
                        "<value of type const ::WTF::String&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kClipboardHost_WriteBookmark_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ClipboardHost_WriteBookmark_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_url, url_fragment);
  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in ClipboardHost.WriteBookmark request");
  mojo::internal::MessageFragment<
      typename decltype(params->title)::BaseType> title_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_title, title_fragment);
  params->title.Set(
      title_fragment.is_null() ? nullptr : title_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->title.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null title in ClipboardHost.WriteBookmark request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClipboardHost::Name_);
  message.set_method_name("WriteBookmark");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void ClipboardHostProxy::WriteImage(
    const ::SkBitmap& in_image) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ClipboardHost::WriteImage", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("image"), in_image, 
                        "<value of type const ::SkBitmap&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kClipboardHost_WriteImage_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ClipboardHost_WriteImage_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->image)::BaseType> image_fragment(
          params.message());
  mojo::internal::Serialize<::skia::mojom::BitmapN32DataView>(
      in_image, image_fragment);
  params->image.Set(
      image_fragment.is_null() ? nullptr : image_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->image.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null image in ClipboardHost.WriteImage request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClipboardHost::Name_);
  message.set_method_name("WriteImage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void ClipboardHostProxy::CommitWrite(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::ClipboardHost::CommitWrite");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kClipboardHost_CommitWrite_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ClipboardHost_CommitWrite_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClipboardHost::Name_);
  message.set_method_name("CommitWrite");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class ClipboardHost_GetSequenceNumber_ProxyToResponder {
 public:
  static ClipboardHost::GetSequenceNumberCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ClipboardHost_GetSequenceNumber_ProxyToResponder> proxy(
        new ClipboardHost_GetSequenceNumber_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ClipboardHost_GetSequenceNumber_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ClipboardHost_GetSequenceNumber_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ClipboardHost_GetSequenceNumber_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ClipboardHost::GetSequenceNumberCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      uint64_t in_result);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ClipboardHost_GetSequenceNumber_ProxyToResponder);
};

bool ClipboardHost_GetSequenceNumber_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::ClipboardHost::GetSequenceNumberCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ClipboardHost_GetSequenceNumber_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ClipboardHost_GetSequenceNumber_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  uint64_t p_result{};
  ClipboardHost_GetSequenceNumber_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_result = input_data_view.result();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ClipboardHost::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void ClipboardHost_GetSequenceNumber_ProxyToResponder::Run(
    uint64_t in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::ClipboardHost::GetSequenceNumberCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result, 
                        "<value of type uint64_t>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kClipboardHost_GetSequenceNumber_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ClipboardHost_GetSequenceNumber_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->result = in_result;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::ClipboardHost::GetSequenceNumberCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClipboardHost::Name_);
  message.set_method_name("GetSequenceNumber");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool ClipboardHost_GetSequenceNumber_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::ClipboardHost_GetSequenceNumber_ResponseParams_Data* params =
      reinterpret_cast<internal::ClipboardHost_GetSequenceNumber_ResponseParams_Data*>(
          message->mutable_payload());
  
  bool success = true;
  uint64_t p_result{};
  ClipboardHost_GetSequenceNumber_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_result = input_data_view.result();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ClipboardHost::Name_, 0, true);
    return false;
  }
  *out_result_ = std::move(p_result);
  mojo::internal::SyncMessageResponseSetup::SetCurrentSyncResponseMessage(
      message);
  *result_ = true;
  return true;
}
class ClipboardHost_IsFormatAvailable_ProxyToResponder {
 public:
  static ClipboardHost::IsFormatAvailableCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ClipboardHost_IsFormatAvailable_ProxyToResponder> proxy(
        new ClipboardHost_IsFormatAvailable_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ClipboardHost_IsFormatAvailable_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ClipboardHost_IsFormatAvailable_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ClipboardHost_IsFormatAvailable_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ClipboardHost::IsFormatAvailableCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_result);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ClipboardHost_IsFormatAvailable_ProxyToResponder);
};

bool ClipboardHost_IsFormatAvailable_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::ClipboardHost::IsFormatAvailableCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ClipboardHost_IsFormatAvailable_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ClipboardHost_IsFormatAvailable_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  bool p_result{};
  ClipboardHost_IsFormatAvailable_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_result = input_data_view.result();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ClipboardHost::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void ClipboardHost_IsFormatAvailable_ProxyToResponder::Run(
    bool in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::ClipboardHost::IsFormatAvailableCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result, 
                        "<value of type bool>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kClipboardHost_IsFormatAvailable_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ClipboardHost_IsFormatAvailable_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->result = in_result;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::ClipboardHost::IsFormatAvailableCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClipboardHost::Name_);
  message.set_method_name("IsFormatAvailable");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool ClipboardHost_IsFormatAvailable_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::ClipboardHost_IsFormatAvailable_ResponseParams_Data* params =
      reinterpret_cast<internal::ClipboardHost_IsFormatAvailable_ResponseParams_Data*>(
          message->mutable_payload());
  
  bool success = true;
  bool p_result{};
  ClipboardHost_IsFormatAvailable_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_result = input_data_view.result();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ClipboardHost::Name_, 1, true);
    return false;
  }
  *out_result_ = std::move(p_result);
  mojo::internal::SyncMessageResponseSetup::SetCurrentSyncResponseMessage(
      message);
  *result_ = true;
  return true;
}
class ClipboardHost_ReadAvailableTypes_ProxyToResponder {
 public:
  static ClipboardHost::ReadAvailableTypesCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ClipboardHost_ReadAvailableTypes_ProxyToResponder> proxy(
        new ClipboardHost_ReadAvailableTypes_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ClipboardHost_ReadAvailableTypes_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ClipboardHost_ReadAvailableTypes_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ClipboardHost_ReadAvailableTypes_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ClipboardHost::ReadAvailableTypesCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const WTF::Vector<::WTF::String>& in_types);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ClipboardHost_ReadAvailableTypes_ProxyToResponder);
};

bool ClipboardHost_ReadAvailableTypes_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::ClipboardHost::ReadAvailableTypesCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ClipboardHost_ReadAvailableTypes_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ClipboardHost_ReadAvailableTypes_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  WTF::Vector<::WTF::String> p_types{};
  ClipboardHost_ReadAvailableTypes_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadTypes(&p_types))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ClipboardHost::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_types));
  return true;
}

void ClipboardHost_ReadAvailableTypes_ProxyToResponder::Run(
    const WTF::Vector<::WTF::String>& in_types) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::ClipboardHost::ReadAvailableTypesCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("types"), in_types, 
                        "<value of type const WTF::Vector<::WTF::String>&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kClipboardHost_ReadAvailableTypes_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ClipboardHost_ReadAvailableTypes_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->types)::BaseType>
      types_fragment(params.message());
  const mojo::internal::ContainerValidateParams types_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::mojo_base::mojom::String16DataView>>(
      in_types, types_fragment, &types_validate_params);
  params->types.Set(
      types_fragment.is_null() ? nullptr : types_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->types.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null types in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::ClipboardHost::ReadAvailableTypesCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClipboardHost::Name_);
  message.set_method_name("ReadAvailableTypes");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool ClipboardHost_ReadAvailableTypes_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::ClipboardHost_ReadAvailableTypes_ResponseParams_Data* params =
      reinterpret_cast<internal::ClipboardHost_ReadAvailableTypes_ResponseParams_Data*>(
          message->mutable_payload());
  
  bool success = true;
  WTF::Vector<::WTF::String> p_types{};
  ClipboardHost_ReadAvailableTypes_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadTypes(&p_types))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ClipboardHost::Name_, 2, true);
    return false;
  }
  *out_types_ = std::move(p_types);
  mojo::internal::SyncMessageResponseSetup::SetCurrentSyncResponseMessage(
      message);
  *result_ = true;
  return true;
}
class ClipboardHost_ReadText_ProxyToResponder {
 public:
  static ClipboardHost::ReadTextCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ClipboardHost_ReadText_ProxyToResponder> proxy(
        new ClipboardHost_ReadText_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ClipboardHost_ReadText_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ClipboardHost_ReadText_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ClipboardHost_ReadText_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ClipboardHost::ReadTextCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::WTF::String& in_result);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ClipboardHost_ReadText_ProxyToResponder);
};

bool ClipboardHost_ReadText_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::ClipboardHost::ReadTextCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ClipboardHost_ReadText_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ClipboardHost_ReadText_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::WTF::String p_result{};
  ClipboardHost_ReadText_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ClipboardHost::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void ClipboardHost_ReadText_ProxyToResponder::Run(
    const ::WTF::String& in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::ClipboardHost::ReadTextCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result, 
                        "<value of type const ::WTF::String&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kClipboardHost_ReadText_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ClipboardHost_ReadText_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::BigString16DataView>(
      in_result, result_fragment);
  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::ClipboardHost::ReadTextCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClipboardHost::Name_);
  message.set_method_name("ReadText");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool ClipboardHost_ReadText_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::ClipboardHost_ReadText_ResponseParams_Data* params =
      reinterpret_cast<internal::ClipboardHost_ReadText_ResponseParams_Data*>(
          message->mutable_payload());
  
  bool success = true;
  ::WTF::String p_result{};
  ClipboardHost_ReadText_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ClipboardHost::Name_, 3, true);
    return false;
  }
  *out_result_ = std::move(p_result);
  mojo::internal::SyncMessageResponseSetup::SetCurrentSyncResponseMessage(
      message);
  *result_ = true;
  return true;
}
class ClipboardHost_ReadHtml_ProxyToResponder {
 public:
  static ClipboardHost::ReadHtmlCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ClipboardHost_ReadHtml_ProxyToResponder> proxy(
        new ClipboardHost_ReadHtml_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ClipboardHost_ReadHtml_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ClipboardHost_ReadHtml_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ClipboardHost_ReadHtml_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ClipboardHost::ReadHtmlCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::WTF::String& in_markup, const ::blink::KURL& in_url, uint32_t in_fragment_start, uint32_t in_fragment_end);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ClipboardHost_ReadHtml_ProxyToResponder);
};

bool ClipboardHost_ReadHtml_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::ClipboardHost::ReadHtmlCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ClipboardHost_ReadHtml_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ClipboardHost_ReadHtml_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::WTF::String p_markup{};
  ::blink::KURL p_url{};
  uint32_t p_fragment_start{};
  uint32_t p_fragment_end{};
  ClipboardHost_ReadHtml_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadMarkup(&p_markup))
    success = false;
  if (success && !input_data_view.ReadUrl(&p_url))
    success = false;
  if (success)
    p_fragment_start = input_data_view.fragment_start();
  if (success)
    p_fragment_end = input_data_view.fragment_end();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ClipboardHost::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_markup), 
std::move(p_url), 
std::move(p_fragment_start), 
std::move(p_fragment_end));
  return true;
}

void ClipboardHost_ReadHtml_ProxyToResponder::Run(
    const ::WTF::String& in_markup, const ::blink::KURL& in_url, uint32_t in_fragment_start, uint32_t in_fragment_end) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::ClipboardHost::ReadHtmlCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("markup"), in_markup, 
                        "<value of type const ::WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url, 
                        "<value of type const ::blink::KURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("fragment_start"), in_fragment_start, 
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("fragment_end"), in_fragment_end, 
                        "<value of type uint32_t>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kClipboardHost_ReadHtml_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ClipboardHost_ReadHtml_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->markup)::BaseType> markup_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::BigString16DataView>(
      in_markup, markup_fragment);
  params->markup.Set(
      markup_fragment.is_null() ? nullptr : markup_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->markup.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null markup in ");
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, url_fragment);
  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in ");
  params->fragment_start = in_fragment_start;
  params->fragment_end = in_fragment_end;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::ClipboardHost::ReadHtmlCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClipboardHost::Name_);
  message.set_method_name("ReadHtml");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool ClipboardHost_ReadHtml_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::ClipboardHost_ReadHtml_ResponseParams_Data* params =
      reinterpret_cast<internal::ClipboardHost_ReadHtml_ResponseParams_Data*>(
          message->mutable_payload());
  
  bool success = true;
  ::WTF::String p_markup{};
  ::blink::KURL p_url{};
  uint32_t p_fragment_start{};
  uint32_t p_fragment_end{};
  ClipboardHost_ReadHtml_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadMarkup(&p_markup))
    success = false;
  if (success && !input_data_view.ReadUrl(&p_url))
    success = false;
  if (success)
    p_fragment_start = input_data_view.fragment_start();
  if (success)
    p_fragment_end = input_data_view.fragment_end();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ClipboardHost::Name_, 4, true);
    return false;
  }
  *out_markup_ = std::move(p_markup);
  *out_url_ = std::move(p_url);
  *out_fragment_start_ = std::move(p_fragment_start);
  *out_fragment_end_ = std::move(p_fragment_end);
  mojo::internal::SyncMessageResponseSetup::SetCurrentSyncResponseMessage(
      message);
  *result_ = true;
  return true;
}
class ClipboardHost_ReadSvg_ProxyToResponder {
 public:
  static ClipboardHost::ReadSvgCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ClipboardHost_ReadSvg_ProxyToResponder> proxy(
        new ClipboardHost_ReadSvg_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ClipboardHost_ReadSvg_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ClipboardHost_ReadSvg_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ClipboardHost_ReadSvg_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ClipboardHost::ReadSvgCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::WTF::String& in_result);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ClipboardHost_ReadSvg_ProxyToResponder);
};

bool ClipboardHost_ReadSvg_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::ClipboardHost::ReadSvgCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ClipboardHost_ReadSvg_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ClipboardHost_ReadSvg_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::WTF::String p_result{};
  ClipboardHost_ReadSvg_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ClipboardHost::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void ClipboardHost_ReadSvg_ProxyToResponder::Run(
    const ::WTF::String& in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::ClipboardHost::ReadSvgCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result, 
                        "<value of type const ::WTF::String&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kClipboardHost_ReadSvg_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ClipboardHost_ReadSvg_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::BigString16DataView>(
      in_result, result_fragment);
  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::ClipboardHost::ReadSvgCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClipboardHost::Name_);
  message.set_method_name("ReadSvg");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ClipboardHost_ReadRtf_ProxyToResponder {
 public:
  static ClipboardHost::ReadRtfCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ClipboardHost_ReadRtf_ProxyToResponder> proxy(
        new ClipboardHost_ReadRtf_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ClipboardHost_ReadRtf_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ClipboardHost_ReadRtf_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ClipboardHost_ReadRtf_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ClipboardHost::ReadRtfCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::WTF::String& in_result);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ClipboardHost_ReadRtf_ProxyToResponder);
};

bool ClipboardHost_ReadRtf_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::ClipboardHost::ReadRtfCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ClipboardHost_ReadRtf_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ClipboardHost_ReadRtf_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::WTF::String p_result{};
  ClipboardHost_ReadRtf_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ClipboardHost::Name_, 6, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void ClipboardHost_ReadRtf_ProxyToResponder::Run(
    const ::WTF::String& in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::ClipboardHost::ReadRtfCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result, 
                        "<value of type const ::WTF::String&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kClipboardHost_ReadRtf_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ClipboardHost_ReadRtf_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::BigStringDataView>(
      in_result, result_fragment);
  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::ClipboardHost::ReadRtfCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClipboardHost::Name_);
  message.set_method_name("ReadRtf");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool ClipboardHost_ReadRtf_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::ClipboardHost_ReadRtf_ResponseParams_Data* params =
      reinterpret_cast<internal::ClipboardHost_ReadRtf_ResponseParams_Data*>(
          message->mutable_payload());
  
  bool success = true;
  ::WTF::String p_result{};
  ClipboardHost_ReadRtf_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ClipboardHost::Name_, 6, true);
    return false;
  }
  *out_result_ = std::move(p_result);
  mojo::internal::SyncMessageResponseSetup::SetCurrentSyncResponseMessage(
      message);
  *result_ = true;
  return true;
}
class ClipboardHost_ReadImage_ProxyToResponder {
 public:
  static ClipboardHost::ReadImageCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ClipboardHost_ReadImage_ProxyToResponder> proxy(
        new ClipboardHost_ReadImage_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ClipboardHost_ReadImage_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ClipboardHost_ReadImage_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ClipboardHost_ReadImage_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ClipboardHost::ReadImageCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::SkBitmap& in_image);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ClipboardHost_ReadImage_ProxyToResponder);
};

bool ClipboardHost_ReadImage_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::ClipboardHost::ReadImageCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ClipboardHost_ReadImage_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ClipboardHost_ReadImage_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::SkBitmap p_image{};
  ClipboardHost_ReadImage_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadImage(&p_image))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ClipboardHost::Name_, 7, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_image));
  return true;
}

void ClipboardHost_ReadImage_ProxyToResponder::Run(
    const ::SkBitmap& in_image) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::ClipboardHost::ReadImageCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("image"), in_image, 
                        "<value of type const ::SkBitmap&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kClipboardHost_ReadImage_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ClipboardHost_ReadImage_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->image)::BaseType> image_fragment(
          params.message());
  mojo::internal::Serialize<::skia::mojom::BitmapN32DataView>(
      in_image, image_fragment);
  params->image.Set(
      image_fragment.is_null() ? nullptr : image_fragment.data());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::ClipboardHost::ReadImageCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClipboardHost::Name_);
  message.set_method_name("ReadImage");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool ClipboardHost_ReadImage_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::ClipboardHost_ReadImage_ResponseParams_Data* params =
      reinterpret_cast<internal::ClipboardHost_ReadImage_ResponseParams_Data*>(
          message->mutable_payload());
  
  bool success = true;
  ::SkBitmap p_image{};
  ClipboardHost_ReadImage_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadImage(&p_image))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ClipboardHost::Name_, 7, true);
    return false;
  }
  *out_image_ = std::move(p_image);
  mojo::internal::SyncMessageResponseSetup::SetCurrentSyncResponseMessage(
      message);
  *result_ = true;
  return true;
}
class ClipboardHost_ReadFiles_ProxyToResponder {
 public:
  static ClipboardHost::ReadFilesCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ClipboardHost_ReadFiles_ProxyToResponder> proxy(
        new ClipboardHost_ReadFiles_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ClipboardHost_ReadFiles_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ClipboardHost_ReadFiles_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ClipboardHost_ReadFiles_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ClipboardHost::ReadFilesCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ClipboardFilesPtr in_result);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ClipboardHost_ReadFiles_ProxyToResponder);
};

bool ClipboardHost_ReadFiles_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::ClipboardHost::ReadFilesCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ClipboardHost_ReadFiles_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ClipboardHost_ReadFiles_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ClipboardFilesPtr p_result{};
  ClipboardHost_ReadFiles_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ClipboardHost::Name_, 8, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void ClipboardHost_ReadFiles_ProxyToResponder::Run(
    ClipboardFilesPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::ClipboardHost::ReadFilesCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result, 
                        "<value of type ClipboardFilesPtr>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kClipboardHost_ReadFiles_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ClipboardHost_ReadFiles_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::ClipboardFilesDataView>(
      in_result, result_fragment);
  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::ClipboardHost::ReadFilesCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClipboardHost::Name_);
  message.set_method_name("ReadFiles");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool ClipboardHost_ReadFiles_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::ClipboardHost_ReadFiles_ResponseParams_Data* params =
      reinterpret_cast<internal::ClipboardHost_ReadFiles_ResponseParams_Data*>(
          message->mutable_payload());
  
  bool success = true;
  ClipboardFilesPtr p_result{};
  ClipboardHost_ReadFiles_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ClipboardHost::Name_, 8, true);
    return false;
  }
  *out_result_ = std::move(p_result);
  mojo::internal::SyncMessageResponseSetup::SetCurrentSyncResponseMessage(
      message);
  *result_ = true;
  return true;
}
class ClipboardHost_ReadCustomData_ProxyToResponder {
 public:
  static ClipboardHost::ReadCustomDataCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ClipboardHost_ReadCustomData_ProxyToResponder> proxy(
        new ClipboardHost_ReadCustomData_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ClipboardHost_ReadCustomData_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ClipboardHost_ReadCustomData_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ClipboardHost_ReadCustomData_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ClipboardHost::ReadCustomDataCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::WTF::String& in_result);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ClipboardHost_ReadCustomData_ProxyToResponder);
};

bool ClipboardHost_ReadCustomData_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::ClipboardHost::ReadCustomDataCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ClipboardHost_ReadCustomData_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ClipboardHost_ReadCustomData_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::WTF::String p_result{};
  ClipboardHost_ReadCustomData_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ClipboardHost::Name_, 9, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void ClipboardHost_ReadCustomData_ProxyToResponder::Run(
    const ::WTF::String& in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::ClipboardHost::ReadCustomDataCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result, 
                        "<value of type const ::WTF::String&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kClipboardHost_ReadCustomData_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ClipboardHost_ReadCustomData_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::BigString16DataView>(
      in_result, result_fragment);
  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::ClipboardHost::ReadCustomDataCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClipboardHost::Name_);
  message.set_method_name("ReadCustomData");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool ClipboardHost_ReadCustomData_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::ClipboardHost_ReadCustomData_ResponseParams_Data* params =
      reinterpret_cast<internal::ClipboardHost_ReadCustomData_ResponseParams_Data*>(
          message->mutable_payload());
  
  bool success = true;
  ::WTF::String p_result{};
  ClipboardHost_ReadCustomData_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ClipboardHost::Name_, 9, true);
    return false;
  }
  *out_result_ = std::move(p_result);
  mojo::internal::SyncMessageResponseSetup::SetCurrentSyncResponseMessage(
      message);
  *result_ = true;
  return true;
}

// static
bool ClipboardHostStubDispatch::Accept(
    ClipboardHost* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kClipboardHost_GetSequenceNumber_Name: {
      break;
    }
    case internal::kClipboardHost_IsFormatAvailable_Name: {
      break;
    }
    case internal::kClipboardHost_ReadAvailableTypes_Name: {
      break;
    }
    case internal::kClipboardHost_ReadText_Name: {
      break;
    }
    case internal::kClipboardHost_ReadHtml_Name: {
      break;
    }
    case internal::kClipboardHost_ReadSvg_Name: {
      break;
    }
    case internal::kClipboardHost_ReadRtf_Name: {
      break;
    }
    case internal::kClipboardHost_ReadImage_Name: {
      break;
    }
    case internal::kClipboardHost_ReadFiles_Name: {
      break;
    }
    case internal::kClipboardHost_ReadCustomData_Name: {
      break;
    }
    case internal::kClipboardHost_WriteText_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ClipboardHost::WriteText",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ClipboardHost::WriteText");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ClipboardHost_WriteText_Params_Data* params =
          reinterpret_cast<internal::ClipboardHost_WriteText_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::WTF::String p_text{};
      ClipboardHost_WriteText_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadText(&p_text))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ClipboardHost::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->WriteText(
std::move(p_text));
      return true;
    }
    case internal::kClipboardHost_WriteHtml_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ClipboardHost::WriteHtml",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ClipboardHost::WriteHtml");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ClipboardHost_WriteHtml_Params_Data* params =
          reinterpret_cast<internal::ClipboardHost_WriteHtml_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::WTF::String p_markup{};
      ::blink::KURL p_url{};
      ClipboardHost_WriteHtml_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMarkup(&p_markup))
        success = false;
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ClipboardHost::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->WriteHtml(
std::move(p_markup), 
std::move(p_url));
      return true;
    }
    case internal::kClipboardHost_WriteSvg_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ClipboardHost::WriteSvg",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ClipboardHost::WriteSvg");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ClipboardHost_WriteSvg_Params_Data* params =
          reinterpret_cast<internal::ClipboardHost_WriteSvg_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::WTF::String p_markup{};
      ClipboardHost_WriteSvg_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMarkup(&p_markup))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ClipboardHost::Name_, 12, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->WriteSvg(
std::move(p_markup));
      return true;
    }
    case internal::kClipboardHost_WriteSmartPasteMarker_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ClipboardHost::WriteSmartPasteMarker",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ClipboardHost::WriteSmartPasteMarker");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ClipboardHost_WriteSmartPasteMarker_Params_Data* params =
          reinterpret_cast<internal::ClipboardHost_WriteSmartPasteMarker_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ClipboardHost_WriteSmartPasteMarker_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ClipboardHost::Name_, 13, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->WriteSmartPasteMarker();
      return true;
    }
    case internal::kClipboardHost_WriteCustomData_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ClipboardHost::WriteCustomData",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ClipboardHost::WriteCustomData");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ClipboardHost_WriteCustomData_Params_Data* params =
          reinterpret_cast<internal::ClipboardHost_WriteCustomData_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      WTF::HashMap<::WTF::String, ::WTF::String> p_data{};
      ClipboardHost_WriteCustomData_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadData(&p_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ClipboardHost::Name_, 14, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->WriteCustomData(
std::move(p_data));
      return true;
    }
    case internal::kClipboardHost_WriteBookmark_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ClipboardHost::WriteBookmark",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ClipboardHost::WriteBookmark");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ClipboardHost_WriteBookmark_Params_Data* params =
          reinterpret_cast<internal::ClipboardHost_WriteBookmark_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      WTF::String p_url{};
      ::WTF::String p_title{};
      ClipboardHost_WriteBookmark_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadTitle(&p_title))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ClipboardHost::Name_, 15, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->WriteBookmark(
std::move(p_url), 
std::move(p_title));
      return true;
    }
    case internal::kClipboardHost_WriteImage_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ClipboardHost::WriteImage",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ClipboardHost::WriteImage");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ClipboardHost_WriteImage_Params_Data* params =
          reinterpret_cast<internal::ClipboardHost_WriteImage_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::SkBitmap p_image{};
      ClipboardHost_WriteImage_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadImage(&p_image))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ClipboardHost::Name_, 16, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->WriteImage(
std::move(p_image));
      return true;
    }
    case internal::kClipboardHost_CommitWrite_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ClipboardHost::CommitWrite",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ClipboardHost::CommitWrite");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ClipboardHost_CommitWrite_Params_Data* params =
          reinterpret_cast<internal::ClipboardHost_CommitWrite_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ClipboardHost_CommitWrite_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ClipboardHost::Name_, 17, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CommitWrite();
      return true;
    }
  }
  return false;
}

// static
bool ClipboardHostStubDispatch::AcceptWithResponder(
    ClipboardHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kClipboardHost_GetSequenceNumber_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ClipboardHost::GetSequenceNumber",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ClipboardHost::GetSequenceNumber");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ClipboardHost_GetSequenceNumber_Params_Data* params =
          reinterpret_cast<
              internal::ClipboardHost_GetSequenceNumber_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ClipboardBuffer p_buffer{};
      ClipboardHost_GetSequenceNumber_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBuffer(&p_buffer))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ClipboardHost::Name_, 0, false);
        return false;
      }
      ClipboardHost::GetSequenceNumberCallback callback =
          ClipboardHost_GetSequenceNumber_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetSequenceNumber(
std::move(p_buffer), std::move(callback));
      return true;
    }
    case internal::kClipboardHost_IsFormatAvailable_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ClipboardHost::IsFormatAvailable",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ClipboardHost::IsFormatAvailable");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ClipboardHost_IsFormatAvailable_Params_Data* params =
          reinterpret_cast<
              internal::ClipboardHost_IsFormatAvailable_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ClipboardFormat p_format{};
      ClipboardBuffer p_buffer{};
      ClipboardHost_IsFormatAvailable_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFormat(&p_format))
        success = false;
      if (success && !input_data_view.ReadBuffer(&p_buffer))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ClipboardHost::Name_, 1, false);
        return false;
      }
      ClipboardHost::IsFormatAvailableCallback callback =
          ClipboardHost_IsFormatAvailable_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->IsFormatAvailable(
std::move(p_format), 
std::move(p_buffer), std::move(callback));
      return true;
    }
    case internal::kClipboardHost_ReadAvailableTypes_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ClipboardHost::ReadAvailableTypes",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ClipboardHost::ReadAvailableTypes");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ClipboardHost_ReadAvailableTypes_Params_Data* params =
          reinterpret_cast<
              internal::ClipboardHost_ReadAvailableTypes_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ClipboardBuffer p_buffer{};
      ClipboardHost_ReadAvailableTypes_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBuffer(&p_buffer))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ClipboardHost::Name_, 2, false);
        return false;
      }
      ClipboardHost::ReadAvailableTypesCallback callback =
          ClipboardHost_ReadAvailableTypes_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReadAvailableTypes(
std::move(p_buffer), std::move(callback));
      return true;
    }
    case internal::kClipboardHost_ReadText_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ClipboardHost::ReadText",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ClipboardHost::ReadText");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ClipboardHost_ReadText_Params_Data* params =
          reinterpret_cast<
              internal::ClipboardHost_ReadText_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ClipboardBuffer p_buffer{};
      ClipboardHost_ReadText_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBuffer(&p_buffer))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ClipboardHost::Name_, 3, false);
        return false;
      }
      ClipboardHost::ReadTextCallback callback =
          ClipboardHost_ReadText_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReadText(
std::move(p_buffer), std::move(callback));
      return true;
    }
    case internal::kClipboardHost_ReadHtml_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ClipboardHost::ReadHtml",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ClipboardHost::ReadHtml");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ClipboardHost_ReadHtml_Params_Data* params =
          reinterpret_cast<
              internal::ClipboardHost_ReadHtml_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ClipboardBuffer p_buffer{};
      ClipboardHost_ReadHtml_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBuffer(&p_buffer))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ClipboardHost::Name_, 4, false);
        return false;
      }
      ClipboardHost::ReadHtmlCallback callback =
          ClipboardHost_ReadHtml_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReadHtml(
std::move(p_buffer), std::move(callback));
      return true;
    }
    case internal::kClipboardHost_ReadSvg_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ClipboardHost::ReadSvg",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ClipboardHost::ReadSvg");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ClipboardHost_ReadSvg_Params_Data* params =
          reinterpret_cast<
              internal::ClipboardHost_ReadSvg_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ClipboardBuffer p_buffer{};
      ClipboardHost_ReadSvg_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBuffer(&p_buffer))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ClipboardHost::Name_, 5, false);
        return false;
      }
      ClipboardHost::ReadSvgCallback callback =
          ClipboardHost_ReadSvg_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReadSvg(
std::move(p_buffer), std::move(callback));
      return true;
    }
    case internal::kClipboardHost_ReadRtf_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ClipboardHost::ReadRtf",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ClipboardHost::ReadRtf");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ClipboardHost_ReadRtf_Params_Data* params =
          reinterpret_cast<
              internal::ClipboardHost_ReadRtf_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ClipboardBuffer p_buffer{};
      ClipboardHost_ReadRtf_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBuffer(&p_buffer))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ClipboardHost::Name_, 6, false);
        return false;
      }
      ClipboardHost::ReadRtfCallback callback =
          ClipboardHost_ReadRtf_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReadRtf(
std::move(p_buffer), std::move(callback));
      return true;
    }
    case internal::kClipboardHost_ReadImage_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ClipboardHost::ReadImage",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ClipboardHost::ReadImage");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ClipboardHost_ReadImage_Params_Data* params =
          reinterpret_cast<
              internal::ClipboardHost_ReadImage_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ClipboardBuffer p_buffer{};
      ClipboardHost_ReadImage_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBuffer(&p_buffer))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ClipboardHost::Name_, 7, false);
        return false;
      }
      ClipboardHost::ReadImageCallback callback =
          ClipboardHost_ReadImage_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReadImage(
std::move(p_buffer), std::move(callback));
      return true;
    }
    case internal::kClipboardHost_ReadFiles_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ClipboardHost::ReadFiles",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ClipboardHost::ReadFiles");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ClipboardHost_ReadFiles_Params_Data* params =
          reinterpret_cast<
              internal::ClipboardHost_ReadFiles_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ClipboardBuffer p_buffer{};
      ClipboardHost_ReadFiles_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBuffer(&p_buffer))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ClipboardHost::Name_, 8, false);
        return false;
      }
      ClipboardHost::ReadFilesCallback callback =
          ClipboardHost_ReadFiles_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReadFiles(
std::move(p_buffer), std::move(callback));
      return true;
    }
    case internal::kClipboardHost_ReadCustomData_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ClipboardHost::ReadCustomData",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ClipboardHost::ReadCustomData");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ClipboardHost_ReadCustomData_Params_Data* params =
          reinterpret_cast<
              internal::ClipboardHost_ReadCustomData_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ClipboardBuffer p_buffer{};
      ::WTF::String p_type{};
      ClipboardHost_ReadCustomData_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBuffer(&p_buffer))
        success = false;
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ClipboardHost::Name_, 9, false);
        return false;
      }
      ClipboardHost::ReadCustomDataCallback callback =
          ClipboardHost_ReadCustomData_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReadCustomData(
std::move(p_buffer), 
std::move(p_type), std::move(callback));
      return true;
    }
    case internal::kClipboardHost_WriteText_Name: {
      break;
    }
    case internal::kClipboardHost_WriteHtml_Name: {
      break;
    }
    case internal::kClipboardHost_WriteSvg_Name: {
      break;
    }
    case internal::kClipboardHost_WriteSmartPasteMarker_Name: {
      break;
    }
    case internal::kClipboardHost_WriteCustomData_Name: {
      break;
    }
    case internal::kClipboardHost_WriteBookmark_Name: {
      break;
    }
    case internal::kClipboardHost_WriteImage_Name: {
      break;
    }
    case internal::kClipboardHost_CommitWrite_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kClipboardHostValidationInfo[] = {
    {&internal::ClipboardHost_GetSequenceNumber_Params_Data::Validate,
     &internal::ClipboardHost_GetSequenceNumber_ResponseParams_Data::Validate},
    {&internal::ClipboardHost_IsFormatAvailable_Params_Data::Validate,
     &internal::ClipboardHost_IsFormatAvailable_ResponseParams_Data::Validate},
    {&internal::ClipboardHost_ReadAvailableTypes_Params_Data::Validate,
     &internal::ClipboardHost_ReadAvailableTypes_ResponseParams_Data::Validate},
    {&internal::ClipboardHost_ReadText_Params_Data::Validate,
     &internal::ClipboardHost_ReadText_ResponseParams_Data::Validate},
    {&internal::ClipboardHost_ReadHtml_Params_Data::Validate,
     &internal::ClipboardHost_ReadHtml_ResponseParams_Data::Validate},
    {&internal::ClipboardHost_ReadSvg_Params_Data::Validate,
     &internal::ClipboardHost_ReadSvg_ResponseParams_Data::Validate},
    {&internal::ClipboardHost_ReadRtf_Params_Data::Validate,
     &internal::ClipboardHost_ReadRtf_ResponseParams_Data::Validate},
    {&internal::ClipboardHost_ReadImage_Params_Data::Validate,
     &internal::ClipboardHost_ReadImage_ResponseParams_Data::Validate},
    {&internal::ClipboardHost_ReadFiles_Params_Data::Validate,
     &internal::ClipboardHost_ReadFiles_ResponseParams_Data::Validate},
    {&internal::ClipboardHost_ReadCustomData_Params_Data::Validate,
     &internal::ClipboardHost_ReadCustomData_ResponseParams_Data::Validate},
    {&internal::ClipboardHost_WriteText_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::ClipboardHost_WriteHtml_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::ClipboardHost_WriteSvg_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::ClipboardHost_WriteSmartPasteMarker_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::ClipboardHost_WriteCustomData_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::ClipboardHost_WriteBookmark_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::ClipboardHost_WriteImage_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::ClipboardHost_CommitWrite_Params_Data::Validate,
     nullptr /* no response */},
};

bool ClipboardHostRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::ClipboardHost::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kClipboardHostValidationInfo);
}

bool ClipboardHostResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::ClipboardHost::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kClipboardHostValidationInfo);
}
}  // namespace blink
}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::blink::ClipboardFiles::DataView, ::blink::mojom::blink::ClipboardFilesPtr>::Read(
    ::blink::mojom::blink::ClipboardFiles::DataView input,
    ::blink::mojom::blink::ClipboardFilesPtr* output) {
  bool success = true;
  ::blink::mojom::blink::ClipboardFilesPtr result(::blink::mojom::blink::ClipboardFiles::New());
  
      if (success && !input.ReadFiles(&result->files))
        success = false;
      if (success && !input.ReadFileSystemId(&result->file_system_id))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif