// third_party/blink/public/mojom/clipboard/clipboard.mojom-test-utils.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif


#include "third_party/blink/public/mojom/clipboard/clipboard.mojom-test-utils.h"

#include <utility>

#include "base/bind.h"
#include "base/run_loop.h"
#include "mojo/public/mojom/base/string16.mojom.h"
#include "mojo/public/mojom/base/big_buffer.mojom.h"
#include "mojo/public/mojom/base/big_string.mojom.h"
#include "skia/public/mojom/bitmap.mojom.h"
#include "third_party/blink/public/mojom/data_transfer/data_transfer.mojom.h"
#include "url/mojom/url.mojom.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_CLIPBOARD_CLIPBOARD_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_CLIPBOARD_CLIPBOARD_MOJOM_JUMBO_H_
#endif


namespace blink {
namespace mojom {


void ClipboardHostInterceptorForTesting::GetSequenceNumber(::ui::ClipboardBuffer buffer, GetSequenceNumberCallback callback) {
  GetForwardingInterface()->GetSequenceNumber(std::move(buffer), std::move(callback));
}
void ClipboardHostInterceptorForTesting::IsFormatAvailable(ClipboardFormat format, ::ui::ClipboardBuffer buffer, IsFormatAvailableCallback callback) {
  GetForwardingInterface()->IsFormatAvailable(std::move(format), std::move(buffer), std::move(callback));
}
void ClipboardHostInterceptorForTesting::ReadAvailableTypes(::ui::ClipboardBuffer buffer, ReadAvailableTypesCallback callback) {
  GetForwardingInterface()->ReadAvailableTypes(std::move(buffer), std::move(callback));
}
void ClipboardHostInterceptorForTesting::ReadText(::ui::ClipboardBuffer buffer, ReadTextCallback callback) {
  GetForwardingInterface()->ReadText(std::move(buffer), std::move(callback));
}
void ClipboardHostInterceptorForTesting::ReadHtml(::ui::ClipboardBuffer buffer, ReadHtmlCallback callback) {
  GetForwardingInterface()->ReadHtml(std::move(buffer), std::move(callback));
}
void ClipboardHostInterceptorForTesting::ReadSvg(::ui::ClipboardBuffer buffer, ReadSvgCallback callback) {
  GetForwardingInterface()->ReadSvg(std::move(buffer), std::move(callback));
}
void ClipboardHostInterceptorForTesting::ReadRtf(::ui::ClipboardBuffer buffer, ReadRtfCallback callback) {
  GetForwardingInterface()->ReadRtf(std::move(buffer), std::move(callback));
}
void ClipboardHostInterceptorForTesting::ReadImage(::ui::ClipboardBuffer buffer, ReadImageCallback callback) {
  GetForwardingInterface()->ReadImage(std::move(buffer), std::move(callback));
}
void ClipboardHostInterceptorForTesting::ReadFiles(::ui::ClipboardBuffer buffer, ReadFilesCallback callback) {
  GetForwardingInterface()->ReadFiles(std::move(buffer), std::move(callback));
}
void ClipboardHostInterceptorForTesting::ReadCustomData(::ui::ClipboardBuffer buffer, const ::base::string16& type, ReadCustomDataCallback callback) {
  GetForwardingInterface()->ReadCustomData(std::move(buffer), std::move(type), std::move(callback));
}
void ClipboardHostInterceptorForTesting::WriteText(const ::base::string16& text) {
  GetForwardingInterface()->WriteText(std::move(text));
}
void ClipboardHostInterceptorForTesting::WriteHtml(const ::base::string16& markup, const ::GURL& url) {
  GetForwardingInterface()->WriteHtml(std::move(markup), std::move(url));
}
void ClipboardHostInterceptorForTesting::WriteSvg(const ::base::string16& markup) {
  GetForwardingInterface()->WriteSvg(std::move(markup));
}
void ClipboardHostInterceptorForTesting::WriteSmartPasteMarker() {
  GetForwardingInterface()->WriteSmartPasteMarker();
}
void ClipboardHostInterceptorForTesting::WriteCustomData(const base::flat_map<::base::string16, ::base::string16>& data) {
  GetForwardingInterface()->WriteCustomData(std::move(data));
}
void ClipboardHostInterceptorForTesting::WriteBookmark(const std::string& url, const ::base::string16& title) {
  GetForwardingInterface()->WriteBookmark(std::move(url), std::move(title));
}
void ClipboardHostInterceptorForTesting::WriteImage(const ::SkBitmap& image) {
  GetForwardingInterface()->WriteImage(std::move(image));
}
void ClipboardHostInterceptorForTesting::CommitWrite() {
  GetForwardingInterface()->CommitWrite();
}
ClipboardHostAsyncWaiter::ClipboardHostAsyncWaiter(
    ClipboardHost* proxy) : proxy_(proxy) {}

ClipboardHostAsyncWaiter::~ClipboardHostAsyncWaiter() = default;

void ClipboardHostAsyncWaiter::GetSequenceNumber(
    ::ui::ClipboardBuffer buffer, uint64_t* out_result) {
  base::RunLoop loop;
  proxy_->GetSequenceNumber(std::move(buffer),
      base::BindOnce(
          [](base::RunLoop* loop,
             uint64_t* out_result
,
             uint64_t result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}
void ClipboardHostAsyncWaiter::IsFormatAvailable(
    ClipboardFormat format, ::ui::ClipboardBuffer buffer, bool* out_result) {
  base::RunLoop loop;
  proxy_->IsFormatAvailable(std::move(format),std::move(buffer),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_result
,
             bool result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}
void ClipboardHostAsyncWaiter::ReadAvailableTypes(
    ::ui::ClipboardBuffer buffer, std::vector<::base::string16>* out_types) {
  base::RunLoop loop;
  proxy_->ReadAvailableTypes(std::move(buffer),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<::base::string16>* out_types
,
             const std::vector<::base::string16>& types) {*out_types = std::move(types);
            loop->Quit();
          },
          &loop,
          out_types));
  loop.Run();
}
void ClipboardHostAsyncWaiter::ReadText(
    ::ui::ClipboardBuffer buffer, ::base::string16* out_result) {
  base::RunLoop loop;
  proxy_->ReadText(std::move(buffer),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::base::string16* out_result
,
             const ::base::string16& result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}
void ClipboardHostAsyncWaiter::ReadHtml(
    ::ui::ClipboardBuffer buffer, ::base::string16* out_markup, ::GURL* out_url, uint32_t* out_fragment_start, uint32_t* out_fragment_end) {
  base::RunLoop loop;
  proxy_->ReadHtml(std::move(buffer),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::base::string16* out_markup
,
             ::GURL* out_url
,
             uint32_t* out_fragment_start
,
             uint32_t* out_fragment_end
,
             const ::base::string16& markup,
             const ::GURL& url,
             uint32_t fragment_start,
             uint32_t fragment_end) {*out_markup = std::move(markup);*out_url = std::move(url);*out_fragment_start = std::move(fragment_start);*out_fragment_end = std::move(fragment_end);
            loop->Quit();
          },
          &loop,
          out_markup,
          out_url,
          out_fragment_start,
          out_fragment_end));
  loop.Run();
}
void ClipboardHostAsyncWaiter::ReadSvg(
    ::ui::ClipboardBuffer buffer, ::base::string16* out_result) {
  base::RunLoop loop;
  proxy_->ReadSvg(std::move(buffer),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::base::string16* out_result
,
             const ::base::string16& result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}
void ClipboardHostAsyncWaiter::ReadRtf(
    ::ui::ClipboardBuffer buffer, ::std::string* out_result) {
  base::RunLoop loop;
  proxy_->ReadRtf(std::move(buffer),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::std::string* out_result
,
             const ::std::string& result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}
void ClipboardHostAsyncWaiter::ReadImage(
    ::ui::ClipboardBuffer buffer, ::SkBitmap* out_image) {
  base::RunLoop loop;
  proxy_->ReadImage(std::move(buffer),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::SkBitmap* out_image
,
             const ::SkBitmap& image) {*out_image = std::move(image);
            loop->Quit();
          },
          &loop,
          out_image));
  loop.Run();
}
void ClipboardHostAsyncWaiter::ReadFiles(
    ::ui::ClipboardBuffer buffer, ClipboardFilesPtr* out_result) {
  base::RunLoop loop;
  proxy_->ReadFiles(std::move(buffer),
      base::BindOnce(
          [](base::RunLoop* loop,
             ClipboardFilesPtr* out_result
,
             ClipboardFilesPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}
void ClipboardHostAsyncWaiter::ReadCustomData(
    ::ui::ClipboardBuffer buffer, const ::base::string16& type, ::base::string16* out_result) {
  base::RunLoop loop;
  proxy_->ReadCustomData(std::move(buffer),std::move(type),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::base::string16* out_result
,
             const ::base::string16& result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}





}  // namespace mojom
}  // namespace blink

#if defined(__clang__)
#pragma clang diagnostic pop
#endif