// third_party/blink/public/mojom/clipboard/raw_clipboard.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/clipboard/raw_clipboard.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/clipboard/raw_clipboard.mojom-params-data.h"
#include "third_party/blink/public/mojom/clipboard/raw_clipboard.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/clipboard/raw_clipboard.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_CLIPBOARD_RAW_CLIPBOARD_MOJOM_BLINK_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_CLIPBOARD_RAW_CLIPBOARD_MOJOM_BLINK_JUMBO_H_
#endif
namespace blink {
namespace mojom {
namespace blink {
const char RawClipboardHost::Name_[] = "blink.mojom.RawClipboardHost";
constexpr int32_t RawClipboardHost::kMaxFormatSize;
constexpr int32_t RawClipboardHost::kMaxDataSize;

class RawClipboardHost_ReadAvailableFormatNames_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  RawClipboardHost_ReadAvailableFormatNames_ForwardToCallback(
      RawClipboardHost::ReadAvailableFormatNamesCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  RawClipboardHost::ReadAvailableFormatNamesCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(RawClipboardHost_ReadAvailableFormatNames_ForwardToCallback);
};

class RawClipboardHost_Read_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  RawClipboardHost_Read_ForwardToCallback(
      RawClipboardHost::ReadCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  RawClipboardHost::ReadCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(RawClipboardHost_Read_ForwardToCallback);
};

RawClipboardHostProxy::RawClipboardHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void RawClipboardHostProxy::ReadAvailableFormatNames(
    ReadAvailableFormatNamesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::RawClipboardHost::ReadAvailableFormatNames");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRawClipboardHost_ReadAvailableFormatNames_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RawClipboardHost_ReadAvailableFormatNames_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RawClipboardHost::Name_);
  message.set_method_name("ReadAvailableFormatNames");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new RawClipboardHost_ReadAvailableFormatNames_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void RawClipboardHostProxy::Read(
    const ::WTF::String& in_format, ReadCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::RawClipboardHost::Read", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("format"), in_format, 
                        "<value of type const ::WTF::String&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRawClipboardHost_Read_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RawClipboardHost_Read_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->format)::BaseType> format_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_format, format_fragment);
  params->format.Set(
      format_fragment.is_null() ? nullptr : format_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->format.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null format in RawClipboardHost.Read request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RawClipboardHost::Name_);
  message.set_method_name("Read");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new RawClipboardHost_Read_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void RawClipboardHostProxy::Write(
    const ::WTF::String& in_format, ::mojo_base::BigBuffer in_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::RawClipboardHost::Write", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("format"), in_format, 
                        "<value of type const ::WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data, 
                        "<value of type ::mojo_base::BigBuffer>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRawClipboardHost_Write_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RawClipboardHost_Write_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->format)::BaseType> format_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_format, format_fragment);
  params->format.Set(
      format_fragment.is_null() ? nullptr : format_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->format.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null format in RawClipboardHost.Write request");
  mojo::internal::MessageFragment<decltype(params->data)>
      data_fragment(params.message());
  data_fragment.Claim(&params->data);
  mojo::internal::Serialize<::mojo_base::mojom::BigBufferDataView>(
      in_data, data_fragment, true);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null data in RawClipboardHost.Write request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RawClipboardHost::Name_);
  message.set_method_name("Write");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RawClipboardHostProxy::CommitWrite(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::RawClipboardHost::CommitWrite");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRawClipboardHost_CommitWrite_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RawClipboardHost_CommitWrite_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RawClipboardHost::Name_);
  message.set_method_name("CommitWrite");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class RawClipboardHost_ReadAvailableFormatNames_ProxyToResponder {
 public:
  static RawClipboardHost::ReadAvailableFormatNamesCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<RawClipboardHost_ReadAvailableFormatNames_ProxyToResponder> proxy(
        new RawClipboardHost_ReadAvailableFormatNames_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&RawClipboardHost_ReadAvailableFormatNames_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~RawClipboardHost_ReadAvailableFormatNames_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  RawClipboardHost_ReadAvailableFormatNames_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "RawClipboardHost::ReadAvailableFormatNamesCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const WTF::Vector<::WTF::String>& in_raw_types);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(RawClipboardHost_ReadAvailableFormatNames_ProxyToResponder);
};

bool RawClipboardHost_ReadAvailableFormatNames_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::RawClipboardHost::ReadAvailableFormatNamesCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::RawClipboardHost_ReadAvailableFormatNames_ResponseParams_Data* params =
      reinterpret_cast<
          internal::RawClipboardHost_ReadAvailableFormatNames_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  WTF::Vector<::WTF::String> p_raw_types{};
  RawClipboardHost_ReadAvailableFormatNames_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadRawTypes(&p_raw_types))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        RawClipboardHost::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_raw_types));
  return true;
}

void RawClipboardHost_ReadAvailableFormatNames_ProxyToResponder::Run(
    const WTF::Vector<::WTF::String>& in_raw_types) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::RawClipboardHost::ReadAvailableFormatNamesCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("raw_types"), in_raw_types, 
                        "<value of type const WTF::Vector<::WTF::String>&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRawClipboardHost_ReadAvailableFormatNames_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RawClipboardHost_ReadAvailableFormatNames_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->raw_types)::BaseType>
      raw_types_fragment(params.message());
  const mojo::internal::ContainerValidateParams raw_types_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::mojo_base::mojom::String16DataView>>(
      in_raw_types, raw_types_fragment, &raw_types_validate_params);
  params->raw_types.Set(
      raw_types_fragment.is_null() ? nullptr : raw_types_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->raw_types.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null raw_types in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::RawClipboardHost::ReadAvailableFormatNamesCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RawClipboardHost::Name_);
  message.set_method_name("ReadAvailableFormatNames");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class RawClipboardHost_Read_ProxyToResponder {
 public:
  static RawClipboardHost::ReadCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<RawClipboardHost_Read_ProxyToResponder> proxy(
        new RawClipboardHost_Read_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&RawClipboardHost_Read_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~RawClipboardHost_Read_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  RawClipboardHost_Read_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "RawClipboardHost::ReadCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::mojo_base::BigBuffer in_data);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(RawClipboardHost_Read_ProxyToResponder);
};

bool RawClipboardHost_Read_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::RawClipboardHost::ReadCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::RawClipboardHost_Read_ResponseParams_Data* params =
      reinterpret_cast<
          internal::RawClipboardHost_Read_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::mojo_base::BigBuffer p_data{};
  RawClipboardHost_Read_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadData(&p_data))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        RawClipboardHost::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_data));
  return true;
}

void RawClipboardHost_Read_ProxyToResponder::Run(
    ::mojo_base::BigBuffer in_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::RawClipboardHost::ReadCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data, 
                        "<value of type ::mojo_base::BigBuffer>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRawClipboardHost_Read_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RawClipboardHost_Read_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->data)>
      data_fragment(params.message());
  data_fragment.Claim(&params->data);
  mojo::internal::Serialize<::mojo_base::mojom::BigBufferDataView>(
      in_data, data_fragment, true);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null data in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::RawClipboardHost::ReadCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RawClipboardHost::Name_);
  message.set_method_name("Read");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool RawClipboardHostStubDispatch::Accept(
    RawClipboardHost* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kRawClipboardHost_ReadAvailableFormatNames_Name: {
      break;
    }
    case internal::kRawClipboardHost_Read_Name: {
      break;
    }
    case internal::kRawClipboardHost_Write_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RawClipboardHost::Write",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RawClipboardHost::Write");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RawClipboardHost_Write_Params_Data* params =
          reinterpret_cast<internal::RawClipboardHost_Write_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::WTF::String p_format{};
      ::mojo_base::BigBuffer p_data{};
      RawClipboardHost_Write_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFormat(&p_format))
        success = false;
      if (success && !input_data_view.ReadData(&p_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RawClipboardHost::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Write(
std::move(p_format), 
std::move(p_data));
      return true;
    }
    case internal::kRawClipboardHost_CommitWrite_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RawClipboardHost::CommitWrite",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RawClipboardHost::CommitWrite");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RawClipboardHost_CommitWrite_Params_Data* params =
          reinterpret_cast<internal::RawClipboardHost_CommitWrite_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      RawClipboardHost_CommitWrite_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RawClipboardHost::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CommitWrite();
      return true;
    }
  }
  return false;
}

// static
bool RawClipboardHostStubDispatch::AcceptWithResponder(
    RawClipboardHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kRawClipboardHost_ReadAvailableFormatNames_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RawClipboardHost::ReadAvailableFormatNames",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RawClipboardHost::ReadAvailableFormatNames");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::RawClipboardHost_ReadAvailableFormatNames_Params_Data* params =
          reinterpret_cast<
              internal::RawClipboardHost_ReadAvailableFormatNames_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      RawClipboardHost_ReadAvailableFormatNames_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RawClipboardHost::Name_, 0, false);
        return false;
      }
      RawClipboardHost::ReadAvailableFormatNamesCallback callback =
          RawClipboardHost_ReadAvailableFormatNames_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReadAvailableFormatNames(std::move(callback));
      return true;
    }
    case internal::kRawClipboardHost_Read_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RawClipboardHost::Read",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RawClipboardHost::Read");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::RawClipboardHost_Read_Params_Data* params =
          reinterpret_cast<
              internal::RawClipboardHost_Read_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::WTF::String p_format{};
      RawClipboardHost_Read_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFormat(&p_format))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RawClipboardHost::Name_, 1, false);
        return false;
      }
      RawClipboardHost::ReadCallback callback =
          RawClipboardHost_Read_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Read(
std::move(p_format), std::move(callback));
      return true;
    }
    case internal::kRawClipboardHost_Write_Name: {
      break;
    }
    case internal::kRawClipboardHost_CommitWrite_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kRawClipboardHostValidationInfo[] = {
    {&internal::RawClipboardHost_ReadAvailableFormatNames_Params_Data::Validate,
     &internal::RawClipboardHost_ReadAvailableFormatNames_ResponseParams_Data::Validate},
    {&internal::RawClipboardHost_Read_Params_Data::Validate,
     &internal::RawClipboardHost_Read_ResponseParams_Data::Validate},
    {&internal::RawClipboardHost_Write_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::RawClipboardHost_CommitWrite_Params_Data::Validate,
     nullptr /* no response */},
};

bool RawClipboardHostRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::RawClipboardHost::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kRawClipboardHostValidationInfo);
}

bool RawClipboardHostResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::RawClipboardHost::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kRawClipboardHostValidationInfo);
}
}  // namespace blink
}  // namespace mojom
}  // namespace blink

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif