// third_party/blink/public/mojom/context_menu/context_menu.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/context_menu/context_menu.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/context_menu/context_menu.mojom-params-data.h"
#include "third_party/blink/public/mojom/context_menu/context_menu.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/context_menu/context_menu.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_CONTEXT_MENU_CONTEXT_MENU_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_CONTEXT_MENU_CONTEXT_MENU_MOJOM_JUMBO_H_
#endif
namespace blink {
namespace mojom {
Impression::Impression()
    : conversion_destination(),
      reporting_origin(),
      impression_data(),
      expiry() {}

Impression::Impression(
    const ::url::Origin& conversion_destination_in,
    const base::Optional<::url::Origin>& reporting_origin_in,
    uint64_t impression_data_in,
    base::Optional<::base::TimeDelta> expiry_in)
    : conversion_destination(std::move(conversion_destination_in)),
      reporting_origin(std::move(reporting_origin_in)),
      impression_data(std::move(impression_data_in)),
      expiry(std::move(expiry_in)) {}

Impression::~Impression() = default;

void Impression::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "conversion_destination"), this->conversion_destination, 
      "<value of type const ::url::Origin&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "reporting_origin"), this->reporting_origin, 
      "<value of type const base::Optional<::url::Origin>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "impression_data"), this->impression_data, 
      "<value of type uint64_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "expiry"), this->expiry, 
      "<value of type base::Optional<::base::TimeDelta>>");
}

bool Impression::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CustomContextMenuItem::CustomContextMenuItem()
    : label(),
      icon(),
      tool_tip(),
      type(),
      action(),
      rtl(),
      has_directional_override(),
      enabled(),
      checked(),
      submenu() {}

CustomContextMenuItem::CustomContextMenuItem(
    const ::base::string16& label_in,
    const ::base::string16& icon_in,
    const ::base::string16& tool_tip_in,
    CustomContextMenuItemType type_in,
    int32_t action_in,
    bool rtl_in,
    bool has_directional_override_in,
    bool enabled_in,
    bool checked_in,
    std::vector<CustomContextMenuItemPtr> submenu_in)
    : label(std::move(label_in)),
      icon(std::move(icon_in)),
      tool_tip(std::move(tool_tip_in)),
      type(std::move(type_in)),
      action(std::move(action_in)),
      rtl(std::move(rtl_in)),
      has_directional_override(std::move(has_directional_override_in)),
      enabled(std::move(enabled_in)),
      checked(std::move(checked_in)),
      submenu(std::move(submenu_in)) {}

CustomContextMenuItem::~CustomContextMenuItem() = default;

void CustomContextMenuItem::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "label"), this->label, 
      "<value of type const ::base::string16&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "icon"), this->icon, 
      "<value of type const ::base::string16&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tool_tip"), this->tool_tip, 
      "<value of type const ::base::string16&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "type"), this->type, 
      "<value of type CustomContextMenuItemType>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "action"), this->action, 
      "<value of type int32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "rtl"), this->rtl, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_directional_override"), this->has_directional_override, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enabled"), this->enabled, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "checked"), this->checked, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "submenu"), this->submenu, 
      "<value of type std::vector<CustomContextMenuItemPtr>>");
}

bool CustomContextMenuItem::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
UntrustworthyContextMenuParams::UntrustworthyContextMenuParams()
    : media_type(),
      x(),
      y(),
      link_url(),
      link_text(),
      impression(),
      unfiltered_link_url(),
      src_url(),
      has_image_contents(),
      media_flags(),
      selection_text(),
      title_text(),
      alt_text(),
      suggested_filename(),
      misspelled_word(),
      dictionary_suggestions(),
      spellcheck_enabled(),
      is_editable(),
      writing_direction_default(),
      writing_direction_left_to_right(),
      writing_direction_right_to_left(),
      edit_flags(),
      frame_charset(),
      referrer_policy(),
      link_followed(),
      custom_items(),
      source_type(),
      input_field_type(),
      selection_rect(),
      selection_start_offset() {}

UntrustworthyContextMenuParams::UntrustworthyContextMenuParams(
    ContextMenuDataMediaType media_type_in,
    int32_t x_in,
    int32_t y_in,
    const ::GURL& link_url_in,
    const ::base::string16& link_text_in,
    const base::Optional<::blink::Impression>& impression_in,
    const ::GURL& unfiltered_link_url_in,
    const ::GURL& src_url_in,
    bool has_image_contents_in,
    int32_t media_flags_in,
    const ::base::string16& selection_text_in,
    const ::base::string16& title_text_in,
    const ::base::string16& alt_text_in,
    const ::base::string16& suggested_filename_in,
    const ::base::string16& misspelled_word_in,
    std::vector<::base::string16> dictionary_suggestions_in,
    bool spellcheck_enabled_in,
    bool is_editable_in,
    int32_t writing_direction_default_in,
    int32_t writing_direction_left_to_right_in,
    int32_t writing_direction_right_to_left_in,
    int32_t edit_flags_in,
    const std::string& frame_charset_in,
    ::network::mojom::ReferrerPolicy referrer_policy_in,
    const ::GURL& link_followed_in,
    std::vector<CustomContextMenuItemPtr> custom_items_in,
    ::ui::MenuSourceType source_type_in,
    ContextMenuDataInputFieldType input_field_type_in,
    const ::gfx::Rect& selection_rect_in,
    int32_t selection_start_offset_in)
    : media_type(std::move(media_type_in)),
      x(std::move(x_in)),
      y(std::move(y_in)),
      link_url(std::move(link_url_in)),
      link_text(std::move(link_text_in)),
      impression(std::move(impression_in)),
      unfiltered_link_url(std::move(unfiltered_link_url_in)),
      src_url(std::move(src_url_in)),
      has_image_contents(std::move(has_image_contents_in)),
      media_flags(std::move(media_flags_in)),
      selection_text(std::move(selection_text_in)),
      title_text(std::move(title_text_in)),
      alt_text(std::move(alt_text_in)),
      suggested_filename(std::move(suggested_filename_in)),
      misspelled_word(std::move(misspelled_word_in)),
      dictionary_suggestions(std::move(dictionary_suggestions_in)),
      spellcheck_enabled(std::move(spellcheck_enabled_in)),
      is_editable(std::move(is_editable_in)),
      writing_direction_default(std::move(writing_direction_default_in)),
      writing_direction_left_to_right(std::move(writing_direction_left_to_right_in)),
      writing_direction_right_to_left(std::move(writing_direction_right_to_left_in)),
      edit_flags(std::move(edit_flags_in)),
      frame_charset(std::move(frame_charset_in)),
      referrer_policy(std::move(referrer_policy_in)),
      link_followed(std::move(link_followed_in)),
      custom_items(std::move(custom_items_in)),
      source_type(std::move(source_type_in)),
      input_field_type(std::move(input_field_type_in)),
      selection_rect(std::move(selection_rect_in)),
      selection_start_offset(std::move(selection_start_offset_in)) {}

UntrustworthyContextMenuParams::~UntrustworthyContextMenuParams() = default;

void UntrustworthyContextMenuParams::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "media_type"), this->media_type, 
      "<value of type ContextMenuDataMediaType>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "x"), this->x, 
      "<value of type int32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "y"), this->y, 
      "<value of type int32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "link_url"), this->link_url, 
      "<value of type const ::GURL&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "link_text"), this->link_text, 
      "<value of type const ::base::string16&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "impression"), this->impression, 
      "<value of type const base::Optional<::blink::Impression>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "unfiltered_link_url"), this->unfiltered_link_url, 
      "<value of type const ::GURL&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "src_url"), this->src_url, 
      "<value of type const ::GURL&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_image_contents"), this->has_image_contents, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "media_flags"), this->media_flags, 
      "<value of type int32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "selection_text"), this->selection_text, 
      "<value of type const ::base::string16&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "title_text"), this->title_text, 
      "<value of type const ::base::string16&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "alt_text"), this->alt_text, 
      "<value of type const ::base::string16&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "suggested_filename"), this->suggested_filename, 
      "<value of type const ::base::string16&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "misspelled_word"), this->misspelled_word, 
      "<value of type const ::base::string16&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "dictionary_suggestions"), this->dictionary_suggestions, 
      "<value of type const std::vector<::base::string16>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "spellcheck_enabled"), this->spellcheck_enabled, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_editable"), this->is_editable, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "writing_direction_default"), this->writing_direction_default, 
      "<value of type int32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "writing_direction_left_to_right"), this->writing_direction_left_to_right, 
      "<value of type int32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "writing_direction_right_to_left"), this->writing_direction_right_to_left, 
      "<value of type int32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "edit_flags"), this->edit_flags, 
      "<value of type int32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame_charset"), this->frame_charset, 
      "<value of type const std::string&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "referrer_policy"), this->referrer_policy, 
      "<value of type ::network::mojom::ReferrerPolicy>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "link_followed"), this->link_followed, 
      "<value of type const ::GURL&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "custom_items"), this->custom_items, 
      "<value of type std::vector<CustomContextMenuItemPtr>>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "source_type"), this->source_type, 
      "<value of type ::ui::MenuSourceType>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "input_field_type"), this->input_field_type, 
      "<value of type ContextMenuDataInputFieldType>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "selection_rect"), this->selection_rect, 
      "<value of type const ::gfx::Rect&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "selection_start_offset"), this->selection_start_offset, 
      "<value of type int32_t>");
}

bool UntrustworthyContextMenuParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char ContextMenuClient::Name_[] = "blink.mojom.ContextMenuClient";

ContextMenuClientProxy::ContextMenuClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ContextMenuClientProxy::CustomContextMenuAction(
    uint32_t in_action) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ContextMenuClient::CustomContextMenuAction", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("action"), in_action, 
                        "<value of type uint32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kContextMenuClient_CustomContextMenuAction_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ContextMenuClient_CustomContextMenuAction_Params_Data> params(
          message);
  params.Allocate();
  params->action = in_action;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ContextMenuClient::Name_);
  message.set_method_name("CustomContextMenuAction");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void ContextMenuClientProxy::ContextMenuClosed(
    const ::GURL& in_link_followed) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ContextMenuClient::ContextMenuClosed", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("link_followed"), in_link_followed, 
                        "<value of type const ::GURL&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kContextMenuClient_ContextMenuClosed_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ContextMenuClient_ContextMenuClosed_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->link_followed)::BaseType> link_followed_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_link_followed, link_followed_fragment);
  params->link_followed.Set(
      link_followed_fragment.is_null() ? nullptr : link_followed_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->link_followed.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null link_followed in ContextMenuClient.ContextMenuClosed request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ContextMenuClient::Name_);
  message.set_method_name("ContextMenuClosed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool ContextMenuClientStubDispatch::Accept(
    ContextMenuClient* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kContextMenuClient_CustomContextMenuAction_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ContextMenuClient::CustomContextMenuAction",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ContextMenuClient::CustomContextMenuAction");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ContextMenuClient_CustomContextMenuAction_Params_Data* params =
          reinterpret_cast<internal::ContextMenuClient_CustomContextMenuAction_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      uint32_t p_action{};
      ContextMenuClient_CustomContextMenuAction_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_action = input_data_view.action();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ContextMenuClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CustomContextMenuAction(
std::move(p_action));
      return true;
    }
    case internal::kContextMenuClient_ContextMenuClosed_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ContextMenuClient::ContextMenuClosed",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ContextMenuClient::ContextMenuClosed");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ContextMenuClient_ContextMenuClosed_Params_Data* params =
          reinterpret_cast<internal::ContextMenuClient_ContextMenuClosed_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::GURL p_link_followed{};
      ContextMenuClient_ContextMenuClosed_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadLinkFollowed(&p_link_followed))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ContextMenuClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ContextMenuClosed(
std::move(p_link_followed));
      return true;
    }
  }
  return false;
}

// static
bool ContextMenuClientStubDispatch::AcceptWithResponder(
    ContextMenuClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kContextMenuClient_CustomContextMenuAction_Name: {
      break;
    }
    case internal::kContextMenuClient_ContextMenuClosed_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kContextMenuClientValidationInfo[] = {
    {&internal::ContextMenuClient_CustomContextMenuAction_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::ContextMenuClient_ContextMenuClosed_Params_Data::Validate,
     nullptr /* no response */},
};

bool ContextMenuClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::ContextMenuClient::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kContextMenuClientValidationInfo);
}

}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::Impression::DataView, ::blink::mojom::ImpressionPtr>::Read(
    ::blink::mojom::Impression::DataView input,
    ::blink::mojom::ImpressionPtr* output) {
  bool success = true;
  ::blink::mojom::ImpressionPtr result(::blink::mojom::Impression::New());
  
      if (success && !input.ReadConversionDestination(&result->conversion_destination))
        success = false;
      if (success && !input.ReadReportingOrigin(&result->reporting_origin))
        success = false;
      if (success)
        result->impression_data = input.impression_data();
      if (success && !input.ReadExpiry(&result->expiry))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::CustomContextMenuItem::DataView, ::blink::mojom::CustomContextMenuItemPtr>::Read(
    ::blink::mojom::CustomContextMenuItem::DataView input,
    ::blink::mojom::CustomContextMenuItemPtr* output) {
  bool success = true;
  ::blink::mojom::CustomContextMenuItemPtr result(::blink::mojom::CustomContextMenuItem::New());
  
      if (success && !input.ReadLabel(&result->label))
        success = false;
      if (success && !input.ReadIcon(&result->icon))
        success = false;
      if (success && !input.ReadToolTip(&result->tool_tip))
        success = false;
      if (success && !input.ReadType(&result->type))
        success = false;
      if (success)
        result->action = input.action();
      if (success)
        result->rtl = input.rtl();
      if (success)
        result->has_directional_override = input.has_directional_override();
      if (success)
        result->enabled = input.enabled();
      if (success)
        result->checked = input.checked();
      if (success && !input.ReadSubmenu(&result->submenu))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::UntrustworthyContextMenuParams::DataView, ::blink::mojom::UntrustworthyContextMenuParamsPtr>::Read(
    ::blink::mojom::UntrustworthyContextMenuParams::DataView input,
    ::blink::mojom::UntrustworthyContextMenuParamsPtr* output) {
  bool success = true;
  ::blink::mojom::UntrustworthyContextMenuParamsPtr result(::blink::mojom::UntrustworthyContextMenuParams::New());
  
      if (success && !input.ReadMediaType(&result->media_type))
        success = false;
      if (success)
        result->x = input.x();
      if (success)
        result->y = input.y();
      if (success && !input.ReadLinkUrl(&result->link_url))
        success = false;
      if (success && !input.ReadLinkText(&result->link_text))
        success = false;
      if (success && !input.ReadImpression(&result->impression))
        success = false;
      if (success && !input.ReadUnfilteredLinkUrl(&result->unfiltered_link_url))
        success = false;
      if (success && !input.ReadSrcUrl(&result->src_url))
        success = false;
      if (success)
        result->has_image_contents = input.has_image_contents();
      if (success)
        result->media_flags = input.media_flags();
      if (success && !input.ReadSelectionText(&result->selection_text))
        success = false;
      if (success && !input.ReadTitleText(&result->title_text))
        success = false;
      if (success && !input.ReadAltText(&result->alt_text))
        success = false;
      if (success && !input.ReadSuggestedFilename(&result->suggested_filename))
        success = false;
      if (success && !input.ReadMisspelledWord(&result->misspelled_word))
        success = false;
      if (success && !input.ReadDictionarySuggestions(&result->dictionary_suggestions))
        success = false;
      if (success)
        result->spellcheck_enabled = input.spellcheck_enabled();
      if (success)
        result->is_editable = input.is_editable();
      if (success)
        result->writing_direction_default = input.writing_direction_default();
      if (success)
        result->writing_direction_left_to_right = input.writing_direction_left_to_right();
      if (success)
        result->writing_direction_right_to_left = input.writing_direction_right_to_left();
      if (success)
        result->edit_flags = input.edit_flags();
      if (success && !input.ReadFrameCharset(&result->frame_charset))
        success = false;
      if (success && !input.ReadReferrerPolicy(&result->referrer_policy))
        success = false;
      if (success && !input.ReadLinkFollowed(&result->link_followed))
        success = false;
      if (success && !input.ReadCustomItems(&result->custom_items))
        success = false;
      if (success && !input.ReadSourceType(&result->source_type))
        success = false;
      if (success && !input.ReadInputFieldType(&result->input_field_type))
        success = false;
      if (success && !input.ReadSelectionRect(&result->selection_rect))
        success = false;
      if (success)
        result->selection_start_offset = input.selection_start_offset();
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif